/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.data.idi.formplugin.SmartPanelPlugin;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class SmartMobilePanelPlugin
extends AbstractMobFormPlugin {
    private static Log logger = LogFactory.getLog(SmartPanelPlugin.class);

    protected String getCustomPanel() {
        return "dynamicpanel";
    }

    protected String getResult() {
        String entityNumber = this.getEntityNumber();
        String billId = this.getBillId();
        String schemaNumber = this.getSchemaNumber();
        ArrayList<String> schemaNumberList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)schemaNumber)) {
            if (schemaNumber.contains(",")) {
                String[] numbers;
                for (String number : numbers = schemaNumber.split(",")) {
                    if (StringUtils.isEmpty((String)number)) continue;
                    schemaNumberList.add(number);
                }
            } else {
                schemaNumberList.add(schemaNumber);
            }
        }
        DynamicObject billObj = Objects.requireNonNull(BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber, (String)"id"), ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"SmartMobilePanelPlugin_1", (String)"bos-ext-data", (Object[])new Object[0]));
        Object[] params = new Object[]{billObj, schemaNumberList};
        try {
            return (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"getSchemaSummary", (Object[])params);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("status", "error");
            map.put("content", ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"SmartMobilePanelPlugin_0", (String)"bos-ext-data", (Object[])new Object[0]));
            return SerializationUtils.toJsonString(map);
        }
    }

    private String getEntityNumber() {
        return this.getPageCache().get("entitynumber");
    }

    private String getBillId() {
        return this.getPageCache().get("businesskey");
    }

    private String getSchemaNumber() {
        return this.getPageCache().get("schemenumber");
    }

    public void afterCreateNewData(EventObject e) {
        if (StringUtils.isEmpty((String)this.getSchemaNumber())) {
            return;
        }
        FlexPanelAp root = new FlexPanelAp();
        root.setKey(this.getCustomPanel());
        Map rootControlMap = root.createControl();
        List itemList = (List)this.createOverView(this.getResult()).createControl().get("items");
        rootControlMap.put("items", itemList);
        this.getView().updateControlMetadata(this.getCustomPanel(), rootControlMap);
    }

    private FlexPanelAp createOverView(String result) {
        Map map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        String status = (String)map.get("status");
        boolean isSucceed = "success".equals(status);
        String content = (String)map.get("content");
        FlexPanelAp rootPanel = new FlexPanelAp();
        rootPanel.setKey("overviewroot");
        rootPanel.setDirection("column");
        rootPanel.setWidth(new LocaleString("100%"));
        rootPanel.setGrow(1);
        FlexPanelAp viewPanel = new FlexPanelAp();
        viewPanel.setKey("overview");
        viewPanel.setBackColor("#ffffff");
        viewPanel.setDirection("row");
        viewPanel.setAlignItems("center");
        viewPanel.setClickable(isSucceed);
        viewPanel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7ZmxleC13cmFwOiBub3dyYXA7fSJ9");
        rootPanel.getItems().add(viewPanel);
        FlexPanelAp viewLeftPanel = new FlexPanelAp();
        viewLeftPanel.setKey("overviewleftflex");
        viewLeftPanel.setDirection("row");
        viewLeftPanel.setAlignItems("center");
        viewLeftPanel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7ZmxleC13cmFwOiBub3dyYXA7fSJ9");
        viewPanel.getItems().add(viewLeftPanel);
        ImageAp imageap = new ImageAp();
        imageap.setImageKey("/images/pc/emotion/krobot_100_100.png");
        imageap.setWidth(new LocaleString("40px"));
        imageap.setHeight(new LocaleString("40px"));
        imageap.setKey("rabotk");
        imageap.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7bWluLWhlaWdodDogNDBweDttaW4td2lkdGg6IDQwcHg7fSJ9");
        viewLeftPanel.getItems().add(imageap);
        LabelAp labelap = new LabelAp();
        labelap.setKey("overviewtext");
        labelap.setName(new LocaleString(content));
        labelap.setFontSize(14);
        labelap.setForeColor("#768893");
        viewLeftPanel.getItems().add(labelap);
        FlexPanelAp viewRightPanel = new FlexPanelAp();
        viewRightPanel.setKey("overviewrightflex");
        viewRightPanel.setDirection("row");
        viewRightPanel.setJustifyContent("flex-end");
        viewPanel.getItems().add(viewRightPanel);
        if (isSucceed) {
            VectorAp vectorap = new VectorAp();
            vectorap.setKey("goresult");
            vectorap.setfontClass("kdfont kdfont-houfan");
            viewRightPanel.getItems().add(vectorap);
        }
        return rootPanel;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (StringUtils.isNotEmpty((String)key) && key.equals("overview")) {
            Container flexPanel = new Container();
            flexPanel.setKey(key);
            flexPanel.setView(this.getView());
            flexPanel.addClickListener((ClickListener)this);
            e.setControl((Control)flexPanel);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("overview".equals(control.getKey())) {
            this.showForm();
        }
    }

    private void showForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("idi_datainsight_mobile");
        String entityNumber = this.getEntityNumber();
        String billId = this.getBillId();
        String schemaNumber = this.getSchemaNumber();
        fsp.setCaption(ResManager.loadKDString((String)"\u667a\u80fd\u6570\u636e\u6d1e\u5bdf", (String)"SmartMobilePanelPlugin_title", (String)"bos-ext-data", (Object[])new Object[0]));
        fsp.setCustomParam("entitynumber", (Object)entityNumber);
        fsp.setCustomParam("billid", (Object)billId);
        fsp.setCustomParam("schemenumber", (Object)schemaNumber);
        fsp.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm(fsp);
    }
}

