/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.bpmn.model.AdvAppScheme;
import kd.bos.workflow.bpmn.model.AdvAppSchemeModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.IApproverPageEventListener;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgs;

public class SubmitControlFormPlugin
extends AbstractWorkflowPlugin
implements IApproverPageEventListener {
    public void customEvent(CustomEventArgs e) {
        List advAppSchemeList;
        AuditTask at;
        AdvAppSchemeModel advAppSchemeModel;
        AfterCreatNewDataForApprovalCustomEvent acd;
        FlowElement fe;
        if (e != null && "pagecacheKeyForSubmit".equals(e.getKey()) && e instanceof BeforeSubmitCustomEventArgs) {
            List<Object> schemaNumberList;
            BeforeSubmitCustomEventArgs bsc = (BeforeSubmitCustomEventArgs)e;
            String billId = this.getPageCache().get("businesskey");
            String entityNumber = this.getPageCache().get("entitynumber");
            String schemaNumber = this.getIDISchemaNumbers();
            if (StringUtils.isNotEmpty((String)schemaNumber) && schemaNumber.indexOf(",") > 0) {
                schemaNumberList = Arrays.asList(schemaNumber.split(","));
            } else {
                schemaNumberList = new ArrayList(2);
                if (StringUtils.isNotEmpty((String)schemaNumber)) {
                    schemaNumberList.add(schemaNumber);
                }
            }
            if (StringUtils.isNotEmpty((String)entityNumber) && StringUtils.isNotEmpty((String)billId) && CollectionUtils.isNotEmpty(schemaNumberList)) {
                Object[] params = new Object[]{Long.valueOf(billId), entityNumber, schemaNumberList};
                String result = null;
                try {
                    result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"billControl", (Object[])params);
                }
                catch (Exception ex) {
                    this.logger.error((Throwable)ex);
                }
                Map<String, String> kv = null;
                if (StringUtils.isNotEmpty((String)result)) {
                    kv = this.processResult(result);
                }
                if (kv != null) {
                    boolean isCanel = kv.containsKey("force");
                    bsc.setCancel(isCanel);
                    if (isCanel) {
                        this.getView().showErrorNotification(kv.get("force"));
                        bsc.setShowConfirmTips(false);
                    } else {
                        bsc.setShowConfirmTips(true);
                        HashMap<String, String> submitParamMap = bsc.getSubmitParams();
                        if (submitParamMap == null) {
                            submitParamMap = new HashMap<String, String>(10);
                            bsc.setSubmitParams(submitParamMap);
                        }
                        submitParamMap.put("confirmTips", kv.get("confirm"));
                    }
                } else {
                    bsc.setCancel(false);
                    bsc.setShowConfirmTips(false);
                }
            } else {
                bsc.setCancel(false);
                bsc.setShowConfirmTips(false);
            }
        } else if (e instanceof AfterCreatNewDataForApprovalCustomEvent && "AuditTask".equalsIgnoreCase((fe = (acd = (AfterCreatNewDataForApprovalCustomEvent)e).getFlowElement()).getType()) && (advAppSchemeModel = (at = (AuditTask)fe).getAdvAppSchemeModel()) != null && CollectionUtils.isNotEmpty((Collection)(advAppSchemeList = advAppSchemeModel.getAdvAppSchemes()))) {
            StringBuilder sb = new StringBuilder();
            for (AdvAppScheme advAppScheme : advAppSchemeList) {
                sb.append(',').append(advAppScheme.getSchemeNumber());
            }
            if (sb.length() > 0) {
                this.putIDISchemaNumbers(sb.substring(1));
            }
        }
    }

    private void putIDISchemaNumbers(String schemaNumber) {
        this.getPageCache().put("idiSchemaNumber", schemaNumber);
    }

    private String getIDISchemaNumbers() {
        return this.getPageCache().get("idiSchemaNumber");
    }

    private Map<String, String> processResult(String result) {
        Map map = (Map)JSON.parseObject((String)result, Map.class);
        String controlStatus = (String)map.get("controlStatus");
        String status = (String)map.get("status");
        String title = (String)map.get("title");
        List content = (List)map.get("content");
        if ("success".equals(status) && !this.isEmpty(title, content)) {
            if ("force".equals(controlStatus)) {
                String contentMsg = this.parseToString(content, true, 4);
                contentMsg = title + ":\r\n" + contentMsg;
                HashMap<String, String> resultMap = new HashMap<String, String>(2);
                resultMap.put("force", contentMsg);
                return resultMap;
            }
            if ("confirm".equals(controlStatus)) {
                String contentMsg = this.parseToString(content, true);
                contentMsg = contentMsg + "\r\n";
                HashMap<String, String> resultMap = new HashMap<String, String>(2);
                resultMap.put("confirm", contentMsg);
                return resultMap;
            }
        }
        return null;
    }

    private boolean isEmpty(String title, List<?> content) {
        return title == null || "".equals(title) || content == null || content.isEmpty();
    }

    private String parseToString(List<String> content, boolean wrap) {
        return this.parseToString(content, wrap, 0);
    }

    private String parseToString(List<String> content, boolean wrap, int indent) {
        StringBuilder blank = new StringBuilder();
        String spit = "";
        if (wrap) {
            for (int i = 0; i < indent; ++i) {
                blank.append(" ");
            }
            spit = "\r\n";
        }
        StringBuilder sb = new StringBuilder();
        String prefixed = blank.toString();
        for (int i = 0; i < content.size(); ++i) {
            String msgLine = content.get(i);
            sb.append(prefixed);
            sb.append(msgLine);
            sb.append(spit);
        }
        return sb.toString();
    }
}

