/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.imic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.ext.imsc.imic.util.CommonUtils;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListColumnContext;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.column.ListTemplateTextColumnDesc;
import kd.bos.list.column.TemplateTextItem;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgSchemeList
extends AbstractListPlugin
implements CreateListColumnsListener {
    private static final String DEFAULTCALIBER = "defaultcaliber";
    private static final String INITPERCENT = "org_initpercent";
    private static final String PERCENT = "org_percent";
    private static final String MUSTPERCENT = "org_mustpercent";
    private static final String USEDIMENSION = "usedimension";
    private static final String F7_ORGIDS = "orgids";
    private static final String INITSCHEMEID = "initSchemeId";
    private static final String IMIC_INITIALSCHEME = "imic_initialscheme";
    private static final String E_itemgroup = "itemgroup";
    private static final String E_imic_initentry_items = "imic_initentry_items";
    private static final String EF_initentry_items_id = String.join((CharSequence)".", "itemgroup", "imic_initentry_items", "id");
    private static final String EF_initconfigmustset = "initconfigmustset";
    private static final String EF_initentry_initconfigmustset = String.join((CharSequence)".", "itemgroup", "imic_initentry_items", "initconfigmustset");
    private static final String EF_itemenabled = "itemenabled";
    private static final String EF_initentry_itemenabled = String.join((CharSequence)".", "itemgroup", "imic_initentry_items", "itemenabled");
    private static final String IMIC_PROGRESSUNIT = "imic_progressunit";
    private static final String F_initialschemeentryid = "initialschemeentryid";
    private static final String F_org = "org";
    private static final String F_initialscheme = "initialscheme";
    private static final String ISBATCH = "isBatch";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addPackageDataListener(this::packageData);
    }

    public void createListColumns(BeforeCreateListColumnsArgs e) {
        String defaultcaliber = CommonUtils.getStringCustomParamValue(this.getView(), DEFAULTCALIBER);
        if ("C".equals(defaultcaliber)) {
            TemplateTextListColumn allColumn = new TemplateTextListColumn();
            allColumn.setListFieldKey(PERCENT);
            allColumn.setKey(PERCENT);
            allColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u4efb\u52a1\u9879\u5b8c\u6210\u8fdb\u5ea6", (String)"OrgSchemeList_0", (String)"bos-ext-imsc", (Object[])new Object[0])));
            allColumn.setContext(new ListColumnContext(null, false));
            TemplateTextListColumn mustColumn = new TemplateTextListColumn();
            mustColumn.setListFieldKey(MUSTPERCENT);
            mustColumn.setKey(MUSTPERCENT);
            mustColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5fc5\u987b\u914d\u7f6e\u9879\u5b8c\u6210\u8fdb\u5ea6", (String)"OrgSchemeList_1", (String)"bos-ext-imsc", (Object[])new Object[0])));
            mustColumn.setContext(new ListColumnContext(null, false));
            e.getListColumns().add(2, allColumn);
            e.getListColumns().add(3, mustColumn);
        } else {
            TemplateTextListColumn column1 = new TemplateTextListColumn();
            column1.setListFieldKey(INITPERCENT);
            column1.setKey(INITPERCENT);
            column1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fdb\u5ea6", (String)"OrgSchemeList_2", (String)"bos-ext-imsc", (Object[])new Object[0])));
            column1.setContext(new ListColumnContext(null, false));
            e.getListColumns().add(2, column1);
        }
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListTemplateTextColumnDesc) {
            if (CommonUtils.getBooleanCustomParamValue(this.getView(), ISBATCH)) {
                e.getNoLinkKey().add("number");
            }
            String fieldkey = ((ListTemplateTextColumnDesc)e.getSource()).getFieldKey();
            boolean usedImension = CommonUtils.getBooleanCustomParamValue(this.getView(), USEDIMENSION);
            List<Long> orgIds = CommonUtils.getListCustomParamValue(this.getView(), F7_ORGIDS);
            if (usedImension) {
                String completeProgressStr = "0%";
                String completeMustProgressStr = "0%";
                long mustItemCount = 0L;
                if (!orgIds.isEmpty()) {
                    if (CommonUtils.isNull(this.getPageCache().get(IMIC_PROGRESSUNIT))) {
                        long initSchemeId = CommonUtils.getLongCustomParamValue(this.getView(), INITSCHEMEID);
                        QFilter filter = new QFilter(F_initialscheme, "=", (Object)initSchemeId);
                        filter.and(new QFilter(F_org, "in", orgIds));
                        DynamicObjectCollection progressColl = QueryServiceHelper.query((String)IMIC_PROGRESSUNIT, (String)String.join((CharSequence)",", F_org, F_initialschemeentryid), (QFilter[])filter.toArray());
                        if (!CommonUtils.isNull(progressColl)) {
                            QFilter qFilter = new QFilter("id", "=", (Object)initSchemeId);
                            qFilter.and(new QFilter(EF_initentry_itemenabled, "=", (Object)Boolean.TRUE));
                            DynamicObjectCollection schemeColl = QueryServiceHelper.query((String)IMIC_INITIALSCHEME, (String)String.join((CharSequence)",", EF_initentry_items_id, EF_initentry_initconfigmustset), (QFilter[])qFilter.toArray());
                            if (!CommonUtils.isNull(schemeColl)) {
                                mustItemCount = schemeColl.stream().filter(o -> o.getBoolean(EF_initentry_initconfigmustset)).count();
                                this.getView().getPageCache().put(IMIC_PROGRESSUNIT, SerializationUtils.toJsonString(this.getProgressMap(schemeColl, progressColl)));
                            }
                        }
                    }
                    if (!CommonUtils.isNull(this.getPageCache().get(IMIC_PROGRESSUNIT))) {
                        Map progressMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(IMIC_PROGRESSUNIT), Map.class);
                        List progressList = (List)progressMap.get(e.getRowData().getPkValue().toString());
                        if (!CommonUtils.isNull(progressList)) {
                            completeProgressStr = (String)progressList.get(0);
                            completeMustProgressStr = (String)progressList.get(1);
                        } else if (mustItemCount == 0L) {
                            completeMustProgressStr = "100%";
                        }
                    }
                }
                if (INITPERCENT.equals(fieldkey)) {
                    String defaultcaliber = CommonUtils.getStringCustomParamValue(this.getView(), DEFAULTCALIBER);
                    if ("A".equals(defaultcaliber)) {
                        this.setFormatValue(e, completeProgressStr);
                    } else {
                        this.setFormatValue(e, completeMustProgressStr);
                    }
                } else if (PERCENT.equals(fieldkey)) {
                    this.setFormatValue(e, completeProgressStr);
                } else if (MUSTPERCENT.equals(fieldkey)) {
                    this.setFormatValue(e, completeMustProgressStr);
                }
            }
        }
    }

    private Map<Long, List<String>> getProgressMap(DynamicObjectCollection schemeColl, DynamicObjectCollection progressColl) {
        Map<Long, List<DynamicObject>> map = progressColl.stream().collect(Collectors.groupingBy(o -> o.getLong(F_org)));
        HashMap<Long, List<String>> progressMap = new HashMap<Long, List<String>>(16);
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : map.entrySet()) {
            Set initEntryIdSet = mapEntry.getValue().stream().map(o -> o.getLong(F_initialschemeentryid)).collect(Collectors.toSet());
            int completeAllSize = 0;
            int completeMustSize = 0;
            for (DynamicObject initEntryDynObj : schemeColl) {
                if (!initEntryIdSet.contains(initEntryDynObj.getLong(EF_initentry_items_id))) continue;
                if (initEntryDynObj.getBoolean(EF_initentry_initconfigmustset)) {
                    ++completeMustSize;
                }
                ++completeAllSize;
            }
            int allSize = schemeColl.size();
            long mustSize = schemeColl.stream().filter(o -> o.getBoolean(EF_initentry_initconfigmustset)).count();
            BigDecimal total = new BigDecimal(allSize);
            BigDecimal complete = new BigDecimal(completeAllSize);
            BigDecimal completeProgress = complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            total = new BigDecimal(mustSize);
            complete = new BigDecimal(completeMustSize);
            BigDecimal completeMustProgress = total.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(100L) : complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            ArrayList<String> progressList = new ArrayList<String>(2);
            progressList.add(completeProgress.intValue() + "%");
            progressList.add(completeMustProgress.intValue() + "%");
            progressMap.put(mapEntry.getKey(), progressList);
        }
        return progressMap;
    }

    private void setFormatValue(PackageDataEvent e, String tem) {
        ArrayList data = new ArrayList(16);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "r");
        map.put("id", "rid");
        map.put("text", "");
        data.add(map);
        TemplateTextItem templateTextItem = new TemplateTextItem();
        templateTextItem.setTem(tem);
        templateTextItem.setData(data);
        e.setFormatValue((Object)templateTextItem);
    }
}

