/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.ricc.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListView;

public class SelectedIdsAdapter {
    private static final Map<String, SelectModel> FORM_ENTRY_MAP = new HashMap<String, SelectModel>();

    private SelectedIdsAdapter() {
        throw new IllegalStateException("Utility class");
    }

    public static ListSelectedRowCollection getSelectedRows(String formId, IFormView view) {
        ListSelectedRowCollection listSelectedRows = null;
        SelectModel selectModel = FORM_ENTRY_MAP.get(formId);
        if (selectModel != null) {
            listSelectedRows = SelectedIdsAdapter.getSelectRows(view, selectModel);
        } else if (view instanceof ListView) {
            listSelectedRows = ((IListView)view).getSelectedRows().getBillListSelectedRowCollection();
        } else if (view.getControl("billlistap") != null) {
            BillList list = (BillList)view.getControl("billlistap");
            listSelectedRows = list.getSelectedRows().getBillListSelectedRowCollection();
        }
        return listSelectedRows;
    }

    public static ListSelectedRowCollection getSelectRows(IFormView view, SelectModel selectModel) {
        EntryGrid entry = (EntryGrid)view.getControl(selectModel.getEntryField());
        int[] rowIndexs = entry.getSelectRows();
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        for (int index : rowIndexs) {
            String nameField;
            String numberField;
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            String pkField = selectModel.getPkField();
            if (!StringUtils.isEmpty((CharSequence)pkField)) {
                Object fid = view.getModel().getValue(pkField, index);
                listSelectedRow.setPrimaryKeyValue(fid);
            }
            if (!StringUtils.isEmpty((CharSequence)(numberField = selectModel.getNumberField()))) {
                String fbillno = (String)view.getModel().getValue(numberField, index);
                listSelectedRow.setNumber(fbillno);
            }
            if (!StringUtils.isEmpty((CharSequence)(nameField = selectModel.getNameField()))) {
                String fname = (String)view.getModel().getValue(nameField, index);
                listSelectedRow.setName(fname);
            }
            listSelectedRows.add((Object)listSelectedRow);
        }
        return listSelectedRows;
    }

    static {
        FORM_ENTRY_MAP.put("perm_operationruleassign", new SelectModel("operationruleobj_list", "operationrule_id", "operation", "name"));
        FORM_ENTRY_MAP.put("ai_vchtemplate_configs", new SelectModel("entryentity", "fbillid", "fbillno", "fdescription"));
    }

    static class SelectModel {
        String entryField;
        String pkField;
        String numberField;
        String nameField;

        public SelectModel(String entryField, String pkField, String numberField, String nameField) {
            this.entryField = entryField;
            this.pkField = pkField;
            this.numberField = numberField;
            this.nameField = nameField;
        }

        public String getEntryField() {
            return this.entryField;
        }

        public String getPkField() {
            return this.pkField;
        }

        public String getNumberField() {
            return this.numberField;
        }

        public String getNameField() {
            return this.nameField;
        }
    }
}

