/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.macc.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.macc.thread.MaccTaskType;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;

public class MaccThreadHelper {
    private static final ThreadExecutorService THREAD_EXECUTOR;

    public static ThreadExecutorService getThreadExecutor() {
        return THREAD_EXECUTOR;
    }

    public static void execute(Runnable command, MaccTaskType taskType) {
        MaccThreadHelper.execute(command, taskType, null);
    }

    public static void execute(Runnable command, MaccTaskType taskType, RequestContext context) {
        MaccThreadHelper.execute(command, taskType, context, null);
    }

    public static void execute(Runnable command, MaccTaskType taskType, RequestContext context, OperationContext oc) {
        THREAD_EXECUTOR.execute(command, taskType.getName(), null, null);
    }

    public static <T> Future<T> submit(Callable<T> task, MaccTaskType taskType) {
        return MaccThreadHelper.submit(task, taskType, null);
    }

    public static <T> Future<T> submit(Callable<T> task, MaccTaskType taskType, RequestContext context) {
        return MaccThreadHelper.submit(task, taskType, context, null);
    }

    public static <T> Future<T> submit(Callable<T> task, MaccTaskType taskType, RequestContext context, OperationContext oc) {
        return THREAD_EXECUTOR.submit(task, taskType.getName(), context, oc);
    }

    static {
        ThreadPoolStrategy threadPoolStrategy = ThreadPoolStrategyFactory.create();
        threadPoolStrategy.setMaxThreadNum(200);
        threadPoolStrategy.setMinThreadNum(50);
        threadPoolStrategy.setOverflowThreadNum(20);
        threadPoolStrategy.setThreadIdeMinutes(1L);
        for (MaccTaskType taskType : MaccTaskType.values()) {
            threadPoolStrategy.register(taskType.build());
        }
        THREAD_EXECUTOR = ThreadPoolFactory.create((String)"macc", (String)"macc-threadpool", (ThreadPoolStrategy)threadPoolStrategy);
    }
}

