package kd.bos.ext.imc.common.util;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.dataentity.utils.StringUtils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * <p>
 * Title: java
 * </p>
 * <p>
 * Description: 日期工具类
 * </p>
 *
 * @author 陈劲豪
 * @date 2019年3月20日 上午10:41:52
 */
public class DateUtils {
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    /**
     * 去除时分秒
     *
     * @param date
     * @return
     */
    public static Date trunc(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    /**
     * 在输入日期上增加（+）或减去（-）天数
     *
     * @param date 输入日期
     * @param iday 要增加或减少的天数
     */
    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(Calendar.DAY_OF_MONTH, iday);
        return cd.getTime();
    }

    public static Date addHour(Date date, int hour) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(Calendar.HOUR_OF_DAY, hour);
        return cd.getTime();
    }

    /**
     * 在输入日期上增加（+）或减去（-）月份
     *
     * @param date   输入日期
     * @param imonth 要增加或减少的月分数
     */
    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(Calendar.MONTH, imonth);
        return cd.getTime();
    }

    /**
     * 在输入日期上增加（+）或减去（-）年份
     *
     * @param date  输入日期
     * @param iyear 要增加或减少的年数
     */
    public static Date addYear(Date date, int iyear) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(Calendar.YEAR, iyear);
        return cd.getTime();
    }

    /**
     * 获取指定月第一天
     *
     * @param date
     * @return
     */
    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    public static Date getFirstDateOfThreeMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, -2);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    public static Date getFirstDateOfYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.MONTH, 0);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    /**
     * 获取指定月最后一天
     *
     * @param date
     * @return
     */
    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, 1);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.add(Calendar.DATE, -1);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        return calendar.getTime();
    }

    /**
     * 将字符串日期转换为日期格式 自定義格式
     *
     * @param datestr
     * @return
     */
    public static Date stringToDate(String datestr) {
        return stringToDate(datestr, YYYY_MM_DD);
    }

    /**
     * 将字符串日期转换为日期格式 自定義格式
     *
     * @param datestr
     * @return
     */
    public static Date stringToDate(String datestr, String dateformat) {
        if(StringUtils.isBlank(datestr)){
            return null;
        }
        Date date;
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            date = df.parse(datestr);
        } catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString("日期[%1$s]格式错误,正确格式为:%2$s", "DateUtils_0", "bos-ext-imc") , datestr , dateformat), e);
        }
        return date;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String format(Date date) {
        return format(date, YYYY_MM_DD);
    }

    // 获取本周的开始时间
    public static Date getFirstDayOfWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek);
        return getDayStartTime(cal.getTime());
    }

    // 获取某个日期的开始时间
    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d)
            calendar.setTime(d);
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 0,
                0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    //获取某一日0时0分0秒0毫秒
    public static Date getDayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);//将小时至零
        calendar.set(Calendar.MINUTE, 0);//将分钟至零
        calendar.set(Calendar.SECOND, 0);//将秒至零
        calendar.set(Calendar.MILLISECOND, 0);//将毫秒至零
        return calendar.getTime();
    }

    //获取某一日结束时间0时0分0秒0毫秒
    public static Date getDayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);//将小时至零
        calendar.set(Calendar.MINUTE, 0);//将分钟至零
        calendar.set(Calendar.SECOND, 0);//将秒至零
        calendar.set(Calendar.MILLISECOND, 0);//将毫秒至零
        calendar.add(Calendar.DATE, 1);
        return calendar.getTime();
    }

    /**
     * @Description date1和date2进行比较是否是同一天，date1在date2之后的时间点发回大于0，反之小于0
     * @Author wenhao_wei
     * @Date 2020/10/8 14:07
     * @param: date1
     * @param: date2
     * @Return int
     * @Exception
     */
    public static int compare(Date date1, Date date2) {
        String date1Str = format(date1, YYYYMMDD);
        String date2Str = format(date2, YYYYMMDD);
        return Integer.parseInt(date1Str) - Integer.parseInt(date2Str);
    }

    /***
     * @Description: 获取时间差
     * @Param: [date1, date2]
     * @return: long
     * @Author: xiaojun_yuan
     * @Date: 2021/7/19 15:03
     */
    public static long timeDifference(Date date1, Date date2) {
        return date2.getTime() - date1.getTime();
    }

    public static int timeDifferenceDay(Date date1, Date date2) {
        return (int) ((date2.getTime() - date1.getTime()) / (1000 * 3600 * 24));
    }

    public static int timeDifferenceSecond(Date date1, Date date2) {
        return (int) ((date2.getTime() - date1.getTime()) / (1000));
    }

    public static Date handleDate(String issueTimeStr) {
        switch (issueTimeStr.length()) {
            case 8:
                return DateUtils.stringToDate(issueTimeStr, DateUtils.YYYYMMDD);
            case 10:
                return DateUtils.stringToDate(issueTimeStr, DateUtils.YYYY_MM_DD);
            case 14:
                return DateUtils.stringToDate(issueTimeStr, DateUtils.YYYYMMDDHHMMSS);
            default:
                return DateUtils.stringToDate(issueTimeStr, DateUtils.YYYY_MM_DD_HH_MM_SS);
        }
    }
}
