package kd.bos.ext.imc.common.util;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;

public class PropertyUtils {
    /**
     * @param        entityName
     * @param        isContainItemsAll  是否包含子单据体所有字段
     * @description  根据实体名称获取其所有字段，并用逗号隔开a
     * @author       rd_wang_yi
     * @date         2020/11/12 15:33
     */
    public static String getAllPropertiesSplitByComma(String entityName, boolean isContainItemsAll){
        DynamicObjectType type = EntityMetadataCache.getDataEntityType(entityName);
        DataEntityPropertyCollection ls = type.getProperties();
        if (ls == null || ls.isEmpty()) {
            return "";
        }

        StringBuilder sb = new StringBuilder();
        for (IDataEntityProperty property : ls) {
            String name = property.getName();
            if(property instanceof DynamicLocaleProperty){
                continue;
            }
            if(!(property instanceof EntryProp)){
                sb.append(name).append(',');
                continue;
            }
            if(!isContainItemsAll){
                continue;
            }
            EntryProp prop = (EntryProp) property;
            for (IDataEntityProperty itemProperty : prop.getItemType().getProperties()) {
                sb.append(name).append('.').append(itemProperty.getName()).append(',');
            }
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - 1);
    }

}
