package kd.bos.ext.imc.common.util;
import kd.bos.dataentity.resource.ResManager;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author : rd_wang_yi
 * @description :
 * @date : 2020年07月28日 10:12
 **/
public class TaxRateUtil {
    private static final Set<String> eazy345 = new HashSet<>(Arrays.asList("3%", "4%", "5%"));
    private static final Set<String> zore = new HashSet<>(Collections.singletonList("0%"));
    private static final Set<String> eazy3 = new HashSet<>(Collections.singletonList("3%"));
    private static final Set<String> eazy5 = new HashSet<>(Collections.singletonList("5%"));
    private static final Set<String> eazy15 = new HashSet<>(Collections.singletonList("1.5%"));
    private static final Set<String> all = new HashSet<>(Arrays.asList("0%", "1%", "1.5%", "3%", "4%", "5%", "6%", "9%", "10%", "11%", "13%", "16%", "17%"));
    private static final String[] intTaxRate = {"0", "1", "1.5", "3", "4", "5", "6", "9", "10", "11", "13", "16", "17"};

    //当优惠政策发生变化是触发税率变更
    public static Set<String> setRate(String val) {
        Set<String> now = new HashSet<>();
        switch (val) {
            case "简易征收":
                now.addAll(eazy345);
                break;
            case "免税":
            case "不征税":
                now.addAll(zore);
                break;
            case "先征后退":
            case "100%先征后退":
            case "50%先征后退":
            case "超税负3%即征即退":
            case "超税负8%即征即退":
            case "超税负12%即征即退":
            case "即征即退30%":
            case "即征即退50%":
            case "即征即退70%":
            case "即征即退100%":
            case "稀土产品":
                //now=new HashSet<String>();
                break;
            case "按3%简易征收":
                now.addAll(eazy3);
                break;
            case "按5%简易征收":
                now.addAll(eazy5);
                break;
            case "按5%简易征收减按1.5%计征":
                now.addAll(eazy15);
                break;
            default:
                now.addAll(all);
                break;
        }
        return now;
    }

    /**
     * @param : percent
     * @return : double
     * @description : 百分数转小数
     * @author : rd_wang_yi
     * @date : 2020/7/28 10:20
     */
    public static String percent2Point(String percent) {
        String pointStr;
        try {
            pointStr = new BigDecimal(percent.substring(0, percent.length() - 1)).divide(new BigDecimal("100"), 8, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString();
        } catch (Exception e) {
            pointStr = "0";
        }
        return "0.1".equals(pointStr) ? "0.10" : pointStr;
    }

    /**
     * @param        zzstsgl    税收分类编码表中增值税特殊管理字段
     * @param        privilegeType  发票数据中优惠政策内容
     * @param        taxRate    税率
     * @description  校验优惠政策内容
     * @author       rd_wang_yi
     * @date         2020/11/20 13:57
     */
    public static String checkPrivilegeType(String zzstsgl, String privilegeType, String taxRate) {
        taxRate = new BigDecimal(taxRate).stripTrailingZeros().toPlainString();
        List<String> zzstsglList = Arrays.asList(zzstsgl.split("、"));
        if (zzstsglList.size() > 0) {
            if (!zzstsglList.contains(privilegeType) && !ResManager.loadKDString("免税", "TaxRateUtil_1", "bos-ext-imc").equals(privilegeType) && !ResManager.loadKDString("不征税", "TaxRateUtil_2", "bos-ext-imc").equals(privilegeType)) {
                return String.format(ResManager.loadKDString("优惠政策不合法!此编码下的优惠政策不包含%s", "TaxRateUtil_3", "bos-ext-imc"), privilegeType);
            }

            if ((ResManager.loadKDString("免税", "TaxRateUtil_1", "bos-ext-imc").equals(privilegeType) || ResManager.loadKDString("不征税", "TaxRateUtil_2", "bos-ext-imc").equals(privilegeType)) && !"0".equals(taxRate)) {
                return ResManager.loadKDString("免税或不征税税率不合法", "TaxRateUtil_4", "bos-ext-imc");
            }

            if (ResManager.loadKDString("简易征收", "TaxRateUtil_5", "bos-ext-imc").equals(privilegeType) && !"0.05".equals(taxRate) && !"0.04".equals(taxRate) && !"0.03".equals(taxRate)) {
                return ResManager.loadKDString("简易征收税率不合法", "TaxRateUtil_6", "bos-ext-imc");
            }

            if (ResManager.loadKDString("按5%简易征收减按1.5%计征", "TaxRateUtil_7", "bos-ext-imc").equals(privilegeType) && !"0.015".equals(taxRate)) {
                return ResManager.loadKDString("按5%简易征收减按1.5%征,税率不合法", "TaxRateUtil_8", "bos-ext-imc");
            }

            if (ResManager.loadKDString("按5%简易征收", "TaxRateUtil_9", "bos-ext-imc").equals(privilegeType) && !"0.05".equals(taxRate)) {
                return ResManager.loadKDString("按5%简易征收,税率不合法", "TaxRateUtil_10", "bos-ext-imc");
            }

            if (ResManager.loadKDString("按3%简易征收", "TaxRateUtil_11", "bos-ext-imc").equals(privilegeType) && !"0.03".equals(taxRate)) {
                return ResManager.loadKDString("按3%简易征收,税率不合法", "TaxRateUtil_12", "bos-ext-imc");
            }
        }

        return null;
    }

    /**
     * 统一处理不统一的税率格式
     */
    public static String okTaxRate(String currTaxRate) {
        String rate=realOkTaxRate(currTaxRate);
        if ("0.1".equals(rate)){
            rate = rate + '0';
        }
        return rate;
    }

    private static String realOkTaxRate(String currTaxRate) {
        if (all.contains(currTaxRate)) {
            String tmpStr = currTaxRate.substring(0, currTaxRate.length() - 1);
            if ("0".equals(tmpStr)){return "0";}
            return String.valueOf(Double.parseDouble(tmpStr) / 100.0d);
        }
        if (Arrays.asList(intTaxRate).contains(currTaxRate)) {
            if ("0".equals(currTaxRate)){return currTaxRate;}
            return String.valueOf(Double.parseDouble(currTaxRate) / 100.0d);
        }
        return currTaxRate;
    }

    public static String convertTaxRate(String taxRate){
        try {
            if(StringUtils.isBlank(taxRate)){
                return null;
            }
            if (taxRate.contains("%")) {
                taxRate = percent2Point(taxRate);
            } else if (!taxRate.startsWith("0.")) {
                taxRate = new BigDecimal(taxRate).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString();
            }
            if ("0.1".equals(taxRate)) {
                taxRate = taxRate + '0';
            }
        }catch (Exception e){
            taxRate = "0";
        }
        return taxRate;
    }

    /**
     * @Description 小数转百分数
     * @Author zongjie_ye
     * @date 2021/9/3 15:37
     * @param taxRate
     * @return
     */
    public static String convertPercentTaxRate(String taxRate){
        try {
            if(StringUtils.isBlank(taxRate)){
                throw new KDBizException(ResManager.loadKDString("转换失败，税率不能为空", "TaxRateUtil_13", "bos-ext-imc"));
            }
            if (taxRate.contains("%")) {
               return  taxRate;
            } else if (taxRate.startsWith("0.")) {
                taxRate = new BigDecimal(taxRate).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString().concat("%");
            }
        }catch (Exception e){
            taxRate = "0";
        }
        return taxRate;
    }

}
