/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.balance.IBalanceField;
import kd.bos.metadata.balance.RuntimeBalanceInfoMeta;
import kd.bos.metadata.balance.RuntimeBalanceInfoMetaL;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;

public class BalanceEntity
extends BillEntity {
    public static final String SUFFIX = "_sp";
    private static final long serialVersionUID = -5031928319027626326L;
    public static final String BALANCETYPE_REALTIME = "realtime";
    public static final String BALANCETYPE_PERIOD = "period";
    public static final String BALANCETYPE_END = "endterm";
    private String balanceType = "realtime";
    private String snapshotPolicy = "A";
    private String updatePolicy = "A";
    private String mainOccCol;
    private List<Plugin> balancePlugins = new ArrayList<Plugin>(4);

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getBalancePlugins() {
        return this.balancePlugins;
    }

    public List<Plugin> setBalancePlugins() {
        return this.balancePlugins;
    }

    @SimplePropertyAttribute(name="MainOccCol")
    public String getMainOccCol() {
        return this.mainOccCol;
    }

    public void setMainOccCol(String mainOccCol) {
        this.mainOccCol = mainOccCol;
    }

    @SimplePropertyAttribute(name="SnapshotPolicy")
    public String getSnapshotPolicy() {
        return this.snapshotPolicy;
    }

    public void setSnapshotPolicy(String snapshotPolicy) {
        this.snapshotPolicy = snapshotPolicy;
    }

    @SimplePropertyAttribute(name="UpdatePolicy")
    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    @SimplePropertyAttribute
    public String getBalanceType() {
        return this.balanceType;
    }

    public void setBalanceType(String balanceType) {
        this.balanceType = balanceType;
    }

    public String getSnapshotTable() {
        String tableName = this.getTableName();
        return tableName == null ? null : tableName + SUFFIX;
    }

    public RuntimeBalanceInfoMeta buildBalanceInfoMeta(EntityMetadata entityMetadata) {
        RuntimeBalanceInfoMeta balanceInfo = new RuntimeBalanceInfoMeta();
        balanceInfo.setId(this.getId());
        balanceInfo.setNumber(this.getKey());
        balanceInfo.setBizAppId(entityMetadata.getBizappId());
        balanceInfo.setBalanceType(this.getBalanceType());
        balanceInfo.setTableName(this.getTableName());
        balanceInfo.setSnapshotTable(this.getTableName() + SUFFIX);
        balanceInfo.setPkFieldName(this.getPkFieldName());
        balanceInfo.setSnapshotPolicy(this.getSnapshotPolicy());
        balanceInfo.setUpdatePolicy(this.getUpdatePolicy());
        balanceInfo.setPluginClass(this.collectPlugins(this.getBalancePlugins()));
        balanceInfo.setMainOccCol(this.getMainOccCol());
        balanceInfo.setFieldsXML(this.collectBizDataType(entityMetadata.getItems()));
        balanceInfo.setTemplate(this.isTemplate());
        String sql = "SELECT fnumber,fsysstatus,fcuststatus FROM t_bal_balanceinfo WHERE fnumber = '" + this.getKey() + "'";
        try (DataSet data = DB.queryDataSet((String)"BalanceEntity.buildBalanceInfoMeta", (DBRoute)DBRoute.meta, (String)sql);){
            if (data.hasNext()) {
                Row row = data.next();
                balanceInfo.setSysStatus(row.getString("fsysstatus"));
                balanceInfo.setCustStatus(row.getString("fcuststatus"));
            }
        }
        return balanceInfo;
    }

    private String collectPlugins(List<Plugin> balancePlugins) {
        ArrayList<String> plugins = new ArrayList<String>(balancePlugins.size());
        for (Plugin plugin : balancePlugins) {
            if (!plugin.isEnabled()) continue;
            plugins.add(plugin.getClassName());
        }
        return SerializationUtils.toJsonString(plugins);
    }

    public List<RuntimeBalanceInfoMetaL> buildBalanceInfoMetaL(EntityMetadata entityMetadata) {
        ArrayList<RuntimeBalanceInfoMetaL> langs = new ArrayList<RuntimeBalanceInfoMetaL>(10);
        if (this.getName() == null || this.getName().isEmpty()) {
            return langs;
        }
        String[] pkids = DB.genStringIds((String)"", (int)this.getName().size());
        int i = 0;
        for (Map.Entry entry : this.getName().entrySet()) {
            String localeId = (String)entry.getKey();
            String name = (String)entry.getValue();
            if (StringUtils.isBlank((CharSequence)name)) continue;
            RuntimeBalanceInfoMetaL metaL = new RuntimeBalanceInfoMetaL();
            metaL.setPkid(pkids[i]);
            metaL.setId(this.getId());
            metaL.setNumber(this.getKey());
            metaL.setName(name);
            metaL.setLocaleId(localeId);
            langs.add(metaL);
            ++i;
        }
        return langs;
    }

    private String collectBizDataType(List<EntityItem<?>> entities) {
        HashMap<String, String> bizDataTypes = new HashMap<String, String>();
        for (EntityItem<?> entity : entities) {
            if (!(entity instanceof IBalanceField)) continue;
            String bizDataType = ((IBalanceField)entity).getBizDataType();
            bizDataTypes.put(entity.getKey(), bizDataType);
        }
        return SerializationUtils.toJsonString(bizDataTypes);
    }
}

