/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.balance.BizDataType;
import kd.bos.metadata.balance.BalanceEntity;
import kd.bos.metadata.balance.BalanceRuleCacheUtils;
import kd.bos.metadata.balance.IBalanceField;
import kd.bos.metadata.balance.RuntimeBalanceInfoMeta;
import kd.bos.metadata.balance.RuntimeBalanceInfoMetaL;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.FormmetaDaoPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.ShardingUtil;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;

public class BalanceFormMetaDaoPlugin
extends FormmetaDaoPlugin {
    private RuntimeBalanceInfoMeta balanceInfo;
    private List<RuntimeBalanceInfoMetaL> balanceInfo_Ls = new ArrayList<RuntimeBalanceInfoMetaL>();
    private IDataEntityType balanceType = null;
    private IDataEntityType balanceType_L = null;
    private EntityMetadata entityMeta;

    private IDataEntityType getBalanceType() {
        if (this.balanceType == null) {
            this.balanceType = OrmUtils.getDataEntityType(RuntimeBalanceInfoMeta.class);
        }
        return this.balanceType;
    }

    private IDataEntityType getBalanceType_L() {
        if (this.balanceType_L == null) {
            this.balanceType_L = OrmUtils.getDataEntityType(RuntimeBalanceInfoMetaL.class);
        }
        return this.balanceType_L;
    }

    public void delete(String id) {
        Object[] datas;
        super.delete(id);
        IDataEntityType type = this.getBalanceType();
        Object[] ids = new Object[]{id};
        for (Object data : datas = BusinessDataReader.load((Object[])ids, (IDataEntityType)type)) {
            RuntimeBalanceInfoMeta meta = (RuntimeBalanceInfoMeta)data;
            BalanceRuleCacheUtils.removeBalVersion(meta.getNumber());
        }
        BusinessDataWriter.delete((IDataEntityType)this.getBalanceType(), (Object[])ids);
        BusinessDataWriter.delete((IDataEntityType)this.getBalanceType_L(), (Object[])new Object[]{id});
    }

    protected void beforeTransaction(FormMetadata formMeta, EntityMetadata entityMeta) {
        super.beforeTransaction(formMeta, entityMeta);
        this.buildBalanceInfo(entityMeta);
    }

    protected void beginTransaction(FormMetadata formMeta, EntityMetadata entityMeta) {
        super.beginTransaction(formMeta, entityMeta);
    }

    protected void endTransaction(FormMetadata formMeta, EntityMetadata entityMeta) {
        super.endTransaction(formMeta, entityMeta);
        if (entityMeta != null) {
            BusinessDataWriter.delete((IDataEntityType)this.getBalanceType(), (Object[])new Object[]{entityMeta.getId()});
            BusinessDataWriter.delete((IDataEntityType)this.getBalanceType_L(), (Object[])new Object[]{entityMeta.getId()});
            BusinessDataWriter.save((IDataEntityType)this.getBalanceType(), (Object[])new Object[]{this.balanceInfo});
            BusinessDataWriter.save((IDataEntityType)this.getBalanceType_L(), (Object[])this.balanceInfo_Ls.toArray());
            BalanceRuleCacheUtils.updateBalVersion(this.balanceInfo.getNumber());
        }
    }

    protected void afterTransaction(FormMetadata formMeta, EntityMetadata entityMeta) {
        super.afterTransaction(formMeta, entityMeta);
        this.entityMeta = entityMeta;
    }

    public void builderSchemaAfterSave() {
        super.builderSchemaAfterSave();
        if (this.entityMeta != null) {
            this.buildBalanceSnapShot(this.entityMeta);
        }
    }

    private boolean buildBalanceSnapShot(EntityMetadata entityMetadata) {
        MainEntity rootEntity = entityMetadata.getRootEntity();
        if (!(rootEntity instanceof BalanceEntity) || rootEntity.isTemplate()) {
            return false;
        }
        BalanceEntity balEntity = (BalanceEntity)rootEntity;
        String tableName = balEntity.getTableName();
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return false;
        }
        String snTableName = tableName + "_sp";
        String snTmpTableName = tableName + "_tp";
        boolean useSharding = ShardingUtil.isUseSharding((EntityMetadata)entityMetadata);
        String entityId = MetadataDao.getIdByNumber((String)"bal_snapshot", (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return false;
        }
        EntityMetadata snapShotEntityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        MainEntity spEntity = snapShotEntityMeta.getRootEntity();
        List items = spEntity.getItems();
        ArrayList oldItems = new ArrayList(items);
        String oldTb = spEntity.getTableName();
        String tempBizDataType = null;
        Field field = null;
        HashSet<String> spCol = new HashSet<String>();
        spCol.add(BizDataType.OCC.getNumber());
        spCol.add(BizDataType.IN.getNumber());
        spCol.add(BizDataType.INIT.getNumber());
        spCol.add(BizDataType.OUT.getNumber());
        HashSet<String> notSpCol = new HashSet<String>();
        notSpCol.add(BizDataType.COVER.getNumber());
        notSpCol.add(BizDataType.PER.getNumber());
        for (EntityItem item : balEntity.getItems()) {
            if (!(item instanceof IBalanceField)) continue;
            tempBizDataType = ((IBalanceField)item).getBizDataType();
            if (spCol.contains(tempBizDataType)) {
                field = (Field)item;
                DecimalField qtyItem = new DecimalField();
                qtyItem.setFieldName(field.getFieldName() + "_sp");
                qtyItem.setKey(field.getKey() + "_sp");
                items.add(qtyItem);
                continue;
            }
            if (!notSpCol.contains(tempBizDataType)) continue;
            if (item instanceof Field) {
                ((Field)item).setSuffix(null);
            }
            items.add(item);
        }
        spEntity.setdbRoute(balEntity.getdbRoute());
        BalanceTableUtil util = new BalanceTableUtil();
        spEntity.setTableName(snTableName);
        util.createTable(snapShotEntityMeta, (Entity<?, ?>)spEntity, useSharding);
        CheckBoxField readType = new CheckBoxField();
        readType.setKey("readtype");
        readType.setFieldName("freadtype");
        CheckBoxField moveType = new CheckBoxField();
        moveType.setKey("movetype");
        moveType.setFieldName("fmovetype");
        CheckBoxField coverFlag = new CheckBoxField();
        coverFlag.setKey("coverflag");
        coverFlag.setFieldName("fcoverflag");
        CheckBoxField sync = new CheckBoxField();
        sync.setKey("sync");
        sync.setFieldName("fsync");
        items.add(readType);
        items.add(moveType);
        items.add(coverFlag);
        items.add(sync);
        spEntity.setTableName(snTmpTableName);
        util.createTable(snapShotEntityMeta, (Entity<?, ?>)spEntity, useSharding);
        spEntity.setTableName(oldTb);
        spEntity.getItems().clear();
        spEntity.getItems().addAll(oldItems);
        return true;
    }

    private void buildBalanceInfo(EntityMetadata entityMeta) {
        if (entityMeta == null) {
            return;
        }
        BalanceEntity balanceEntity = (BalanceEntity)entityMeta.getRootEntity();
        this.balanceInfo = balanceEntity.buildBalanceInfoMeta(entityMeta);
        this.balanceInfo_Ls.addAll(balanceEntity.buildBalanceInfoMetaL(entityMeta));
        this.balanceInfo.setModifierId(RequestContext.get().getCurrUserId());
        this.balanceInfo.setModifyDate(new Date());
        try {
            RuntimeBalanceInfoMeta oldBalanceInfo = (RuntimeBalanceInfoMeta)BusinessDataReader.read((Object)entityMeta.getId(), (IDataEntityType)this.getBalanceType(), (Boolean)false);
            if (oldBalanceInfo != null) {
                this.balanceInfo.setSysStatus(oldBalanceInfo.getSysStatus());
                this.balanceInfo.setCustStatus(oldBalanceInfo.getCustStatus());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class BalanceTableUtil
    extends AlterTableUtil {
        private BalanceTableUtil() {
        }

        public boolean createTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding) {
            return super.createTable(entityMetadata, entity, useSharding);
        }
    }
}

