/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.balance.BalanceRuleCacheUtils;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.BalanceUpdateRuleWriter;
import kd.bos.metadata.balance.DesignBalanceRuleMeta;
import kd.bos.metadata.balance.RuntimeBalanceUpdateRuleMeta;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.metadata.exception.ErrorInfo;

public class BalanceUpdateRuleMetaDaoPlugin
implements IMetadataDaoPlugIn {
    private static IDataEntityType designMetaType;
    private static IDataEntityType runtimeMetaType;
    private List<ErrorInfo> errors = new ArrayList<ErrorInfo>();

    private static synchronized IDataEntityType getDesignMetaType() {
        if (designMetaType == null) {
            designMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
        }
        return designMetaType;
    }

    private static synchronized IDataEntityType getRuntimeMetaType() {
        if (runtimeMetaType == null) {
            runtimeMetaType = OrmUtils.getDataEntityType(RuntimeBalanceUpdateRuleMeta.class);
        }
        return runtimeMetaType;
    }

    public HashSet<String> loadDisableExtend(HashSet<String> extObjectIds) {
        HashSet<String> disableIds = new HashSet<String>();
        if (extObjectIds.size() == 0) {
            return disableIds;
        }
        String ids = StringUtils.join((Object[])extObjectIds.toArray(), (String)"','");
        String sql = String.format("SELECT FId FROM %s_S WHERE FCustStatus <> '1' and FId IN ('%s') ", BalanceUpdateRuleMetaDaoPlugin.getDesignMetaType().getAlias(), ids);
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    list.add(id);
                }
                return list;
            }
        };
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
        disableIds.addAll(list);
        return disableIds;
    }

    public void save(AbstractMetadata[] metadatas) {
        for (AbstractMetadata metadata : metadatas) {
            this.saveStatus((BalanceUpdateRuleMetadata)metadata);
        }
    }

    public void afterReadMeta(AbstractMetadata meta) {
        this.loadStatus((BalanceUpdateRuleMetadata)meta);
    }

    public void saveRuntimeMeta(AbstractMetadata[] metadatas) {
        this.saveRuntimeMeta(false, metadatas);
    }

    public void saveRuntimeMeta(boolean isDraft, AbstractMetadata[] metadatas) {
        BalanceUpdateRuleMetadata ruleMetadata = null;
        for (AbstractMetadata meta : metadatas) {
            if (!(meta instanceof BalanceUpdateRuleMetadata)) continue;
            ruleMetadata = (BalanceUpdateRuleMetadata)meta;
            break;
        }
        if (ruleMetadata != null && StringUtils.equals((CharSequence)ruleMetadata.getDevType(), (CharSequence)"2")) {
            BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
            ruleMetadata = reader.loadMeta(ruleMetadata.getMasterId(), true);
        }
        if (ruleMetadata == null) {
            return;
        }
        this.clearCache(ruleMetadata);
        List<RuntimeBalanceUpdateRuleMeta> runtimeMetas = ruleMetadata.buildRuntimeMetadata();
        if (!isDraft) {
            this.errors.addAll(ruleMetadata.getBuildErrors());
        }
        if (this.hasBuildError()) {
            return;
        }
        try (TXHandle txh = TX.required();){
            try {
                BusinessDataWriter.delete((IDataEntityType)BalanceUpdateRuleMetaDaoPlugin.getRuntimeMetaType(), (Object[])new Object[]{ruleMetadata.getId()});
                BusinessDataWriter.save((IDataEntityType)BalanceUpdateRuleMetaDaoPlugin.getRuntimeMetaType(), (Object[])runtimeMetas.toArray());
            }
            catch (Throwable e) {
                txh.markRollback();
                throw e;
            }
        }
        this.bindOperationService(ruleMetadata);
    }

    public void delete(String id) {
        try {
            DesignBalanceRuleMeta designMeta = (DesignBalanceRuleMeta)((Object)BusinessDataReader.read((Object)id, (IDataEntityType)BalanceUpdateRuleMetaDaoPlugin.getDesignMetaType(), (Boolean)false));
            if (designMeta != null) {
                this.clearCache(designMeta);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BusinessDataWriter.delete((IDataEntityType)BalanceUpdateRuleMetaDaoPlugin.getRuntimeMetaType(), (Object[])new Object[]{id});
    }

    private boolean hasBuildError() {
        for (ErrorInfo errorInfo : this.errors) {
            if (errorInfo.getLevel() != 2) continue;
            return true;
        }
        return false;
    }

    private static String readOldNumber(String id, IDataEntityType type) {
        String sql = String.format("select FNumber from %s where FId = ? ", type.getAlias());
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private void saveStatus(BalanceUpdateRuleMetadata meta) {
        String sqlExists = String.format("select FID from %s_S where FId = ? ", BalanceUpdateRuleMetaDaoPlugin.getDesignMetaType().getAlias());
        Object[] paramsExists = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        boolean exists = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sqlExists, (Object[])paramsExists, (ResultSetHandler)action);
        String sql = null;
        Object[] params = null;
        if (exists) {
            sql = String.format("update %s_S set FCustStatus = ? where FId = ? ", BalanceUpdateRuleMetaDaoPlugin.getDesignMetaType().getAlias());
            params = new SqlParameter[]{new SqlParameter(":FCustStatus", 1, (Object)meta.getRuleElement().getCustStatus()), new SqlParameter(":FId", 12, (Object)meta.getId())};
        } else {
            sql = String.format("insert into %s_S (FID, FCustStatus) values (?, ?)", BalanceUpdateRuleMetaDaoPlugin.getDesignMetaType().getAlias());
            params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId()), new SqlParameter(":FCustStatus", 1, (Object)meta.getRuleElement().getCustStatus())};
        }
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
    }

    private boolean loadStatus(final BalanceUpdateRuleMetadata meta) {
        String sql = String.format("select FCustStatus from %s_S where FId = ? ", BalanceUpdateRuleMetaDaoPlugin.getDesignMetaType().getAlias());
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    String custStatus = rs.getString(1);
                    meta.getRuleElement().setCustStatus(custStatus);
                    return true;
                }
                meta.getRuleElement().setCustStatus("1");
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private void clearCache(BalanceUpdateRuleMetadata ruleMetadata) {
        String oldNumber;
        String ruleId = ruleMetadata.getId();
        if (ruleMetadata.getDevType().equals("2")) {
            ruleId = ruleMetadata.getMasterId();
        }
        if (StringUtils.isBlank((CharSequence)(oldNumber = BalanceUpdateRuleMetaDaoPlugin.readOldNumber(ruleId, BalanceUpdateRuleMetaDaoPlugin.getRuntimeMetaType())))) {
            oldNumber = ruleMetadata.getNumber();
        }
        this.clearCache(oldNumber, ruleMetadata.getRuleElement().getBalanceTableNumber(), ruleMetadata.getRuleElement().getSourceEntityNumber());
    }

    private void clearCache(DesignBalanceRuleMeta designMeta) {
        String number = designMeta.getNumber();
        if (StringUtils.equals((CharSequence)"2", (CharSequence)designMeta.getDevType())) {
            number = BalanceUpdateRuleMetaDaoPlugin.readOldNumber(designMeta.getMasterId(), BalanceUpdateRuleMetaDaoPlugin.getDesignMetaType());
        }
        this.clearCache(number, designMeta.getBalanceTableNumber(), designMeta.getSourceEntityNumber());
    }

    private void clearCache(String number, String balanceTableNumber, String sourceEntityNumber) {
        BalanceRuleCacheUtils.removeRuleDistributeCache(number);
        BalanceRuleCacheUtils.removeBillRuleListDistributeCache(sourceEntityNumber);
        BalanceRuleCacheUtils.removeTableRuleListDistributeCache(balanceTableNumber);
    }

    private void bindOperationService(BalanceUpdateRuleMetadata ruleMetadata) {
        String entityNumber = ruleMetadata.getRuleElement().getSourceEntityNumber();
        List<BalanceUpdateRuleElement> rules = BalanceUpdateRuleReader.loadRulesBySrcBill(entityNumber);
        rules.add(ruleMetadata.getRuleElement());
        BalanceUpdateRuleWriter.updateRuleBizOp(entityNumber, rules);
    }
}

