/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.archive.RecordSplitTaskHandle;
import kd.bos.bal.business.archive.RecordSplitUtil;
import kd.bos.bal.common.BalPoolUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BalRecordSplitManager {
    public static final String RECORD_SPLIT_TASK = "bal_record_split";
    public static final String SUB_RECORD_SPLIT_TASK = "bal_record_split_task";

    public static void buildTask(DynamicObject task) {
        BalPoolUtil.executeByOtherExecutor(() -> new RecordSplitTaskHandle().buildTask(task));
    }

    public static void consumerTask(TaskMsg msg) {
        new RecordSplitTaskHandle().consumerTask(msg);
    }

    public static Map<String, DynamicObject> loadBalBackRecordByKeycol(BalanceTB balanceTB, Collection<String> allKeys) {
        return RecordSplitUtil.loadBalBackRecordByKeycol(balanceTB, allKeys);
    }

    public static void revertRecordById(BalanceTB balanceTB, Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        Set<String> keycols = BalRecordSplitManager.getKeycolById(balanceTB, ids);
        BalRecordSplitManager.revertRecordByKeycol(balanceTB, keycols);
    }

    private static Set<String> getKeycolById(BalanceTB bal, Collection<Long> ids) {
        String filter = " FID " + QFUtil.getIdsFilter(ids);
        HashSet<String> keycols = new HashSet<String>(ids.size());
        try (DataSet infos = DB.queryDataSet((String)"getKeycolById", (DBRoute)bal.getDbRoute(), (String)("SELECT FKEYCOL FROM " + bal.getColBackTb() + " WHERE " + filter));){
            for (Row info : infos) {
                keycols.add(info.getString("FKEYCOL"));
            }
        }
        return keycols;
    }

    public static Set<String> revertRecordByKeycol(BalanceTB balanceTB, Collection<String> keycols) {
        HashSet<String> keycol4Revert = new HashSet<String>();
        if (keycols == null || keycols.isEmpty()) {
            return keycol4Revert;
        }
        keycol4Revert.addAll(keycols);
        Set<String> keycol4Del = BalRecordSplitManager.filterExistRecord(balanceTB, keycols);
        keycol4Revert.removeAll(keycol4Del);
        Map<String, DynamicObject> records = BalRecordSplitManager.loadBalBackRecordByKeycol(balanceTB, keycol4Revert);
        keycol4Del.addAll(records.keySet());
        keycol4Revert.removeAll(records.keySet());
        BalRecordSplitManager.reBuildRecord(balanceTB, records, keycol4Del);
        return keycol4Revert;
    }

    private static void reBuildRecord(BalanceTB balanceTB, Map<String, DynamicObject> records, Collection<String> allKeycols) {
        if (allKeycols.isEmpty()) {
            return;
        }
        String filter = QFUtil.getIdsFilter(allKeycols, true);
        String delSql = "DELETE FROM " + balanceTB.getColBackTb() + " WHERE FKEYCOL " + filter;
        try (TXHandle tx = TX.requiresNew((String)"reBuildRecord");){
            try {
                if (!records.isEmpty()) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("updateModifyDate", "false");
                    SaveServiceHelper.save((DynamicObject[])records.values().toArray(new DynamicObject[0]), (OperateOption)option);
                }
                DB.execute((DBRoute)balanceTB.getDbRoute(), (String)delSql);
            }
            catch (Throwable t) {
                tx.markRollback();
                throw t;
            }
        }
    }

    private static Set<String> filterExistRecord(BalanceTB balanceTB, Collection<String> keycols) {
        String filter = QFUtil.getIdsFilter(keycols, true);
        String selectSql = "SELECT FKEYCOL FROM " + balanceTB.getTb() + " WHERE FKEYCOL " + filter;
        HashSet<String> existKeycols = new HashSet<String>(keycols.size());
        try (DataSet dataSet = DB.queryDataSet((String)"filterExistRecord", (DBRoute)balanceTB.getDbRoute(), (String)selectSql);){
            int index = dataSet.getRowMeta().getFieldIndex("FKEYCOL");
            for (Row row : dataSet) {
                existKeycols.add(row.getString(index));
            }
        }
        return existKeycols;
    }

    public static int applyVer4ColList(String balName) {
        return RecordSplitUtil.applyVer4ColList(balName);
    }
}

