/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.business.repair.BalRepairManager;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

class RecordSplitUtil {
    private static final Map<String, ConcurrentHashMap<Integer, List<String>>> VER_CACHE = new ConcurrentHashMap<String, ConcurrentHashMap<Integer, List<String>>>();

    RecordSplitUtil() {
    }

    static List<String> queryColList(String balName, int ver) {
        String key = RequestContext.getOrCreate().getAccountId() + "_" + balName;
        Map cacheItem = VER_CACHE.computeIfAbsent(key, k -> new ConcurrentHashMap());
        List<String> colList = (List<String>)cacheItem.get(ver);
        if (colList == null) {
            colList = RecordSplitUtil.queryColListFromDB(balName, ver);
            if (cacheItem.size() > 100) {
                cacheItem.clear();
            }
            if (!colList.isEmpty()) {
                cacheItem.put(ver, colList);
            }
        }
        return colList;
    }

    private static List<String> queryColListFromDB(String balName, int ver) {
        QFilter fs = new QFilter("ver", "=", (Object)ver).and("bal", "=", (Object)balName);
        DynamicObject info = QueryServiceHelper.queryOne((String)"bal_record_split_ver", (String)"col_tag", (QFilter[])fs.toArray());
        if (info != null) {
            String cols = info.getString("col_tag");
            return RecordSplitUtil.buildCols(cols);
        }
        return Collections.emptyList();
    }

    private static List<String> buildCols(String cols) {
        if (cols != null) {
            String[] colArr = cols.split(",");
            ArrayList<String> colList = new ArrayList<String>(colArr.length);
            for (String col : colArr) {
                colList.add(col);
            }
            return Collections.unmodifiableList(colList);
        }
        return Collections.emptyList();
    }

    static synchronized int applyVer4ColList(String balName) {
        try (DLock lock = DLock.create((String)("Bal_applyVer4ColList_" + balName));){
            if (lock.tryLock()) {
                BalanceTB bal = BalanceTB.getBalanceTB(balName);
                QFilter fs = new QFilter("bal", "=", (Object)balName);
                DynamicObjectCollection datas = QueryServiceHelper.query((String)"applyVer4ColList", (String)"bal_record_split_ver", (String)"ver,col_tag", (QFilter[])fs.toArray(), (String)"ver desc");
                int ver = 1;
                if (datas == null || datas.isEmpty()) {
                    RecordSplitUtil.addVerInfo(ver, bal);
                    int n = ver;
                    return n;
                }
                DynamicObject info = (DynamicObject)datas.get(0);
                ver = info.getInt("ver");
                List<String> colList = RecordSplitUtil.buildCols(info.getString("col_tag"));
                if (!RecordSplitUtil.checkColList(colList, bal.getColList4RecordSplit())) {
                    RecordSplitUtil.addVerInfo(++ver, bal);
                }
                int n = ver;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    static boolean checkColList(List<String> taskColList, List<String> balColList) {
        if (taskColList.size() != balColList.size()) {
            return false;
        }
        int len = taskColList.size();
        for (int i = 0; i < len; ++i) {
            if (taskColList.get(i).equals(balColList.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void addVerInfo(int var, BalanceTB bal) {
        DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"bal_record_split_ver");
        info.set("ver", (Object)var);
        info.set("bal", (Object)bal.getName());
        info.set("createdate", (Object)new Date());
        info.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
        info.set("col_tag", (Object)String.join((CharSequence)",", bal.getColList4RecordSplit()));
        try (TXHandle tx = TX.requiresNew((String)"addVerInfo");){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        }
    }

    static String zipRecordByRow(Row balData, List<String> sortCols, int ver) throws IOException {
        String jsonStr = RecordSplitUtil.toJsonRecord(balData, sortCols, ver);
        return RecordSplitUtil.zipRecord(jsonStr);
    }

    private static String zipRecord(String str) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(str.getBytes("UTF-8"));
            gzip.close();
            String string = Base64.getEncoder().encodeToString(out.toByteArray());
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    static String unZipRecord(String base64Str) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String toJsonRecord(Row balData, List<String> sortCols, int ver) {
        Object[] vals = new Object[sortCols.size() + 1];
        vals[0] = ver;
        for (int i = 0; i < sortCols.size(); ++i) {
            vals[i + 1] = balData.get(sortCols.get(i));
        }
        String jsonStr = JSON.toJSONString((Object)vals);
        return jsonStr;
    }

    static void archiveZeroRecord(int ver, BalanceTB bal, List<Long> balIds, boolean isAutoRepair) {
        if (isAutoRepair) {
            BalRepairManager.repairSpDataSumBal(bal, balIds);
        }
        QFilter fs = RecordSplitUtil.buildFs4ArchiveZeroRecord(bal, balIds);
        List<String> colList = bal.getColList4RecordSplit();
        ArrayList<Object[]> params = new ArrayList<Object[]>(balIds.size());
        ArrayList<Object> ids = new ArrayList<Object>(balIds.size());
        DataSet balDatas = QueryServiceHelper.queryDataSet((String)"archiveZeroRecord", (String)bal.getName(), (String)("keycol,id," + String.join((CharSequence)",", colList)), (QFilter[])fs.toArray(), null);
        Object object = null;
        try {
            for (Row balData : balDatas) {
                RecordSplitUtil.buildParams(params, ids, balData, colList, ver);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (balDatas != null) {
                if (object != null) {
                    try {
                        balDatas.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    balDatas.close();
                }
            }
        }
        if (params.isEmpty() || ids.isEmpty()) {
            return;
        }
        ArrayList<Object[]> keycols = new ArrayList<Object[]>(params.size());
        for (Object[] param : params) {
            keycols.add(new Object[]{param[0]});
        }
        TXHandle tx = TX.requiresNew((String)"archiveZeroRecord");
        Object object2 = null;
        try {
            try {
                DB.executeBatch((DBRoute)bal.getDbRoute(), (String)("DELETE FROM " + bal.getColBackTb() + " WHERE FKEYCOL = ?"), keycols);
                DB.executeBatch((DBRoute)bal.getDbRoute(), (String)("INSERT INTO " + bal.getColBackTb() + " (FKEYCOL,FID,FCOLBACK) VALUES (?,?,?)"), params);
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)bal.getName()), (Object[])ids.toArray());
            }
            catch (Throwable e) {
                tx.markRollback();
                BalLogUtil.saveError("RecordSplitTaskHandle", "keycols.size=" + keycols.size(), "archiveZeroRecord", e);
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static void buildParams(List<Object[]> params, List<Object> ids, Row balData, List<String> colList, int ver) {
        try {
            long id = balData.getLong("id");
            String backInfo = RecordSplitUtil.zipRecordByRow(balData, colList, ver);
            params.add(new Object[]{balData.getString("keycol"), id, backInfo});
            ids.add(id);
        }
        catch (IOException e) {
            BalLogUtil.error("RecordSplitTaskHandle.buildParams error: balData = " + balData, e);
        }
    }

    static Map<String, DynamicObject> loadBalBackRecordByKeycol(BalanceTB bal, Collection<String> keys) {
        String filter = " FKEYCOL " + QFUtil.getIdsFilter(keys, true);
        return RecordSplitUtil.loadBalBackRecord(bal, filter);
    }

    private static Map<String, DynamicObject> loadBalBackRecord(BalanceTB bal, String filter) {
        HashMap<String, DynamicObject> reBuildRecords = new HashMap<String, DynamicObject>();
        String modifyTimeCol = bal.getModifyTimeCol();
        Date initDate = new Date(0L);
        try (DataSet infos = DB.queryDataSet((String)"loadBalBackRecord", (DBRoute)bal.getDbRoute(), (String)("SELECT FKEYCOL,FID,FCOLBACK FROM " + bal.getColBackTb() + " WHERE " + filter));){
            RowMeta rowMeta = infos.getRowMeta();
            int idxKey = rowMeta.getFieldIndex("FKEYCOL");
            int idxId = rowMeta.getFieldIndex("FID");
            int idxCol = rowMeta.getFieldIndex("FCOLBACK");
            String balName = bal.getName();
            for (Row info : infos) {
                DynamicObject balRecord = BusinessDataServiceHelper.newDynamicObject((String)balName);
                if (modifyTimeCol != null) {
                    balRecord.set(modifyTimeCol, (Object)initDate);
                }
                String keyCol = info.getString(idxKey);
                balRecord.set("keycol", (Object)keyCol);
                balRecord.set("id", (Object)info.getLong(idxId));
                if (!RecordSplitUtil.reBuildRecord(balName, balRecord, info.getString(idxCol))) continue;
                reBuildRecords.put(keyCol, balRecord);
            }
        }
        return reBuildRecords;
    }

    private static boolean reBuildRecord(String balName, DynamicObject balRecord, String colBackInfo) {
        try {
            String jsonData = RecordSplitUtil.unZipRecord(colBackInfo);
            JSONArray vals = JSON.parseArray((String)jsonData);
            int ver = vals.getIntValue(0);
            List<String> colList = RecordSplitUtil.queryColList(balName, ver);
            for (int i = 0; i < colList.size(); ++i) {
                String col = colList.get(i);
                Object val = vals.get(i + 1);
                balRecord.set(col, val);
            }
            return true;
        }
        catch (Exception e) {
            BalLogUtil.error("unZipRecord error: balName=" + balName + ", keycol=" + balRecord.getString("keycol") + ", colBackInfo=" + colBackInfo, e);
            return false;
        }
    }

    static QFilter buildOccQtyFs(BalanceTB bal) {
        QFilter fs = null;
        Set<String> occCols = bal.getOccCols();
        for (String occCol : occCols) {
            fs = fs == null ? new QFilter(occCol, "=", (Object)0) : fs.and(occCol, "=", (Object)0);
        }
        return fs;
    }

    private static QFilter buildFs4ArchiveZeroRecord(BalanceTB bal, List<Long> balIds) {
        QFilter fs = new QFilter("id", "in", balIds);
        Set<String> occCols = bal.getOccCols();
        for (String occCol : occCols) {
            fs.and(occCol, "=", (Object)0);
        }
        return fs;
    }
}

