/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.bal.business.archive.SpDataSplitUtil;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalInnerUtil;
import kd.bos.bal.business.sparse.SparseDataLoader;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.balance.BizDataType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

class SpDataSplit {
    private static final String IDS_DEL = "ids_del";
    private static final String ALL_ZERO_FLAG = "all_zero_flag";
    private static final String ALL_ZERO_FLAG_TRUE = "1";
    private long fromId;
    private final long toId;
    private final BalanceTB bal;
    private final DynamicObject taskInfo;
    private String taskMode;
    private final String bill;
    private final Long lastSuccessId;
    private long maxLimitBillId;
    private final boolean formKbTB;
    private final String actualTb;
    private final int queryBatch;
    private final boolean saveZeroSpDataRow;
    private final int sumBatch;
    private final String deleteSql;
    private Set<String> qtyCols;
    private final long maxBillIdOfCfg;
    private final long maxBillIdOfPoint;
    private final String[] fixValColCache = new String[]{"fid", "fupdatetime", "fcreatetime", "fmovetime", "fbillname", "fbillid", "fentryid", "fupdatetype", "fbillno", "fentryseq", "fstatus", "fisnew"};
    private String insertSqlCache;
    private List<String> insertColCache;

    SpDataSplit(DynamicObject taskInfo) {
        String balName = taskInfo.getString("parenttask.bal.id");
        this.bal = BalanceTB.getBalanceTB(balName);
        this.fromId = taskInfo.getLong("fromid");
        this.toId = taskInfo.getLong("toid");
        this.lastSuccessId = taskInfo.getLong("lastsuccessid");
        this.bill = taskInfo.getString("bill.id");
        this.taskInfo = taskInfo;
        this.maxLimitBillId = taskInfo.getLong("parenttask.idpoint");
        this.actualTb = taskInfo.getString("sparseseq.actualtb");
        this.formKbTB = this.bal.isRealBal() && this.bal.getColBackTb().equalsIgnoreCase(this.actualTb);
        BalConfig cfg = BalConfig.loadBalConfig(balName);
        this.queryBatch = cfg.getSpDataSpiltQueryBatch();
        this.saveZeroSpDataRow = cfg.isSaveZeroSpDataRow();
        this.sumBatch = cfg.getSpDataSpiltSumBatch();
        this.deleteSql = "DELETE FROM " + this.bal.getSnapshotTb() + " WHERE FID = ? ";
        this.maxBillIdOfCfg = BalUtil.getIdByDays(cfg.getSpDataSpiltLimitDay());
        this.maxBillIdOfPoint = SpDataSplitUtil.getArchiveLimitId(this.bal.getName(), this.bill);
        this.setParam2Task();
        if (this.maxBillIdOfPoint == 0L) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7ed3\u8f6c\u8bb0\u5f55\u70b9\uff0c\u4e0d\u80fd\u505a\u7ed3\u8f6c\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u53d1\u5e03\u4efb\u52a1\u3002", (String)"SpDataSplit_1", (String)"bos-biz-balance", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        this.maxLimitBillId = Math.min(this.maxLimitBillId, this.maxBillIdOfCfg);
        this.maxLimitBillId = Math.min(this.maxLimitBillId, this.maxBillIdOfPoint);
    }

    public void setTaskMode(String mode) {
        this.taskMode = mode;
    }

    private void buildAndSetParams() {
        if ("B".equals(this.taskMode)) {
            this.fromId = Math.max(this.lastSuccessId, this.fromId);
        }
        this.setParam2Task();
    }

    private TreeSet<Long> getAllBalIds() {
        SparseDataLoader loader = new SparseDataLoader(this.taskInfo, this.fromId, this.toId);
        if (this.bal.isPerBal()) {
            loader.setOtherFs(new QFilter(this.bal.getEndPeriodCol(), "=", (Object)999999));
        }
        return loader.getAllIds();
    }

    public void split() {
        this.buildAndSetParams();
        TreeSet<Long> allIds = this.getAllBalIds();
        TreeSet<Long> batchIds = new TreeSet<Long>();
        for (Long id : allIds) {
            batchIds.add(id);
            if (batchIds.size() < this.sumBatch) continue;
            this.doSplitByBalIds(batchIds);
            this.setLastSuccessId(batchIds.last());
            batchIds.clear();
        }
        if (!batchIds.isEmpty()) {
            this.doSplitByBalIds(batchIds);
            this.setLastSuccessId(batchIds.last());
        }
    }

    private void setParam2Task() {
        String msg = String.format("fromId=%s, toId=%s, maxLimitBillId=%s, maxBillIdOfCfg=%s, maxBillIdOfPoint=%s", this.fromId, this.toId, this.maxLimitBillId, this.maxBillIdOfCfg, this.maxBillIdOfPoint);
        this.taskInfo.set("param_tag", (Object)msg);
    }

    private void setLastSuccessId(Object lastId) {
        this.taskInfo.set("lastsuccessid", lastId);
    }

    public void doSplitByBalIds(TreeSet<Long> balIds) {
        TreeSet<String> keyCols = this.getKeyColById(balIds);
        if (keyCols.isEmpty()) {
            return;
        }
        List<Object[]> params = this.buildTxParams(keyCols);
        try (TXHandle lockTx = TX.requiresNew((String)"doSplitByBalIds").setRollback(true);){
            BalInnerUtil.lockUpdate(this.bal, params);
            this.doSplitByKeyCols(keyCols);
        }
        BalInnerUtil.forceUnLockUpdate(this.bal);
    }

    private TreeSet<String> getKeyColById(TreeSet<Long> balIds) {
        String selectSql = "SELECT FKEYCOL FROM  " + this.actualTb + " WHERE FID " + QFUtil.getIdsFilter(balIds);
        TreeSet<String> keyCols = new TreeSet<String>();
        try (DataSet data = DB.queryDataSet((String)"getKeyColById_1", (DBRoute)this.bal.getDbRoute(), (String)selectSql);){
            for (Row row : data) {
                keyCols.add(row.getString("FKEYCOL"));
            }
        }
        if (this.formKbTB) {
            QFilter fs = new QFilter("keycol", "in", keyCols);
            DataSet data = QueryServiceHelper.queryDataSet((String)"getKeyColById_2", (String)this.bal.getName(), (String)"keycol", (QFilter[])fs.toArray(), null);
            Object object = null;
            try {
                for (Row row : data) {
                    keyCols.remove(row.getString("keycol"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (data != null) {
                    if (object != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        data.close();
                    }
                }
            }
        }
        return keyCols;
    }

    private List<Object[]> buildTxParams(TreeSet<String> keyCols) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(keyCols.size());
        for (String keyCol : keyCols) {
            params.add(new Object[]{keyCol});
        }
        return params;
    }

    protected void applyTxLock(List<Object[]> params) {
        String sql = "INSERT INTO " + this.bal.getUpdateLockTb() + " (FKEYCOL) VALUES (?) ";
        DB.executeBatch((DBRoute)this.bal.getDbRoute(), (String)sql, params);
    }

    private void doSplitByKeyCols(TreeSet<String> keyCols) {
        String selectSql = this.buildSelectSql(keyCols);
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(keyCols.size());
        ArrayList<Object[]> delParams = new ArrayList<Object[]>(keyCols.size());
        List<String> insertCols = this.buildInsertCols();
        String insertSql = this.buildInsertSql(insertCols);
        int loopCount = 100;
        for (int i = 0; i < loopCount; ++i) {
            boolean hasData = false;
            Date now = new Date();
            Object[] fixVals = new Object[]{0L, 0L, now, now, this.bill, 0L, 0L, 2, "", 0, "A", ALL_ZERO_FLAG_TRUE};
            try (DataSet spDatas = this.querySpData(selectSql);){
                for (Row spData : spDatas) {
                    if (this.checkSave(spData)) {
                        insertParams.add(this.buildInsertParams(spData, insertCols, fixVals));
                    }
                    this.buildDelParams(delParams, spData);
                    hasData = true;
                }
            }
            if (!hasData) {
                return;
            }
            this.resetIds(insertParams);
            var13_14 = null;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    if (!insertParams.isEmpty()) {
                        DB.executeBatch((DBRoute)this.bal.getDbRoute(), (String)insertSql, insertParams);
                        insertParams.clear();
                    }
                    DB.executeBatch((DBRoute)this.bal.getDbRoute(), (String)this.deleteSql, delParams);
                    delParams.clear();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                var13_14 = throwable;
                throw throwable;
            }
        }
        String msg = ResManager.loadKDString((String)"\u5faa\u73af\u5904\u7406\u8d85\u8fc7{0}\u6b21\uff0c\u9700\u624b\u5de5\u7ee7\u7eed\u6267\u884c\u3002", (String)"SpDataSplit_3", (String)"bos-biz-balance", (Object[])new Object[]{loopCount});
        throw new KDBizException(msg);
    }

    private boolean checkSave(Row spData) {
        return this.saveZeroSpDataRow || !ALL_ZERO_FLAG_TRUE.equals(spData.getString(ALL_ZERO_FLAG));
    }

    private void resetIds(List<Object[]> insertParams) {
        long[] newIds = DB.genGlobalLongIds((int)insertParams.size());
        int ic = 0;
        for (Object[] param : insertParams) {
            param[0] = newIds[ic++];
            param[1] = param[0];
        }
    }

    private String buildInsertSql(List<String> insertCols) {
        if (this.insertSqlCache == null) {
            StringBuilder insert = new StringBuilder();
            insert.append("INSERT INTO ").append(this.bal.getSnapshotTb());
            insert.append(" (").append(StringUtils.join((Object[])this.fixValColCache, (String)","));
            insert.append(',').append(StringUtils.join(insertCols, (String)",")).append(") VALUES (");
            int len = this.fixValColCache.length + insertCols.size();
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    insert.append(',');
                }
                insert.append('?');
            }
            insert.append(" )");
            this.insertSqlCache = insert.toString();
        }
        return this.insertSqlCache;
    }

    private List<String> buildInsertCols() {
        if (this.insertColCache == null) {
            Set<String> spCols = this.getBalQtyCols();
            Set<String> notSpCols = this.bal.getColsByDataType(BizDataType.COVER, BizDataType.PER);
            ArrayList<String> moveCols = new ArrayList<String>(spCols.size() + notSpCols.size() + 2);
            moveCols.add("fkeycol");
            moveCols.add("fupdateruleid");
            Map<String, String> colFieldMap = this.bal.getColFieldMap();
            for (String spCol : spCols) {
                moveCols.add(BalanceTB.parse2SnapName(colFieldMap.get(spCol)));
            }
            for (String notSpCol : notSpCols) {
                moveCols.add(colFieldMap.get(notSpCol));
            }
            this.insertColCache = moveCols;
        }
        return this.insertColCache;
    }

    private Object[] buildInsertParams(Row spData, List<String> moveCols, Object[] fixVals) {
        Object[] param = new Object[moveCols.size() + fixVals.length];
        int i = 0;
        for (Object fixVal : fixVals) {
            param[i++] = fixVal;
        }
        for (String moveCol : moveCols) {
            param[i++] = spData.get(moveCol);
        }
        return param;
    }

    private void buildDelParams(List<Object[]> delParams, Row spData) {
        String idsStr = spData.getString(IDS_DEL);
        if (StringUtils.isNotBlank((CharSequence)idsStr)) {
            String[] idStrs;
            for (String idStr : idStrs = idsStr.split(",")) {
                delParams.add(new Object[]{Long.valueOf(idStr)});
            }
        }
    }

    private Set<String> getBalQtyCols() {
        if (this.qtyCols == null) {
            this.qtyCols = this.bal.getColsByDataType(BizDataType.OCC, BizDataType.IN, BizDataType.INIT, BizDataType.OUT);
        }
        return this.qtyCols;
    }

    private String buildSelectSql(TreeSet<String> keyCols) {
        Set<String> qtyCols = this.getBalQtyCols();
        Set<String> otherCols = this.bal.getColsByDataType(BizDataType.COVER, BizDataType.PER);
        List<String> selectCols = this.getSelectCols(qtyCols, otherCols);
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT TOP ").append(this.queryBatch).append(' ');
        sql.append(String.join((CharSequence)",", selectCols)).append(" FROM ").append(this.bal.getSnapshotTb());
        sql.append(" WHERE fbillid < ").append(this.maxLimitBillId);
        sql.append(" AND fbillname = '").append(this.bill);
        sql.append("' AND ").append("fstatus").append(" = '").append("A");
        sql.append("' AND fkeycol ").append(QFUtil.getIdsFilter(keyCols, true));
        return sql.toString();
    }

    private List<String> getSelectCols(Set<String> qtyCols, Set<String> otherCols) {
        int size = qtyCols.size() + otherCols.size() + 4;
        ArrayList<String> colExpr = new ArrayList<String>(size);
        colExpr.add("fid");
        colExpr.add("fkeycol");
        colExpr.add("fupdatetype");
        colExpr.add("fupdateruleid");
        Map<String, String> colFieldMap = this.bal.getColFieldMap();
        for (String qtyCol : qtyCols) {
            colExpr.add(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol)));
        }
        for (String otherCol : otherCols) {
            colExpr.add(colFieldMap.get(otherCol));
        }
        return colExpr;
    }

    private DataSet querySpData(String selectSql) {
        String[] stringArray;
        DataSet spData = DB.queryDataSet((String)"querySpData", (DBRoute)this.bal.getDbRoute(), (String)selectSql);
        spData = spData.addFields(new String[]{"''", "''"}, new String[]{IDS_DEL, ALL_ZERO_FLAG});
        Map<String, String> colFieldMap = this.bal.getColFieldMap();
        boolean isPerBal = "period".equals(this.bal.getType());
        if (isPerBal) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "fkeycol";
            stringArray2[1] = colFieldMap.get(this.bal.getPeriodCol());
            stringArray = stringArray2;
            stringArray2[2] = "fupdateruleid";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "fkeycol";
            stringArray = stringArray3;
            stringArray3[1] = "fupdateruleid";
        }
        String[] groupKeys = stringArray;
        RowMeta rowMeta = spData.getRowMeta();
        GroupbyDataSet groupData = spData.groupBy(groupKeys);
        Set<String> qtyCols = this.getBalQtyCols();
        Set<String> coverCols = this.bal.getColsByDataType(BizDataType.COVER);
        String[] qtyColsArr = (String[])qtyCols.stream().map(col -> BalanceTB.parse2SnapName((String)colFieldMap.get(col))).toArray(String[]::new);
        String[] coverColsArr = (String[])coverCols.stream().map(colFieldMap::get).toArray(String[]::new);
        spData = groupData.reduceGroup((ReduceGroupFunctionWithCollector)new SpDataSumFunc(rowMeta, this.saveZeroSpDataRow, qtyColsArr, coverColsArr));
        return spData;
    }

    private static class SpDataSumFunc
    extends ReduceGroupFunctionWithCollector {
        private final RowMeta rowMeta;
        private final int[] qtyColsIdx;
        private final int idxIdsDel;
        private final int[] coverColsIdx;
        private final int idIdx;
        private final int updateTypeIdx;
        private final int allZeroFlagIdx;
        private final boolean saveZeroSpDataRow;

        SpDataSumFunc(RowMeta rowMeta, boolean saveZeroSpDataRow, String[] qtyCols, String[] coverCols) {
            int i;
            this.rowMeta = rowMeta;
            this.qtyColsIdx = new int[qtyCols.length];
            int len = qtyCols.length;
            for (i = 0; i < len; ++i) {
                this.qtyColsIdx[i] = rowMeta.getFieldIndex(qtyCols[i]);
            }
            this.coverColsIdx = new int[coverCols.length];
            len = coverCols.length;
            for (i = 0; i < len; ++i) {
                this.coverColsIdx[i] = rowMeta.getFieldIndex(coverCols[i]);
            }
            this.idxIdsDel = rowMeta.getFieldIndex(SpDataSplit.IDS_DEL);
            this.idIdx = rowMeta.getFieldIndex("fid");
            this.updateTypeIdx = rowMeta.getFieldIndex("fupdatetype");
            this.allZeroFlagIdx = rowMeta.getFieldIndex(SpDataSplit.ALL_ZERO_FLAG);
            this.saveZeroSpDataRow = saveZeroSpDataRow;
        }

        public void reduce(Iterator<Row> rows, Collector ct) {
            int i;
            StringBuilder idDel = new StringBuilder();
            Object[] result = null;
            BigDecimal[] qtyCols = this.initQtyCols();
            Object[] coverCols = new Object[this.coverColsIdx.length];
            long maxId = 0L;
            boolean hasSumData = false;
            while (rows.hasNext()) {
                Row data = rows.next();
                if (data.getInteger(this.updateTypeIdx) != 2) {
                    hasSumData = true;
                }
                if (result == null) {
                    result = RowUtil.toArray((Row)data);
                }
                this.sumQtyCols(qtyCols, data);
                if (idDel.length() != 0) {
                    idDel.append(',');
                }
                long id = data.getLong(this.idIdx);
                idDel.append(id);
                if (id <= maxId) continue;
                maxId = id;
                for (i = 0; i < coverCols.length; ++i) {
                    coverCols[i] = result[this.coverColsIdx[i]];
                }
            }
            if (result != null) {
                for (i = 0; i < coverCols.length; ++i) {
                    result[this.coverColsIdx[i]] = coverCols[i];
                }
                boolean isAllZero = true;
                for (int i2 = 0; i2 < qtyCols.length; ++i2) {
                    result[this.qtyColsIdx[i2]] = qtyCols[i2];
                    if (!isAllZero || qtyCols[i2].compareTo(BigDecimal.ZERO) == 0) continue;
                    isAllZero = false;
                }
                result[this.idxIdsDel] = idDel.toString();
                Object object = result[this.allZeroFlagIdx] = isAllZero ? SpDataSplit.ALL_ZERO_FLAG_TRUE : "";
                if (hasSumData || !this.saveZeroSpDataRow && isAllZero) {
                    ct.collect(result);
                }
            }
        }

        private BigDecimal[] initQtyCols() {
            BigDecimal[] qtys = new BigDecimal[this.qtyColsIdx.length];
            int len = this.qtyColsIdx.length;
            for (int i = 0; i < len; ++i) {
                qtys[i] = BigDecimal.ZERO;
            }
            return qtys;
        }

        private void sumQtyCols(BigDecimal[] qtyCols, Row data) {
            int len = this.qtyColsIdx.length;
            for (int i = 0; i < len; ++i) {
                BigDecimal qty = data.getBigDecimal(this.qtyColsIdx[i]);
                if (qty == null) continue;
                qtyCols[i] = qtyCols[i].add(qty);
            }
        }

        public RowMeta getResultRowMeta() {
            return this.rowMeta;
        }
    }
}

