/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.business.consumer.BalMsgUtil;
import kd.bos.bal.business.consumer.BalSemaphore;
import kd.bos.bal.business.consumer.ReUpdateMsg;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalManager;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalReUpdateParam;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;

public class BalReCalConsumer
implements MessageConsumer,
Runnable {
    private Object msg;

    private ReUpdateMsg getParam(Object param) {
        block5: {
            if (param instanceof String) {
                try {
                    JSONObject json = JSON.parseObject((String)((String)param));
                    String op = json.getString("op");
                    DBRoute occDb = DBRoute.of((String)json.getString("db"));
                    String ruleId = json.getString("ruleId");
                    UpdateRule rule = UpdateRuleCache.getUpdateRuleFromCache(ruleId);
                    ReUpdateMsg info = new ReUpdateMsg(occDb, rule, op);
                    if (!rule.isMatchUpdate(info.op)) break block5;
                    info.getIds().addAll((Collection<Object>)json.getJSONArray("ids"));
                    if (!info.getIds().isEmpty()) {
                        return info;
                    }
                }
                catch (Throwable e) {
                    BalLogUtil.saveError("BalReCalConsumer", String.valueOf(param), "getParam", e);
                }
            } else {
                BalLogUtil.info("BalReCalConsumer.getParam illegal param = " + (param == null ? "null" : param.getClass().getName()), new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object param, String messageId, boolean resend, MessageAcker acker) {
        boolean applied = false;
        try {
            BalLogUtil.info("BalReCalConsumer.onMessage start\uff1a " + param, new Object[0]);
            ReUpdateMsg msg = this.getParam(param);
            if (msg == null) {
                return;
            }
            applied = this.applyHandle(msg);
            if (!applied && acker != null) {
                BalMsgUtil.rePublish(param, "bal.recal");
            }
            BalLogUtil.info("BalReCalConsumer.onMessage end", new Object[0]);
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalReCalConsumer", "applied = " + applied + ", param = " + param, "onMessage", e);
        }
        finally {
            if (acker != null) {
                acker.ack(messageId);
            }
        }
    }

    private boolean applyHandle(ReUpdateMsg msg) {
        String balName = msg.rule.getBalanceTB().getName();
        int semaphoreLimit = BalConfig.loadBalConfig(balName).getReUpdateMsgSemaphore();
        String semaphoreKey = RequestContext.getOrCreate().getAccountId() + "_ReUpdateMsg_" + balName;
        try (BalSemaphore semaphore = BalMsgUtil.getOrCreate(semaphoreKey);){
            if (semaphore.acquire(semaphoreLimit)) {
                this.doUpdate(msg);
                boolean bl = true;
                return bl;
            }
            BalLogUtil.warn("BalReCalConsumer.applyHandle over limit: semaphoreKey={}, current={}, limit={} ", semaphoreKey, semaphore.getCurrentCount(), semaphoreLimit);
        }
        return false;
    }

    private void doUpdate(ReUpdateMsg param) {
        BalLogUtil.info("BalReCalConsumer.doUpdate start", new Object[0]);
        try {
            this.tryUpdate(param, true);
        }
        catch (Throwable e) {
            if (BalLogUtil.isDeadkLockError(e)) {
                BalLogUtil.info("BalReCalConsumer has DeadLock : auto retry", e);
                this.tryUpdate(param, false);
            }
            throw e;
        }
        BalManager.clearUpdateInfo(param);
    }

    private void tryUpdate(ReUpdateMsg param, boolean isFirstTime) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"BalReCalConsumer");){
            if (isFirstTime) {
                this.checkAndBuildBills(param);
                if (param.getBillIds().isEmpty()) {
                    BalLogUtil.info("BalReCalConsumer tryUpdate : bills already empty after checkReUpdateBill", new Object[0]);
                    return;
                }
            }
            try {
                BalReUpdateParam updateParam = new BalReUpdateParam(param.getBillIds(), null, false);
                updateParam.addReUpdateRules(param.rule);
                updateParam.setOp(param.op);
                updateParam.setSaveLog(true);
                BalManager.doReUpdate(updateParam);
                BalManager.checkMsgExists(param, tx);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void checkAndBuildBills(ReUpdateMsg param) {
        String sql = "SELECT FID,FBILLID FROM " + param.rule.getBalanceTB().getOrCreateAsyncInfoTb(param.occDb) + " WHERE FRULEID ='" + param.rule.getId() + "' AND FOP='" + param.op + "' AND FID " + QFUtil.getIdsFilter(param.getIds());
        try (DataSet dataSet = DB.queryDataSet((String)"checkAndBuildBills", (DBRoute)param.occDb, (String)sql);){
            RowMeta rowMeta = dataSet.getRowMeta();
            int fbillIdIdx = rowMeta.getFieldIndex("FBILLID");
            int fidIdx = rowMeta.getFieldIndex("FID");
            Set<Object> ids = param.getIds();
            Set<Object> billIds = param.getBillIds();
            ids.clear();
            billIds.clear();
            for (Row row : dataSet) {
                billIds.add(row.getLong(fbillIdIdx));
                ids.add(row.getLong(fidIdx));
            }
        }
    }

    public BalReCalConsumer() {
    }

    public BalReCalConsumer(Object msg) {
        this.msg = msg;
    }

    @Override
    public void run() {
        BalLogUtil.info("BalReCalConsumer.mockMsg start", new Object[0]);
        this.onMessage(this.msg, "", true, null);
    }
}

