/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

class QtyLimitFunc
extends MapFunction {
    protected RowMeta rowMeta;
    protected int[] qtyIdxs;
    private static final BigDecimal MAX_QTY = new BigDecimal("999999999");
    private static final BigDecimal MIN_QTY = new BigDecimal("-999999999");

    QtyLimitFunc(RowMeta rowMeta, Collection<String> cols) {
        this.rowMeta = rowMeta;
        this.qtyIdxs = new int[cols.size()];
        int i = 0;
        for (String col : cols) {
            this.qtyIdxs[i++] = rowMeta.getFieldIndex(col, false);
        }
    }

    public Object[] map(Row row) {
        Object[] result = RowUtil.toArray((Row)row);
        for (int idx : this.qtyIdxs) {
            BigDecimal qty = row.getBigDecimal(idx);
            if (qty.compareTo(MAX_QTY) < 0 && qty.compareTo(MIN_QTY) > 0) continue;
            String msg = ResManager.loadKDString((String)"\u6d4b\u8bd5\u6570\u636e\u7684\u6570\u91cf\u5b57\u6bb5\u503c\u8bf7\u63a7\u5236\u5728(-999999999,999999999)\u533a\u95f4\uff0c\u8d85\u8fc7\u9650\u5b9a\u7684\u6570\u636e\u53ef\u80fd\u5f15\u8d77\u6570\u636e\u5e93\u5b58\u50a8\u5f02\u5e38\uff0c\u8bf7\u4fee\u6539\u6570\u91cf\u540e\u91cd\u8bd5\u3002", (String)"BAL-E-0001", (String)"bos-biz-balance", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        return result;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

