/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin.updaterule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.plugin.botp.BOTPFileUtil;
import kd.bos.devportal.plugin.botp.BOTPListFilePlugin;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.IListView;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.BalanceUpdateRuleTemplate;
import kd.bos.metadata.balance.BalanceUpdateRuleWriter;
import kd.bos.metadata.balance.DesignBalanceRuleMeta;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class RuleTreeList
extends BOTPListFilePlugin {
    private static final String Op_Add = "new";
    private static final String Op_Copy = "copy";
    private static final String Op_Modify = "modify";
    private static final String Op_Ext = "ext";
    private static final String Op_Inherit = "inherit";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String PNL_TREEBTNLIST = "flexpanel_treebtn";
    private static final String CACHE_APPNODES = "appnodes";
    private String currNodeId;

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        if (EnvTypeHelper.isProductEnv() && ("bar_new".equals(itemKey = evt.getItemKey()) || "bar_copy".equals(itemKey) || "bar_ext".equals(itemKey) || "bar_inherit".equals(itemKey) || "bar_delete".equals(itemKey) || "btncheckin".equals(itemKey) || "commit".equals(itemKey) || "push".equals(itemKey) || "revert".equals(itemKey) || "pull".equals(itemKey) || "btnimport".equals(itemKey))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u4e0d\u80fd\u76f4\u63a5\u8c03\u6574\u914d\u7f6e\uff0c\u8bf7\u5728\u5f00\u53d1\u73af\u5883\u4fee\u6539\u9a8c\u8bc1\u540e\uff0c\u53d1\u5e03\u5230\u751f\u4ea7\u73af\u5883\u3002", (String)"RuleEdit_9", (String)"bos-biz-balance", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        switch (e.getOperateKey()) {
            case "new": {
                this.doAdd();
                break;
            }
            case "copy": {
                this.doCopy(e);
                break;
            }
            case "ext": {
                this.doExt(e);
                break;
            }
            case "inherit": {
                this.doInherit(e);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        e.getRowIndex();
        String ruleId = (String)((IListView)this.getView()).getFocusRowPkId();
        this.showRuleEditForm(ruleId);
    }

    private void doAdd() {
        this.showRuleEditForm("");
    }

    private void doCopy(AfterDoOperationEventArgs e) {
        IDataEntityType dType;
        String ruleId = this.getSelectedRuleId();
        DesignBalanceRuleMeta designMeta = (DesignBalanceRuleMeta)BusinessDataReader.read((Object)ruleId, (IDataEntityType)(dType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class)), (Boolean)false);
        if ("2".equals(designMeta.getDevType())) {
            ruleId = designMeta.getMasterId();
        }
        BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
        BalanceUpdateRuleMetadata sourceMeta = reader.loadMeta(ruleId, true);
        BalanceUpdateRuleTemplate template = new BalanceUpdateRuleTemplate();
        BalanceUpdateRuleMetadata copyRule = template.CreateBlankRule();
        copyRule.setRuleElement(sourceMeta.getRuleElement());
        copyRule.getName().setLocaleValue_zh_CN(sourceMeta.getName().getLocaleValue_zh_CN());
        String loadKDString = ResManager.loadKDString((String)"\u590d\u5236", (String)"RuleTreeList_4", (String)"bos-biz-balance", (Object[])new Object[0]);
        copyRule.getName().setLocaleValue(sourceMeta.getName().getLocaleValue() + "_" + loadKDString);
        copyRule.setNumber(copyRule.getId());
        copyRule.setBizappId(sourceMeta.getBizappId());
        copyRule.setIsv(ISVService.getISVInfo().getId());
        copyRule.setCreateDate(TimeServiceHelper.now());
        copyRule.getRuleElement().setCustStatus("2");
        Map saveResult = BalanceUpdateRuleWriter.save((BalanceUpdateRuleMetadata)copyRule);
        this.checkSaveResult(e, saveResult, ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"RuleTreeList_0", (String)"bos-biz-balance", (Object[])new Object[0]));
    }

    private void doExt(AfterDoOperationEventArgs e) {
        String inheritPath;
        BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
        String ruleId = this.getSelectedRuleId();
        if (reader.hadExtRules(ruleId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u89c4\u5219\u5df2\u6709\u6269\u5c55\u89c4\u5219\uff0c\u4e0d\u80fd\u518d\u6b21\u6269\u5c55\u3002", (String)"RuleTreeList_1", (String)"bos-biz-balance", (Object[])new Object[0]));
            return;
        }
        BalanceUpdateRuleMetadata ruleMetadata = reader.loadMeta(ruleId, false, true);
        ruleMetadata.setParentId(ruleMetadata.getId());
        if (StringUtils.isBlank((CharSequence)ruleMetadata.getMasterId())) {
            ruleMetadata.setMasterId(ruleId);
        }
        inheritPath = StringUtils.isBlank((CharSequence)(inheritPath = ruleMetadata.getInheritPath())) ? ruleMetadata.getId() : inheritPath + "," + ruleMetadata.getId();
        ruleMetadata.setInheritPath(inheritPath);
        ruleMetadata.setDevType("2");
        ruleMetadata.setExtLevel(ruleMetadata.getExtLevel() + 1);
        ruleMetadata.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        ruleMetadata.setNumber(ruleMetadata.getNumber() + "_ext");
        ruleMetadata.getName().setLocaleValue_zh_CN(ruleMetadata.getName().getLocaleValue_zh_CN());
        String loadKDString = ResManager.loadKDString((String)"\u6269\u5c55", (String)"RuleTreeList_5", (String)"bos-biz-balance", (Object[])new Object[0]);
        ruleMetadata.getName().setLocaleValue(ruleMetadata.getName().getLocaleValue() + "_" + loadKDString);
        ruleMetadata.setIsv(ISVService.getISVInfo().getId());
        ruleMetadata.setModifyDate(TimeServiceHelper.now());
        ruleMetadata.setModifierId(RequestContext.getOrCreate().getUserId());
        Map saveResult = BalanceUpdateRuleWriter.save((BalanceUpdateRuleMetadata)ruleMetadata);
        this.checkSaveResult(e, saveResult, ResManager.loadKDString((String)"\u6269\u5c55\u6210\u529f\u3002", (String)"RuleTreeList_2", (String)"bos-biz-balance", (Object[])new Object[0]));
    }

    private void doInherit(AfterDoOperationEventArgs e) {
        IDataEntityType dType;
        String ruleId = this.getSelectedRuleId();
        DesignBalanceRuleMeta designMeta = (DesignBalanceRuleMeta)BusinessDataReader.read((Object)ruleId, (IDataEntityType)(dType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class)), (Boolean)false);
        if (designMeta.getDevType().equals("2")) {
            ruleId = designMeta.getMasterId();
        }
        BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
        BalanceUpdateRuleMetadata ruleMetadata = reader.loadMeta(ruleId, false, true);
        ruleMetadata.setParentId(ruleMetadata.getId());
        ruleMetadata.setMasterId("");
        String inheritPath = ruleMetadata.getInheritPath();
        inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? ruleMetadata.getId() : inheritPath + "," + ruleMetadata.getId();
        ruleMetadata.setInheritPath(inheritPath);
        ruleMetadata.setDevType("1");
        ruleMetadata.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        ruleMetadata.setNumber(ruleMetadata.getId());
        ruleMetadata.getName().setLocaleValue_zh_CN(ruleMetadata.getName().getLocaleValue_zh_CN());
        String loadKDString = ResManager.loadKDString((String)"\u7ee7\u627f", (String)"RuleTreeList_6", (String)"bos-biz-balance", (Object[])new Object[0]);
        ruleMetadata.getName().setLocaleValue(ruleMetadata.getName().getLocaleValue() + "_" + loadKDString);
        ruleMetadata.setIsv(ISVService.getISVInfo().getId());
        ruleMetadata.setModifyDate(TimeServiceHelper.now());
        ruleMetadata.setModifierId(RequestContext.getOrCreate().getUserId());
        ruleMetadata.getRuleElement().setCustStatus("2");
        Map saveResult = BalanceUpdateRuleWriter.save((BalanceUpdateRuleMetadata)ruleMetadata);
        this.checkSaveResult(e, saveResult, ResManager.loadKDString((String)"\u6269\u5c55\u6210\u529f\u3002", (String)"RuleTreeList_2", (String)"bos-biz-balance", (Object[])new Object[0]));
    }

    private void showRuleEditForm(String ruleId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bal_balanceupdateruleedit");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("ruleid", (Object)ruleId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, Op_Modify);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "modify": {
                AbstractListView view = (AbstractListView)this.getView();
                view.setNeedRefreshTree(false);
                view.refresh();
                break;
            }
        }
    }

    private void checkSaveResult(AfterDoOperationEventArgs e, Map<String, Object> saveResult, String successMessage) {
        boolean success = (Boolean)saveResult.get("success");
        if (success) {
            this.getView().showSuccessNotification(successMessage);
            ((IEntityOperate)e.getSource()).setCancelRefresh(false);
        } else {
            String message = (String)saveResult.get("message");
            this.getView().showTipNotification(message);
        }
    }

    private String getSelectedRuleId() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RuleTreeList_3", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        return String.valueOf(rows.get(0).getPrimaryKeyValue());
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PNL_TREEBTNLIST});
    }

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> nodes = RuleTreeList.getCacheTreeNodes((AbstractFormPlugin)this, CACHE_APPNODES);
        TreeNode currNode = null;
        String nodeId = (String)e.getNodeId();
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            for (TreeNode node : nodes) {
                if (StringUtils.equals((CharSequence)node.getId(), (CharSequence)nodeId)) {
                    currNode = node;
                    break;
                }
                TreeNode childNode = node.getTreeNode(nodeId, 5);
                if (childNode == null) continue;
                currNode = childNode;
                break;
            }
        }
        if (currNode == null) {
            e.setChildNodes(nodes);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.currNodeId = String.valueOf(e.getNodeId());
        super.treeNodeClick(e);
    }

    protected QFilter nodeClickFilter() {
        return this.buildAppQFilter(this.currNodeId, CACHE_APPNODES);
    }

    public static List<TreeNode> getCacheTreeNodes(AbstractFormPlugin plugin, String cacheKey) {
        List treeNodes;
        String json = plugin.getPageCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)json)) {
            treeNodes = RuleTreeList.loadAppNodes();
            RuleTreeList.setCacheTreeNodes(plugin, cacheKey, treeNodes);
        } else {
            treeNodes = SerializationUtils.fromJsonStringToList((String)json, TreeNode.class);
        }
        return treeNodes;
    }

    public static void setCacheTreeNodes(AbstractFormPlugin plugin, String cacheKey, List<TreeNode> treeNodes) {
        String json = SerializationUtils.toJsonString(treeNodes);
        plugin.getPageCache().put(cacheKey, json);
    }

    public static List<TreeNode> loadAppNodes() {
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        List<TreeNode> cloudNode4 = RuleTreeList.getCloudData();
        for (TreeNode node : cloudNode4) {
            allNodes.put(node.getId(), node);
        }
        List<TreeNode> appNode4 = RuleTreeList.getAppData();
        for (TreeNode node : appNode4) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return cloudNode4;
    }

    private static List<TreeNode> getCloudData() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject cloud : clouds) {
            TreeNode node = new TreeNode();
            String nodeID = "cloud/" + cloud.getString("id");
            node.setText(cloud.getString("name") + "(" + cloud.getString("number") + ")");
            node.setParentid("0");
            node.setId(nodeID);
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private static List<TreeNode> getAppData() {
        ArrayList<TreeNode> appNode = new ArrayList<TreeNode>();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : apps) {
            TreeNode node = new TreeNode();
            String parentId = "cloud/" + app.getString("bizcloud");
            String nodeID = app.getString("id");
            node.setId(nodeID);
            node.setParentid(parentId);
            node.setText(app.getString("name") + "(" + app.getString("number") + ")");
            appNode.add(node);
        }
        return appNode;
    }

    public QFilter buildAppQFilter(String nodeId, String nodesCacheKey) {
        ArrayList<String> appIds = new ArrayList<String>();
        List<TreeNode> bizCloudNodes = RuleTreeList.getCacheTreeNodes((AbstractFormPlugin)this, nodesCacheKey);
        for (TreeNode bizCloudNode : bizCloudNodes) {
            if (this.searchBizNode(bizCloudNode, nodeId, appIds)) break;
        }
        if (appIds.isEmpty()) {
            return null;
        }
        if (appIds.size() == 1) {
            return new QFilter(KEY_BIZAPPID, "=", appIds.get(0));
        }
        return new QFilter(KEY_BIZAPPID, "in", (Object)appIds.toArray(new String[appIds.size()]));
    }

    private boolean searchBizNode(TreeNode bizCloudNode, String nodeId, List<String> appIds) {
        if (!StringUtils.equals((CharSequence)nodeId, (CharSequence)bizCloudNode.getId())) {
            if (this.searchAppNode(bizCloudNode, nodeId)) {
                appIds.add(nodeId);
                return true;
            }
        } else {
            if (bizCloudNode.getChildren() != null) {
                for (TreeNode appNode : bizCloudNode.getChildren()) {
                    appIds.add(appNode.getId());
                }
            }
            if (appIds.isEmpty()) {
                appIds.add(nodeId);
            }
            return true;
        }
        return false;
    }

    private boolean searchAppNode(TreeNode bizCloudNode, String nodeId) {
        if (bizCloudNode.getChildren() != null) {
            for (TreeNode appNode : bizCloudNode.getChildren()) {
                if (!StringUtils.equals((CharSequence)appNode.getId(), (CharSequence)nodeId)) continue;
                return true;
            }
        }
        return false;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        String entryId;
        switch (entryId = e.getRefEntityId()) {
            case "bal_balanceinfo": {
                e.addCustomQFilter(this.getBalFs());
                e.getCustomParams().put("showDisabledCheckbox", "false");
                break;
            }
            case "bal_balanceupdaterule": {
                e.getCustomParams().put("showDisabledCheckbox", "false");
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent e) {
        super.filterColumnSetFilter(e);
        String key = e.getFieldName();
        if (key.startsWith("balancetablenumber.")) {
            e.addCustomQFilter(this.getBalFs());
        }
    }

    private QFilter getBalFs() {
        return new QFilter("istemplate", "=", (Object)"0");
    }

    protected BOTPFileUtil createFileUtil() {
        BOTPFileUtil fileUtil = new BOTPFileUtil("bur");
        return fileUtil;
    }
}

