/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.mservice;

import java.util.Locale;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.lang3.StringUtils;

public class BalSpTbMoveTimeUpgrade
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (DataSet datas = DB.queryDataSet((String)"BalSpTbMoveTimeUpgrade", (DBRoute)DBRoute.of((String)"sys.meta"), (String)"SELECT B.fdbroute dbkey,A.ftablename baltb FROM t_bal_balanceinfo A inner join t_meta_bizapp B on A.fbizappid = B.FID where A.fsysstatus = '0' and A.fistemplate = '0' order by B.fdbroute");){
            for (Row row : datas) {
                this.addTimeCol(row);
            }
        }
        return new UpgradeResult();
    }

    private void addTimeCol(Row row) {
        String balTb = row.getString("baltb");
        String dbkey = row.getString("dbkey");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{balTb, dbkey})) {
            return;
        }
        DBRoute db = DBRoute.of((String)dbkey);
        this.addCol4Tb(balTb + "_sp", db);
        this.addCol4Tb(balTb + "_tp", db);
    }

    private void addCol4Tb(String tb, DBRoute db) {
        if (!DB.exitsTable((DBRoute)db, (String)(tb = tb.toUpperCase(Locale.ENGLISH)))) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '").append(tb).append("' AND KSQL_COL_NAME ='FCREATETIME') ");
        sql.append(" ALTER TABLE ").append(tb).append(" ADD ( FCREATETIME TIMESTAMP NULL DEFAULT NULL ) ");
        DB.execute((DBRoute)db, (String)sql.toString());
        sql = new StringBuilder();
        sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '").append(tb).append("' AND KSQL_COL_NAME ='FMOVETIME') ");
        sql.append(" ALTER TABLE ").append(tb).append(" ADD ( FMOVETIME TIMESTAMP NULL DEFAULT NULL ) ");
        DB.execute((DBRoute)db, (String)sql.toString());
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return null;
    }
}

