/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.mservice;

import java.util.Locale;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.tablemanager.meta.Imeta;
import kd.bos.archive.tablemanager.meta.MetaFactory;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.lang3.StringUtils;

public class BalSpTbUpgrade
implements IUpgradeService {
    public void upgradeTB(String bal, String balTb, String dbkey) {
        try (TXHandle tx = TX.notSupported((String)"BalSpTbUpgrade.createTB");){
            if (StringUtils.isBlank((CharSequence)bal)) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)balTb)) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)dbkey)) {
                return;
            }
            bal = bal.toUpperCase(Locale.ENGLISH);
            balTb = balTb.toUpperCase(Locale.ENGLISH);
            String spTb = balTb + "_SP";
            String tpTb = balTb + "_TP";
            DBRoute db = DBRoute.of((String)dbkey);
            if (!DB.exitsTable((DBRoute)db, (String)spTb)) {
                return;
            }
            if (!DB.exitsTable((DBRoute)db, (String)tpTb)) {
                String tab = DB.getOriginalsnapTableNameIfShardingTable((String)spTb);
                this.createTBLike(db, tpTb, tab.toUpperCase(Locale.ENGLISH));
            }
            if (DB.exitsTable((DBRoute)db, (String)tpTb)) {
                StringBuilder sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '").append(tpTb).append("' AND KSQL_COL_NAME ='FREADTYPE') ");
                sql.append(" ALTER TABLE ").append(tpTb).append(" ADD (FREADTYPE CHAR(1) NOT NULL DEFAULT '0') ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '").append(tpTb).append("' AND KSQL_COL_NAME ='FMOVETYPE') ");
                sql.append(" ALTER TABLE ").append(tpTb).append(" ADD (FMOVETYPE CHAR(1) NOT NULL DEFAULT '0') ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '").append(tpTb).append("' AND KSQL_COL_NAME ='FSYNC') ");
                sql.append(" ALTER TABLE ").append(tpTb).append(" ADD (FSYNC CHAR(1) NOT NULL DEFAULT '0') ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '").append(tpTb).append("' AND KSQL_COL_NAME ='FCOVERFLAG') ");
                sql.append(" ALTER TABLE ").append(tpTb).append(" ADD (FCOVERFLAG CHAR(1) NOT NULL DEFAULT '0') ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" EXEC P_ALTERPK 'PK_").append(tpTb).append("', '").append(tpTb).append("', 'FID', '1' ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_").append(bal).append("_TPKC') CREATE INDEX IDX_").append(bal).append("_TPKC ON ").append(tpTb).append(" ( FKEYCOL ) ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_").append(bal).append("_TPBID') CREATE INDEX IDX_").append(bal).append("_TPBID ON ").append(tpTb).append(" ( FBILLID ) ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_").append(bal).append("_TPEID') CREATE INDEX IDX_").append(bal).append("_TPEID ON ").append(tpTb).append(" ( FENTRYID ) ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_").append(bal).append("_TPUT') CREATE INDEX IDX_").append(bal).append("_TPUT ON ").append(tpTb).append(" ( FUPDATETIME ) ");
                DB.execute((DBRoute)db, (String)sql.toString());
                sql = new StringBuilder();
                sql.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_").append(bal).append("_TPBNO') CREATE INDEX IDX_").append(bal).append("_TPBNO ON ").append(tpTb).append(" ( FBILLNO ) ");
                DB.execute((DBRoute)db, (String)sql.toString());
            }
        }
    }

    private String createTB(Row row) {
        try {
            this.upgradeTB(row.getString("bal"), row.getString("baltb"), row.getString("dbkey"));
        }
        catch (Throwable e) {
            BalLogUtil.error("BalSpTbUpgrade.createTB ERROR ", e);
            return BalLogUtil.parseMsg(e, 2000);
        }
        return null;
    }

    public void createTBLike(DBRoute db, String tb, String likeTb) {
        Imeta meta = MetaFactory.getMeta((DBRoute)db);
        String createTableSql = meta.createTableSql(tb, meta.queryColumns(db, likeTb));
        DB.execute((DBRoute)db, (String)ArchiveUtil.wrapSQL((String)createTableSql, (boolean)true, (boolean)true));
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        StringBuilder msgs = this.updateBalTpTb();
        UpgradeResult result = new UpgradeResult();
        if (msgs.length() == 0) {
            result.setSuccess(true);
        } else {
            result.setSuccess(false);
            result.setErrorInfo(msgs.toString());
        }
        return result;
    }

    private StringBuilder updateBalTpTb() {
        StringBuilder msgs = new StringBuilder();
        try (DataSet datas = DB.queryDataSet((String)"BalSpTbUpgrade", (DBRoute)DBRoute.of((String)"sys.meta"), (String)"SELECT B.fdbroute dbkey,A.ftablename baltb,A.fnumber bal FROM t_bal_balanceinfo A inner join t_meta_bizapp B on A.fbizappid = B.FID where A.fsysstatus = '0' and A.fistemplate = '0' order by B.fdbroute");){
            for (Row row : datas) {
                String msg = this.createTB(row);
                if (msg == null) continue;
                msgs.append(String.format("bal=%s,baltb=%s,dbkey=%s", row.get("bal"), row.get("baltb"), row.get("dbkey"))).append("\r\n").append(msg).append("\r\n");
            }
        }
        return msgs;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return null;
    }
}

