/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.common.QFUtil;
import kd.bos.biz.balance.model.BalTbUtil;
import kd.bos.biz.balance.model.IBalance;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.MetadataServiceHelper;

public class BalTxTbUpgrade
implements IUpgradeService {
    private final StringBuilder msg = new StringBuilder();
    private static final Log LOG = LogFactory.getLog(BalTxTbUpgrade.class);
    private boolean throwEx;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.doUpdate();
        UpgradeResult result = new UpgradeResult();
        if (this.msg.length() > 0) {
            result.setSuccess(false);
            String msgPrefix = ResManager.loadKDString((String)"\u4f59\u989d\u6a21\u578b\u76f8\u5173\u8868\u7ed3\u6784\u81ea\u52a8\u5347\u7ea7\u6709\u5f02\u5e38\uff0c\u53ef\u5c1d\u8bd5\u91cd\u65b0\u6267\u884c\u6216\u8005\u6293\u53d6monitor\u5f02\u5e38\u65e5\u5fd7\u53cd\u9988\u7814\u53d1\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", (String)"BalTxTbUpgrade_0", (String)"bos-biz-balance", (Object[])new Object[0]);
            result.setErrorInfo(msgPrefix + this.msg);
        }
        return result;
    }

    private void doUpdate() {
        try (TXHandle tx = TX.notSupported((String)"handleSingleDb");){
            try (DataSet dbs = DB.queryDataSet((String)"handleSingleDb", (DBRoute)IBalance.BAL_DB, (String)"select distinct fdb from t_bal_occurred_dbs");){
                for (Row db : dbs) {
                    this.handleSingleDb(db.getString(0));
                }
            }
            this.handleUpdatingRecord();
        }
    }

    public void reUpdate(Set<String> bals) {
        this.throwEx = true;
        try (TXHandle tx = TX.notSupported((String)"handleSingleDb");){
            for (String bal : bals) {
                this.handleSingleDb(bal);
            }
            this.handleUpdatingRecord();
        }
    }

    private void handleTxTb(DBRoute db, String bal) {
        try {
            String tb = MetadataServiceHelper.getDataEntityType((String)bal).getAlias() + "_tx";
            this.buildTxTb(db, tb);
            String addSql = "INSERT INTO " + tb + "(FTXID, FBAL, FDB, FCREATERID, FCREATETIME) SELECT FTXID, FBAL, FDB, FCREATERID, FCREATETIME FROM T_BAL_BIZ_TXS WHERE FBAL = '" + bal + "' ";
            String delSql = "DELETE FROM T_BAL_BIZ_TXS WHERE FBAL = '" + bal + "' ";
            try (TXHandle tx = TX.requiresNew((String)"handleTxTb");){
                try {
                    DB.execute((DBRoute)db, (String)addSql);
                    DB.execute((DBRoute)db, (String)delSql);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        catch (Throwable t) {
            String msgStr = "handleTxTb error: db = " + db.getRouteKey() + ", bal = " + bal + "\r\n";
            if (this.throwEx) {
                throw new RuntimeException(msgStr, t);
            }
            this.msg.append(msgStr);
            LOG.error(msgStr, t);
        }
    }

    private void handleUpdatingRecord() {
        ArrayList<String> ruleIds = new ArrayList<String>();
        try (DataSet rules = DB.queryDataSet((String)"handleUpdatingRecord", (DBRoute)IBalance.BAL_DB, (String)"SELECT DISTINCT FRULEID FROM T_BAL_UPDATING WHERE FBAL = ''");){
            for (Object row : rules) {
                ruleIds.add(row.getString(0));
            }
        }
        if (ruleIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(ruleIds.size());
        DataSet datas = DB.queryDataSet((String)"handleUpdatingRecord", (DBRoute)IBalance.BAL_DB, (String)("select fid,fbalancetablenumber,fsourceentitynumber from t_bal_updateruledesign where fid" + QFUtil.getIdsFilter(ruleIds, true)));
        Object object = null;
        try {
            for (Row row : datas) {
                this.collectorParams(params, row);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (datas != null) {
                if (object != null) {
                    try {
                        datas.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    datas.close();
                }
            }
        }
        if (!params.isEmpty()) {
            TXHandle tx = TX.requiresNew((String)"handleUpdatingRecord");
            object = null;
            try {
                try {
                    DB.executeBatch((DBRoute)IBalance.BAL_DB, (String)"UPDATE T_BAL_UPDATING SET FDB=?,FBAL=?,FAPP=? WHERE fruleid = ? AND FBAL = ''", params);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    private void collectorParams(List<Object[]> params, Row row) {
        try {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)row.getString("fsourceentitynumber"));
            params.add(new Object[]{type.getDBRouteKey(), row.getString("fbalancetablenumber"), type.getAppId(), row.getString("fid")});
        }
        catch (Throwable e) {
            String msgStr = "collectorParams error:" + row + "\r\n";
            if (this.throwEx) {
                throw new RuntimeException(msgStr, e);
            }
            this.msg.append(msgStr);
            LOG.error(msgStr, e);
        }
    }

    private void handleSingleDb(String dbKey) {
        DBRoute db = DBRoute.of((String)dbKey);
        if (DB.exitsTable((DBRoute)db, (String)"T_BAL_BIZ_TXS")) {
            if (DB.existColumn((DBRoute)db, (String)"T_BAL_BIZ_TXS", (String)"FPUBLISHTIME")) {
                BalTbUtil.executeDDL(db, "EXEC p_AlterColumn 'T_BAL_BIZ_TXS', 'FPUBLISHTIME', 'NULL', 'NULL', '1001', 'NULL'");
            }
            try (DataSet bals = DB.queryDataSet((String)"handleSingleDb-txtb", (DBRoute)db, (String)"SELECT DISTINCT FBAL FROM T_BAL_BIZ_TXS");){
                for (Object row : bals) {
                    this.handleTxTb(db, row.getString(0));
                }
            }
        }
        if (DB.exitsTable((DBRoute)db, (String)"T_BAL_ASYNC_INFO")) {
            if (DB.existColumn((DBRoute)db, (String)"T_BAL_ASYNC_INFO", (String)"FPUBLISHTIME")) {
                BalTbUtil.executeDDL(db, "EXEC p_AlterColumn 'T_BAL_ASYNC_INFO', 'FPUBLISHTIME', 'NULL', 'NULL', '1001', 'NULL'");
            }
            ArrayList<String> ruleIds = new ArrayList<String>();
            DataSet rules = DB.queryDataSet((String)"handleSingleDb-asynctb", (DBRoute)db, (String)"SELECT DISTINCT FRULEID FROM T_BAL_ASYNC_INFO");
            Iterator iterator = null;
            try {
                for (Row row : rules) {
                    ruleIds.add(row.getString(0));
                }
            }
            catch (Throwable row) {
                iterator = row;
                throw row;
            }
            finally {
                if (rules != null) {
                    if (iterator != null) {
                        try {
                            rules.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)((Object)iterator)).addSuppressed(row);
                        }
                    } else {
                        rules.close();
                    }
                }
            }
            if (!ruleIds.isEmpty()) {
                Object row;
                HashMap<String, ArrayList<String>> balRules = new HashMap<String, ArrayList<String>>();
                DataSet datas = DB.queryDataSet((String)"handleSingleDb-asynctb", (DBRoute)IBalance.BAL_DB, (String)("select fid,fbalancetablenumber from t_bal_updateruledesign where fid" + QFUtil.getIdsFilter(ruleIds, true)));
                row = null;
                try {
                    for (Row data : datas) {
                        String bal = data.getString("fbalancetablenumber");
                        ArrayList<String> ruleList = (ArrayList<String>)balRules.get(bal);
                        if (ruleList == null) {
                            ruleList = new ArrayList<String>();
                            balRules.put(bal, ruleList);
                        }
                        ruleList.add(data.getString("fid"));
                    }
                }
                catch (Throwable throwable) {
                    row = throwable;
                    throw throwable;
                }
                finally {
                    if (datas != null) {
                        if (row != null) {
                            try {
                                datas.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)row).addSuppressed(throwable);
                            }
                        } else {
                            datas.close();
                        }
                    }
                }
                for (Map.Entry entry : balRules.entrySet()) {
                    this.handleAsyncTb(db, (String)entry.getKey(), (List)entry.getValue());
                }
            }
        }
    }

    private void handleAsyncTb(DBRoute db, String bal, List<String> rules) {
        try {
            String tb = MetadataServiceHelper.getDataEntityType((String)bal).getAlias() + "_as";
            this.buildAsyncTb(db, tb);
            String fsStr = QFUtil.getIdsFilter(rules, true);
            String addSql = "INSERT INTO " + tb + "(FID, FBILLID, FRULEID, FBAL, FBILLENTITY, FOP, FDB, FCREATERID, FCREATETIME) SELECT FID, FBILLID, FRULEID, '" + bal + "' FBAL, FBILLENTITY, FOP, FDB, FCREATERID, FCREATETIME FROM T_BAL_ASYNC_INFO WHERE FRULEID " + fsStr;
            String delSql = "DELETE FROM T_BAL_ASYNC_INFO WHERE FRULEID " + fsStr;
            try (TXHandle tx = TX.requiresNew((String)"handleAsyncTb");){
                try {
                    DB.execute((DBRoute)db, (String)addSql);
                    DB.execute((DBRoute)db, (String)delSql);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        catch (Throwable t) {
            String msgStr = "handleAsyncTb error: db = " + db.getRouteKey() + ", bal = " + bal + "\r\n";
            if (this.throwEx) {
                throw new RuntimeException(msgStr, t);
            }
            this.msg.append(msgStr);
            LOG.error(msgStr, t);
        }
    }

    private void buildAsyncTb(DBRoute db, String tb) {
        String[] sqls = BalTbUtil.getCreateAsyncInfoTbSQL(tb);
        BalTbUtil.executeDDL(db, sqls);
    }

    private void buildTxTb(DBRoute db, String tb) {
        String[] sqls = BalTbUtil.getCreateTxTbSQL(tb);
        BalTbUtil.executeDDL(db, sqls);
    }
}

