/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bal.mservice.BalTxTbUpgrade;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;

public class BalOccurredDBRepairTb
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List cols = e.getFieldKeys();
        cols.add("db");
        cols.add("bal");
        cols.add("type");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        if (datas != null) {
            HashSet<String> dbs = new HashSet<String>(4);
            for (DynamicObject data : datas) {
                String dbKey = data.getString("db");
                dbs.add(dbKey);
                this.rebuildTb(data.getString("bal.id"), dbKey, data.getString("type"));
            }
            this.reUpdateData(dbs);
        }
    }

    private void reUpdateData(Set<String> bals) {
        new BalTxTbUpgrade().reUpdate(bals);
    }

    private void rebuildTb(String balName, String dbKey, String type) {
        DBRoute occDb = DBRoute.of((String)dbKey);
        BalanceTB bal = BalanceTB.getBalanceTB(balName);
        if ("1".equals(type)) {
            bal.getOrCreateAsyncInfoTb(occDb);
        } else if ("2".equals(type)) {
            bal.getOrCreateTxTb(occDb);
        }
    }
}

