/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bal.common.BalTaskUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;

public class BalPerRecordSplitTaskOp
extends AbstractOperationServicePlugIn {
    public static final String OP_RETRY = "retry";
    public static final String OP_GOON = "goon";
    public static final String OP_SAVE = "saveandrun";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("bal");
        keys.add("period");
        keys.add("status");
        keys.add("msgappid");
        keys.add("managertraceid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new SaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String key;
        super.beginOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length == 0) {
            return;
        }
        switch (key = e.getOperationKey()) {
            case "saveandrun": {
                this.setTaskInfo4Save(datas);
                break;
            }
            case "goon": 
            case "retry": {
                this.setTaskInfoAndSave(datas);
                break;
            }
            default: {
                throw new RuntimeException("op=" + key + " not supported");
            }
        }
    }

    private void setTaskInfoAndSave(DynamicObject[] datas) {
        for (DynamicObject data : datas) {
            data.set("managertraceid", (Object)TraceIdUtil.getCurrentTraceIdString());
            data.set("status", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    private void setTaskInfo4Save(DynamicObject[] dataEntities) {
        DynamicObject data = dataEntities[0];
        String balName = data.getString("bal.id");
        int period = data.getInt("period");
        data.set("taskno", (Object)(balName + "_" + period));
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)balName);
        data.set("msgappid", (Object)type.getAppId());
        data.set("status", (Object)"A");
        data.set("managertraceid", (Object)TraceIdUtil.getCurrentTraceIdString());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key;
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length == 0) {
            return;
        }
        switch (key = e.getOperationKey()) {
            case "saveandrun": 
            case "retry": {
                this.publishTasks(datas[0], "A");
                break;
            }
            case "goon": {
                this.publishTasks(datas[0], "B");
                break;
            }
            default: {
                throw new RuntimeException("op=" + key + " not supported");
            }
        }
    }

    private void publishTasks(DynamicObject data, String type) {
        ArrayList<TaskMsg> msgs = new ArrayList<TaskMsg>(1);
        msgs.add(new TaskMsg(data.getString("msgappid"), data.getLong("id"), type).setTaskGroup("4"));
        BalTaskUtil.publishTasks(msgs);
        List ids = msgs.stream().filter(t -> !t.isPubSuccess()).map(TaskMsg::getTaskId).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            data.set("status", (Object)"E");
        }
        try (TXHandle tx = TX.requiresNew((String)"resavetask");){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        }
    }

    static class SaveValidator
    extends AbstractValidator {
        SaveValidator() {
        }

        public void validate() {
            if (BalPerRecordSplitTaskOp.OP_SAVE.equals(this.getOperateKey())) {
                ExtendedDataEntity[] extDatas;
                for (ExtendedDataEntity extData : extDatas = this.getDataEntities()) {
                    this.validate4Save(extData);
                }
            }
        }

        private void validate4Save(ExtendedDataEntity extData) {
            boolean hasYearCol;
            DynamicObject data = extData.getDataEntity();
            String balName = data.getString("bal.id");
            if (StringUtils.isBlank((CharSequence)balName)) {
                return;
            }
            int period = data.getInt("period");
            int month = period % 100;
            if (month < 1 || month > 12) {
                String msg = ResManager.loadKDString((String)"\u5f52\u6863\u671f\u95f4\u5b57\u6bb5\u8f93\u5165\u4e0d\u5408\u6cd5\u3002", (String)"BAL-E-0004", (String)"bos-biz-balance", (Object[])new Object[0]);
                this.addErrorMessage(extData, msg);
                return;
            }
            BalanceTB bal = BalanceTB.getBalanceTB(balName);
            boolean bl = hasYearCol = !bal.getColsByDataType(BizDataType.YEAR_IN, BizDataType.YEAR_OUT).isEmpty();
            if (hasYearCol && period % 100 != 1) {
                String msg = ResManager.loadKDString((String)"\u5e26\u5e74\u6536\u53d1\u5b57\u6bb5\u7684\u4f59\u989d\u8868\uff0c\u53ea\u80fd\u6309\u5e74\u7b2c\u4e00\u671f\u8bbe\u7f6e\u5f52\u6863\u671f\u95f4\u3002", (String)"BAL-E-0003", (String)"bos-biz-balance", (Object[])new Object[0]);
                this.addErrorMessage(extData, msg);
            }
        }
    }
}

