/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.report;

import java.util.Collections;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.OccDBInfo;
import kd.bos.bal.report.BalPartAsyncTxRptParam;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.StringUtils;

public class BalPartAsyncTxRpt
extends AbstractReportListDataPlugin {
    private DataSet getEmpty() {
        return Algo.create((String)"BalAllAsyncBillRpt.getEmpty").createDataSet(Collections.emptyList(), new RowMeta(new Field[0]));
    }

    public DataSet query(ReportQueryParam rqp, Object o) throws Throwable {
        Set<OccDBInfo> infos;
        BalPartAsyncTxRptParam param = (BalPartAsyncTxRptParam)rqp.getCustomParam().get(BalPartAsyncTxRptParam.class.getName());
        String balName = param.getBal();
        String[] dbKeys = param.getDbKeys();
        QFilter fs = new QFilter("type", "=", (Object)"2");
        if (StringUtils.isNotBlank((CharSequence)balName)) {
            fs.and("bal", "=", (Object)balName);
        }
        if (dbKeys != null) {
            fs.and("db", "in", (Object)dbKeys);
            infos = BalUtil.getOccDBInfo(fs);
        } else {
            infos = BalUtil.getOccDBInfoWithBalDb(fs);
        }
        return this.buildDataSet(infos);
    }

    private DataSet buildDataSet(Set<OccDBInfo> infos) {
        if (infos.isEmpty()) {
            return this.getEmpty();
        }
        DataSet data = null;
        int idx = -1;
        DataSet[] datas = new DataSet[infos.size() + idx];
        for (OccDBInfo info : infos) {
            if (idx == -1) {
                data = this.getDataSet(BalanceTB.getBalanceTB(info.balName), info.occDb);
            } else {
                datas[idx] = this.getDataSet(BalanceTB.getBalanceTB(info.balName), info.occDb);
            }
            ++idx;
        }
        if (data == null) {
            data = this.getEmpty();
        }
        return datas.length > 0 ? data.union(datas) : data;
    }

    private DataSet getDataSet(BalanceTB bal, String dbKey) {
        DBRoute db = DBRoute.of((String)dbKey);
        String sql = " SELECT TOP 10000 FTXID TXID,fbal BAL,FXDBFLAG XDBFLAG,FCREATERID CREATER,FCREATETIME CREATETIME,FPUBLISHTIME PUBLISHTIME, '" + dbKey + "' dbkey FROM " + bal.getOrCreateTxTb(db) + " ORDER BY FTXID ASC";
        return DB.queryDataSet((String)"getDataSet", (DBRoute)db, (String)sql);
    }
}

