/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.report;

import java.util.EventObject;
import java.util.List;
import kd.bos.bal.report.BalSpRptParam;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalSpRptForm
extends AbstractReportFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ReportShowParameter fsp = (ReportShowParameter)this.getView().getFormShowParameter();
        String balTb = (String)fsp.getCustomParam("balancetb");
        if (StringUtils.isBlank((CharSequence)balTb)) {
            return;
        }
        this.initBalInfo(balTb, fsp.getCustomParam("id"));
        this.getModel().setValue("balancetb_s", fsp.getCustomParam("balancetb"));
        this.getModel().setValue("billname_s", fsp.getCustomParam("billname"));
    }

    private void initBalInfo(String balTb, Object balId) {
        if (balId == null) {
            return;
        }
        BalanceTB tb = BalanceTB.getBalanceTB(balTb);
        QFilter fs = new QFilter("id", "=", balId);
        DynamicObject result = QueryServiceHelper.queryOne((String)tb.getName(), (String)(tb.isPerBal() ? "keycol," + tb.getPeriodCol() : "keycol"), (QFilter[])fs.toArray());
        if (result != null) {
            this.getModel().setValue("keycol_s", (Object)result.getString("keycol"));
            if (tb.isPerBal()) {
                this.getModel().setValue("period_s", (Object)result.getString(tb.getPeriodCol()));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject billName;
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject bal = data.getDynamicObject("balancetb_s");
        if (bal == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u4f59\u989d\u8868\u540e\u518d\u67e5\u8be2\u3002", (String)"BalSpRptForm_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            return false;
        }
        BalSpRptParam param = new BalSpRptParam();
        param.setBalancetb(bal.getString("id"));
        if (data.get("entryseq_s") != null) {
            param.setEntryseq(data.getInt("entryseq_s"));
        }
        if (data.get("period_s") != null) {
            param.setPeriod(data.getInt("period_s"));
        }
        String val = data.getString("updatetype_s");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{val})) {
            param.setUpdatetype(val);
        }
        val = data.getString("status_s");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{val})) {
            param.setStatus(val);
        }
        val = data.getString("sptb_s");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{val})) {
            param.setSptb(val);
        }
        val = data.getString("billno_s");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{val})) {
            param.setBillno(val);
        }
        val = data.getString("keycol_s");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{val})) {
            param.setKeycol(val);
        }
        if ((billName = data.getDynamicObject("billname_s")) != null) {
            param.setBillName(billName.getString("id"));
        }
        ReportShowParameter fsp = (ReportShowParameter)this.getView().getFormShowParameter();
        param.setBillIds((List)fsp.getCustomParam("billid"));
        param.setEntryIds((List)fsp.getCustomParam("entryid"));
        queryParam.getCustomParam().put(BalSpRptParam.class.getName(), param);
        return true;
    }
}

