/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.util.PerBalQtyReduceFunc;
import kd.bos.bal.util.RealBalQtyReduceFunc;
import kd.bos.bal.util.SpJoinBalReduceGroupFunc;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.IBalance;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.balance.BizDataType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class BalQuery {
    private static final String EQ = "=?";

    public static DataSet getBalData4NegativeCheck(String balName, QFilter balFs, String ... selectCols) {
        return BalQuery.getBalData(balName, balFs, selectCols);
    }

    public static DataSet getBalData4NegativeCheck(long txId, BalanceTB bal, String ... selectCols) {
        return BalQuery.getBalData4NegativeCheck(txId, bal, null, selectCols);
    }

    public static DataSet getBalData4NegativeCheck(long txId, BalanceTB bal, Set<Long> shardTxs, String ... selectCols) {
        BalLogUtil.info("BalQuery.getBalData4NegativeCheck start : txId = {},bal={},shardTxs={}", txId, bal.getName(), shardTxs);
        Set<String> selectColSet = BalQuery.parse2Set(selectCols);
        if (bal.isPerBal()) {
            return BalQuery.getPerBalData4NegativeCheck(txId, bal, shardTxs, selectColSet);
        }
        if (bal.isRealBal()) {
            return BalQuery.getRealBalData4NegativeCheck(txId, bal, shardTxs, selectColSet);
        }
        throw new KDBizException("bal type is not real or period");
    }

    private static DataSet getRealBalData4NegativeCheck(long txId, BalanceTB bal, Set<Long> shardTxs, Set<String> selectCols) {
        selectCols.add("keycol");
        Set<String> allOccQty = bal.getOccCols();
        List<String> qtyCols = BalQuery.filterQtyCols(allOccQty, selectCols);
        Object[] keyColIn = txId < 0L || qtyCols.isEmpty() ? new Object[]{} : BalQuery.getKeycolIn(bal, txId, qtyCols).toArray();
        DataSet spData = qtyCols.isEmpty() || keyColIn.length == 0 ? null : BalQuery.getSpDataByArr(bal, keyColIn, qtyCols, shardTxs);
        QFilter where = keyColIn.length == 0 ? new QFilter("1", "=", (Object)2) : new QFilter("keycol", "in", (Object)keyColIn);
        DataSet balData = QueryServiceHelper.queryDataSet((String)"getBalData4NegativeCheck", (String)bal.getName(), (String)StringUtils.join(selectCols, (String)","), (QFilter[])where.toArray(), null);
        balData = BalQuery.mergeQtys4RealBal(balData, spData, qtyCols);
        return balData;
    }

    private static DataSet getPerBalData4NegativeCheck(long txId, BalanceTB bal, Set<Long> shardTxs, Set<String> selectCols) {
        if (txId < 0L) {
            return null;
        }
        selectCols.add("keycol");
        selectCols.add(bal.getPeriodCol());
        Set<String> allInitQty = bal.getColsByDataType(BizDataType.INIT);
        List<String> qtyInitCols = BalQuery.filterQtyCols(allInitQty, selectCols);
        boolean isOnlyBalQty = true;
        if (qtyInitCols.isEmpty()) {
            for (String initQty : allInitQty) {
                if (!selectCols.contains(initQty + "_bal")) continue;
                qtyInitCols.add(initQty);
            }
        } else {
            isOnlyBalQty = false;
        }
        if (qtyInitCols.isEmpty()) {
            return null;
        }
        BalQuery.reBuildSelectCols(selectCols, qtyInitCols, isOnlyBalQty);
        Map<Integer, Set<String>> keyColGroup = BalQuery.getPerKeycolIn(bal, txId, qtyInitCols);
        if (keyColGroup.isEmpty()) {
            return null;
        }
        DataSet spData = BalQuery.buildPerBalSpData(bal, keyColGroup, qtyInitCols, isOnlyBalQty, shardTxs);
        DataSet balData = BalQuery.buildPerBalData(bal, keyColGroup, selectCols);
        if (balData != null) {
            balData = BalQuery.mergeQtys4PerBal(bal, balData, spData, qtyInitCols, isOnlyBalQty);
        }
        return balData;
    }

    private static void reBuildSelectCols(Set<String> selectCols, List<String> qtyInitCols, boolean onlyBalQty) {
        if (onlyBalQty) {
            for (String qtyInitCol : qtyInitCols) {
                selectCols.remove(qtyInitCol);
                selectCols.remove(qtyInitCol + "_in");
                selectCols.remove(qtyInitCol + "_out");
                selectCols.add(qtyInitCol + "_bal");
            }
        } else {
            for (String qtyInitCol : qtyInitCols) {
                selectCols.add(qtyInitCol);
                selectCols.add(qtyInitCol + "_in");
                selectCols.add(qtyInitCol + "_out");
                selectCols.add(qtyInitCol + "_bal");
            }
        }
    }

    private static DataSet mergeQtys4PerBal(BalanceTB bal, DataSet balData, DataSet spData, List<String> qtyInitCols, boolean onlyBalQty) {
        if (spData != null) {
            if (onlyBalQty) {
                int size = qtyInitCols.size() * 3;
                ArrayList<String> addBalCols = new ArrayList<String>(size);
                ArrayList<String> addBalColExprs = new ArrayList<String>(size);
                for (String qtyInitCol : qtyInitCols) {
                    addBalCols.add(qtyInitCol);
                    addBalColExprs.add("0");
                    addBalCols.add(qtyInitCol + "_in");
                    addBalColExprs.add("0");
                    addBalCols.add(qtyInitCol + "_out");
                    addBalColExprs.add("0");
                }
                balData = balData.addFields(addBalColExprs.toArray(new String[0]), addBalCols.toArray(new String[0]));
            }
            String periodCol = bal.getPeriodCol();
            String[] balDataCols = balData.getRowMeta().getFieldNames();
            Set<String> spDataCols = BalQuery.getSpDataCols(spData);
            String[] spCols = new String[balDataCols.length];
            int len = balDataCols.length;
            for (int i = 0; i < len; ++i) {
                balDataCols[i] = balDataCols[i].toLowerCase(Locale.ENGLISH);
                spCols[i] = spDataCols.contains(balDataCols[i]) ? balDataCols[i] : "null " + balDataCols[i];
            }
            spData = spData.select(spCols);
            spData = spData.addField(String.valueOf(2), "balorspdataflag");
            balData = balData.addField(String.valueOf(1), "balorspdataflag");
            balData = balData.union(spData);
            balData = balData.groupBy(new String[]{"keycol"}).reduceGroup((ReduceGroupFunctionWithCollector)new PerBalQtyReduceFunc(balData.getRowMeta(), qtyInitCols, periodCol, onlyBalQty));
            return balData;
        }
        return balData;
    }

    private static DataSet buildPerBalData(BalanceTB bal, Map<Integer, Set<String>> keyColGroup, Set<String> selectCols) {
        String selectColStr = StringUtils.join(selectCols, (String)",");
        DataSet balData = null;
        for (Map.Entry<Integer, Set<String>> entry : keyColGroup.entrySet()) {
            QFilter fs = new QFilter("keycol", "in", entry.getValue()).and(bal.getPeriodCol(), ">=", (Object)entry.getKey());
            DataSet tempData = QueryServiceHelper.queryDataSet((String)"buildPerBalData", (String)bal.getName(), (String)selectColStr, (QFilter[])fs.toArray(), null);
            if (balData == null) {
                balData = tempData;
                continue;
            }
            balData = balData.union(tempData);
        }
        return balData;
    }

    private static DataSet buildPerBalSpData(BalanceTB bal, Map<Integer, Set<String>> keyColGroup, List<String> qtyCols, boolean isOnlyBalQty, Set<Long> shardTxs) {
        HashSet<String> keycols = new HashSet<String>();
        for (Set<String> keycolSet : keyColGroup.values()) {
            keycols.addAll(keycolSet);
        }
        DataSet spData = BalQuery.getPerSpDataByArr(bal, keycols, qtyCols, shardTxs);
        return spData;
    }

    private static Map<Integer, Set<String>> getPerKeycolIn(BalanceTB bal, long txId, List<String> qtyInitCols) {
        Map<String, String> colFieldMap = bal.getColFieldMap();
        String periodCol = colFieldMap.get(bal.getPeriodCol());
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append("fkeycol").append(',').append(periodCol);
        sql.append(" FROM ").append(bal.getTmpSnapshotTb());
        sql.append(" WHERE ").append("fupdatetime").append(" = ").append(txId);
        if (bal.isSyncUpdate()) {
            if (!qtyInitCols.isEmpty()) {
                ArrayList<String> qtyCols = new ArrayList<String>(qtyInitCols.size() * 3);
                for (String qtyCol : qtyInitCols) {
                    qtyCols.add(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol)) + "< 0");
                    qtyCols.add(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol + "_in")) + "< 0");
                    qtyCols.add(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol + "_out")) + "> 0");
                }
                sql.append(" AND (").append(StringUtils.join(qtyCols, (String)" OR ")).append(") ");
            }
        } else {
            sql.append(" AND ").append("freadtype").append("='").append("1").append("' ");
        }
        HashMap<Integer, Set> groupResult = new HashMap<Integer, Set>(2);
        try (DataSet datas = DB.queryDataSet((String)"getKeycolIn", (DBRoute)bal.getDbRoute(), (String)sql.toString()).groupBy(new String[]{"fkeycol"}).min(periodCol).finish();){
            RowMeta rowMeta = datas.getRowMeta();
            int keycolIdx = rowMeta.getFieldIndex("fkeycol");
            int periodIdx = rowMeta.getFieldIndex(periodCol);
            for (Row row : datas) {
                Integer period = row.getInteger(periodIdx);
                groupResult.computeIfAbsent(period, k -> new HashSet()).add(row.getString(keycolIdx));
            }
            HashMap<Integer, Set> hashMap = groupResult;
            return hashMap;
        }
    }

    private static Set<String> parse2Set(String[] selectCols) {
        HashSet<String> cols = new HashSet<String>(8);
        if (selectCols != null) {
            for (String col : selectCols) {
                cols.add(col);
            }
        }
        return cols;
    }

    private static Set<Object> getKeycolIn(BalanceTB bal, long txId, List<String> qtyCols) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append("fkeycol");
        sql.append(" FROM ").append(bal.getTmpSnapshotTb());
        sql.append(" WHERE ").append("fupdatetime").append(" = ").append(txId);
        if (bal.isSyncUpdate()) {
            if (!qtyCols.isEmpty()) {
                Object[] qtys = qtyCols.toArray(new String[0]);
                Map<String, String> colFieldMap = bal.getColFieldMap();
                int len = qtys.length;
                for (int i = 0; i < len; ++i) {
                    qtys[i] = BalanceTB.parse2SnapName(colFieldMap.get(qtys[i])) + "< 0";
                }
                sql.append(" AND (").append(StringUtils.join((Object[])qtys, (String)" OR ")).append(") ");
            }
        } else {
            sql.append(" AND ").append("freadtype").append("='").append("1").append("' ");
        }
        try (DataSet datas = DB.queryDataSet((String)"getKeycolIn", (DBRoute)bal.getDbRoute(), (String)sql.toString());){
            HashSet<String> keys = new HashSet<String>(256);
            for (Row row : datas) {
                keys.add(row.getString("fkeycol"));
            }
            HashSet<String> hashSet = keys;
            return hashSet;
        }
    }

    private static List<String> filterQtyCols(Set<String> targetQtyCols, Set<String> selectCols) {
        ArrayList<String> qtyCols = new ArrayList<String>(8);
        if (selectCols != null) {
            for (String col : selectCols) {
                if (!targetQtyCols.contains(col)) continue;
                qtyCols.add(col);
            }
        }
        return qtyCols;
    }

    private static DataSet getBalData(String balName, QFilter balFs, String ... selectCols) {
        BalanceTB tb = BalanceTB.getBalanceTB(balName);
        if (!tb.isRealBal()) {
            throw new KDBizException("kd.bos.bal.util.BalQuery.getBalData only support real bal");
        }
        Set<String> selectColSet = BalQuery.parse2Set(selectCols);
        selectColSet.add("keycol");
        DataSet spData = null;
        List<String> qtyCols = BalQuery.filterQtyCols(tb.getOccCols(), selectColSet);
        if (!qtyCols.isEmpty()) {
            int batch = 1000;
            ArrayList<String> keycols = new ArrayList<String>(batch);
            try (DataSet keycolData = QueryServiceHelper.queryDataSet((String)"getBalKeyCol", (String)balName, (String)"keycol", (QFilter[])balFs.toArray(), null);){
                for (Row row : keycolData) {
                    keycols.add(row.getString("keycol"));
                    if (keycols.size() < batch) continue;
                    spData = spData == null ? BalQuery.getSpData(tb, keycols, qtyCols) : spData.union(BalQuery.getSpData(tb, keycols, qtyCols));
                    keycols.clear();
                }
            }
            if (!keycols.isEmpty()) {
                spData = spData == null ? BalQuery.getSpData(tb, keycols, qtyCols) : spData.union(BalQuery.getSpData(tb, keycols, qtyCols));
            }
        }
        String cols = StringUtils.join(selectColSet, (char)',');
        DataSet balData = QueryServiceHelper.queryDataSet((String)"getBalData", (String)balName, (String)cols, (QFilter[])balFs.toArray(), null);
        balData = BalQuery.mergeQtys4RealBal(balData, spData, qtyCols);
        return balData;
    }

    private static Set<String> getSpDataCols(DataSet spData) {
        String[] cols;
        HashSet<String> spDataCols = new HashSet<String>(16);
        for (String col : cols = spData.getRowMeta().getFieldNames()) {
            spDataCols.add(col.toLowerCase(Locale.ENGLISH));
        }
        return spDataCols;
    }

    private static DataSet mergeQtys4RealBal(DataSet balData, DataSet spData, List<String> qtyCols) {
        if (spData != null) {
            String[] balDataCols = balData.getRowMeta().getFieldNames();
            Set<String> spDataCols = BalQuery.getSpDataCols(spData);
            String[] spCols = new String[balDataCols.length];
            int len = balDataCols.length;
            for (int i = 0; i < len; ++i) {
                balDataCols[i] = balDataCols[i].toLowerCase(Locale.ENGLISH);
                spCols[i] = spDataCols.contains(balDataCols[i]) ? balDataCols[i] : "null " + balDataCols[i];
            }
            spData = spData.select(spCols);
            balData = BalQuery.mergeSpQtys(balData, spData, "keycol", qtyCols);
        }
        return balData;
    }

    public static DataSet mergeSpQtys(DataSet balData, DataSet spData, String groupKey, List<String> qtyCols) {
        spData = spData.addField(String.valueOf(2), "balorspdataflag");
        balData = balData.addField(String.valueOf(1), "balorspdataflag");
        balData = balData.union(spData);
        balData = balData.groupBy(new String[]{groupKey}).reduceGroup((ReduceGroupFunctionWithCollector)new RealBalQtyReduceFunc(balData.getRowMeta(), qtyCols));
        return balData;
    }

    private static DataSet getSpData(BalanceTB tb, List<String> keycols, List<String> qtyCols) {
        return BalQuery.getSpDataByArr(tb, keycols.toArray(), qtyCols, null);
    }

    private static DataSet getSpDataByArr(BalanceTB tb, Object[] keycols, List<String> qtyCols, Set<Long> shardTxs) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT ", new Object[0]).append("fkeycol", new Object[0]).append(" ", new Object[0]).append("keycol", new Object[0]);
        Map<String, String> colsMap = tb.getColFieldMap();
        for (String qtyCol : qtyCols) {
            sql.append(",", new Object[0]).append(BalanceTB.parse2SnapName(colsMap.get(qtyCol)), new Object[0]).append(" ", new Object[0]).append(qtyCol, new Object[0]);
        }
        sql.append(" FROM ", new Object[0]).append(tb.getTmpSnapshotTb(), new Object[0]).append(" WHERE ", new Object[0]);
        if (keycols == null || keycols.length == 0) {
            sql.append(" 1!=1 ", new Object[0]);
        } else {
            sql.appendIn("fkeycol", keycols);
        }
        if (shardTxs == null || shardTxs.isEmpty()) {
            sql.append(" AND ", new Object[0]).append("freadtype", new Object[0]).append("='1' ", new Object[0]);
        } else {
            sql.append(" AND (", new Object[0]).append("freadtype", new Object[0]).append("='1' OR ", new Object[0]);
            sql.append("fupdatetime", new Object[0]).append(QFUtil.getIdsFilter(shardTxs), new Object[0]).append(") ", new Object[0]);
        }
        return DB.queryDataSet((String)"getSpData", (DBRoute)tb.getDbRoute(), (SqlBuilder)sql);
    }

    private static void appendPerBalQtyCol(SqlBuilder sql, Map<String, String> colsMap, String qtyCol) {
        sql.append(",", new Object[0]).append(BalanceTB.parse2SnapName(colsMap.get(qtyCol)), new Object[0]).append(" ", new Object[0]).append(qtyCol, new Object[0]);
    }

    private static DataSet getPerSpDataByArr(BalanceTB tb, Set<String> keycols, List<String> qtyCols, Set<Long> shardTxs) {
        Map<String, String> colsMap = tb.getColFieldMap();
        String periodCol = colsMap.get(tb.getPeriodCol());
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT ", new Object[0]).append("fkeycol", new Object[0]).append(" ", new Object[0]).append("keycol", new Object[0]);
        sql.append(", ", new Object[0]).append(periodCol, new Object[0]).append(" ", new Object[0]).append(tb.getPeriodCol(), new Object[0]);
        for (String qtyCol : qtyCols) {
            BalQuery.appendPerBalQtyCol(sql, colsMap, qtyCol);
            BalQuery.appendPerBalQtyCol(sql, colsMap, qtyCol + "_in");
            BalQuery.appendPerBalQtyCol(sql, colsMap, qtyCol + "_out");
        }
        sql.append(" FROM ", new Object[0]).append(tb.getTmpSnapshotTb(), new Object[0]).append(" WHERE ", new Object[0]);
        sql.appendIn("fkeycol", keycols.toArray());
        if (shardTxs == null || shardTxs.isEmpty()) {
            sql.append(" AND ", new Object[0]).append("freadtype", new Object[0]).append("='1' ", new Object[0]);
        } else {
            sql.append(" AND (", new Object[0]).append("freadtype", new Object[0]).append("='1' OR ", new Object[0]);
            sql.append("fupdatetime", new Object[0]).append(QFUtil.getIdsFilter(shardTxs), new Object[0]).append(") ", new Object[0]);
        }
        return DB.queryDataSet((String)"getSpData", (DBRoute)tb.getDbRoute(), (SqlBuilder)sql);
    }

    private static List<String> buildSelectCols(BalanceTB bal, Collection<String> qtyCols) {
        ArrayList<String> selectCols = new ArrayList<String>(qtyCols.size() + 2);
        selectCols.add("fbillid billid");
        selectCols.add("fbillno billno");
        selectCols.add("fentryid entryid");
        selectCols.add("fentryseq entryseq");
        selectCols.add("fkeycol keycol");
        selectCols.add("fupdateruleid updaterule");
        Map<String, String> colMap = bal.getColFieldMap();
        for (String qtycol : qtyCols) {
            selectCols.add(BalUtil.buildColExpr(BalanceTB.parse2SnapName(colMap.get(qtycol)), qtycol));
        }
        return selectCols;
    }

    private static DataSet getBalUpdateInfo(long txId, BalanceTB bal, Collection<String> qtyCols) {
        List<String> selectCols = BalQuery.buildSelectCols(bal, qtyCols);
        String select = StringUtils.join(selectCols, (String)",");
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT", new Object[0]).append(select, new Object[0]).append("FROM", new Object[0]);
        sql.append(bal.getTmpSnapshotTb(), new Object[0]);
        sql.append("WHERE", new Object[0]).append("fupdatetime=?", new Object[]{txId});
        DataSet tempSpData = DB.queryDataSet((String)"getBalUpdateInfo", (DBRoute)bal.getDbRoute(), (SqlBuilder)sql);
        return tempSpData;
    }

    private static DataSet getBalUpdateInfo(BalanceTB bal, String billEntity, Collection<Object> billIds, Collection<String> qtyCols) {
        if (!bal.isRealBal()) {
            throw new KDBizException("bal must be real type");
        }
        List<String> selectCols = BalQuery.buildSelectCols(bal, qtyCols);
        String select = StringUtils.join(selectCols, (String)",");
        SqlBuilder where = new SqlBuilder();
        where.append("WHERE", new Object[0]).append("fbillname=?", new Object[]{billEntity});
        where.append("AND", new Object[0]).appendIn("fbillid", billIds.toArray());
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT", new Object[0]).append(select, new Object[0]).append("FROM", new Object[0]);
        sql.append(bal.getSnapshotTb(), new Object[0]).appendSqlBuilder(where);
        sql.append("AND", new Object[0]).append("fstatus=?", new Object[]{"A"});
        DataSet spData = DB.queryDataSet((String)"getBalUpdateInfo", (DBRoute)bal.getDbRoute(), (SqlBuilder)sql);
        sql = new SqlBuilder();
        sql.append("SELECT", new Object[0]).append(select, new Object[0]).append("FROM", new Object[0]);
        sql.append(bal.getTmpSnapshotTb(), new Object[0]).appendSqlBuilder(where);
        DataSet tempSpData = DB.queryDataSet((String)"getBalUpdateInfo", (DBRoute)bal.getDbRoute(), (SqlBuilder)sql);
        spData = spData.union(tempSpData);
        return spData;
    }

    public static DataSet getBalUpdatedInfo4SerialNo(String balEntity, String billEntity, Collection<Object> billIds, List<String> balCols) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{balEntity, billEntity}) || billIds == null || billIds.isEmpty()) {
            return null;
        }
        if (balCols == null) {
            balCols = Collections.emptyList();
        }
        BalanceTB bal = BalanceTB.getBalanceTB(balEntity);
        Set<String> allQtyCols = bal.getColsByDataType(BizDataType.OCC);
        HashSet<String> qtyCols = new HashSet<String>(8);
        HashSet<String> selectBalCols = new HashSet<String>(balCols.size());
        for (String col : balCols) {
            if (allQtyCols.contains(col = col.toLowerCase(Locale.ENGLISH))) {
                qtyCols.add(col);
                continue;
            }
            selectBalCols.add(col);
        }
        selectBalCols.remove("keycol");
        DataSet spData = BalQuery.getBalUpdateInfo(bal, billEntity, billIds, qtyCols);
        if (!selectBalCols.isEmpty()) {
            spData = spData.reduceGroup((ReduceGroupFunctionWithCollector)new SpJoinBalReduceGroupFunc(spData.getRowMeta(), balEntity, selectBalCols));
        }
        return spData;
    }

    public static DataSet getBalUpdatedInfo(long txId, BalanceTB bal, Collection<String> balQtyCols, Collection<String> balCols) {
        List<String> qtyCols;
        Set<String> selectBalCols = null;
        Collection<Object> collection = qtyCols = balQtyCols == null ? Collections.emptyList() : balQtyCols;
        if (balCols == null) {
            selectBalCols = Collections.emptySet();
        } else {
            selectBalCols = new HashSet(balCols.size());
            for (String balCol : balCols) {
                selectBalCols.add(balCol.toLowerCase(Locale.ENGLISH));
            }
            selectBalCols.remove("keycol");
            selectBalCols.removeAll(qtyCols);
        }
        DataSet spData = BalQuery.getBalUpdateInfo(txId, bal, qtyCols);
        if (!selectBalCols.isEmpty()) {
            spData = spData.reduceGroup((ReduceGroupFunctionWithCollector)new SpJoinBalReduceGroupFunc(spData.getRowMeta(), bal.getName(), selectBalCols));
        }
        return spData;
    }

    public static DataSet getBalUpdatedInfo4ReserveTrans(long txId, BalanceTB bal, List<String> balCols) {
        if (!bal.isRealBal()) {
            throw new KDBizException("bal must be real type");
        }
        return BalQuery.getBalUpdatedInfo(txId, bal, bal.getColsByDataType(BizDataType.OCC), balCols);
    }

    public static DataSet getBalUpdatedInfo4ReserveTrans(String balEntity, String billEntity, Collection<Object> billIds, List<String> balCols) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{balEntity, billEntity}) || billIds == null || billIds.isEmpty()) {
            return null;
        }
        Set<String> selectBalCols = null;
        BalanceTB bal = BalanceTB.getBalanceTB(balEntity);
        Set<String> qtyCols = bal.getColsByDataType(BizDataType.OCC);
        if (balCols == null) {
            selectBalCols = Collections.emptySet();
        } else {
            selectBalCols = new HashSet(balCols.size());
            for (String balCol : balCols) {
                selectBalCols.add(balCol.toLowerCase(Locale.ENGLISH));
            }
            selectBalCols.remove("keycol");
            selectBalCols.removeAll(qtyCols);
        }
        DataSet spData = BalQuery.getBalUpdateInfo(bal, billEntity, billIds, qtyCols);
        GroupbyDataSet groupData = spData.groupBy(new String[]{"billid", "entryid", "keycol"});
        for (String qtycol : qtyCols) {
            groupData = groupData.sum(qtycol);
        }
        spData = groupData.finish();
        if (!selectBalCols.isEmpty()) {
            spData = spData.reduceGroup((ReduceGroupFunctionWithCollector)new SpJoinBalReduceGroupFunc(spData.getRowMeta(), balEntity, selectBalCols));
        }
        return spData;
    }

    public static boolean isUpdateComplete(BalanceTB bal, DBRoute routeOfBill, int opFlag) {
        String key = "check_" + bal.getName() + "_" + routeOfBill.getRouteKey() + "_" + opFlag;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bal");
        String cacheVal = (String)cache.get(key);
        if (!"true".equals(cacheVal) && !"false".equals(cacheVal)) {
            boolean complete = BalQuery.queryUpdateComplete(bal, routeOfBill, opFlag);
            cache.put(key, (Object)String.valueOf(complete), 60);
            return complete;
        }
        return Boolean.parseBoolean(cacheVal);
    }

    private static boolean queryUpdateComplete(BalanceTB bal, DBRoute routeOfBill, int opFlag) {
        boolean hasData = BalQuery.hasData(bal.getOrCreateTempAsyncInfoTb(routeOfBill), routeOfBill, "FXDBFLAG", opFlag);
        if (hasData) {
            return false;
        }
        hasData = BalQuery.hasData(bal.getOrCreateAsyncInfoTb(routeOfBill), routeOfBill, "FXDBFLAG", opFlag);
        if (hasData) {
            return false;
        }
        hasData = BalQuery.hasData("T_BAL_UPDATING", IBalance.BAL_DB, "FOPFLAG", opFlag);
        return !hasData;
    }

    private static boolean hasData(String tb, DBRoute routeOfBill, String col, int opFlag) {
        String sql = "SELECT TOP 1 FID FROM " + tb + " WHERE " + col + " = " + opFlag;
        try (DataSet rows = DB.queryDataSet((String)"hasAsyncInfo", (DBRoute)routeOfBill, (String)sql);){
            if (rows.isEmpty()) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

