/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public class IDIHttpUtils {
    private static Log logger = LogFactory.getLog(IDIHttpUtils.class);
    private static CloseableHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpRequestByPostCore(String url, String params, int timeOut, int readOut, @NotNull Function<Integer, Boolean> responseStatusCodeFunction) {
        CloseableHttpClient httpClient = IDIHttpUtils.createHttpClient();
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(timeOut).setConnectionRequestTimeout(timeOut).setSocketTimeout(readOut);
        RequestConfig requestConfig = builder.build();
        StringEntity reqFromEntity = new StringEntity(params, ContentType.APPLICATION_JSON);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)reqFromEntity);
        httpPost.setConfig(requestConfig);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                if (responseStatusCodeFunction.apply(response.getStatusLine().getStatusCode()).booleanValue()) {
                    String string = resultStr;
                    return string;
                }
                String errorMessage = ResManager.loadKDString((String)"\u53d1\u9001\u6d88\u606f\u5931\u8d25:", (String)"IDIInvoicePiaoZoneHelper_13", (String)"data-idi-core", (Object[])new Object[0]);
                throw new KDBizException(errorMessage + resultStr);
            }
        }
        catch (Exception e) {
            String errorMessage = ResManager.loadKDString((String)"\u53d1\u9001HTTP POST\u51fa\u9519\uff1a", (String)"IDIInvoicePiaoZoneHelper_14", (String)"data-idi-core", (Object[])new Object[0]);
            logger.error(errorMessage + e.getMessage(), (Throwable)e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return null;
    }

    public static String sendHttpRequestByPost(String url, String params, int timeOut, int readOut) {
        return IDIHttpUtils.sendHttpRequestByPostCore(url, params, timeOut, readOut, statusCode -> statusCode == 200);
    }

    public static String sendHttpRequestByPostV1(String url, String params, int timeOut, int readOut) {
        return IDIHttpUtils.sendHttpRequestByPostCore(url, params, timeOut, readOut, statusCode -> statusCode == 200 || statusCode == 403);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpsRequest(String url, String paramStr, int timeOut, int readOut) {
        String data = "";
        CloseableHttpClient client = IDIHttpUtils.createHttpClient();
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(timeOut).setConnectionRequestTimeout(timeOut).setSocketTimeout(readOut);
        RequestConfig requestConfig = builder.build();
        HttpPost post = new HttpPost(url);
        post.setConfig(requestConfig);
        URI uri = post.getURI();
        try {
            if ("https".equals(uri.getScheme())) {
                client = IDIHttpUtils.wapperHttps((HttpClient)client);
            }
            StringEntity se = new StringEntity(paramStr, ContentType.APPLICATION_FORM_URLENCODED);
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            logger.error("response = " + response);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    data = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                    logger.error("data of response : " + data);
                }
            } else {
                String errorMessage = ResManager.loadKDString((String)"\u53d1\u9001HTTP POST\u51fa\u9519\uff1a", (String)"CourierLogisticsHelper_2", (String)"data-idi-core", (Object[])new Object[0]);
                logger.error(errorMessage + response);
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            String errorMessage = ResManager.loadKDString((String)"\u53d1\u9001HTTP POST\u51fa\u9519\uff1a", (String)"IDIInvoicePiaoZoneHelper_14", (String)"data-idi-core", (Object[])new Object[0]);
            logger.error(errorMessage + e.getMessage(), (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static HttpClient wapperHttps(HttpClient httpClient) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            ctx.init(null, new TrustManager[]{factory.getTrustManagers()[0]}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
            ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(registry);
            return new DefaultHttpClient((ClientConnectionManager)mgr, httpClient.getParams());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("wapperHttps is error", (Throwable)e);
            throw e;
        }
        catch (KeyManagementException e) {
            logger.error("wapperHttps is error", (Throwable)e);
            throw e;
        }
        catch (KeyStoreException e) {
            logger.error("wapperHttps is error", (Throwable)e);
            throw e;
        }
    }

    private static CloseableHttpClient createHttpClient() {
        if (httpClient == null) {
            HttpClientBuilder custom = HttpClients.custom();
            String[] proxy = IDIHttpUtils.queryProxyHost();
            if (proxy != null) {
                HttpHost proxyHost = new HttpHost(proxy[0], Integer.parseInt(proxy[1]));
                custom.setProxy(proxyHost);
            }
            httpClient = custom.build();
        }
        return httpClient;
    }

    public static String[] queryProxyHost() {
        String[] proxy = null;
        DynamicObject queryOne = null;
        try {
            queryOne = QueryServiceHelper.queryOne((String)"er_stdconfig", (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"httpProxy")});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (queryOne != null) {
            String httpProxy = queryOne.getString("value");
            if (StringUtils.isNotEmpty((String)httpProxy)) {
                String[] values = httpProxy.trim().split(":");
                if (values.length != 2) {
                    throw new KDBizException(ResManager.loadKDString((String)"er_stdconfig\u540e\u53f0\u8868\u4e2d, httpProxy\u53c2\u6570\u683c\u5f0f\u4e0d\u5bf9, \u5e94\u5f53\u4e3a: hostname:port", (String)"IDIInvoicePiaoZoneHelper_15", (String)"data-idi-core", (Object[])new Object[0]));
                }
                proxy = values;
            } else {
                String host = System.getProperty("https.proxyHost");
                String port = System.getProperty("https.proxyPort");
                if (StringUtils.isNotEmpty((String)host) && StringUtils.isNotEmpty((String)port)) {
                    proxy = new String[]{host, port};
                }
            }
        } else {
            String host = System.getProperty("https.proxyHost");
            String port = System.getProperty("https.proxyPort");
            if (StringUtils.isNotEmpty((String)host) && StringUtils.isNotEmpty((String)port)) {
                proxy = new String[]{host, port};
            }
        }
        return proxy;
    }
}

