/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionFrontEndConfigField;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.attachment.AIAttachmentConfig;
import kd.data.idi.data.attachment.CheckAttachmentTypeEnum;
import kd.data.idi.data.attachment.CheckMethodEnum;
import kd.data.idi.data.attachment.ExceptionTip;
import kd.data.idi.data.attachment.ExceptionTipEnum;
import kd.data.idi.data.attachment.GptRiskTip;
import kd.data.idi.data.attachment.RuleRepo;
import kd.data.idi.data.basedata.CreateOrgBaseDataConfig;
import kd.data.idi.data.basedata.StandardBaseDataConfig;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.engine.attachment.AttachmentServiceFactory;
import kd.data.idi.engine.attachment.IAttachmentService;
import kd.data.idi.formplugin.IDIAIAttachmentRuleSetFormPlugin;
import kd.data.idi.util.ExpressionTranslator;
import kd.data.idi.util.FieldTreeBuilder;
import kd.data.idi.util.FilterGridHelper;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;
import kd.data.idi.util.Pair;

public class IDIAIAttachmentFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String Key_BTN_OK = "btnok";
    private static final String CustomParam_ENTITY_NUMBER = "entitynumber";
    private static final String CustomParam_ANALYSIS_MODE = "analysis_mode";
    private static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    private static final String CustomParam_CURRENTSELECTFIELDS = "currentSelectField";
    private static final String CustomParam_LIMITFIELDS = "limitfields";
    private static final String CustomParam_FORMULA = "formula";
    private static final String CustomParam_TREENODES = "treenodes";
    private static final String CustomParam_SOURCEENTITYNUMBER = "sourceentitynumber";
    private static final String CustomParam_ATTACHMENTFIELD = "attachmentField";
    private static final String CustomParam_ONLY_ATTACHMENTFIELD = "onlyAttachmentField";
    private static final String CustomParam_ONLY_ATTACHMENTFILENAME = "onlyAttachmentFileName";
    private static final String Key_CHECKTYPE = "checktype";
    private static final String Key_CHECKMETHOD = "checkmethod";
    private static final String Key_FGPTASTEMPLATE = "fgptastemplate";
    private static final String Key_ENABLERULEBASE = "enablerulebase";
    private static final String Key_WORDSCONFIG = "wordsconfig";
    private static final String Key_MULEXISTWORDS = "mulexistwords";
    private static final String Key_MULNOTEXISTWORDS = "mulnotexistwords";
    private static final String Key_RULEPANEL = "rulepanel";
    private static final String Key_RULE_LIST = "rulelist";
    private static final String Key_MULTITLE = "multitle";
    private static final String Key_ISPASS = "ispass";
    private static final String Key_RULE_JSON = "rulejson";
    private static final String Key_RULE = "rule";
    private static final String Key_PERCENT = "percent";
    private static final String Key_STATUS = "status";
    private static final String Key_SHOWALLCHECKTRUE = "showallchecktrue";
    private static final String Key_RULEREPOPANEL = "rulerepopanel";
    private static final String Key_RULEREPOENTRY = "rulerepoentry";
    private static final String Key_RULEREPOTIP = "rulerepotip";
    private static final String Key_RULEREPO = "rulerepo";
    private static final String Key_RULEREPOPERCENT = "rulerepopercent";
    private static final String KEY_TIPPANEL = "tippanel";
    private static final String Key_SETENTRY = "setentry";
    private static final String Key_DEDUCTITEM = "deductitem";
    private static final String Key_MULERRORTIPS = "mulerrortips";
    private static final String KEY_ISSHOWERRORTIPS = "isshowerrortips";
    private static final String Key_DEDUCTPERCENT = "deductpercent";
    private static final String KEY_GPTPANEL = "gptpanel";
    private static final String KEY_GPTRISKTIPENTRY = "gptrisktipentry";
    private static final String KEY_GPTTIP = "gpttip";
    private static final String KEY_BILLPOSITIONGING = "billpositionging";
    private static final String KEY_CHECKATTACHEMNTFIELD = "checkattachemntfield";
    private static final String KEY_GPTRULE = "gptrule";
    private static final String KEY_GPTRULEEND = "gptrule_backend";
    private static final String KEY_GPTPERCENT = "gptpercent";
    private static final String KEY_GPTRISKTIP = "gptrisktip";
    private static final String KEY_GPTID = "gptid";
    private static final String Key_BAR_FRONTEND = "bar_frontend";
    private static final String Key_BTN_NEW = "btn_new";
    private static final String Key_SHOW_LIST = "show_list";
    private static final String KEY_SOURCEBILL = "srcbill";
    private static final String Key_BILLTYPE = "billtype";
    private static final String Key_PROPNAME = "propname";
    private static final String Key_MULDISPLAYNAME = "muldisplayname";
    private static final String Key_PROPDISPLAYNAME = "propdisplayname";
    private static final String PAGECACHE_INTERRUPT = "interrupt";
    private static final String ActionId_SET_BILLFIELD = "setBillField";
    private static final String ActionId_SET_GPPTRULE = "ide_largertextedit_callBack";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{Key_BTN_OK, Key_RULE, Key_PROPDISPLAYNAME, KEY_GPTRULE});
        this.addItemClickListeners(new String[]{Key_BAR_FRONTEND});
        BasedataEdit fgptTemplateEdit = (BasedataEdit)this.getControl(Key_FGPTASTEMPLATE);
        fgptTemplateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        String analysisMode = (String)fsp.getCustomParam(CustomParam_ANALYSIS_MODE);
        boolean scoreMode = AnalysisMode.SCORE.getType().equals(analysisMode);
        String detailConfig = (String)fsp.getCustomParam(CustomParam_DETAIL_CONFIG);
        AIAttachmentConfig aiAttachmentConfig = (AIAttachmentConfig)IDIJSONUtils.cast((String)detailConfig, AIAttachmentConfig.class);
        if (aiAttachmentConfig != null) {
            this.setBase(aiAttachmentConfig);
            this.setWords(aiAttachmentConfig);
            this.setRule(aiAttachmentConfig, scoreMode);
            this.setRuleRepo(aiAttachmentConfig, scoreMode);
            this.setGPTTips(aiAttachmentConfig, scoreMode);
            this.setErrorTipsPanel(aiAttachmentConfig.getCheckType(), aiAttachmentConfig.getExceptionTipList(), scoreMode);
            this.setFrontConfig(aiAttachmentConfig);
            this.updateBillTypeCombo(aiAttachmentConfig.getFgptasTemplate(), aiAttachmentConfig.getCheckMethod());
            if (aiAttachmentConfig.getCheckType() == CheckAttachmentTypeEnum.CHECKBILLCONTENT && !aiAttachmentConfig.isEnableRuleBase()) {
                this.updateCheckAttachmentField(aiAttachmentConfig.getFgptasTemplate(), aiAttachmentConfig.getCheckMethod());
            }
        } else {
            this.setErrorTipsPanel(CheckAttachmentTypeEnum.CHECKBILLCONTENT, null, scoreMode);
            this.getModel().setValue(KEY_GPTRISKTIP, this.getDefaultPrompt());
            this.updateBillTypeCombo(null, CheckMethodEnum.FGPTAS);
        }
        this.setVisibility(aiAttachmentConfig, scoreMode);
        this.setEnable(aiAttachmentConfig);
        this.initBillPositionging();
    }

    private Object getDefaultPrompt() {
        DynamicObject initConfig = QueryServiceHelper.queryOne((String)"fgptas_audit_init", (String)"prompt_risk", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return initConfig == null ? null : initConfig.get("prompt_risk");
    }

    private void setEnable(AIAttachmentConfig aiAttachmentConfig) {
        if (aiAttachmentConfig != null && aiAttachmentConfig.isEnableRuleBase()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{Key_CHECKTYPE, Key_FGPTASTEMPLATE});
        }
    }

    private void setVisibility(AIAttachmentConfig aiAttachmentConfig, boolean scoreMode) {
        CheckAttachmentTypeEnum checkType = aiAttachmentConfig == null ? CheckAttachmentTypeEnum.CHECKBILLCONTENT : aiAttachmentConfig.getCheckType();
        boolean enableRuleBase = aiAttachmentConfig == null ? false : aiAttachmentConfig.isEnableRuleBase();
        ArrayList<String> hiddenList = new ArrayList<String>();
        if (!scoreMode) {
            hiddenList.add(Key_PERCENT);
            hiddenList.add(Key_RULEREPOPERCENT);
            hiddenList.add(KEY_GPTPERCENT);
            hiddenList.add(Key_DEDUCTPERCENT);
        }
        this.setHiddenField(checkType, hiddenList, enableRuleBase);
        this.getView().setVisible(Boolean.valueOf(false), hiddenList.toArray(new String[0]));
    }

    private void setHiddenField(CheckAttachmentTypeEnum checkType, List<String> hiddenList, boolean enableRuleBase) {
        switch (checkType) {
            case CHECKBILLCONTENT: {
                hiddenList.add(Key_WORDSCONFIG);
                if (enableRuleBase) {
                    hiddenList.add(Key_RULEPANEL);
                    hiddenList.add(KEY_GPTPANEL);
                    break;
                }
                hiddenList.add(Key_RULEREPOPANEL);
                break;
            }
            case CHECKEXISTS: {
                hiddenList.add(Key_ENABLERULEBASE);
                hiddenList.add(Key_RULEPANEL);
                hiddenList.add(Key_RULEREPOPANEL);
                hiddenList.add(KEY_GPTPANEL);
                break;
            }
            case CHECKFILENAME: {
                hiddenList.add(Key_CHECKMETHOD);
                hiddenList.add(Key_FGPTASTEMPLATE);
                hiddenList.add(Key_ENABLERULEBASE);
                hiddenList.add(Key_CHECKMETHOD);
                hiddenList.add(Key_WORDSCONFIG);
                hiddenList.add(Key_RULEREPOPANEL);
                hiddenList.add(KEY_GPTPANEL);
            }
        }
    }

    private void initBillPositionging() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        MainEntityType sourceBillEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        Map<String, String> propToCaptionMap = this.achieveFieldCaption(sourceBillEntityType);
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_BILLPOSITIONGING);
        ArrayList comboItemList = new ArrayList(2);
        propToCaptionMap.forEach((prop, caption) -> {
            ComboItem srcBillComboItem = new ComboItem();
            srcBillComboItem.setCaption(new LocaleString(caption));
            srcBillComboItem.setValue(prop);
            comboItemList.add(srcBillComboItem);
        });
        comboEdit.setComboItems(comboItemList);
    }

    private void updateBillTypeCombo(Object[] newTemplateValues, CheckMethodEnum checkMethodEnum) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(Key_BILLTYPE);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(2);
        ComboItem srcBillComboItem = new ComboItem();
        srcBillComboItem.setCaption(ResManager.getLocaleString((String)"\u6e90\u5355\u5b57\u6bb5", (String)"IDIDecisionFormPlugin_8", (String)"data-idi-formplugin"));
        srcBillComboItem.setValue(KEY_SOURCEBILL);
        comboItemList.add(srcBillComboItem);
        if (newTemplateValues != null && newTemplateValues.length > 0 || checkMethodEnum == null) {
            ComboItem templateComboItem = new ComboItem();
            templateComboItem.setCaption(ResManager.getLocaleString((String)"\u9644\u4ef6\u5b57\u6bb5", (String)"IDIDecisionFormPlugin_14", (String)"data-idi-formplugin"));
            templateComboItem.setValue(CustomParam_ATTACHMENTFIELD);
            comboItemList.add(templateComboItem);
        }
        comboEdit.setComboItems(comboItemList);
    }

    private void setFrontConfig(AIAttachmentConfig aiAttachmentConfig) {
        List contents;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DecisionFrontEndConfig decisionFrontEndConfig = aiAttachmentConfig.getFrontEndConfig();
        if (decisionFrontEndConfig != null && (contents = decisionFrontEndConfig.getHoverFieldContents()) != null) {
            Map<String, String> srcFieldMap = null;
            HashMap<String, String> attachmentFieldMap = new HashMap<String, String>(2);
            attachmentFieldMap.put("filename", ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0", (String)"IDIFieldListFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            model.beginInit();
            for (DecisionFrontEndConfigField configField : contents) {
                String billType = configField.getBillType();
                int row = model.createNewEntryRow(Key_SHOW_LIST);
                boolean isSrc = KEY_SOURCEBILL.equals(billType);
                if (isSrc && srcFieldMap == null) {
                    String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
                    srcFieldMap = this.achieveFieldCaption(EntityMetadataCache.getDataEntityType((String)sourceBill));
                }
                String mulPropDisplayName = isSrc ? (String)srcFieldMap.get(configField.getPropName()) : (String)attachmentFieldMap.get(configField.getPropName());
                model.setValue(Key_BILLTYPE, (Object)(isSrc ? billType : CustomParam_ATTACHMENTFIELD), row);
                model.setValue(Key_PROPNAME, (Object)(isSrc ? configField.getPropName() : billType + "," + configField.getPropName()), row);
                model.setValue(Key_PROPDISPLAYNAME, (Object)(StringUtils.isNotEmpty((String)mulPropDisplayName) ? mulPropDisplayName : configField.getPropDisplayName()), row);
                model.setValue(Key_MULDISPLAYNAME, (Object)configField.getMulDisplayName(), row);
            }
            model.endInit();
            view.updateView(Key_SHOW_LIST);
        }
    }

    private Map<String, String> achieveFieldCaption(MainEntityType entityType) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(10);
        if (entityType == null) {
            return fieldMap;
        }
        Map entityTypeMap = entityType.getAllEntities();
        Map propertyMap = entityType.getAllFields();
        List cols = FilterGridHelper.getAllFilterColumnsAndMulBase((MainEntityType)entityType);
        String billEntityType = entityType.getName();
        for (Map map : cols) {
            boolean isEntry;
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            String fieldHead = fieldName;
            if (fieldName.indexOf(".") > 0) {
                String[] feilds = fieldName.split("\\.");
                fieldHead = feilds[0];
            }
            IDataEntityProperty property = (IDataEntityProperty)propertyMap.get(fieldHead);
            String value = fieldName;
            if (property instanceof MulBasedataProp) {
                value = fieldName.replace(property.getName() + ".", property.getName() + ".fbasedataid.");
            }
            boolean entryEntityNotEmpty = StringUtils.isNotEmpty((String)entryEntity);
            boolean bl = isEntry = !billEntityType.equals(entryEntity);
            if (entryEntityNotEmpty && isEntry) {
                EntityType entryType = (EntityType)entityTypeMap.get(entryEntity);
                value = entryType instanceof SubEntryType ? entryType.getParent().getName() + "." + entryEntity + "." + value : entryEntity + "." + value;
            }
            fieldMap.put(value, fieldCaption);
        }
        return fieldMap;
    }

    private void setGPTTips(AIAttachmentConfig aiAttachmentConfig, boolean scoreMode) {
        CreateOrgBaseDataConfig createOrgBaseDataConfig;
        IDataModel model = this.getModel();
        if (CollectionUtils.isNotEmpty((Collection)aiAttachmentConfig.getGptRiskTipList())) {
            model.deleteEntryData(KEY_GPTRISKTIPENTRY);
            List gptRiskTipList = aiAttachmentConfig.getGptRiskTipList();
            for (GptRiskTip gptRiskTip : gptRiskTipList) {
                int rowIndex = model.createNewEntryRow(KEY_GPTRISKTIPENTRY);
                model.setValue(KEY_GPTTIP, (Object)gptRiskTip.getGptTip(), rowIndex);
                model.setValue(KEY_BILLPOSITIONGING, gptRiskTip.getBillPositionings() == null ? null : String.join((CharSequence)",", gptRiskTip.getBillPositionings()), rowIndex);
                model.setValue(KEY_CHECKATTACHEMNTFIELD, gptRiskTip.getCheckAttachmentField() == null ? null : String.join((CharSequence)",", gptRiskTip.getCheckAttachmentField()), rowIndex);
                String rule = gptRiskTip.getGptRule();
                model.setValue(KEY_GPTRULE, (Object)(StringUtils.isNotEmpty((String)rule) && rule.length() > 255 ? rule.substring(0, 255) : rule), rowIndex);
                model.setValue(KEY_GPTRULEEND, (Object)rule, rowIndex);
                model.setValue(KEY_GPTID, (Object)gptRiskTip.getId());
                if (!scoreMode) continue;
                model.setValue(KEY_GPTPERCENT, (Object)gptRiskTip.getPercent(), rowIndex);
            }
        }
        if ((createOrgBaseDataConfig = aiAttachmentConfig.getGptRiskTip()) != null) {
            Object[] pks = CreateOrgBaseDataConfig.loadBaseData((String)"gai_prompt", (CreateOrgBaseDataConfig[])new CreateOrgBaseDataConfig[]{createOrgBaseDataConfig});
            model.setValue(KEY_GPTRISKTIP, pks[0]);
        }
    }

    private void setErrorTipsPanel(CheckAttachmentTypeEnum checkAttachmentTypeEnum, List<ExceptionTip> tipList, boolean scoreMode) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.deleteEntryData(Key_SETENTRY);
        AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(Key_DEDUCTITEM, new Object[0]);
        tvs.addField(Key_MULERRORTIPS, new Object[0]);
        tvs.addField(KEY_ISSHOWERRORTIPS, new Object[0]);
        tvs.addField(Key_DEDUCTPERCENT, new Object[0]);
        if (tipList != null && !tipList.isEmpty()) {
            for (ExceptionTip tip : tipList) {
                LocaleString mulTipWords = tip.getMulTipWords();
                if (mulTipWords == null) {
                    mulTipWords = new LocaleString(Lang.zh_CN.toString(), tip.getTipWords());
                }
                tvs.addRow(new Object[]{tip.getExceptionTipItem().getType(), mulTipWords, tip.getShowErrorTips(), scoreMode ? tip.getPercent() : 0});
            }
        } else {
            if (CheckAttachmentTypeEnum.CHECKEXISTS != checkAttachmentTypeEnum) {
                tvs.addRow(new Object[]{ExceptionTipEnum.NOEXISTS.getType(), new LocaleString(Lang.zh_CN.toString(), ExceptionTipEnum.NOEXISTS.convertDescription()), false, 0});
            }
            tvs.addRow(new Object[]{ExceptionTipEnum.NO_MATCH_START.getType(), new LocaleString(Lang.zh_CN.toString(), ExceptionTipEnum.NO_MATCH_START.convertDescription()), true, 0});
            if (CheckAttachmentTypeEnum.CHECKEXISTS != checkAttachmentTypeEnum) {
                tvs.addRow(new Object[]{ExceptionTipEnum.NO_MATCH_RULE.getType(), new LocaleString(Lang.zh_CN.toString(), ExceptionTipEnum.NO_MATCH_RULE.convertDescription()), true, 0});
            }
        }
        abstractModel.beginInit();
        abstractModel.batchCreateNewEntryRow(Key_SETENTRY, tvs);
        abstractModel.endInit();
        view.updateView(Key_SETENTRY);
    }

    private void setRuleRepo(AIAttachmentConfig aiAttachmentConfig, boolean scoreMode) {
        if (aiAttachmentConfig.isEnableRuleBase() && CollectionUtils.isNotEmpty((Collection)aiAttachmentConfig.getRuleRepoList())) {
            List ruleRepoList = aiAttachmentConfig.getRuleRepoList();
            IDataModel model = this.getModel();
            model.deleteEntryData(Key_RULEREPOENTRY);
            for (RuleRepo ruleRepo : ruleRepoList) {
                int rowIndex = model.createNewEntryRow(Key_RULEREPOENTRY);
                model.setValue(Key_RULEREPOTIP, (Object)ruleRepo.getRuleRepoTip(), rowIndex);
                StandardBaseDataConfig standardBaseDataConfig = ruleRepo.getRuleRepo();
                Object[] pks = StandardBaseDataConfig.loadBaseData((String)"fgptas_rule_repo", (StandardBaseDataConfig[])new StandardBaseDataConfig[]{standardBaseDataConfig});
                model.setValue(Key_RULEREPO, pks[0], rowIndex);
                model.setValue(Key_RULEREPOTIP, (Object)ruleRepo.getRuleRepoTip(), rowIndex);
                if (!scoreMode) continue;
                model.setValue(Key_RULEREPOPERCENT, (Object)ruleRepo.getPercent(), rowIndex);
            }
        }
    }

    private void setBase(AIAttachmentConfig aiAttachmentConfig) {
        IDataModel model = this.getModel();
        model.setValue(Key_CHECKTYPE, (Object)aiAttachmentConfig.getCheckType().getType());
        if (CheckAttachmentTypeEnum.CHECKFILENAME != aiAttachmentConfig.getCheckType()) {
            model.setValue(Key_CHECKMETHOD, (Object)aiAttachmentConfig.getCheckMethod().getType());
            StandardBaseDataConfig[] fgptasTemplates = aiAttachmentConfig.getFgptasTemplate();
            Object[] templatePks = StandardBaseDataConfig.loadBaseData((String)"fgptas_attachtemplate", (StandardBaseDataConfig[])fgptasTemplates);
            if (templatePks != null && templatePks.length > 0) {
                model.setValue(Key_FGPTASTEMPLATE, (Object)templatePks);
            }
        } else {
            model.setValue(Key_CHECKMETHOD, null);
        }
        model.setValue(Key_ENABLERULEBASE, (Object)(CheckAttachmentTypeEnum.CHECKBILLCONTENT == aiAttachmentConfig.getCheckType() ? aiAttachmentConfig.isEnableRuleBase() : false));
    }

    private void setWords(AIAttachmentConfig aiAttachmentConfig) {
        IDataModel model = this.getModel();
        if (CheckAttachmentTypeEnum.CHECKEXISTS == aiAttachmentConfig.getCheckType()) {
            model.setValue(Key_MULEXISTWORDS, (Object)aiAttachmentConfig.getMulExistWords());
            model.setValue(Key_MULNOTEXISTWORDS, (Object)aiAttachmentConfig.getMulNotExistWords());
        }
    }

    private void setRule(AIAttachmentConfig aiAttachmentConfig, boolean scoreMode) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        List ruleList = aiAttachmentConfig.getRuleList();
        if (ruleList != null && !ruleList.isEmpty()) {
            String sourceBill = (String)view.getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
            TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61", (String)"IDIDecisionFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), true);
            root.setIsOpened(true);
            Pair<Map<AITemplate, List<AttachmentField>>, Boolean> pair = this.createFieldTree(sourceBill, root);
            model.beginInit();
            model.deleteEntryData(Key_RULE_LIST);
            model.batchCreateNewEntryRow(Key_RULE_LIST, ruleList.size());
            for (int row = 0; row < ruleList.size(); ++row) {
                DecisionRule rule = (DecisionRule)ruleList.get(row);
                model.setValue(Key_MULTITLE, (Object)rule.getMulName(), row);
                model.setValue(Key_ISPASS, (Object)rule.isPass(), row);
                if (scoreMode) {
                    model.setValue(Key_PERCENT, (Object)rule.getDeductionGradePercent(), row);
                }
                model.setValue(Key_STATUS, (Object)rule.getDecisionStatus(), row);
                IDICondition realRule = rule.getRule();
                ExpressionTranslator.tranFilterCondition((IDICondition)realRule, (String)sourceBill, (String)sourceBill, (Map)(pair == null ? null : (Map)pair.getKey()), (Object)(pair == null ? null : pair.getValue()), (boolean)false, (TreeNode)root, (boolean)true, (aiAttachmentConfig.getCheckType() == CheckAttachmentTypeEnum.CHECKBILLCONTENT ? 1 : 0) != 0);
                model.setValue(Key_RULE, (Object)this.getExprDesc(realRule), row);
                model.setValue(Key_RULE_JSON, (Object)(rule.getRule() == null ? "" : IDIJSONUtils.toJsonString((Object)rule.getRule())), row);
                model.setValue(Key_SHOWALLCHECKTRUE, (Object)rule.isShowAllCheckTrue(), row);
            }
            model.endInit();
            view.updateView(Key_RULE_LIST);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pair<Map<AITemplate, List<AttachmentField>>, Boolean> createFieldTree(String sourceBill, TreeNode root) {
        CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)this.getModel().getValue(Key_CHECKMETHOD)));
        boolean onlyAttachmentFileName = false;
        Map<AITemplate, List<AttachmentField>> fieldClassifyMap = null;
        if (checkMethodEnum != null) {
            IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance((CheckMethodEnum)checkMethodEnum);
            AIParam fieldQueryParam = this.buildParam();
            if (fieldQueryParam == null) return null;
            fieldQueryParam.setEntityNumber(sourceBill);
            List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
            if (fieldList != null) {
                fieldClassifyMap = fieldList.stream().collect(Collectors.groupingBy(AttachmentField::getTemplate));
                FieldTreeBuilder.buildAttachFieldNode(fieldClassifyMap, (TreeNode)root, (boolean)true);
            }
        } else {
            onlyAttachmentFileName = Boolean.TRUE;
        }
        if (!StringUtils.isNotEmpty((String)sourceBill)) return new Pair(fieldClassifyMap, (Object)onlyAttachmentFileName);
        MainEntityType sourceBillEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        TreeNode sourceBillTreeNode = FieldTreeBuilder.buildBillFieldNode((MainEntityType)sourceBillEntityType, (TreeNode)root);
        sourceBillTreeNode.setIsOpened(false);
        return new Pair(fieldClassifyMap, (Object)onlyAttachmentFileName);
    }

    private AIParam buildParam() {
        AIParam fieldQueryParam = new AIParam();
        IDataModel model = this.getModel();
        CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD)));
        if (checkMethodEnum == null) {
            return fieldQueryParam;
        }
        IFormView view = this.getView();
        switch (checkMethodEnum) {
            case FGPTAS: {
                DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)model.getValue(Key_FGPTASTEMPLATE);
                if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9644\u4ef6\u6a21\u677f\u201d\u3002", (String)"IDIAIAttachmentFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return null;
                }
                StandardBaseDataConfig[] dataConfigs = new StandardBaseDataConfig[dynamicObjectCollection.size()];
                int index = 0;
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    DynamicObject templateObj = dynamicObject.getDynamicObject("fbasedataid");
                    dataConfigs[index++] = new StandardBaseDataConfig(dynamicObject.get("fbasedataid_id"), templateObj.getString("number"));
                }
                fieldQueryParam.setFgptasTemplates(dataConfigs);
            }
        }
        fieldQueryParam.setCheckMethod(checkMethodEnum);
        return fieldQueryParam;
    }

    private String getExprDesc(IDICondition condition) {
        if (condition == null) {
            return "";
        }
        String handDesc = condition.getDescription().toString();
        if (StringUtils.isNotEmpty((String)handDesc)) {
            return handDesc;
        }
        return StringUtils.isNotEmpty((String)condition.getExprTran()) ? condition.getExprTran() : condition.getExpression();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isInterruptPropertyChange()) {
            this.clearInterruptPropertyChange();
            return;
        }
        String property = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        IDataModel model = this.getModel();
        switch (property) {
            case "checktype": {
                CheckAttachmentTypeEnum checkAttachmentTypeEnum = CheckAttachmentTypeEnum.convertFromMatchType((String)String.valueOf(newValue));
                this.changeCheckType(checkAttachmentTypeEnum);
                break;
            }
            case "fgptastemplate": {
                this.changeFgptTemplate((DynamicObjectCollection)newValue);
                break;
            }
            case "rule": {
                if (StringUtils.isEmpty((String)String.valueOf(newValue))) {
                    int currentIndex = model.getEntryCurrentRowIndex(Key_RULE_LIST);
                    model.setValue(Key_RULE_JSON, (Object)"", currentIndex);
                }
                this.deleteEntryAndTableField();
                break;
            }
            case "propdisplayname": {
                if (!StringUtils.isEmpty((String)String.valueOf(newValue))) break;
                int currentIndex = model.getEntryCurrentRowIndex(Key_SHOW_LIST);
                model.setValue(Key_PROPNAME, null, currentIndex);
                model.setValue(Key_MULDISPLAYNAME, null, currentIndex);
                model.setValue(Key_PROPDISPLAYNAME, null, currentIndex);
                break;
            }
            case "billtype": {
                int currentIndex = model.getEntryCurrentRowIndex(Key_SHOW_LIST);
                CheckAttachmentTypeEnum checkAttachmentTypeEnum = CheckAttachmentTypeEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKTYPE)));
                if (CheckAttachmentTypeEnum.CHECKFILENAME == checkAttachmentTypeEnum && CustomParam_ATTACHMENTFIELD.equals(String.valueOf(newValue))) {
                    model.setValue(Key_PROPNAME, (Object)"filename", currentIndex);
                    model.setValue(Key_PROPDISPLAYNAME, (Object)ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0", (String)"IDIFieldListFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), currentIndex);
                    break;
                }
                model.setValue(Key_PROPNAME, null, currentIndex);
                model.setValue(Key_MULDISPLAYNAME, null, currentIndex);
                model.setValue(Key_PROPDISPLAYNAME, null, currentIndex);
                break;
            }
            case "gptrule": {
                int currentGptIndex = model.getEntryCurrentRowIndex(KEY_GPTRISKTIPENTRY);
                String gptRule = (String)newValue;
                if (!StringUtils.isEmpty((String)gptRule)) break;
                model.setValue(KEY_GPTRULEEND, null, currentGptIndex);
            }
        }
    }

    private void clearInterruptPropertyChange() {
        this.getPageCache().remove(PAGECACHE_INTERRUPT);
    }

    private boolean isInterruptPropertyChange() {
        return Boolean.parseBoolean(this.getPageCache().get(PAGECACHE_INTERRUPT));
    }

    private void interruptPropertyChange() {
        this.getPageCache().put(PAGECACHE_INTERRUPT, "true");
    }

    private void changeCheckType(CheckAttachmentTypeEnum checkAttachmentTypeEnum) {
        if (checkAttachmentTypeEnum == null) {
            return;
        }
        String analysisMode = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ANALYSIS_MODE);
        boolean scoreMode = AnalysisMode.SCORE.getType().equals(analysisMode);
        this.setErrorTipsPanel(checkAttachmentTypeEnum, null, scoreMode);
        ArrayList<String> visableList = new ArrayList<String>(10);
        IDataModel dataModel = this.getModel();
        switch (checkAttachmentTypeEnum) {
            case CHECKBILLCONTENT: {
                dataModel.setValue(Key_CHECKMETHOD, (Object)CheckMethodEnum.FGPTAS.getType());
                dataModel.setValue(Key_MULEXISTWORDS, null);
                dataModel.setValue(Key_MULNOTEXISTWORDS, null);
                dataModel.deleteEntryData(KEY_GPTRISKTIPENTRY);
                dataModel.createNewEntryRow(KEY_GPTRISKTIPENTRY);
                dataModel.setValue(KEY_GPTRISKTIP, this.getDefaultPrompt());
                visableList.add(Key_CHECKMETHOD);
                visableList.add(Key_FGPTASTEMPLATE);
                visableList.add(Key_ENABLERULEBASE);
                visableList.add(Key_RULEPANEL);
                visableList.add(KEY_GPTPANEL);
                break;
            }
            case CHECKFILENAME: {
                dataModel.setValue(Key_CHECKMETHOD, null);
                dataModel.setValue(Key_FGPTASTEMPLATE, null);
                dataModel.setValue(Key_MULEXISTWORDS, null);
                dataModel.setValue(Key_MULNOTEXISTWORDS, null);
                dataModel.deleteEntryData(KEY_GPTRISKTIPENTRY);
                dataModel.setValue(KEY_GPTRISKTIP, null);
                dataModel.deleteEntryData(Key_SHOW_LIST);
                visableList.add(Key_RULEPANEL);
                break;
            }
            case CHECKEXISTS: {
                dataModel.setValue(Key_FGPTASTEMPLATE, null);
                dataModel.setValue(Key_CHECKMETHOD, (Object)CheckMethodEnum.FGPTAS.getType());
                dataModel.deleteEntryData(KEY_GPTRISKTIPENTRY);
                dataModel.setValue(KEY_GPTRISKTIP, null);
                visableList.add(Key_CHECKMETHOD);
                visableList.add(Key_WORDSCONFIG);
            }
        }
        ArrayList<String> hiddenList = new ArrayList<String>(10);
        this.setHiddenField(checkAttachmentTypeEnum, hiddenList, false);
        this.getView().setVisible(Boolean.valueOf(true), visableList.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), hiddenList.toArray(new String[0]));
        DynamicObjectCollection newTemplateCols = (DynamicObjectCollection)dataModel.getValue(Key_FGPTASTEMPLATE);
        this.changeFgptTemplate(newTemplateCols);
    }

    private void changeFgptTemplate(DynamicObjectCollection newTemplateCols) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(Key_RULE_LIST);
        int rowCount = dataModel.getEntryRowCount(Key_SHOW_LIST);
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            String billType = (String)dataModel.getValue(Key_BILLTYPE, i);
            if (KEY_SOURCEBILL.equals(billType)) continue;
            rowIndexList.add(i);
        }
        int[] deleteIndexs = new int[rowIndexList.size()];
        for (int i = 0; i < deleteIndexs.length; ++i) {
            deleteIndexs[i] = (Integer)rowIndexList.get(i);
        }
        dataModel.deleteEntryRows(Key_SHOW_LIST, deleteIndexs);
        Object[] templateIds = null;
        StandardBaseDataConfig[] templateDatas = null;
        HashSet<String> templatePrefixed = new HashSet<String>(3);
        if (CollectionUtils.isNotEmpty((Collection)newTemplateCols)) {
            templateDatas = new StandardBaseDataConfig[newTemplateCols.size()];
            templateIds = new Object[newTemplateCols.size()];
            int index = 0;
            for (DynamicObject newTemplateCol : newTemplateCols) {
                templateIds[index] = newTemplateCol.get("fbasedataid_id");
                templateDatas[index] = new StandardBaseDataConfig(templateIds[index], newTemplateCol.getString("fbasedataid.number"));
                templatePrefixed.add(templateDatas[index].getNumber());
                ++index;
            }
        }
        CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)dataModel.getValue(Key_CHECKMETHOD)));
        this.updateBillTypeCombo(templateIds, checkMethodEnum);
        this.updateCheckAttachmentField(templateDatas, checkMethodEnum);
        int count = dataModel.getEntryRowCount(KEY_GPTRISKTIPENTRY);
        for (int i = 0; i < count; ++i) {
            String[] checkAttachmentFields;
            String checkAttachmentFieldStr = (String)dataModel.getValue(KEY_CHECKATTACHEMNTFIELD, i);
            if (!StringUtils.isNotEmpty((String)checkAttachmentFieldStr) || (checkAttachmentFields = checkAttachmentFieldStr.split(",")).length <= 0) continue;
            ArrayList<String> newcheckAttachmentFieldList = new ArrayList<String>(checkAttachmentFields.length);
            for (String checkAttachmentField : checkAttachmentFields) {
                String prefix;
                if (StringUtils.isEmpty((String)checkAttachmentField) || !templatePrefixed.contains(prefix = checkAttachmentField.substring(0, checkAttachmentField.indexOf(".")))) continue;
                newcheckAttachmentFieldList.add(checkAttachmentField);
            }
            if (newcheckAttachmentFieldList.isEmpty()) {
                dataModel.setValue(KEY_CHECKATTACHEMNTFIELD, null, i);
                continue;
            }
            dataModel.setValue(KEY_CHECKATTACHEMNTFIELD, (Object)String.join((CharSequence)",", newcheckAttachmentFieldList.toArray(new String[0])), i);
        }
    }

    private void deleteEntryAndTableField() {
        AIParam fieldQueryParam = this.buildParam();
        if (fieldQueryParam == null) {
            return;
        }
        CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)this.getModel().getValue(Key_CHECKMETHOD)));
        if (checkMethodEnum == null) {
            return;
        }
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        fieldQueryParam.setEntityNumber(sourceBill);
        IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance((CheckMethodEnum)checkMethodEnum);
        List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
        Map<Long, List<AttachmentField>> fieldClassifyMap = this.attachmentFieldFilter(fieldList, sourceBill);
        Set<String> entrySet = this.billFieldFilter(sourceBill);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        Map entityMap = mainType.getAllEntities();
        int rowCount = this.getModel().getEntryRowCount(Key_SHOW_LIST);
        ArrayList<String> deleteRowIndexList = new ArrayList<String>(5);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                String propName = (String)this.getModel().getValue(Key_PROPNAME, i);
                if (propName == null || propName.isEmpty()) continue;
                int splitIndex = propName.indexOf(",");
                String templateIdStr = "";
                String fullPropName = "";
                String entryKey = "";
                if (splitIndex > -1) {
                    templateIdStr = propName.substring(0, splitIndex);
                    fullPropName = propName.substring(splitIndex + 1);
                } else {
                    int index = propName.indexOf(".");
                    if (index > -1) {
                        entryKey = propName.substring(0, index);
                    }
                }
                if (StringUtils.isNotEmpty((String)templateIdStr) && !CustomParam_ATTACHMENTFIELD.equals(templateIdStr) && StringUtils.isNotEmpty((String)fullPropName)) {
                    List<AttachmentField> templateFieldList = fieldClassifyMap.get(Long.valueOf(templateIdStr));
                    String finalFullPropName = fullPropName;
                    Optional<AttachmentField> field = templateFieldList.stream().filter(fieldObj -> fieldObj.getFullName().equals(finalFullPropName)).findFirst();
                    if (!field.isPresent()) {
                        deleteRowIndexList.add(String.valueOf(i));
                    }
                }
                if (!StringUtils.isNotEmpty((String)entryKey) || !entityMap.containsKey(entryKey) || entrySet.contains(entryKey)) continue;
                deleteRowIndexList.add(String.valueOf(i));
            }
        }
        if (!deleteRowIndexList.isEmpty()) {
            int[] deleteIndexs = new int[deleteRowIndexList.size()];
            for (int i = 0; i < deleteIndexs.length; ++i) {
                deleteIndexs[i] = Integer.parseInt((String)deleteRowIndexList.get(i));
            }
            this.getModel().deleteEntryRows(Key_SHOW_LIST, deleteIndexs);
        }
    }

    private Map<Long, List<AttachmentField>> attachmentFieldFilter(List<AttachmentField> fieldList, String sourceBill) {
        Long templateId;
        HashMap<Long, List<AttachmentField>> fieldClassifyMap = new HashMap<Long, List<AttachmentField>>(1);
        HashMap<Long, String> idToNumberMap = new HashMap<Long, String>(10);
        for (AttachmentField attachmentField : fieldList) {
            AITemplate template = attachmentField.getTemplate();
            if (template == null) continue;
            templateId = template.getId();
            idToNumberMap.put(templateId, template.getNumber());
            List attachmentFields = fieldClassifyMap.computeIfAbsent(templateId, k -> new ArrayList(1));
            attachmentFields.add(attachmentField);
        }
        Map<String, String> templateTableMap = this.getTemplateTable(idToNumberMap.values(), sourceBill);
        for (Map.Entry entry : fieldClassifyMap.entrySet()) {
            templateId = (Long)entry.getKey();
            List attachmentFieldList = (List)entry.getValue();
            ListIterator attachmentFieldListIterator = attachmentFieldList.listIterator();
            while (attachmentFieldListIterator.hasNext()) {
                AttachmentField attachmentField = (AttachmentField)attachmentFieldListIterator.next();
                if (attachmentField == null) {
                    attachmentFieldListIterator.remove();
                    continue;
                }
                boolean reserve = false;
                String tableKey = templateTableMap.get(idToNumberMap.get(templateId));
                if (StringUtils.isNotEmpty((String)tableKey)) {
                    reserve = attachmentField.getParent() == null && !attachmentField.isTable() ? true : attachmentField.getParent() != null && tableKey.equals(attachmentField.getParent().getName());
                } else if (attachmentField.getParent() == null && !attachmentField.isTable()) {
                    reserve = true;
                }
                if (reserve) continue;
                attachmentFieldListIterator.remove();
            }
        }
        return fieldClassifyMap;
    }

    private Set<String> billFieldFilter(String sourceBill) {
        int ruleCount = this.getModel().getEntryRowCount(Key_RULE_LIST);
        String mainVarName = sourceBill + "_billObj.";
        HashSet<String> fieldLimitSet = new HashSet<String>();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        Map entityMap = mainType.getAllEntities();
        for (int i = 0; i < ruleCount; ++i) {
            String ruleJson = (String)this.getModel().getValue(Key_RULE_JSON, i);
            if (!StringUtils.isNotEmpty((String)ruleJson)) continue;
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
            String script = condition.getScript();
            Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{sourceBill});
            for (String field : vars) {
                if (!field.startsWith(mainVarName)) continue;
                String fullField = field.substring(mainVarName.length());
                for (String entryKey : entityMap.keySet()) {
                    if (entryKey.equals(sourceBill) || !fullField.contains(entryKey)) continue;
                    fieldLimitSet.add(entryKey);
                }
            }
        }
        return fieldLimitSet;
    }

    private Map<String, String> getTemplateTable(Collection<String> templateNumberList, String sourceBill) {
        IDataModel model = this.getModel();
        int ruleCount = model.getEntryRowCount(Key_RULE_LIST);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < ruleCount; ++i) {
            String ruleJson = (String)model.getValue(Key_RULE_JSON, i);
            if (!StringUtils.isNotEmpty((String)ruleJson)) continue;
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
            String script = condition.getScript();
            Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{sourceBill});
            for (String number : templateNumberList) {
                String prefix = IDIStringUtils.templatePrefix((String)number);
                for (String var : vars) {
                    String previousTable;
                    String[] properties = var.split("\\.");
                    if (properties.length <= 2 || !var.startsWith(prefix) || (previousTable = (String)map.get(number)) != null && !previousTable.equals(properties[1])) continue;
                    map.put(number, properties[1]);
                }
            }
        }
        return map;
    }

    public void click(EventObject evt) {
        String btnKey;
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnok": {
                if (!this.preVerity()) break;
                IFormView view = this.getView();
                view.returnDataToParent((Object)IDIJSONUtils.toJsonString((Object)this.buildAIAttachmentConfig()));
                view.close();
                break;
            }
            case "rule": {
                this.showRuleForm();
                break;
            }
            case "propdisplayname": {
                this.showBillFieldForm();
                break;
            }
            case "gptrule": {
                this.showGPTrule();
                break;
            }
        }
    }

    private void showGPTrule() {
        String checkAttachmentFieldCaption;
        String billFieldStr;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex(KEY_GPTRISKTIPENTRY);
        String riule = (String)model.getValue(KEY_GPTRULEEND, row);
        String billTypeStr = (String)model.getValue(KEY_BILLPOSITIONGING, row);
        if (StringUtils.isEmpty((String)billTypeStr)) {
            billFieldStr = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u3010\u53c2\u4e0e\u68c0\u67e5\u5355\u636e\u5b57\u6bb5\u3011", (String)"IDIAIAttachmentFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]);
        } else {
            String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
            MainEntityType sourceBillEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
            Map<String, String> propToCaptionMap = this.achieveFieldCaption(sourceBillEntityType);
            String[] billTypes = billTypeStr.split(",");
            StringBuilder sb = new StringBuilder();
            for (String billType : billTypes) {
                if (StringUtils.isEmpty((String)billType)) continue;
                sb.append(propToCaptionMap.get(billType)).append(",");
            }
            billFieldStr = sb.substring(0, sb.length() - 1);
        }
        String checkAttachmentFieldStr = (String)model.getValue(KEY_CHECKATTACHEMNTFIELD, row);
        if (StringUtils.isEmpty((String)checkAttachmentFieldStr)) {
            checkAttachmentFieldCaption = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u3010\u53c2\u4e0e\u68c0\u67e5\u9644\u4ef6\u5b57\u6bb5\u3011", (String)"IDIAIAttachmentFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]);
        } else {
            DynamicObjectCollection newTemplateCols = (DynamicObjectCollection)model.getValue(Key_FGPTASTEMPLATE);
            StandardBaseDataConfig[] templateDatas = null;
            if (CollectionUtils.isNotEmpty((Collection)newTemplateCols)) {
                templateDatas = new StandardBaseDataConfig[newTemplateCols.size()];
                int index = 0;
                for (DynamicObject newTemplateCol : newTemplateCols) {
                    templateDatas[index] = new StandardBaseDataConfig(newTemplateCol.get("fbasedataid_id"), newTemplateCol.getString("fbasedataid.number"));
                    ++index;
                }
            }
            AIParam fieldQueryParam = new AIParam();
            fieldQueryParam.setFgptasTemplates(templateDatas);
            CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD)));
            IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance((CheckMethodEnum)checkMethodEnum);
            List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
            HashMap<String, String> propToCaptionMap = new HashMap<String, String>(10);
            if (fieldList != null) {
                Map<AITemplate, List<AttachmentField>> fieldClassifyMap = fieldList.stream().collect(Collectors.groupingBy(AttachmentField::getTemplate));
                for (List<AttachmentField> value : fieldClassifyMap.values()) {
                    if (!CollectionUtils.isNotEmpty(value)) continue;
                    for (AttachmentField attachmentField : value) {
                        if (attachmentField.isTable()) continue;
                        propToCaptionMap.put(attachmentField.getFullNameAndTemplate(), attachmentField.getFullDisplayNameAndTemplate());
                    }
                }
            }
            String[] checkAttachmentFields = checkAttachmentFieldStr.split(",");
            StringBuilder sb = new StringBuilder();
            for (String checkAttachmentField : checkAttachmentFields) {
                if (StringUtils.isEmpty((String)checkAttachmentField)) continue;
                sb.append((String)propToCaptionMap.get(checkAttachmentField)).append(",");
            }
            checkAttachmentFieldCaption = sb.substring(0, sb.length() - 1);
        }
        IDIAIAttachmentRuleSetFormPlugin.openSetting(view, this, riule, billFieldStr, checkAttachmentFieldCaption, ActionId_SET_GPPTRULE);
    }

    private AIAttachmentConfig buildAIAttachmentConfig() {
        DynamicObjectCollection templateCols;
        AIAttachmentConfig config = new AIAttachmentConfig();
        IDataModel model = this.getModel();
        CheckAttachmentTypeEnum checkAttachmentTypeEnum = CheckAttachmentTypeEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKTYPE)));
        config.setCheckType(checkAttachmentTypeEnum);
        config.setCheckMethod(CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD))));
        if (CheckAttachmentTypeEnum.CHECKFILENAME != checkAttachmentTypeEnum && CollectionUtils.isNotEmpty((Collection)(templateCols = (DynamicObjectCollection)model.getValue(Key_FGPTASTEMPLATE)))) {
            StandardBaseDataConfig[] templates = new StandardBaseDataConfig[templateCols.size()];
            int index = 0;
            for (DynamicObject rowObj : templateCols) {
                DynamicObject templateObj = rowObj.getDynamicObject("fbasedataid");
                templates[index++] = new StandardBaseDataConfig(templateObj.getPkValue(), templateObj.getString("number"));
            }
            config.setFgptasTemplate(templates);
        }
        config.setEnableRuleBase(((Boolean)model.getValue(Key_ENABLERULEBASE)).booleanValue());
        if (CheckAttachmentTypeEnum.CHECKEXISTS == checkAttachmentTypeEnum) {
            LocaleString mulExistWord = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)model.getValue(Key_MULEXISTWORDS)));
            LocaleString mulNotExistWord = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)model.getValue(Key_MULNOTEXISTWORDS)));
            if (IDIStringUtils.localeIsEmpty((LocaleString)mulNotExistWord)) {
                if (mulNotExistWord == null) {
                    mulNotExistWord = new LocaleString();
                }
                mulNotExistWord.put(Lang.get().toString(), (Object)ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728", (String)"IDIAttachmentFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
            config.setMulNotExistWords(mulNotExistWord);
            if (IDIStringUtils.localeIsEmpty((LocaleString)mulExistWord)) {
                if (mulExistWord == null) {
                    mulExistWord = new LocaleString();
                }
                mulExistWord.put(Lang.get().toString(), (Object)ResManager.loadKDString((String)"\u9644\u4ef6\u5b58\u5728", (String)"IDIAttachmentFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
            config.setMulExistWords(mulExistWord);
        }
        config.setRuleList(this.getFormulaData());
        config.setRuleRepoList(this.getRuleRepo());
        config.setGptRiskTipList(this.getGptTip());
        DynamicObject gptRiskTipObj = (DynamicObject)model.getValue(KEY_GPTRISKTIP);
        if (gptRiskTipObj != null) {
            DynamicObject createOrgObj = gptRiskTipObj.getDynamicObject("createorg");
            CreateOrgBaseDataConfig createOrgBaseDataConfig = new CreateOrgBaseDataConfig(gptRiskTipObj.getPkValue(), gptRiskTipObj.getString("number"), (Object)createOrgObj.getLong("id"), createOrgObj.getString("number"));
            config.setGptRiskTip(createOrgBaseDataConfig);
        }
        config.setExceptionTipList(this.getExceptionTips());
        config.setFrontEndConfig(this.getFrontEndConfig());
        return config;
    }

    private List<GptRiskTip> getGptTip() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(KEY_GPTRISKTIPENTRY);
        ArrayList<GptRiskTip> gprRiskTipList = null;
        if (rowCount > 0) {
            gprRiskTipList = new ArrayList<GptRiskTip>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                String checkAttachmentFieldStr;
                GptRiskTip gptRiskTip = new GptRiskTip();
                LocaleString mulTips = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)model.getValue(KEY_GPTTIP, i)));
                gptRiskTip.setGptTip(mulTips);
                String billPositionging = (String)model.getValue(KEY_BILLPOSITIONGING, i);
                if (StringUtils.isNotEmpty((String)billPositionging)) {
                    String[] positiongings = billPositionging.split(",");
                    ArrayList<String> positiongingsList = new ArrayList<String>(positiongings.length);
                    for (String positionging : positiongings) {
                        if (StringUtils.isEmpty((String)positionging)) continue;
                        positiongingsList.add(positionging);
                    }
                    gptRiskTip.setBillPositionings(positiongingsList.toArray(new String[0]));
                }
                if (StringUtils.isNotEmpty((String)(checkAttachmentFieldStr = (String)model.getValue(KEY_CHECKATTACHEMNTFIELD, i)))) {
                    String[] checkAttachmentFields = checkAttachmentFieldStr.split(",");
                    ArrayList<String> checkAttachmentFieldList = new ArrayList<String>(checkAttachmentFields.length);
                    for (String checkAttachmentField : checkAttachmentFields) {
                        if (StringUtils.isEmpty((String)checkAttachmentField)) continue;
                        checkAttachmentFieldList.add(checkAttachmentField);
                    }
                    gptRiskTip.setCheckAttachmentField(checkAttachmentFieldList.toArray(new String[0]));
                }
                gptRiskTip.setGptRule((String)model.getValue(KEY_GPTRULEEND, i));
                gptRiskTip.setPercent(((Integer)model.getValue(KEY_GPTPERCENT, i)).intValue());
                gptRiskTip.setId((String)model.getValue(KEY_GPTID, i));
                if (StringUtils.isEmpty((String)gptRiskTip.getId())) {
                    gptRiskTip.setId(Uuid16.create().toString());
                }
                if (IDIStringUtils.localeIsEmpty((LocaleString)mulTips) || !StringUtils.isNotEmpty((String)gptRiskTip.getGptRule())) continue;
                gprRiskTipList.add(gptRiskTip);
            }
        }
        return gprRiskTipList;
    }

    private List<RuleRepo> getRuleRepo() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(Key_RULEREPOENTRY);
        ArrayList<RuleRepo> ruleRepoList = new ArrayList<RuleRepo>(rowCount);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                RuleRepo rr = new RuleRepo();
                LocaleString mulTips = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)model.getValue(Key_RULEREPOTIP, i)));
                rr.setRuleRepoTip(mulTips);
                DynamicObject ruleRepoObj = (DynamicObject)model.getValue(Key_RULEREPO, i);
                if (ruleRepoObj == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u5e93\u5df2\u88ab\u5220\u9664\u3002", (String)"IDIAIAttachmentFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
                }
                rr.setRuleRepo(new StandardBaseDataConfig(ruleRepoObj.getPkValue(), ruleRepoObj.getString("number")));
                rr.setPercent(((Integer)model.getValue(Key_RULEREPOPERCENT, i)).intValue());
                ruleRepoList.add(rr);
            }
        }
        return ruleRepoList;
    }

    private List<DecisionRule> getFormulaData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_RULE_LIST);
        ArrayList<DecisionRule> ruleList = new ArrayList<DecisionRule>();
        for (DynamicObject obj : entryEntity) {
            LocaleString mulName = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)obj.get(Key_MULTITLE)));
            boolean isPass = obj.getBoolean(Key_ISPASS);
            String ruleJson = obj.getString(Key_RULE_JSON);
            int percent = obj.getInt(Key_PERCENT);
            String status = obj.getString(Key_STATUS);
            boolean showAllCheckTrue = obj.getBoolean(Key_SHOWALLCHECKTRUE);
            DecisionRule rule = new DecisionRule();
            rule.setMulName(mulName);
            rule.setRule((IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class));
            rule.setDeductionGradePercent(percent);
            rule.setDecisionStatus(status);
            rule.setPass(isPass);
            rule.setShowAllCheckTrue(showAllCheckTrue);
            ruleList.add(rule);
        }
        return ruleList;
    }

    private List<ExceptionTip> getExceptionTips() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(Key_SETENTRY);
        ArrayList<ExceptionTip> exceptionTipList = new ArrayList<ExceptionTip>(rowCount);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                ExceptionTip exceptionTip = new ExceptionTip();
                exceptionTip.setSeq(i);
                ExceptionTipEnum exceptionTipEnum = ExceptionTipEnum.convertFromMatchType((String)((String)model.getValue(Key_DEDUCTITEM, i)));
                exceptionTip.setExceptionTipItem(exceptionTipEnum);
                LocaleString mulTips = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)model.getValue(Key_MULERRORTIPS, i)));
                if (IDIStringUtils.localeIsEmpty((LocaleString)mulTips)) {
                    mulTips = new LocaleString(exceptionTipEnum.convertDescription());
                }
                exceptionTip.setMulTipWords(mulTips);
                exceptionTip.setShowErrorTips((Boolean)model.getValue(KEY_ISSHOWERRORTIPS, i));
                exceptionTip.setPercent(((Integer)model.getValue(Key_DEDUCTPERCENT, i)).intValue());
                exceptionTipList.add(exceptionTip);
            }
        }
        return exceptionTipList;
    }

    private DecisionFrontEndConfig getFrontEndConfig() {
        DecisionFrontEndConfig config = new DecisionFrontEndConfig();
        int rowCount = this.getModel().getEntryRowCount(Key_SHOW_LIST);
        if (rowCount > 0) {
            ArrayList<DecisionFrontEndConfigField> hoverContents = new ArrayList<DecisionFrontEndConfigField>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                int splitIndex;
                String fieldNumber = (String)this.getModel().getValue(Key_BILLTYPE, i);
                String propDisplayName = (String)this.getModel().getValue(Key_PROPDISPLAYNAME, i);
                String propName = (String)this.getModel().getValue(Key_PROPNAME, i);
                LocaleString mulDisplayName = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)this.getModel().getValue(Key_MULDISPLAYNAME, i)));
                DecisionFrontEndConfigField configField = new DecisionFrontEndConfigField();
                configField.setBillType(fieldNumber);
                configField.setPropDisplayName(propDisplayName);
                configField.setPropName(propName);
                configField.setMulDisplayName(mulDisplayName);
                if (propName != null && !propName.isEmpty() && (splitIndex = propName.indexOf(",")) > -1) {
                    configField.setBillType(propName.substring(0, splitIndex));
                    configField.setPropName(propName.substring(splitIndex + 1));
                }
                hoverContents.add(configField);
            }
            config.setHoverFieldContents(hoverContents);
        }
        return config;
    }

    private boolean preVerity() {
        DynamicObjectCollection collection;
        int size;
        int rowCount;
        DynamicObjectCollection fgptTemplate;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String checkType = (String)model.getValue(Key_CHECKTYPE);
        CheckAttachmentTypeEnum checkAttachmentTypeEnum = CheckAttachmentTypeEnum.convertFromMatchType((String)checkType);
        if (checkAttachmentTypeEnum != CheckAttachmentTypeEnum.CHECKFILENAME && CollectionUtils.isEmpty((Collection)(fgptTemplate = (DynamicObjectCollection)model.getValue(Key_FGPTASTEMPLATE)))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9644\u4ef6\u6a21\u677f\u201d\u3002", (String)"IDIAIAttachmentFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean hasRule = false;
        if ((CheckAttachmentTypeEnum.CHECKBILLCONTENT.getType().equals(checkType) || CheckAttachmentTypeEnum.CHECKFILENAME.getType().equals(checkType)) && (rowCount = model.getEntryRowCount(Key_RULE_LIST)) > 0) {
            ArrayList<Integer> removeList = new ArrayList<Integer>();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                OrmLocaleValue modelValue = (OrmLocaleValue)model.getValue(Key_MULTITLE, rowIndex);
                String rule = (String)model.getValue(Key_RULE, rowIndex);
                if (IDIStringUtils.ormLocaleIsEmpty((OrmLocaleValue)modelValue) && StringUtils.isEmpty((String)rule)) {
                    removeList.add(rowIndex);
                    continue;
                }
                if (IDIStringUtils.ormLocaleIsEmpty((OrmLocaleValue)modelValue)) {
                    String message = ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u7b2c%d\u884c\u201c\u7ed3\u679c\u63cf\u8ff0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIDecisionFormPlugin_23", (String)"data-idi-formplugin", (Object[])new Object[0]);
                    view.showTipNotification(String.format(message, rowIndex + 1));
                    return false;
                }
                if (StringUtils.isEmpty((String)rule)) {
                    String message = ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u7b2c%d\u884c\u201c\u89c4\u5219\u914d\u7f6e\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIDecisionFormPlugin_24", (String)"data-idi-formplugin", (Object[])new Object[0]);
                    view.showTipNotification(String.format(message, rowIndex + 1));
                    return false;
                }
                hasRule = true;
            }
            if (removeList.size() != rowCount) {
                model.deleteEntryRows(Key_RULE_LIST, removeList.stream().mapToInt(Integer::intValue).toArray());
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u914d\u7f6e\u5747\u4e0d\u4e3a\u7a7a\u624d\u80fd\u4fdd\u5b58\u3002", (String)"IDIDecisionFormPlugin_25", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        boolean hasGPTTip = false;
        if (CheckAttachmentTypeEnum.CHECKBILLCONTENT == checkAttachmentTypeEnum) {
            int gptRiskTipsCount;
            int errorTipsCount = model.getEntryRowCount(Key_SETENTRY);
            if (errorTipsCount > 0) {
                for (int i = 0; i < errorTipsCount; ++i) {
                    LocaleString mulErrorTips = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)model.getValue(Key_MULERRORTIPS, i)));
                    if (mulErrorTips != null && !StringUtils.isEmpty((String)mulErrorTips.getLocaleValue())) continue;
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7279\u522b\u60c5\u51b5\u63d0\u793a\u201d\u7b2c%d\u884c\u7684\u63d0\u793a\u8bed\u3002", (String)"IDIAttachmentFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1));
                    return false;
                }
            }
            if ((gptRiskTipsCount = model.getEntryRowCount(KEY_GPTRISKTIPENTRY)) > 0) {
                for (int i = 0; i < gptRiskTipsCount; ++i) {
                    OrmLocaleValue gptTip = (OrmLocaleValue)model.getValue(KEY_GPTTIP, i);
                    String gptRule = (String)model.getValue(KEY_GPTRULEEND, i);
                    if (IDIStringUtils.ormLocaleIsEmpty((OrmLocaleValue)gptTip) && StringUtils.isNotEmpty((String)gptRule)) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cAI\u5ba1\u6838\u98ce\u9669\u63d0\u793a\u201d\u7b2c%d\u884c\u7684\u7ed3\u679c\u63cf\u8ff0\u3002", (String)"IDIAIAttachmentFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1));
                        return false;
                    }
                    if (!IDIStringUtils.ormLocaleIsEmpty((OrmLocaleValue)gptTip) && StringUtils.isEmpty((String)gptRule)) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cAI\u5ba1\u6838\u98ce\u9669\u63d0\u793a\u201d\u7b2c%d\u884c\u7684\u89c4\u5219\u914d\u7f6e\u3002", (String)"IDIAIAttachmentFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1));
                        return false;
                    }
                    Object riskTip = this.getModel().getValue(KEY_GPTRISKTIP);
                    boolean bl = hasGPTTip = !IDIStringUtils.ormLocaleIsEmpty((OrmLocaleValue)gptTip) && StringUtils.isNotEmpty((String)gptRule);
                    if (IDIStringUtils.ormLocaleIsEmpty((OrmLocaleValue)gptTip) || !StringUtils.isNotEmpty((String)gptRule) || riskTip != null) continue;
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u63d0\u793a\u8bcd\u3002", (String)"IDIAIAttachmentFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]), new Object[0]));
                    return false;
                }
            }
        }
        if ((size = (collection = model.getEntryEntity(Key_SHOW_LIST)).size()) > 5) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u60ac\u505c\u4fe1\u606f\u914d\u7f6e\u201d\u5206\u5f55\u884c\u6570\u5e94\u22645\u884c\u3002", (String)"IDIDecisionFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!hasRule && hasGPTTip) {
            model.deleteEntryData(Key_SHOW_LIST);
        } else {
            ArrayList<String> hoverContents = new ArrayList<String>(1);
            ArrayList<Integer> removeList = new ArrayList<Integer>(1);
            for (int i = 0; i < size; ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                String billType = dynamicObject.getString(Key_BILLTYPE);
                String fieldNumber = dynamicObject.getString(Key_PROPNAME);
                if (StringUtils.isEmpty((String)billType) && StringUtils.isEmpty((String)fieldNumber)) {
                    removeList.add(i);
                    continue;
                }
                if (StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)fieldNumber)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u60ac\u505c\u5c55\u793a\u5b57\u6bb5\u5f55\u5165\u5b8c\u6574\u3002", (String)"IDIDecisionFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
                String key = billType + "_" + fieldNumber;
                if (hoverContents.contains(key)) continue;
                hoverContents.add(key);
            }
            int[] delArray = new int[removeList.size()];
            for (int i = 0; i < removeList.size(); ++i) {
                delArray[i] = (Integer)removeList.get(i);
            }
            model.deleteEntryRows(Key_SHOW_LIST, delArray);
            if (size - removeList.size() != hoverContents.size()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u60ac\u505c\u5c55\u793a\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\u3002", (String)"IDIDecisionFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void showRuleForm() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String sourceBill = (String)view.getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        int row = model.getEntryCurrentRowIndex(Key_RULE_LIST);
        String conditionJson = (String)model.getValue(Key_RULE_JSON, row);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("idi_condition_edit");
        showParameter.getCustomParams().put(CustomParam_FORMULA, conditionJson);
        showParameter.getCustomParams().put(CustomParam_ENTITY_NUMBER, sourceBill);
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61", (String)"IDIDecisionFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), true);
        root.setIsOpened(true);
        Pair<Map<AITemplate, List<AttachmentField>>, Boolean> pair = this.createFieldTree(sourceBill, root);
        if (pair == null) {
            return;
        }
        Map fieldClassifyMap = (Map)pair.getKey();
        boolean onlyAttachmentFileName = (Boolean)pair.getValue();
        if (fieldClassifyMap != null && !fieldClassifyMap.isEmpty()) {
            fieldClassifyMap.forEach((template, fieldList) -> {
                Iterator iterator = fieldList.iterator();
                while (iterator.hasNext()) {
                    AttachmentField field = (AttachmentField)iterator.next();
                    if (field.getParent() != null || !field.isTable()) continue;
                    iterator.remove();
                }
            });
            showParameter.getCustomParams().put(CustomParam_ATTACHMENTFIELD, JSON.toJSONString((Object)fieldClassifyMap));
            showParameter.getCustomParams().put(CustomParam_ONLY_ATTACHMENTFIELD, Boolean.TRUE);
        }
        showParameter.getCustomParams().put(CustomParam_ONLY_ATTACHMENTFILENAME, onlyAttachmentFileName);
        String nodesJson = SerializationUtils.toJsonString((Object)root);
        showParameter.getCustomParams().put(CustomParam_TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_RULE));
        showParameter.getCustomParams().put(CustomParam_SOURCEENTITYNUMBER, sourceBill);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private void showBillFieldForm() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex(Key_SHOW_LIST);
        if (currentRowIndex > -1) {
            String billType = (String)model.getValue(Key_BILLTYPE, currentRowIndex);
            if (StringUtils.isEmpty((String)billType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u5b57\u6bb5\u6765\u6e90\u201d\u3002", (String)"IDIDecisionFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("idi_fieldlist");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            String sourceBill = (String)view.getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
            if (!KEY_SOURCEBILL.equals(billType)) {
                AIParam fieldQueryParam = this.buildParam();
                if (fieldQueryParam == null) {
                    return;
                }
                fieldQueryParam.setEntityNumber(sourceBill);
                CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD)));
                if (checkMethodEnum != null) {
                    IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance((CheckMethodEnum)checkMethodEnum);
                    List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
                    if (fieldList != null && !fieldList.isEmpty()) {
                        Map<Long, List<AttachmentField>> fieldClassifyMap = this.attachmentFieldFilter(fieldList, sourceBill);
                        fsp.getCustomParams().put(CustomParam_ATTACHMENTFIELD, JSON.toJSONString(fieldClassifyMap));
                    } else {
                        fsp.getCustomParams().put(CustomParam_ATTACHMENTFIELD, "");
                    }
                } else {
                    fsp.getCustomParams().put(CustomParam_ONLY_ATTACHMENTFILENAME, Boolean.TRUE);
                }
            }
            fsp.setCustomParam(CustomParam_ENTITY_NUMBER, (Object)sourceBill);
            fsp.setCustomParam(CustomParam_CURRENTSELECTFIELDS, model.getValue(Key_PROPNAME, currentRowIndex));
            String checkType = (String)model.getValue(Key_CHECKTYPE);
            if (CheckAttachmentTypeEnum.CHECKBILLCONTENT.getType().equals(checkType)) {
                Set<String> fieldLimitSet = this.billFieldFilter(sourceBill);
                fsp.setCustomParam(CustomParam_LIMITFIELDS, fieldLimitSet);
            }
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_BILLFIELD));
            view.showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "rule": {
                this.receiveCondition((String)result);
                break;
            }
            case "setBillField": {
                this.receiveBillField(result);
                break;
            }
            case "ide_largertextedit_callBack": {
                this.receiveGPTRule((String)result);
            }
        }
    }

    private void receiveGPTRule(String ruleStr) {
        if (StringUtils.isNotEmpty((String)ruleStr)) {
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex(KEY_GPTRISKTIPENTRY);
            model.setValue(KEY_GPTRULEEND, (Object)ruleStr, row);
            model.setValue(KEY_GPTRULE, (Object)(ruleStr.length() > 255 ? ruleStr.substring(0, 255) : ruleStr), row);
        }
    }

    private void receiveCondition(String ruleJson) {
        IDICondition condition;
        if (StringUtils.isNotEmpty((String)ruleJson) && (condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class)) != null) {
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex(Key_RULE_LIST);
            model.setValue(Key_RULE_JSON, (Object)ruleJson, row);
            model.setValue(Key_RULE, (Object)this.getExprDesc(condition), row);
        }
    }

    private void receiveBillField(Object result) {
        IDataModel model = this.getModel();
        if (result != null) {
            String[][] fields = (String[][])result;
            int currentIndex = model.getEntryCurrentRowIndex(Key_SHOW_LIST);
            for (int i = 0; i < fields.length; ++i) {
                String[] field = fields[i];
                if (field == null || i != 0) continue;
                model.setValue(Key_PROPNAME, (Object)field[0], currentIndex);
                model.setValue(Key_PROPDISPLAYNAME, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDIDecisionFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]), field[1]), currentIndex);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if (Key_FGPTASTEMPLATE.equals(fieldName)) {
            String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
            DynamicObject[] templateObjs = BusinessDataServiceHelper.load((String)"fgptas_attachtemplate", (String)"id,linkbill", (QFilter[])new QFilter[]{new QFilter(Key_STATUS, "=", (Object)"C"), new QFilter("enable", "=", (Object)"1"), new QFilter("isextract", "=", (Object)true)});
            ArrayList<Object> idList = new ArrayList<Object>(10);
            if (templateObjs != null && templateObjs.length > 0) {
                block0: for (DynamicObject templateObj : templateObjs) {
                    DynamicObjectCollection linkbills = templateObj.getDynamicObjectCollection("linkbill");
                    if (CollectionUtils.isEmpty((Collection)linkbills)) {
                        idList.add(templateObj.get("id"));
                        continue;
                    }
                    for (DynamicObject linkbillRow : linkbills) {
                        if (!sourceBill.equals(linkbillRow.get("fbasedataid_id"))) continue;
                        idList.add(templateObj.get("id"));
                        continue block0;
                    }
                }
            }
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", idList));
        }
    }

    private void updateCheckAttachmentField(StandardBaseDataConfig[] templateDatas, CheckMethodEnum checkMethodEnum) {
        if (templateDatas != null && templateDatas.length > 0) {
            AIParam fieldQueryParam = new AIParam();
            fieldQueryParam.setFgptasTemplates(templateDatas);
            IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance((CheckMethodEnum)checkMethodEnum);
            List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
            if (fieldList != null) {
                Map<AITemplate, List<AttachmentField>> fieldClassifyMap = fieldList.stream().collect(Collectors.groupingBy(AttachmentField::getTemplate));
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(fieldList.size());
                for (List<AttachmentField> value : fieldClassifyMap.values()) {
                    if (!CollectionUtils.isNotEmpty(value)) continue;
                    for (AttachmentField attachmentField : value) {
                        if (attachmentField.isTable()) continue;
                        ComboItem ci = new ComboItem();
                        ci.setValue(attachmentField.getFullNameAndTemplate());
                        ci.setCaption(new LocaleString(attachmentField.getFullDisplayNameAndTemplate()));
                        comboItems.add(ci);
                    }
                }
                if (CollectionUtils.isNotEmpty(comboItems)) {
                    ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_CHECKATTACHEMNTFIELD);
                    comboEdit.setComboItems(comboItems);
                }
            }
        }
    }
}

