/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.BillControlTypeEnum;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.attachment.AIAttachmentConfig;
import kd.data.idi.data.attachment.CheckAttachmentTypeEnum;
import kd.data.idi.data.attachment.CheckMethodEnum;
import kd.data.idi.data.attachment.ExceptionTip;
import kd.data.idi.data.attachment.ExceptionTipEnum;
import kd.data.idi.data.attachment.RuleRepo;
import kd.data.idi.data.basedata.StandardBaseDataConfig;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;

public class IDIAISchemaFormPlugin
extends AbstractFormPlugin {
    private static final String ActionId_SET_RULEREPO = "setRuleRepo";
    private static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    private static final String CustomParam_ENTITY_NUMBER = "entitynumber";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"bar_d"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("rulerepo".equals(itemKey)) {
            String version = LicenseServiceHelper.getProductVersion();
            if (!"1.0".equals(version)) {
                RequestContext rc = RequestContext.get();
                LicenseCheckResult checkResult = LicenseServiceHelper.checkUserInGroup((Long)rc.getCurrUserId(), (Long)618L);
                boolean hasLicense = checkResult.getHasLicense();
                String msg = checkResult.getMsg();
                if (!hasLicense) {
                    this.getView().showMessage(msg);
                    return;
                }
            }
            this.showRuleRepo();
        }
    }

    private void showRuleRepo() {
        ListShowParameter listShowParameter = CoreShowFormHelper.createShowListForm((String)"fgptas_rule_repo", (boolean)true);
        listShowParameter.setFormId("bos_treelistf7");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_RULEREPO));
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        if (ActionId_SET_RULEREPO.equals(actionId) && result != null) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)result;
            ArrayList<Object> pkList = new ArrayList<Object>(10);
            for (ListSelectedRow row : data) {
                Object pk = row.getPrimaryKeyValue();
                if (pk == null) continue;
                pkList.add(pk);
            }
            Map ruleRepo = BusinessDataServiceHelper.loadFromCache((Object[])pkList.toArray(new Object[0]), (String)"fgptas_rule_repo");
            this.createAndUpdateConfig(ruleRepo);
        }
    }

    private void createAndUpdateConfig(Map<Object, DynamicObject> ruleRepo) {
        if (ruleRepo == null || ruleRepo.isEmpty()) {
            return;
        }
        Map<Long, StandardBaseDataConfig[]> templateMap = this.queryTemplates(ruleRepo.keySet());
        for (DynamicObject ruleRepoObj : ruleRepo.values()) {
            Object decisionName = ruleRepoObj.get("name");
            String matchType = MatchType.AIATTACHMENT.getType();
            String billControlType = BillControlTypeEnum.NOCONTROL.getType();
            AIAttachmentConfig config = this.createConfig();
            StandardBaseDataConfig[] fgptasTemplates = templateMap.get(ruleRepoObj.getLong("id"));
            config.setFgptasTemplate(fgptasTemplates);
            ArrayList<RuleRepo> ruleRepoList = new ArrayList<RuleRepo>(2);
            RuleRepo rr = new RuleRepo();
            rr.setPercent(0);
            rr.setRuleRepoTip(IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)decisionName)));
            StandardBaseDataConfig ruleRepoConfig = new StandardBaseDataConfig(ruleRepoObj.getPkValue(), ruleRepoObj.getString("number"));
            rr.setRuleRepo(ruleRepoConfig);
            ruleRepoList.add(rr);
            config.setRuleRepoList(ruleRepoList);
            ArrayList<ExceptionTip> exceptionTipList = new ArrayList<ExceptionTip>(3);
            ExceptionTip exceptionTip1 = new ExceptionTip();
            exceptionTip1.setSeq(0);
            exceptionTip1.setExceptionTipItem(ExceptionTipEnum.NOEXISTS);
            LocaleString mulTips = new LocaleString(ExceptionTipEnum.NOEXISTS.convertDescription());
            exceptionTip1.setMulTipWords(mulTips);
            exceptionTip1.setShowErrorTips(Boolean.valueOf(false));
            exceptionTip1.setPercent(0);
            exceptionTipList.add(exceptionTip1);
            ExceptionTip exceptionTip2 = new ExceptionTip();
            exceptionTip2.setSeq(1);
            exceptionTip2.setExceptionTipItem(ExceptionTipEnum.NO_MATCH_START);
            LocaleString mulTips2 = new LocaleString(ExceptionTipEnum.NO_MATCH_START.convertDescription());
            exceptionTip2.setMulTipWords(mulTips2);
            exceptionTip2.setShowErrorTips(Boolean.valueOf(true));
            exceptionTip2.setPercent(0);
            exceptionTipList.add(exceptionTip2);
            ExceptionTip exceptionTip3 = new ExceptionTip();
            exceptionTip3.setSeq(2);
            exceptionTip3.setExceptionTipItem(ExceptionTipEnum.NO_MATCH_RULE);
            LocaleString mulTips3 = new LocaleString(ExceptionTipEnum.NO_MATCH_RULE.convertDescription());
            exceptionTip3.setMulTipWords(mulTips3);
            exceptionTip3.setShowErrorTips(Boolean.valueOf(true));
            exceptionTip3.setPercent(0);
            exceptionTipList.add(exceptionTip3);
            config.setExceptionTipList(exceptionTipList);
            int rowIndex = this.getModel().createNewEntryRow("d_panel");
            this.getModel().setValue("d_multiname", decisionName, rowIndex);
            this.getModel().setValue("match_type", (Object)matchType, rowIndex);
            this.getModel().setValue("detailconfig_json", (Object)IDIJSONUtils.toJsonString((Object)config), rowIndex);
            this.getModel().setValue("controltype", (Object)billControlType, rowIndex);
            this.getModel().setValue("d_id", (Object)Uuid16.create().toString(), rowIndex);
            this.getModel().setValue("detailconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), rowIndex);
        }
    }

    private AIAttachmentConfig createConfig() {
        AIAttachmentConfig aiAttachmentConfig = new AIAttachmentConfig();
        aiAttachmentConfig.setCheckType(CheckAttachmentTypeEnum.CHECKBILLCONTENT);
        aiAttachmentConfig.setCheckMethod(CheckMethodEnum.FGPTAS);
        aiAttachmentConfig.setEnableRuleBase(true);
        return aiAttachmentConfig;
    }

    private Map<Long, StandardBaseDataConfig[]> queryTemplates(Collection<Object> ruleRepoIdCols) {
        if (CollectionUtils.isNotEmpty(ruleRepoIdCols)) {
            Map result;
            try {
                result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"RuleRepoService", (String)"getTemplateByRuleRepoIds", (Object[])new Object[]{new ArrayList<Object>(ruleRepoIdCols)});
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{""});
            }
            if (result != null && !result.isEmpty()) {
                HashMap<Long, StandardBaseDataConfig[]> dataMap = new HashMap<Long, StandardBaseDataConfig[]>(result.size());
                Set kvSet = result.entrySet();
                for (Map.Entry stringListEntry : kvSet) {
                    String ruleId = (String)stringListEntry.getKey();
                    List templateMapList = (List)stringListEntry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)templateMapList)) continue;
                    StandardBaseDataConfig[] configs = new StandardBaseDataConfig[templateMapList.size()];
                    int i = 0;
                    for (Map stringObjectMap : templateMapList) {
                        configs[i++] = new StandardBaseDataConfig(stringObjectMap.get("templateId"), (String)stringObjectMap.get("templateNumber"));
                    }
                    dataMap.put(Long.parseLong(ruleId), configs);
                }
                return dataMap;
            }
        }
        return new HashMap<Long, StandardBaseDataConfig[]>(1);
    }
}

