/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class IDIApiConfigFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_PARAM_ENTRY_ENTITY = "paramentryentity";
    private static final String KEY_PARAM_NAME = "paramname";
    private static final String KEY_PARAM_TYPE = "paramtype";
    private static final String KEY_PARAM_DESC = "paramdesc";
    private static final String OPERATION_SAVE = "save";
    private static final String KEY_PARAM_NUMBER = "number";
    private static final String KEY_VALUE_KDGJ = "KDGJ";
    private static final String KEY_VALUE_KDGJURL = "https://b.kuaidi100.com";
    private static final String KEY_PARAM_URL = "url";
    private static final String KEY_VALUE_MOBILE = "mobile";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (OPERATION_SAVE.equalsIgnoreCase(operateKey)) {
            String number = (String)this.getModel().getValue(KEY_PARAM_NUMBER);
            boolean isKuaidi = KEY_VALUE_KDGJ.equals(number);
            if (isKuaidi && !KEY_VALUE_KDGJURL.equals(this.getModel().getValue(KEY_PARAM_URL))) {
                args.cancel = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"API\u914d\u7f6e\u4e2d\u7684URL\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u3002", (String)"IDIApiConfigFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowCount = this.getModel().getEntryRowCount(KEY_PARAM_ENTRY_ENTITY);
            boolean hasMobile = false;
            boolean isMobile = false;
            for (int i = rowCount - 1; i >= 0; --i) {
                String paramName = (String)this.getModel().getValue(KEY_PARAM_NAME, i);
                String paramType = (String)this.getModel().getValue(KEY_PARAM_TYPE, i);
                String paramDesc = (String)this.getModel().getValue(KEY_PARAM_DESC, i);
                if (StringUtils.isEmpty((String)paramName) && StringUtils.isEmpty((String)paramType) && StringUtils.isEmpty((String)paramDesc)) continue;
                if (isKuaidi && !hasMobile) {
                    hasMobile = KEY_VALUE_MOBILE.equals(paramName);
                    if (StringUtils.isNotEmpty((String)paramType) && !isMobile) {
                        String mobileRegex = "^((13[0-9])|(14[5,6,7,9])|(15[^4])|(16[5,6])|(17[0-9])|(18[0-9])|(19[1,8,9]))\\d{8}$";
                        isMobile = paramType.matches(mobileRegex);
                    }
                }
                String paramMessage = ResManager.loadKDString((String)"\u201c\u53c2\u6570\u4fe1\u606f\u201d", (String)"IDIApiConfigFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]);
                String paramNameMessage = ResManager.loadKDString((String)"\u201c\u53c2\u6570\u540d\u201d", (String)"IDIApiConfigFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]);
                String paramValueMessage = ResManager.loadKDString((String)"\u201c\u53c2\u6570\u503c\u201d", (String)"IDIApiConfigFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]);
                String paramNameAndValueMessage = String.format(ResManager.loadKDString((String)"%1$s\u548c%2$s", (String)"IDIApiConfigFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]), paramNameMessage, paramValueMessage);
                if (StringUtils.isEmpty((String)paramName)) {
                    args.cancel = true;
                    if (StringUtils.isEmpty((String)paramType)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u7b2c%2$d\u884c:%3$s\u3002", (String)"IDIApiConfigFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), paramMessage, i + 1, paramNameAndValueMessage));
                        continue;
                    }
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u7b2c%2$d\u884c:%3$s\u3002", (String)"IDIApiConfigFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), paramMessage, i + 1, paramNameMessage));
                    continue;
                }
                if (!StringUtils.isEmpty((String)paramType)) continue;
                args.cancel = true;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u7b2c%2$d\u884c:%3$s\u3002", (String)"IDIApiConfigFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), paramMessage, i + 1, paramValueMessage));
            }
            if (isKuaidi && (!hasMobile || hasMobile && !isMobile)) {
                args.cancel = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u67e5API\u914d\u7f6e\u4e2d\u53c2\u6570\u540d\u662f\u5426\u4e3a\u201cmobile\u201d\uff0c\u53c2\u6570\u503c\u662f\u5426\u4e3a\u6ce8\u518c\u624b\u673a\u53f7\u3002", (String)"IDIApiConfigFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

