/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;

public class IDIBillFlowFieldFormPlugin
extends AbstractFormPlugin {
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_PROPDISPLAYNAME = "propdisplayname";
    private static final String FIELD_PROPNAME = "propname";
    private static final String BILL_TYPE_NUMBER = "billtypenumber";
    private static final String CUSTOM_SELECTFIELDS = "selectfields";
    private static final String SELECT_FIELDS_DISPLAY = "selectfieldsdisplay";
    private static final String CONTROL_BTNOK = "btnok";
    private static final String CUSTOM_ONLYHEADFIELD = "onlyheadfield";
    private static final String CONTROL_LIMITFIELDS = "limitfields";
    private static final String RENAME = "rename";
    private static final String CHECKBOX_FIELD = "checkboxfield";
    private static final String POSITION = "position";
    private static final String SHOW_TOTAL_COLUMN = "showtotalcolumn";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_BTNOK});
    }

    public void afterBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String billType = (String)fsp.getCustomParam(BILL_TYPE_NUMBER);
        if (!StringUtils.isEmpty((String)billType)) {
            String fields = (String)fsp.getCustomParam(CUSTOM_SELECTFIELDS);
            List selectedList = StringUtils.isNotEmpty((String)fields) ? IDIJSONUtils.jsonCastToList((String)fields, String.class) : null;
            List selectedDisplayList = Collections.emptyList();
            try {
                String displayFields = (String)fsp.getCustomParam(SELECT_FIELDS_DISPLAY);
                selectedDisplayList = StringUtils.isNotEmpty((String)displayFields) ? IDIJSONUtils.jsonCastToList((String)displayFields, LocaleString.class) : Collections.emptyList();
            }
            catch (Exception ex) {
                SchemaExecutorLogger.info((String)("IDI multi-language exception" + Arrays.toString(ex.getStackTrace())), (Object[])new Object[0]);
            }
            Boolean isOnlyHeadField = (Boolean)fsp.getCustomParam(CUSTOM_ONLYHEADFIELD);
            String limitField = (String)fsp.getCustomParam(CONTROL_LIMITFIELDS);
            String showTotalColumn = (String)fsp.getCustomParam(SHOW_TOTAL_COLUMN);
            String[] totalColumnArr = StringUtils.isNotEmpty((String)showTotalColumn) ? showTotalColumn.split("\u3001") : null;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billType);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, isOnlyHeadField.booleanValue());
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField(CHECKBOX_FIELD, new Object[0]);
            tvs.addField(FIELD_PROPDISPLAYNAME, new Object[0]);
            tvs.addField(FIELD_PROPNAME, new Object[0]);
            tvs.addField(RENAME, new Object[0]);
            tvs.addField(POSITION, new Object[0]);
            for (Map map : cols) {
                String entryEntity = (String)map.get(FIELD_ENTRYENTITY);
                String fieldName = (String)map.get("fieldName");
                String fieldCaption = (String)map.get("fieldCaption");
                if (StringUtils.isNotEmpty((String)limitField) && limitField.contains(fieldName)) continue;
                String propertyColumn = fieldName;
                if (StringUtils.isNotEmpty((String)entryEntity) && !billType.equals(entryEntity)) {
                    propertyColumn = entryEntity + "." + fieldName;
                }
                if (selectedList != null && selectedList.contains(propertyColumn)) {
                    String positionNumber = "";
                    int indexOfSelectedList = 0;
                    for (int k = 0; k < selectedList.size(); ++k) {
                        if (!((String)selectedList.get(k)).equals(propertyColumn)) continue;
                        indexOfSelectedList = k;
                        positionNumber = String.valueOf(k + 1);
                        break;
                    }
                    LocaleString display = selectedDisplayList.size() > indexOfSelectedList ? (LocaleString)selectedDisplayList.get(indexOfSelectedList) : new LocaleString("");
                    display = display == null ? new LocaleString("") : display;
                    tvs.addRow(new Object[]{Boolean.TRUE, fieldCaption, propertyColumn, display, positionNumber});
                    continue;
                }
                tvs.addRow(new Object[]{Boolean.FALSE, fieldCaption, propertyColumn, new LocaleString(""), ""});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow(FIELD_ENTRYENTITY, tvs);
            model.endInit();
            this.getView().updateView(FIELD_ENTRYENTITY);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (CONTROL_BTNOK.equalsIgnoreCase(control.getKey())) {
            int totalRowCount = this.getModel().getEntryRowCount(FIELD_ENTRYENTITY);
            if (!this.isExceedMaxCheckedRows(totalRowCount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e94\u4e2a\u5b57\u6bb5\u3002", (String)"IDIBillFlowFieldFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<String, Object> resultMap = this.getMessageFromCheckedRow(totalRowCount);
            if (resultMap != null) {
                String notCheckedPositionRow = (String)resultMap.get("notCheckedPositionRow");
                if (StringUtils.isNotEmpty((String)notCheckedPositionRow)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u7684\u5c55\u793a\u987a\u5e8f\u3002", (String)"IDIBillFlowFieldFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), notCheckedPositionRow));
                    return;
                }
                String repeatPositionRow = (String)resultMap.get("repeatPositionRow");
                if (StringUtils.isNotEmpty((String)repeatPositionRow)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u5c55\u793a\u987a\u5e8f\u91cd\u590d\u3002", (String)"IDIBillFlowFieldFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), repeatPositionRow));
                    return;
                }
                List indexList = (List)resultMap.get("checkedPositionRowIndex");
                if (!CollectionUtils.isEmpty((Collection)indexList)) {
                    for (int i = 0; i < indexList.size() - 1; ++i) {
                        for (int j = 0; j < indexList.size() - 1 - i; ++j) {
                            String rightPositionStr;
                            int rightPosition;
                            String leftPositionStr = (String)this.getModel().getValue(POSITION, ((Integer)indexList.get(j)).intValue());
                            int leftPosition = Integer.parseInt(leftPositionStr);
                            if (leftPosition <= (rightPosition = Integer.parseInt(rightPositionStr = (String)this.getModel().getValue(POSITION, ((Integer)indexList.get(j + 1)).intValue())))) continue;
                            int temp = (Integer)indexList.get(j);
                            indexList.set(j, indexList.get(j + 1));
                            indexList.set(j + 1, temp);
                        }
                    }
                    Object[][] fields = new Object[indexList.size()][3];
                    int i = 0;
                    Iterator iterator = indexList.iterator();
                    while (iterator.hasNext()) {
                        int checkedIndex = (Integer)iterator.next();
                        Object[] row = new Object[]{this.getModel().getValue(FIELD_PROPDISPLAYNAME, checkedIndex), this.getModel().getValue(FIELD_PROPNAME, checkedIndex), this.getModel().getValue(RENAME, checkedIndex) == null ? new LocaleString("") : IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)this.getModel().getValue(RENAME, checkedIndex)))};
                        fields[i] = row;
                        ++i;
                    }
                    this.getView().returnDataToParent((Object)fields);
                } else {
                    String[][] fields = new String[0][3];
                    this.getView().returnDataToParent((Object)fields);
                }
            }
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int currentRow = this.getModel().getEntryCurrentRowIndex(FIELD_ENTRYENTITY);
        switch (e.getProperty().getName()) {
            case "checkboxfield": {
                boolean isChecked = (Boolean)this.getModel().getValue(CHECKBOX_FIELD, currentRow);
                if (isChecked) break;
                this.getModel().setValue(RENAME, (Object)"");
                this.getModel().setValue(POSITION, (Object)"");
            }
        }
    }

    private boolean isExceedMaxCheckedRows(int totalRowCount) {
        int totalCheckedRowsCount = 0;
        for (int i = 0; i < totalRowCount; ++i) {
            boolean hasBeenChecked = (Boolean)this.getModel().getValue(CHECKBOX_FIELD, i);
            if (!hasBeenChecked) continue;
            ++totalCheckedRowsCount;
        }
        return totalCheckedRowsCount <= 4;
    }

    private Map<String, Object> getMessageFromCheckedRow(int totalRowCount) {
        StringBuilder notCheckedPositionRow = new StringBuilder();
        ArrayList<Integer> checkedPositionRowIndex = new ArrayList<Integer>();
        HashMap<Integer, String> checkedPositionMap = new HashMap<Integer, String>();
        StringBuilder repeatPositionRow = new StringBuilder();
        for (int i = 0; i < totalRowCount; ++i) {
            boolean hasBeenChecked = (Boolean)this.getModel().getValue(CHECKBOX_FIELD, i);
            if (!hasBeenChecked) continue;
            String positionStr = (String)this.getModel().getValue(POSITION, i);
            if (StringUtils.isEmpty((String)positionStr)) {
                notCheckedPositionRow.append(',').append(i + 1);
                continue;
            }
            Integer position = Integer.valueOf(positionStr);
            if (checkedPositionMap.get(position) != null) {
                StringBuilder repeatPositionRowIndex = new StringBuilder((String)checkedPositionMap.get(position));
                checkedPositionMap.put(position, repeatPositionRowIndex.append(',').append(i).toString());
            } else {
                checkedPositionMap.put(position, String.valueOf(i));
            }
            checkedPositionRowIndex.add(i);
        }
        for (String rowsNumber : checkedPositionMap.values()) {
            if (!StringUtils.isNotEmpty((String)rowsNumber) || rowsNumber.indexOf(44) <= -1) continue;
            repeatPositionRow.append("\u3001(");
            for (String rowNumber : rowsNumber.split(",")) {
                if (repeatPositionRow.toString().endsWith("(")) {
                    repeatPositionRow.append(Integer.parseInt(rowNumber) + 1);
                    continue;
                }
                repeatPositionRow.append(',').append(Integer.parseInt(rowNumber) + 1);
            }
            repeatPositionRow.append(')');
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("checkedPositionRowIndex", checkedPositionRowIndex);
        if (notCheckedPositionRow.length() > 0) {
            resultMap.put("notCheckedPositionRow", notCheckedPositionRow.substring(1, notCheckedPositionRow.length()));
        }
        if (repeatPositionRow.length() > 0) {
            resultMap.put("repeatPositionRow", repeatPositionRow.substring(1, repeatPositionRow.length()));
        }
        return resultMap;
    }
}

