/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CtsyFormShowParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionFrontEndConfigField;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LinkUpBillConfig;
import kd.data.idi.data.MulTenantBillInfo;
import kd.data.idi.data.Relation;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.functions.CustomFuncEnum;
import kd.data.idi.formplugin.IDIEntityObjectList;
import kd.data.idi.util.FilterGridHelper;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;

public class IDIDecisionFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ActionId_RULE = "rule";
    private static final String CustParamKey_ENTITY_NUMBER = "entitynumber";
    private static final String CustParamKey_FORMULA = "formula";
    private static final String CustParamKey_MATCH_BILL = "matchBill";
    private static final String CustParamKey_TREENODES = "treenodes";
    private static final String FormId_IDI_CONDITION_EDIT = "idi_condition_edit";
    private static final String Key_BAR_FRONTEND = "bar_frontend";
    private static final String Key_BTN_NEW = "btn_new";
    private static final String Key_BTN_OK = "btnok";
    private static final String Key_DETAIL_CONFIG = "detailConfig";
    private static final String Key_FLEX_HOVER = "flex_hover_panel";
    private static final String Key_FRONTEND_CONFIG = "rule_frontend_config";
    private static final String Key_PERCENT = "percent";
    private static final String Key_RULE = "rule";
    private static final String Key_RULE_JSON = "rulejson";
    private static final String Key_RULE_LIST = "rulelist";
    private static final String Key_SHOW_LIST = "show_list";
    private static final String Key_STATUS = "status";
    private static final String Key_TITLE = "title";
    private static final String Key_STARTCCONDITION_FIELD = "startcondition";
    private static final String Key_STARTCCONDITION_JSON = "startcondition_json";
    private static final String CustomParam_START_CONDITION_JSON = "startConditionJson";
    private static final String ActionId_SET_START_CONDITION = "setStartCondition";
    private static final String CustomParam_LINKUPBILLCONFIG = "linkupbillconfig";
    private static final String Key_RELATION = "relation";
    private static final String Key_FLEX_RULEPANEL = "rulepanel";
    private static final String Key_CHECKTYPE = "checktype";
    private static final String Key_TARGET = "target";
    private static final String Key_TARGETQUERYRULE = "targetqueryrule";
    private static final String Key_TARGETQUERYRULEJSON = "targetqueryrule_json";
    private static final String FLEX_CROSSENTRY = "crossentryflex";
    private static final String KEY_CROSSENTRYRULE = "crossentryrule";
    private static final String KEY_CROSSENTRYRULEJSON = "crossentryrule_json";
    private static final String FORMID_IDI_CROSSENTRYRULE = "idi_crossentryrule";
    private static final String ACTIONID_SET_CROSSENTRYRULE = "setCrossEntryRule";
    private static final String Key_ISPASS = "ispass";
    private static final String FormId_IDI_QUERYTARGETBILL = "idi_querytargetbill";
    private static final String CustParamKey_TARGETENTITY_NUMBER = "targetEntityNumber";
    private static final String ActionId_SET_TARGETQUERYRULE = "setTargetQueryRule";
    private static final String Key_BILLTYPE = "billtype";
    private static final String Key_PROPDISPLAYNAME = "propdisplayname";
    private static final String Key_PROPNAME = "propname";
    private static final String Key_DISPLAYNAME = "displayname";
    private static final String ActionId_SET_BILLFIELD = "setBillField";
    private static final String CustParamKey_CURRENTSELECTFIELDS = "currentSelectField";
    private static final String Key_TAERGETNUMBER = "targetNumber";
    private static final String CustParamKey_LIMITFIELDS = "limitfields";
    private static final String IDI_CONDITION_CONFIG = "idi_condition_config";
    private static final String WORDSCONFIG = "wordsconfig";
    private static final String TARGETEXISTWORDS = "targetexistwords";
    private static final String TARGETNOTEXISTWORDS = "targetnotexistwords";
    private static final String CustParamKey_ANALYSISMODE = "analysisModel";
    private static final String Key_COMMONSET = "commonset";
    private static final String Key_SETENTRY = "setentry";
    private static final String Key_DEDUCTITEM = "deductitem";
    private static final String Key_DEDUCTPERCENT = "deductpercent";
    private static final String Key_COMMONPASS = "commonpass";
    private static final String CustParamKey_SOURCEENTITYNUMBER = "sourceentitynumber";
    private static final String KEY_SHOWALLCHECKTRUE = "showallchecktrue";
    private static final String KEY_SHOWALLENTRYCHECKTRUE = "showallentrychecktrue";
    private static final String PAGECACHE_INTERRUPT = "interrupt";
    private static final String KEY_EXITALARM = "exitalarm";
    private static final String CustParamKey_SUPPORTSUBENTRY = "supportSubEntry";
    private static final String CustParamKey_SUPPORTTARGETSELF = "targetSelf";
    private static final String KEY_TENANT = "tenant";
    private static final String KEY_TARGETBILL = "targetbill";
    private static final String KEY_TARGETBILLNUM = "targetbillnum";
    private static final String ActionId_SET_BILLTYPE = "setBillType";
    private static final String CustomParam_MULTENANTBILLINFO = "mulTenantBillInfo";
    private static final String MULTARGETEXISTWORDS = "multargetexistwords";
    private static final String MULTARGETNOTEXISTWORDS = "multargetnotexistwords";
    private static final String Key_MULDISPLAYNAME = "muldisplayname";
    private static final String Key_MULTITLE = "multitle";
    private static final String CustomParam_RELOADTARGETBILLFIELD = "reloadTargetBillField";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_BTN_OK, "rule", Key_BTN_NEW, Key_STARTCCONDITION_FIELD, Key_TARGETQUERYRULE, KEY_CROSSENTRYRULE, Key_PROPDISPLAYNAME, KEY_TARGETBILL});
        this.addItemClickListeners(new String[]{Key_BAR_FRONTEND});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (Key_BTN_NEW.equals(key)) {
            String targetEntityNumber = this.getTargetEntityNumber();
            if (StringUtils.isEmpty((String)targetEntityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u76ee\u6807\u5355\u7c7b\u578b\u201d\u3002", (String)"IDIDecisionFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            int count = this.getModel().getEntryRowCount(Key_SHOW_LIST);
            if (count >= 5) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u60ac\u505c\u4fe1\u606f\u914d\u7f6e\u201d\u5206\u5f55\u884c\u6570\u5e94\u22645\u884c\u3002", (String)"IDIDecisionFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().createNewEntryRow(Key_SHOW_LIST);
        }
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "rule": {
                this.doClickRule();
                break;
            }
            case "btnok": {
                List<DecisionRule> ruleList = this.getFormulaData();
                if (!this.preVerity(ruleList)) {
                    return;
                }
                DecisionFrontEndConfig frontEndConfig = this.getFrontEndConfig();
                String startConditionJson = (String)this.getModel().getValue(Key_STARTCCONDITION_JSON);
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put("frontEndConfig", frontEndConfig);
                returnData.put("ruleList", ruleList);
                returnData.put(CustomParam_START_CONDITION_JSON, startConditionJson);
                DynamicObject dob = (DynamicObject)this.getModel().getValue(Key_TARGET);
                if (dob != null) {
                    returnData.put(CustParamKey_MATCH_BILL, dob.getPkValue());
                }
                LinkUpBillConfig config = this.getLinkupBillConfig();
                returnData.put(CustomParam_LINKUPBILLCONFIG, config);
                this.getView().returnDataToParent((Object)IDIJSONUtils.toJsonString(returnData));
                this.getView().close();
                break;
            }
            case "startcondition": {
                this.showStartConditionForm();
                break;
            }
            case "targetqueryrule": {
                this.showTargetRuleForm();
                break;
            }
            case "crossentryrule": {
                this.showCrossEntryRule();
                break;
            }
            case "propdisplayname": {
                this.showBillFieldForm();
                break;
            }
            case "targetbill": {
                this.showBillType();
            }
        }
    }

    private void showBillFieldForm() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(Key_SHOW_LIST);
        if (currentRowIndex > -1) {
            String billType = (String)this.getModel().getValue(Key_BILLTYPE, currentRowIndex);
            if (StringUtils.isEmpty((String)billType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u5b57\u6bb5\u6765\u6e90\u201d\u3002", (String)"IDIDecisionFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            String relationStr = (String)this.getModel().getValue(Key_RELATION);
            Relation relation = Relation.typeToRelation((String)relationStr);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("idi_fieldlist");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            FormShowParameter sourceFsp = this.getView().getFormShowParameter();
            String sourceBill = (String)sourceFsp.getCustomParam(CustParamKey_ENTITY_NUMBER);
            String targetBillNumber = "";
            MulTenantBillInfo mulTenantBillInfo = this.getMulTenantBillInfo(true);
            if (relation != Relation.SELF) {
                Object targetBill = this.getModel().getValue(Key_TARGET);
                if (targetBill == null && mulTenantBillInfo == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u76ee\u6807\u5355\u7c7b\u578b\u201d\u3002", (String)"IDIDecisionFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return;
                }
                targetBillNumber = this.getTargetEntityNumber();
            }
            if ("srcbill".equalsIgnoreCase(billType)) {
                fsp.setCustomParam(CustParamKey_ENTITY_NUMBER, (Object)sourceBill);
            } else if (mulTenantBillInfo != null) {
                fsp.setCustomParam(CustomParam_MULTENANTBILLINFO, (Object)IDIJSONUtils.toJsonString((Object)mulTenantBillInfo));
            } else {
                fsp.setCustomParam(CustParamKey_ENTITY_NUMBER, (Object)targetBillNumber);
            }
            String billEntityType = "srcbill".equalsIgnoreCase(billType) ? sourceBill : targetBillNumber;
            fsp.setCustomParam(CustParamKey_CURRENTSELECTFIELDS, this.getModel().getValue(Key_PROPNAME, currentRowIndex));
            fsp.setCustomParam(CustParamKey_SUPPORTSUBENTRY, (Object)Boolean.TRUE.toString());
            String checkType = (String)this.getModel().getValue(Key_CHECKTYPE);
            if (LinkUpBillConfig.CheckType.CheckBillContent.getType().equals(checkType)) {
                String[] stringArray;
                String scriptBillPrefix;
                boolean targetSelf = relation != Relation.SELF && sourceBill.equalsIgnoreCase(targetBillNumber);
                String string = scriptBillPrefix = !"srcbill".equalsIgnoreCase(billType) && targetSelf ? "targetisself_" : "";
                if (relation == Relation.SELF) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = sourceBill;
                } else if (targetSelf) {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = sourceBill;
                    stringArray = stringArray3;
                    stringArray3[1] = "targetisself_" + targetBillNumber;
                } else {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = sourceBill;
                    stringArray = stringArray4;
                    stringArray4[1] = targetBillNumber;
                }
                String[] billTypes = stringArray;
                int ruleCount = this.getModel().getEntryRowCount(Key_RULE_LIST);
                String mainVarName = scriptBillPrefix + billEntityType + "_billObj.";
                HashSet<String> fieldLimitSet = new HashSet<String>();
                MainEntityType mainType = "srcbill".equalsIgnoreCase(billType) ? EntityMetadataCache.getDataEntityType((String)billEntityType) : this.getTargetEntity();
                Map entityMap = mainType.getAllEntities();
                for (int i = 0; i < ruleCount; ++i) {
                    String ruleJson = (String)this.getModel().getValue(Key_RULE_JSON, i);
                    if (StringUtils.isEmpty((String)ruleJson)) continue;
                    IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
                    String script = condition.getScript();
                    Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])billTypes);
                    for (String field : vars) {
                        if (!field.startsWith(mainVarName)) continue;
                        String fullField = field.substring(mainVarName.length());
                        for (String entryKey : entityMap.keySet()) {
                            if (entryKey.equals(billEntityType) || !fullField.contains(entryKey)) continue;
                            fieldLimitSet.add(entryKey);
                        }
                    }
                }
                fsp.setCustomParam(CustParamKey_LIMITFIELDS, fieldLimitSet);
            }
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_BILLFIELD));
            this.getView().showForm(fsp);
        }
    }

    private void showTargetRuleForm() {
        FormShowParameter showParameter;
        DynamicObject targetBill = (DynamicObject)this.getModel().getValue(Key_TARGET);
        MulTenantBillInfo mulTenantBillInfo = this.getMulTenantBillInfo(true);
        if (targetBill == null && mulTenantBillInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u76ee\u6807\u5355\u7c7b\u578b\u201d\u3002", (String)"IDIDecisionFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        Objects.requireNonNull(sourceBill);
        String conditionJson = (String)this.getModel().getValue(Key_TARGETQUERYRULEJSON);
        String relationStr = (String)this.getModel().getValue(Key_RELATION);
        Relation relation = Relation.typeToRelation((String)relationStr);
        boolean targetSelf = false;
        if (mulTenantBillInfo != null && !mulTenantBillInfo.isCurrentTenant()) {
            showParameter = new CtsyFormShowParameter(mulTenantBillInfo.getTenantId(), mulTenantBillInfo.getAccountId(), FormId_IDI_QUERYTARGETBILL);
            showParameter.getCustomParams().put(CustomParam_MULTENANTBILLINFO, IDIJSONUtils.toJsonString((Object)mulTenantBillInfo));
            targetSelf = relation != Relation.SELF && sourceBill.equalsIgnoreCase(mulTenantBillInfo.getEntityNumber());
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_TARGETQUERYRULE + ((CtsyFormShowParameter)showParameter).getCloseCallBackActionIdSuffix()));
        } else {
            showParameter = new FormShowParameter();
            showParameter.setFormId(FormId_IDI_QUERYTARGETBILL);
            String targetBillNumber = this.getTargetEntityNumber();
            showParameter.getCustomParams().put(CustParamKey_TARGETENTITY_NUMBER, targetBillNumber);
            targetSelf = relation != Relation.SELF && sourceBill.equalsIgnoreCase(targetBillNumber);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_TARGETQUERYRULE));
        }
        showParameter.getCustomParams().put(CustParamKey_FORMULA, conditionJson);
        showParameter.getCustomParams().put(CustParamKey_ENTITY_NUMBER, sourceBill);
        showParameter.getCustomParams().put(CustParamKey_SUPPORTTARGETSELF, String.valueOf(targetSelf));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showCrossEntryRule() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_IDI_CROSSENTRYRULE);
        showParameter.getCustomParams().put(CustParamKey_FORMULA, model.getValue(KEY_CROSSENTRYRULEJSON));
        showParameter.getCustomParams().put(CustParamKey_ENTITY_NUMBER, view.getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID_SET_CROSSENTRYRULE));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private LinkUpBillConfig getLinkupBillConfig() {
        LocaleString mulTargetNotExistWords;
        IDataModel model = this.getModel();
        String checkType = (String)model.getValue(Key_CHECKTYPE);
        String relation = (String)model.getValue(Key_RELATION);
        String targetRuleJson = (String)model.getValue(Key_TARGETQUERYRULEJSON);
        String crossEntryRuleJson = (String)model.getValue(KEY_CROSSENTRYRULEJSON);
        LinkUpBillConfig config = new LinkUpBillConfig();
        config.setCheckType(LinkUpBillConfig.CheckType.convertFromMatchType((String)checkType));
        config.setRelation(Relation.typeToRelation((String)relation));
        config.setMatchCondition((IDICondition)IDIJSONUtils.cast((String)targetRuleJson, IDICondition.class));
        config.setCrossEntryRule((IDICondition)IDIJSONUtils.cast((String)crossEntryRuleJson, IDICondition.class));
        String targetExistWords = (String)model.getValue(TARGETEXISTWORDS);
        String targetNotExistWords = (String)model.getValue(TARGETNOTEXISTWORDS);
        config.setTargetExistWords(targetExistWords);
        config.setTargetNotExistWords(targetNotExistWords);
        LocaleString mulTargetExistWords = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)model.getValue(MULTARGETEXISTWORDS)));
        if (mulTargetExistWords == null || mulTargetExistWords.isEmpty()) {
            String existWords = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5b58\u5728", (String)"IDIDecisionFormPlugin_15", (String)"data-idi-formplugin", (Object[])new Object[0]);
            mulTargetExistWords = new LocaleString(existWords);
        }
        if ((mulTargetNotExistWords = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)model.getValue(MULTARGETNOTEXISTWORDS)))) == null || mulTargetNotExistWords.isEmpty()) {
            String notExistWords = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e0d\u5b58\u5728", (String)"IDIDecisionFormPlugin_16", (String)"data-idi-formplugin", (Object[])new Object[0]);
            mulTargetNotExistWords = new LocaleString(notExistWords);
        }
        config.setMulTargetExistWords(mulTargetExistWords);
        config.setMulTargetNotExistWords(mulTargetNotExistWords);
        boolean exitAlarm = (Boolean)this.getModel().getValue(KEY_EXITALARM);
        config.setExitAlarm(exitAlarm);
        int rowCount = this.getModel().getEntryRowCount(Key_SETENTRY);
        if (rowCount > 0) {
            ArrayList<DeductionGradeConfig> deductionGradeConfigList = new ArrayList<DeductionGradeConfig>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                int seq = i + 1;
                String item = (String)this.getModel().getValue(Key_DEDUCTITEM, i);
                int percent = (Integer)this.getModel().getValue(Key_DEDUCTPERCENT, i);
                boolean isPass = (Boolean)this.getModel().getValue(Key_COMMONPASS, i);
                DeductionGradeConfig deductionGradeconfig = new DeductionGradeConfig();
                deductionGradeconfig.setSeq(seq);
                deductionGradeconfig.setItem(DeductionGradeConfig.DeductionGradeItem.convertFromMatchType((String)item));
                deductionGradeconfig.setPercent(percent);
                deductionGradeconfig.setPass(isPass);
                deductionGradeConfigList.add(deductionGradeconfig);
            }
            config.setDeductionGradeConfigList(deductionGradeConfigList);
        }
        MulTenantBillInfo mulTenantBillInfo = this.getMulTenantBillInfo(false);
        config.setMulTenantMatchBill(mulTenantBillInfo);
        return config;
    }

    private void showStartConditionForm() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        Objects.requireNonNull(sourceBill);
        String conditionJson = (String)this.getModel().getValue(Key_STARTCCONDITION_JSON);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormId_IDI_CONDITION_EDIT);
        showParameter.getCustomParams().put(CustParamKey_FORMULA, conditionJson);
        showParameter.getCustomParams().put(CustParamKey_ENTITY_NUMBER, sourceBill);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_START_CONDITION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private boolean preVerity(List<DecisionRule> ruleList) {
        int rowCount;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String checkType = (String)model.getValue(Key_CHECKTYPE);
        if (StringUtils.isEmpty((String)checkType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u68c0\u67e5\u76ee\u6807\u201d\u3002", (String)"IDIDecisionFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        String relation = (String)model.getValue(Key_RELATION);
        if (StringUtils.isEmpty((String)relation)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6e90\u5355\u4e0e\u76ee\u6807\u5355\u5173\u7cfb\u3002", (String)"IDIDecisionFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (Relation.CUSTOM.getType().equals(relation) || Relation.BOTP.getType().equalsIgnoreCase(relation) || Relation.LINKDOWN.getType().equalsIgnoreCase(relation)) {
            Object target = model.getValue(Key_TARGET);
            MulTenantBillInfo mulTenantBillInfo = this.getMulTenantBillInfo(true);
            if (target == null && mulTenantBillInfo == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u76ee\u6807\u5355\u7c7b\u578b\u201d\u3002", (String)"IDIDecisionFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (Relation.CUSTOM.getType().equals(relation)) {
                String targerRule = (String)model.getValue(Key_TARGETQUERYRULE);
                String targerRuleJson = (String)model.getValue(Key_TARGETQUERYRULEJSON);
                if (StringUtils.isEmpty((String)targerRule) || StringUtils.isEmpty((String)targerRuleJson)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u76ee\u6807\u5355\u67e5\u627e\u89c4\u5219\u201d\u3002", (String)"IDIDecisionFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        if (LinkUpBillConfig.CheckType.CheckBillContent.getType().equals(checkType) && (rowCount = model.getEntryRowCount(Key_RULE_LIST)) > 0) {
            ArrayList<Integer> removeList = new ArrayList<Integer>();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                OrmLocaleValue modelValue = (OrmLocaleValue)model.getValue(Key_MULTITLE, rowIndex);
                String rule = (String)model.getValue("rule", rowIndex);
                if (IDIStringUtils.ormLocaleIsEmpty((OrmLocaleValue)modelValue) && StringUtils.isEmpty((String)rule)) {
                    removeList.add(rowIndex);
                    continue;
                }
                if (IDIStringUtils.ormLocaleIsEmpty((OrmLocaleValue)modelValue)) {
                    String message = ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u7b2c%d\u884c\u201c\u7ed3\u679c\u63cf\u8ff0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIDecisionFormPlugin_23", (String)"data-idi-formplugin", (Object[])new Object[0]);
                    view.showTipNotification(String.format(message, rowIndex + 1));
                    return false;
                }
                if (!StringUtils.isEmpty((String)rule)) continue;
                String message = ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u7b2c%d\u884c\u201c\u89c4\u5219\u914d\u7f6e\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIDecisionFormPlugin_24", (String)"data-idi-formplugin", (Object[])new Object[0]);
                view.showTipNotification(String.format(message, rowIndex + 1));
                return false;
            }
            if (removeList.size() != rowCount) {
                model.deleteEntryRows(Key_RULE_LIST, removeList.stream().mapToInt(Integer::intValue).toArray());
                ArrayList<DecisionRule> removeRuleList = new ArrayList<DecisionRule>(rowCount);
                for (Integer integer : removeList) {
                    removeRuleList.add(ruleList.get(integer));
                }
                for (DecisionRule decisionRule : removeRuleList) {
                    ruleList.remove(decisionRule);
                }
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u914d\u7f6e\u5747\u4e0d\u4e3a\u7a7a\u624d\u80fd\u4fdd\u5b58\u3002", (String)"IDIDecisionFormPlugin_25", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        DynamicObjectCollection collection = model.getEntryEntity(Key_SHOW_LIST);
        ArrayList<String> hoverContents = new ArrayList<String>();
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            String billType = dynamicObject.getString(Key_BILLTYPE);
            String fieldNumber = dynamicObject.getString(Key_PROPNAME);
            if (StringUtils.isEmpty((String)billType) && StringUtils.isEmpty((String)fieldNumber)) {
                removeList.add(i);
                continue;
            }
            if (StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)fieldNumber)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u60ac\u505c\u5c55\u793a\u5b57\u6bb5\u5f55\u5165\u5b8c\u6574\u3002", (String)"IDIDecisionFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            String key = billType + "_" + fieldNumber;
            if (hoverContents.contains(key)) continue;
            hoverContents.add(key);
        }
        model.deleteEntryRows(Key_SHOW_LIST, removeList.stream().mapToInt(Integer::intValue).toArray());
        if (collection.size() != hoverContents.size()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60ac\u505c\u5c55\u793a\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\u3002", (String)"IDIDecisionFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (collection.size() > 5) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u60ac\u505c\u4fe1\u606f\u914d\u7f6e\u201d\u5206\u5f55\u884c\u6570\u5e94\u22645\u884c\u3002", (String)"IDIDecisionFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        String crossEntryRuleJson = (String)model.getValue(KEY_CROSSENTRYRULEJSON);
        if (crossEntryRuleJson != null && !crossEntryRuleJson.isEmpty()) {
            int entryRowCount = model.getEntryRowCount(Key_RULE_LIST);
            for (int i = 0; i < entryRowCount; ++i) {
                String ruleJson = (String)model.getValue(Key_RULE_JSON, i);
                if (ruleJson != null && ruleJson.contains(CustomFuncEnum.ARRAY_DIFF.getFuncName())) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u914d\u7f6e\u8de8\u5206\u5f55\u5173\u8054\u89c4\u5219\u548carrayDiff\u51fd\u6570\u3002", (String)"IDIDecisionFormPlugin_13", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (ruleJson == null || !ruleJson.contains(CustomFuncEnum.SUB_SET.getFuncName())) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u914d\u7f6e\u8de8\u5206\u5f55\u5173\u8054\u89c4\u5219\u548csubset\u51fd\u6570\u3002", (String)"IDIDecisionFormPlugin_18", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        String sourceNumber = (String)view.getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        MainEntityType targetEntityType = this.getTargetEntity();
        if (ruleList != null && !ruleList.isEmpty()) {
            StringBuilder scriptBuilder = new StringBuilder();
            for (DecisionRule decisionRule : ruleList) {
                IDICondition rule = decisionRule.getRule();
                if (rule == null) continue;
                scriptBuilder.append(rule.getScript()).append(" ");
            }
            if (!ScriptUtils.checkEntryCountByRule((String)sourceNumber, (MainEntityType)targetEntityType, (String)scriptBuilder.toString())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u5b57\u6bb5\uff08\u6216\u5b50\u5206\u5f55\u5b57\u6bb5\uff09\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7\u4fee\u6539\u68c0\u67e5\u89c4\u5219\u3002", (String)"IDIDecisionFormPlugin_17", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private DecisionFrontEndConfig getFrontEndConfig() {
        DecisionFrontEndConfig config = new DecisionFrontEndConfig();
        int rowCount = this.getModel().getEntryRowCount(Key_SHOW_LIST);
        if (rowCount > 0) {
            ArrayList<DecisionFrontEndConfigField> hoverContents = new ArrayList<DecisionFrontEndConfigField>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                String fieldNumber = (String)this.getModel().getValue(Key_BILLTYPE, i);
                String propDispalyName = (String)this.getModel().getValue(Key_PROPDISPLAYNAME, i);
                String propName = (String)this.getModel().getValue(Key_PROPNAME, i);
                String displayName = (String)this.getModel().getValue(Key_DISPLAYNAME, i);
                LocaleString mulDisplayName = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)this.getModel().getValue(Key_MULDISPLAYNAME, i)));
                DecisionFrontEndConfigField dfef = new DecisionFrontEndConfigField();
                dfef.setBillType(fieldNumber);
                dfef.setDisplayName(displayName);
                dfef.setPropDisplayName(propDispalyName);
                dfef.setPropName(propName);
                dfef.setMulDisplayName(mulDisplayName);
                hoverContents.add(dfef);
            }
            config.setHoverFieldContents(hoverContents);
        }
        return config;
    }

    private List<DecisionRule> getFormulaData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_RULE_LIST);
        ArrayList<DecisionRule> ruleList = new ArrayList<DecisionRule>();
        for (DynamicObject obj : entryEntity) {
            String name = obj.getString(Key_TITLE);
            boolean ispass = obj.getBoolean(Key_ISPASS);
            String ruleJson = obj.getString(Key_RULE_JSON);
            int percent = obj.getInt(Key_PERCENT);
            String status = obj.getString(Key_STATUS);
            boolean showAllCheckTrue = obj.getBoolean(KEY_SHOWALLCHECKTRUE);
            boolean showAllEntryCheckTrue = obj.getBoolean(KEY_SHOWALLENTRYCHECKTRUE);
            LocaleString mulName = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)obj.getLocaleString(Key_MULTITLE)));
            DecisionRule rule = new DecisionRule();
            rule.setName(name);
            rule.setRule((IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class));
            rule.setDeductionGradePercent(percent);
            rule.setDecisionStatus(status);
            rule.setPass(ispass);
            rule.setShowAllCheckTrue(showAllCheckTrue);
            rule.setShowAllEntryCheckTrue(showAllEntryCheckTrue);
            rule.setMulName(mulName);
            ruleList.add(rule);
        }
        return ruleList;
    }

    private void doClickRule() {
        MainEntityType targetBillEntityType;
        FormShowParameter showParameter;
        String targetBillNumber = this.getEntityNumber();
        int row = this.getModel().getEntryCurrentRowIndex(Key_RULE_LIST);
        String conditionJson = (String)this.getModel().getValue(Key_RULE_JSON, row);
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        String relationStr = (String)this.getModel().getValue(Key_RELATION);
        Relation relation = Relation.typeToRelation((String)relationStr);
        boolean targetSelf = false;
        MulTenantBillInfo mulTenantBillInfo = this.getMulTenantBillInfo(true);
        if (mulTenantBillInfo != null && !mulTenantBillInfo.isCurrentTenant()) {
            targetSelf = relation != Relation.SELF && sourceBill.equalsIgnoreCase(mulTenantBillInfo.getEntityNumber());
            showParameter = new CtsyFormShowParameter(mulTenantBillInfo.getTenantId(), mulTenantBillInfo.getAccountId(), FormId_IDI_CONDITION_EDIT);
            showParameter.getCustomParams().put(CustomParam_MULTENANTBILLINFO, IDIJSONUtils.toJsonString((Object)mulTenantBillInfo));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rule" + ((CtsyFormShowParameter)showParameter).getCloseCallBackActionIdSuffix()));
        } else {
            showParameter = new FormShowParameter();
            showParameter.setFormId(FormId_IDI_CONDITION_EDIT);
            targetSelf = relation != Relation.SELF && sourceBill.equalsIgnoreCase(targetBillNumber);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rule"));
        }
        showParameter.getCustomParams().put(CustParamKey_FORMULA, conditionJson);
        showParameter.getCustomParams().put(CustParamKey_ENTITY_NUMBER, targetBillNumber);
        showParameter.getCustomParams().put(CustParamKey_SUPPORTSUBENTRY, Boolean.TRUE.toString());
        showParameter.getCustomParams().put(IDI_CONDITION_CONFIG, "true");
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61", (String)"IDIDecisionFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), true);
        root.setIsOpened(true);
        showParameter.getCustomParams().put(CustParamKey_SUPPORTTARGETSELF, String.valueOf(targetSelf));
        if (StringUtils.isNotEmpty((String)sourceBill)) {
            MainEntityType sourceBillEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
            TreeNode sourceBillTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceBillEntityType, (PropTreeBuildOption)new PropTreeBuildOption());
            String srcMesg = ResManager.loadKDString((String)"\u6e90\u5355", (String)"IDIDecisionFormPlugin_19", (String)"data-idi-formplugin", (Object[])new Object[0]);
            this.updateTreeNode(sourceBillTreeNode, sourceBillEntityType, "", targetSelf ? srcMesg + "_" : "");
            root.addChild(sourceBillTreeNode);
            sourceBillTreeNode.setIsOpened(false);
        }
        if (mulTenantBillInfo != null && !mulTenantBillInfo.isCurrentTenant()) {
            showParameter.getCustomParams().put(CustomParam_RELOADTARGETBILLFIELD, Boolean.TRUE.toString());
        } else if (!(relation == Relation.SELF && sourceBill.equalsIgnoreCase(targetBillNumber) || (targetBillEntityType = this.getTargetEntity()) == null)) {
            TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)targetBillEntityType, (PropTreeBuildOption)new PropTreeBuildOption());
            String targetMesg = ResManager.loadKDString((String)"\u76ee\u6807\u5355", (String)"IDIDecisionFormPlugin_20", (String)"data-idi-formplugin", (Object[])new Object[0]);
            this.updateTreeNode(billTreeNode, targetBillEntityType, targetSelf ? "targetisself_" : "", targetSelf ? targetMesg + "_" : "");
            root.addChild(billTreeNode);
        }
        String fldNodes = SerializationUtils.toJsonString((Object)root);
        showParameter.getCustomParams().put(CustParamKey_TREENODES, fldNodes);
        showParameter.getCustomParams().put(CustParamKey_SOURCEENTITYNUMBER, sourceBill);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void updateTreeNode(TreeNode treeNode, MainEntityType billEntityType, String prefix, String namePrefix) {
        String billNumber = billEntityType.getName();
        String newRootId = prefix + billNumber + "_billObj";
        treeNode.setId(newRootId);
        treeNode.setParentid("root");
        String newName = namePrefix + treeNode.getText();
        treeNode.setText(newName);
        if (treeNode.getChildren() == null) {
            return;
        }
        Set mulBaseDataEntitySet = ExecutorHelper.getMulBaseDataEntity((String)billNumber);
        Map entityTypeMap = billEntityType.getAllEntities();
        for (TreeNode node : treeNode.getChildren()) {
            node.setParentid(treeNode.getId());
            EntityType entityType = (EntityType)entityTypeMap.get(node.getId());
            String newNodeId = entityType instanceof SubEntryType ? treeNode.getId() + "." + entityType.getParent().getName() + "." + node.getId() : treeNode.getId() + "." + node.getId();
            node.setId(newNodeId);
            if (node.getChildren() == null) continue;
            this.updateTreeNodeChild(node, mulBaseDataEntitySet);
        }
    }

    private void updateTreeNodeChild(TreeNode parentNode, Set<String> mulBaseDataEntitySet) {
        boolean isHeadField = parentNode.getId().endsWith("billhead");
        for (TreeNode node : parentNode.getChildren()) {
            node.setParentid(parentNode.getId());
            String newNodeId = isHeadField ? parentNode.getId().replace("billhead", node.getId()) : (node.getId().indexOf(46) > -1 ? parentNode.getId() + node.getId().substring(node.getId().lastIndexOf(46)) : parentNode.getId() + "." + node.getId());
            if (!mulBaseDataEntitySet.isEmpty()) {
                for (String mulEntityNumber : mulBaseDataEntitySet) {
                    if (!node.getId().equals(mulEntityNumber) || newNodeId.contains(mulEntityNumber + ".fbasedataid")) continue;
                    newNodeId = newNodeId.replace(mulEntityNumber, mulEntityNumber + ".fbasedataid");
                }
            }
            node.setId(newNodeId);
            if (node.getChildren() == null) continue;
            this.updateTreeNodeChild(node, mulBaseDataEntitySet);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        if (StringUtils.isEmpty((String)actionId)) {
            return;
        }
        if (actionId.startsWith(ActionId_SET_TARGETQUERYRULE)) {
            this.receiveTargetQueryRule((String)result);
            return;
        }
        if (actionId.startsWith("rule")) {
            this.receiveCondition((String)result, Key_RULE_LIST, Key_RULE_JSON, "rule");
            return;
        }
        switch (actionId) {
            case "setStartCondition": {
                this.receiveStartCondition((String)result);
                break;
            }
            case "setCrossEntryRule": {
                this.receiveCrossEntryRule((String)result);
                break;
            }
            case "setBillField": {
                this.reciveBillField(result);
                break;
            }
            case "setBillType": {
                this.reciveMulTenantBillType(result);
            }
        }
    }

    private void reciveBillField(Object result) {
        if (result != null) {
            String[][] fields = (String[][])result;
            int currrentIndex = this.getModel().getEntryCurrentRowIndex(Key_SHOW_LIST);
            for (int i = 0; i < fields.length; ++i) {
                String[] field = fields[i];
                if (field == null || i != 0) continue;
                this.getModel().setValue(Key_PROPNAME, (Object)field[0], currrentIndex);
                this.getModel().setValue(Key_PROPDISPLAYNAME, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDIDecisionFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]), field[1]), currrentIndex);
            }
        }
    }

    private void receiveTargetQueryRule(String result) {
        IDICondition condition;
        if (!StringUtils.isEmpty((String)result) && (condition = (IDICondition)IDIJSONUtils.cast((String)result, IDICondition.class)) != null) {
            this.getModel().setValue(Key_TARGETQUERYRULE, (Object)(condition.getDescription() != null ? condition.getDescription().getLocaleValue() : ""));
            this.getModel().setValue(Key_TARGETQUERYRULEJSON, (Object)result);
        }
    }

    private void receiveCrossEntryRule(String result) {
        IDICondition condition;
        if (!StringUtils.isEmpty((String)result) && (condition = (IDICondition)IDIJSONUtils.cast((String)result, IDICondition.class)) != null) {
            IDataModel model = this.getModel();
            model.setValue(KEY_CROSSENTRYRULE, (Object)(condition.getDescription() != null ? condition.getDescription().getLocaleValue() : ""));
            model.setValue(KEY_CROSSENTRYRULEJSON, (Object)result);
        }
    }

    private void receiveStartCondition(String result) {
        IDICondition condition;
        if (!StringUtils.isEmpty((String)result) && (condition = (IDICondition)IDIJSONUtils.cast((String)result, IDICondition.class)) != null) {
            String exprTran = this.getExprDesc(condition);
            this.getModel().setValue(Key_STARTCCONDITION_FIELD, (Object)exprTran);
            this.getModel().setValue(Key_STARTCCONDITION_JSON, (Object)result);
        }
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        IDICondition condition;
        if (StringUtils.isNotEmpty((String)conditionJson) && (condition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class)) != null) {
            String exprTran = this.getExprDesc(condition);
            if (!StringUtils.isBlank((String)entryEntityKey)) {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)exprTran, row);
                this.setShowAllEntryCheckTrue();
            }
        }
    }

    private void setShowAllEntryCheckTrue() {
        String[] stringArray;
        int rowIndex;
        int rowCount = this.getModel().getEntryRowCount(Key_RULE_LIST);
        StringBuilder scriptBuild = new StringBuilder();
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String ruleJson = (String)this.getModel().getValue(Key_RULE_JSON, rowIndex);
            if (!StringUtils.isNotEmpty((String)ruleJson)) continue;
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
            scriptBuild.append(condition.getScript()).append(" || ");
        }
        if (scriptBuild.length() <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.getModel().setValue(KEY_SHOWALLENTRYCHECKTRUE, (Object)false, rowIndex);
            }
            return;
        }
        String script = scriptBuild.substring(0, scriptBuild.length() - 3);
        String targetBillNumber = this.getTargetEntityNumber();
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        if (StringUtils.isNotEmpty((String)targetBillNumber)) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = sourceBill;
            stringArray = stringArray2;
            stringArray2[1] = targetBillNumber;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = sourceBill;
        }
        String[] billTypes = stringArray;
        Set propSet = ScriptUtils.getEntries((MainEntityType)EntityMetadataCache.getDataEntityType((String)sourceBill), (String)script, (String[])billTypes);
        if (propSet.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
            for (int rowIndex2 = 0; rowIndex2 < rowCount; ++rowIndex2) {
                this.getModel().setValue(KEY_SHOWALLENTRYCHECKTRUE, (Object)false, rowIndex2);
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
        }
    }

    private String getExprDesc(IDICondition condition) {
        if (condition == null) {
            return "";
        }
        String handDesc = condition.getDescription().toString();
        if (StringUtils.isNotEmpty((String)handDesc)) {
            return handDesc;
        }
        return StringUtils.isNotEmpty((String)condition.getExprTran()) ? condition.getExprTran() : condition.getExpression();
    }

    public void afterCreateNewData(EventObject e) {
        List contents;
        DecisionFrontEndConfig decisionFrontEndConfig;
        List ruleList;
        IDICondition condition;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setVisible(Boolean.FALSE, new String[]{WORDSCONFIG, Key_FLEX_HOVER, FLEX_CROSSENTRY});
        String detailConfig = (String)view.getFormShowParameter().getCustomParam(Key_DETAIL_CONFIG);
        String frontEndConfig = (String)view.getFormShowParameter().getCustomParam(Key_FRONTEND_CONFIG);
        String startConditionJson = (String)view.getFormShowParameter().getCustomParam(CustomParam_START_CONDITION_JSON);
        String targetEntityNumber = (String)view.getFormShowParameter().getCustomParam(CustParamKey_MATCH_BILL);
        String linkupBillConfigStr = (String)view.getFormShowParameter().getCustomParam(CustomParam_LINKUPBILLCONFIG);
        String analysisMode = (String)view.getFormShowParameter().getCustomParam(CustParamKey_ANALYSISMODE);
        boolean isNoScore = AnalysisMode.NOSCORE.getType().equals(analysisMode);
        if (!StringUtils.isEmpty((String)startConditionJson) && (condition = (IDICondition)IDIJSONUtils.cast((String)startConditionJson, IDICondition.class)) != null) {
            String exprTran = this.getExprDesc(condition);
            model.setValue(Key_STARTCCONDITION_FIELD, (Object)exprTran);
            model.setValue(Key_STARTCCONDITION_JSON, (Object)startConditionJson);
        }
        String initEntityBIll = targetEntityNumber;
        LinkUpBillConfig.CheckType checkType = null;
        List deductionGradeConfigList = null;
        if (StringUtils.isNotEmpty((String)linkupBillConfigStr)) {
            MulTenantBillInfo mulTenantBillInfo;
            IDICondition crossEntryRule;
            LinkUpBillConfig linkUpBillConfig = (LinkUpBillConfig)IDIJSONUtils.cast((String)linkupBillConfigStr, LinkUpBillConfig.class);
            checkType = linkUpBillConfig.getCheckType();
            deductionGradeConfigList = linkUpBillConfig.getDeductionGradeConfigList();
            if (checkType != null) {
                model.setValue(Key_CHECKTYPE, (Object)checkType.getType());
                this.changeCheckTypeControl(checkType.getType());
                if (LinkUpBillConfig.CheckType.CheckBillExists.getType().equalsIgnoreCase(checkType.getType())) {
                    model.setValue(TARGETEXISTWORDS, (Object)linkUpBillConfig.getTargetExistWords());
                    model.setValue(TARGETNOTEXISTWORDS, (Object)linkUpBillConfig.getTargetNotExistWords());
                    model.setValue(KEY_EXITALARM, (Object)linkUpBillConfig.isExitAlarm());
                    LocaleString mulTargetExistWords = linkUpBillConfig.getMulTargetExistWords();
                    if (mulTargetExistWords == null) {
                        mulTargetExistWords = new LocaleString(linkUpBillConfig.getTargetExistWords());
                    }
                    model.setValue(MULTARGETEXISTWORDS, (Object)mulTargetExistWords);
                    LocaleString mulTargetNotExistWords = linkUpBillConfig.getMulTargetNotExistWords();
                    if (mulTargetNotExistWords == null) {
                        mulTargetNotExistWords = new LocaleString(linkUpBillConfig.getTargetNotExistWords());
                    }
                    model.setValue(MULTARGETNOTEXISTWORDS, (Object)mulTargetNotExistWords);
                }
            }
            if (linkUpBillConfig.getRelation() != null) {
                model.setValue(Key_RELATION, (Object)linkUpBillConfig.getRelation().getType());
                this.changeRelationControl(linkUpBillConfig.getRelation().getType());
            }
            model.setValue(Key_TARGET, (Object)targetEntityNumber);
            IDICondition condition2 = linkUpBillConfig.getMatchCondition();
            if (condition2 != null) {
                model.setValue(Key_TARGETQUERYRULE, (Object)condition2.getDescription());
                model.setValue(Key_TARGETQUERYRULEJSON, (Object)IDIJSONUtils.toJsonString((Object)condition2));
            }
            if ((crossEntryRule = linkUpBillConfig.getCrossEntryRule()) != null) {
                model.setValue(KEY_CROSSENTRYRULE, (Object)crossEntryRule.getDescription());
                model.setValue(KEY_CROSSENTRYRULEJSON, (Object)IDIJSONUtils.toJsonString((Object)crossEntryRule));
            }
            if (Relation.LINKDOWN == linkUpBillConfig.getRelation()) {
                initEntityBIll = Key_TAERGETNUMBER;
            }
            if ((mulTenantBillInfo = linkUpBillConfig.getMulTenantMatchBill()) != null) {
                DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)"ctsy_tenant", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)mulTenantBillInfo.getTenantNumber())});
                if (tenant != null && mulTenantBillInfo.getTenantId().equals(tenant.getString("tenantid")) && mulTenantBillInfo.getAccountId().equals(tenant.getString("accountid"))) {
                    model.setValue(KEY_TENANT, (Object)tenant);
                    initEntityBIll = Key_TAERGETNUMBER;
                    this.visibleTarget(linkUpBillConfig.getRelation() == null ? null : linkUpBillConfig.getRelation().getType(), tenant);
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u79df\u6237%s\u7f3a\u5931\u3002", (String)"IDIDecisionFormPlugin_21", (String)"data-idi-formplugin", (Object[])new Object[0]), mulTenantBillInfo.getTenantNumber()));
                }
                model.setValue(KEY_TARGETBILL, (Object)mulTenantBillInfo.getBillDisplayName());
                model.setValue(KEY_TARGETBILLNUM, (Object)mulTenantBillInfo.getEntityNumber());
            } else {
                this.visibleTarget(linkUpBillConfig.getRelation() == null ? null : linkUpBillConfig.getRelation().getType(), null);
            }
        } else {
            this.visibleTarget(null, null);
        }
        this.initComboList(initEntityBIll, Key_BILLTYPE);
        if (StringUtils.isNotEmpty((String)detailConfig) && (ruleList = IDIJSONUtils.jsonCastToList((String)detailConfig, DecisionRule.class)) != null) {
            model.deleteEntryData(Key_RULE_LIST);
            for (DecisionRule rule : ruleList) {
                int row = model.createNewEntryRow(Key_RULE_LIST);
                model.setValue(Key_TITLE, (Object)rule.getName(), row);
                model.setValue(Key_ISPASS, (Object)rule.isPass(), row);
                if (!isNoScore) {
                    model.setValue(Key_PERCENT, (Object)rule.getDeductionGradePercent(), row);
                }
                model.setValue(Key_STATUS, (Object)rule.getDecisionStatus(), row);
                model.setValue("rule", (Object)this.getExprDesc(rule.getRule()), row);
                String ruleJson = rule.getRule() == null ? "" : IDIJSONUtils.toJsonString((Object)rule.getRule());
                model.setValue(Key_RULE_JSON, (Object)ruleJson, row);
                model.setValue(KEY_SHOWALLCHECKTRUE, (Object)rule.isShowAllCheckTrue(), row);
                model.setValue(KEY_SHOWALLENTRYCHECKTRUE, (Object)rule.isShowAllEntryCheckTrue(), row);
                LocaleString mulName = rule.getMulName();
                if (mulName == null) {
                    mulName = new LocaleString(Lang.zh_CN.toString(), rule.getName());
                }
                model.setValue(Key_MULTITLE, (Object)mulName, row);
            }
            this.setShowAllEntryCheckTrue();
        }
        if (isNoScore) {
            view.setVisible(Boolean.FALSE, new String[]{Key_PERCENT});
        }
        this.changeCommonSetEntry(checkType == null ? null : checkType.getType(), deductionGradeConfigList, isNoScore);
        if (StringUtils.isNotEmpty((String)frontEndConfig) && (decisionFrontEndConfig = (DecisionFrontEndConfig)IDIJSONUtils.cast((String)frontEndConfig, DecisionFrontEndConfig.class)) != null && (contents = decisionFrontEndConfig.getHoverFieldContents()) != null) {
            Map<String, String> srcFieldMap = null;
            Map<String, String> targetFieldMap = null;
            for (DecisionFrontEndConfigField configField : contents) {
                int row = model.createNewEntryRow(Key_SHOW_LIST);
                String billType = configField.getBillType();
                boolean isSrc = "srcbill".equals(billType);
                if (isSrc && srcFieldMap == null) {
                    String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
                    srcFieldMap = this.achieveFieldCaption(EntityMetadataCache.getDataEntityType((String)sourceBill));
                }
                if (!isSrc && targetFieldMap == null) {
                    targetFieldMap = this.achieveFieldCaption(EntityMetadataCache.getDataEntityType((String)targetEntityNumber));
                }
                Map<String, String> fieldMap = isSrc ? srcFieldMap : targetFieldMap;
                model.setValue(Key_BILLTYPE, (Object)configField.getBillType(), row);
                String mulPropDisplayName = fieldMap != null ? fieldMap.get(configField.getPropName()) : null;
                model.setValue(Key_PROPDISPLAYNAME, (Object)(StringUtils.isNotEmpty((String)mulPropDisplayName) ? mulPropDisplayName : configField.getPropDisplayName()), row);
                model.setValue(Key_PROPNAME, (Object)configField.getPropName(), row);
                model.setValue(Key_DISPLAYNAME, (Object)configField.getDisplayName(), row);
                LocaleString mulDisplayName = configField.getMulDisplayName();
                if (mulDisplayName == null) {
                    mulDisplayName = new LocaleString(Lang.zh_CN.toString(), configField.getDisplayName());
                }
                model.setValue(Key_MULDISPLAYNAME, (Object)mulDisplayName, row);
            }
        }
    }

    private void changeCommonSetEntry(String checkType, List<DeductionGradeConfig> dataList, boolean isNoScore) {
        if (StringUtils.isEmpty((String)checkType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_COMMONSET, Key_SETENTRY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_COMMONSET, Key_SETENTRY});
            this.getView().setVisible(Boolean.valueOf(!isNoScore), new String[]{Key_DEDUCTPERCENT});
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData(Key_SETENTRY);
            AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField(Key_DEDUCTITEM, new Object[0]);
            if (!isNoScore) {
                tvs.addField(Key_DEDUCTPERCENT, new Object[0]);
            }
            tvs.addField(Key_COMMONPASS, new Object[0]);
            if (dataList != null && !dataList.isEmpty()) {
                for (DeductionGradeConfig dgc : dataList) {
                    if (isNoScore) {
                        tvs.addRow(new Object[]{dgc.getItem().getType(), dgc.isPass()});
                        continue;
                    }
                    tvs.addRow(new Object[]{dgc.getItem().getType(), dgc.getPercent(), dgc.isPass()});
                }
            } else {
                String[] items;
                String[] stringArray;
                if (LinkUpBillConfig.CheckType.CheckBillExists.getType().equals(checkType)) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH.getType();
                } else {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH.getType();
                    stringArray3[1] = DeductionGradeConfig.DeductionGradeItem.NO_BILL.getType();
                    stringArray = stringArray3;
                    stringArray3[2] = DeductionGradeConfig.DeductionGradeItem.NO_MATCH_RULE.getType();
                }
                for (String item : items = stringArray) {
                    if (isNoScore) {
                        tvs.addRow(new Object[]{item, true});
                        continue;
                    }
                    tvs.addRow(new Object[]{item, 0, true});
                }
            }
            model.beginInit();
            model.batchCreateNewEntryRow(Key_SETENTRY, tvs);
            model.endInit();
            this.getView().updateView(Key_SETENTRY);
        }
    }

    private void initComboList(String entityNumber, String ... keys) {
        List<ComboItem> comboData = this.getComboData(entityNumber);
        for (String key : keys) {
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl(key);
            comboEdit.setComboItems(comboData);
        }
    }

    private List<ComboItem> getComboData(String entityNumber) {
        ComboItem comboItem;
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        String sourceEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        if (StringUtils.isNotEmpty((String)sourceEntityNumber)) {
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5", (String)"IDIDecisionFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0])));
            comboItem.setValue("srcbill");
            list.add(comboItem);
        }
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5b57\u6bb5", (String)"IDIDecisionFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0])));
            comboItem.setValue("linkupbill");
            list.add(comboItem);
        }
        return list;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isInterruptPropertyChange()) {
            this.clearInterruptPropertyChange();
            return;
        }
        String property = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (property) {
            case "relation": {
                String oldValue = (String)e.getChangeSet()[0].getOldValue();
                this.changeRelation((String)newValue, oldValue);
                break;
            }
            case "checktype": {
                this.changeCheckType((String)newValue);
                String analysisMode = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ANALYSISMODE);
                boolean isNoScore = AnalysisMode.NOSCORE.getType().equals(analysisMode);
                this.changeCommonSetEntry((String)newValue, null, isNoScore);
                break;
            }
            case "target": {
                this.changeTarget(newValue);
                break;
            }
            case "startcondition": {
                this.changeStartCondition(newValue);
                break;
            }
            case "targetqueryrule": {
                this.changeTargetRule((String)newValue);
                break;
            }
            case "billtype": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                this.changeBillTypeInFieldList(rowIndex);
                break;
            }
            case "rule": {
                int ruleIndex = e.getChangeSet()[0].getRowIndex();
                this.changeRule((String)newValue, ruleIndex);
                this.updateHoverConfig();
                break;
            }
            case "crossentryrule": {
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                this.getModel().setValue(KEY_CROSSENTRYRULEJSON, (Object)"");
                break;
            }
            case "propdisplayname": {
                if (!StringUtils.isEmpty((String)String.valueOf(newValue))) break;
                int currentIndex = this.getModel().getEntryCurrentRowIndex(Key_SHOW_LIST);
                this.getModel().setValue(Key_PROPNAME, null, currentIndex);
                this.getModel().setValue(Key_DISPLAYNAME, null, currentIndex);
                this.getModel().setValue(Key_PROPDISPLAYNAME, null, currentIndex);
                break;
            }
            case "showallchecktrue": {
                this.changeShowAll((Boolean)newValue, KEY_SHOWALLENTRYCHECKTRUE);
                break;
            }
            case "showallentrychecktrue": {
                this.changeShowAll((Boolean)newValue, KEY_SHOWALLCHECKTRUE);
                break;
            }
            case "tenant": {
                this.changeTenant(newValue);
                break;
            }
            case "targetbill": {
                this.changeMulTarget((String)newValue);
                break;
            }
        }
    }

    private void changeShowAll(Boolean currentValue, String targetField) {
        int rowCount;
        if (currentValue.booleanValue() && (rowCount = this.getModel().getEntryRowCount(Key_RULE_LIST)) > 0) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                boolean targetValue = (Boolean)this.getModel().getValue(targetField, rowIndex);
                if (targetValue) {
                    this.interruptPropertyChange();
                }
                this.getModel().setValue(targetField, (Object)false, rowIndex);
            }
        }
    }

    private void clearInterruptPropertyChange() {
        this.getPageCache().remove(PAGECACHE_INTERRUPT);
    }

    private boolean isInterruptPropertyChange() {
        return Boolean.parseBoolean(this.getPageCache().get(PAGECACHE_INTERRUPT));
    }

    private void interruptPropertyChange() {
        this.getPageCache().put(PAGECACHE_INTERRUPT, "true");
    }

    private void changeRule(String rule, int rowIndex) {
        if (StringUtils.isEmpty((String)rule)) {
            this.getModel().setValue(Key_RULE_JSON, (Object)"", rowIndex);
        }
    }

    private void changeBillTypeInFieldList(int rowIndex) {
        this.getModel().setValue(Key_PROPNAME, (Object)"", rowIndex);
        this.getModel().setValue(Key_PROPDISPLAYNAME, (Object)"", rowIndex);
    }

    private void changeTargetRule(String newValue) {
        if (StringUtils.isEmpty((String)newValue)) {
            this.getModel().setValue(Key_TARGETQUERYRULEJSON, (Object)"");
        }
    }

    private void changeStartCondition(Object newValue) {
        if (StringUtils.isEmpty((String)((String)newValue))) {
            this.getModel().setValue(Key_STARTCCONDITION_JSON, (Object)"");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String targetEntityNumber;
        FormOperate operate = (FormOperate)args.getSource();
        if ("newentry".equalsIgnoreCase(operate.getType()) && StringUtils.isEmpty((String)(targetEntityNumber = this.getTargetEntityNumber()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u76ee\u6807\u5355\u7c7b\u578b\u201d\u3002", (String)"IDIDecisionFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void changeTarget(Object newValue) {
        this.getModel().deleteEntryData(Key_RULE_LIST);
        this.getModel().deleteEntryData(Key_SHOW_LIST);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
        this.getModel().setValue(Key_TARGETQUERYRULE, null);
        this.getModel().setValue(Key_TARGETQUERYRULEJSON, null);
        this.initComboList(newValue == null ? null : (String)((DynamicObject)newValue).get("id"), Key_BILLTYPE);
    }

    private void changeCheckType(String checkType) {
        this.changeCheckTypeControl(checkType);
        this.getModel().deleteEntryData(Key_RULE_LIST);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
    }

    private void changeCheckTypeControl(String checkType) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid ruleEntry = (EntryGrid)this.getControl(Key_RULE_LIST);
        if (LinkUpBillConfig.CheckType.CheckBillContent.getType().equalsIgnoreCase(checkType)) {
            view.setVisible(Boolean.TRUE, new String[]{Key_FLEX_RULEPANEL});
            String relation = (String)model.getValue(Key_RELATION);
            if (Relation.LINKDOWN.getType().equalsIgnoreCase(relation)) {
                model.setValue(Key_RELATION, (Object)"");
            }
            if (Relation.SELF.getType().equalsIgnoreCase(relation)) {
                view.setVisible(Boolean.TRUE, new String[]{FLEX_CROSSENTRY});
            }
            view.setVisible(Boolean.FALSE, new String[]{WORDSCONFIG});
            model.deleteEntryData(Key_SHOW_LIST);
            model.setValue(TARGETEXISTWORDS, (Object)"");
            model.setValue(TARGETNOTEXISTWORDS, (Object)"");
            model.setValue(KEY_EXITALARM, (Object)Boolean.FALSE);
            ruleEntry.setMustInput(Key_MULTITLE, true);
            ruleEntry.setMustInput("rule", true);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{Key_FLEX_RULEPANEL});
            view.setVisible(Boolean.TRUE, new String[]{WORDSCONFIG});
            view.setVisible(Boolean.FALSE, new String[]{FLEX_CROSSENTRY});
            model.setValue(KEY_CROSSENTRYRULE, (Object)"");
            model.setValue(KEY_CROSSENTRYRULEJSON, (Object)"");
            ruleEntry.setMustInput(Key_MULTITLE, false);
            ruleEntry.setMustInput("rule", false);
        }
    }

    private void changeRelation(String relation, String oldValue) {
        this.changeRelationControl(relation);
        this.getModel().setValue(Key_TARGET, null);
        this.getModel().setValue(Key_TARGETQUERYRULE, null);
        this.getModel().setValue(Key_TARGETQUERYRULEJSON, null);
        if (Relation.SELF.getType().equalsIgnoreCase(relation)) {
            this.initComboList(null, Key_BILLTYPE);
        }
        if (Relation.SELF.getType().equalsIgnoreCase(oldValue) || Relation.LINKDOWN.getType().equalsIgnoreCase(relation)) {
            this.getModel().deleteEntryData(Key_RULE_LIST);
            this.getModel().deleteEntryData(Key_SHOW_LIST);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
        }
    }

    private void changeRelationControl(String relation) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setVisible(Boolean.FALSE, new String[]{FLEX_CROSSENTRY});
        model.setValue(KEY_CROSSENTRYRULE, (Object)"");
        model.setValue(KEY_CROSSENTRYRULEJSON, (Object)"");
        if (Relation.SELF.getType().equalsIgnoreCase(relation)) {
            view.setVisible(Boolean.FALSE, new String[]{Key_TARGETQUERYRULE});
            String checkType = (String)model.getValue(Key_CHECKTYPE);
            if (LinkUpBillConfig.CheckType.CheckBillContent.getType().equalsIgnoreCase(checkType)) {
                view.setVisible(Boolean.TRUE, new String[]{FLEX_CROSSENTRY});
            }
        } else if (Relation.BOTP.getType().equalsIgnoreCase(relation) || Relation.LINKDOWN.getType().equalsIgnoreCase(relation)) {
            view.setVisible(Boolean.FALSE, new String[]{Key_TARGETQUERYRULE});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{Key_TARGETQUERYRULE});
        }
        this.visibleTarget(relation, model.getValue(KEY_TENANT));
    }

    private String getEntityNumber() {
        String relation = (String)this.getModel().getValue(Key_RELATION);
        if (Relation.SELF.getType().equalsIgnoreCase(relation)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        }
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(Key_TARGET);
        return dynamicObject == null ? null : (String)dynamicObject.getPkValue();
    }

    private String getTargetEntityNumber() {
        String relation = (String)this.getModel().getValue(Key_RELATION);
        if (Relation.SELF.getType().equalsIgnoreCase(relation)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        }
        DynamicObject tenantObject = (DynamicObject)this.getModel().getValue(KEY_TENANT);
        if (tenantObject != null) {
            return (String)this.getModel().getValue(KEY_TARGETBILLNUM);
        }
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(Key_TARGET);
        return dynamicObject == null ? null : (String)dynamicObject.getPkValue();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            this.updateHoverConfig();
        }
    }

    private void updateHoverConfig() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String srcEntityType = (String)formShowParameter.getCustomParam(CustParamKey_ENTITY_NUMBER);
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)srcEntityType);
        MainEntityType targetMainType = this.getTargetEntity();
        String targetEntityType = targetMainType == null ? null : targetMainType.getName();
        DynamicObjectCollection ruleDyCol = model.getEntryEntity(Key_RULE_LIST);
        String relationStr = (String)this.getModel().getValue(Key_RELATION);
        Relation relation = Relation.typeToRelation((String)relationStr);
        boolean targetSelf = relation != Relation.SELF && srcEntityType.equalsIgnoreCase(targetEntityType);
        Set<String> srcEntrySet = this.getEntrySet(ruleDyCol, srcEntityType, srcMainType);
        Set<String> targetEntrySet = this.getEntrySet(ruleDyCol, targetSelf ? "targetisself_" + targetEntityType : targetEntityType, targetMainType);
        int entryRowCount = model.getEntryRowCount(Key_SHOW_LIST);
        HashSet<Integer> deleteEntryIndexList = new HashSet<Integer>();
        for (int i2 = 0; i2 < entryRowCount; ++i2) {
            DynamicObject entryRowEntity = model.getEntryRowEntity(Key_SHOW_LIST, i2);
            String billType = entryRowEntity.getString(Key_BILLTYPE);
            String billEntityType = "srcbill".equals(billType) ? srcEntityType : targetEntityType;
            MainEntityType billMainType = "srcbill".equals(billType) ? srcMainType : targetMainType;
            Set<String> entrySet = "srcbill".equals(billType) ? srcEntrySet : targetEntrySet;
            String showField = entryRowEntity.getString(Key_PROPNAME);
            String showScript = billEntityType + "_billObj." + showField;
            Set showEntrySet = ScriptUtils.getLeastLevelEntries((MainEntityType)billMainType, (String)showScript, (String[])new String[]{billEntityType});
            if (showEntrySet.isEmpty()) continue;
            boolean deleteFlag = true;
            block1: for (String showEntry : showEntrySet) {
                for (String entry : entrySet) {
                    if (!showEntry.equals(entry)) continue;
                    deleteFlag = false;
                    continue block1;
                }
            }
            if (!deleteFlag) continue;
            deleteEntryIndexList.add(i2);
        }
        if (!deleteEntryIndexList.isEmpty()) {
            int[] deleteEntryIndexs = deleteEntryIndexList.stream().filter(Objects::nonNull).mapToInt(i -> i).toArray();
            this.getModel().deleteEntryRows(Key_SHOW_LIST, deleteEntryIndexs);
            this.getView().updateView(Key_SHOW_LIST);
        }
    }

    private Set<String> getEntrySet(DynamicObjectCollection ruleDyCol, String entityType, MainEntityType mainType) {
        HashSet<String> entrySet = new HashSet<String>();
        for (DynamicObject ruleDy : ruleDyCol) {
            String ruleJson = ruleDy.getString(Key_RULE_JSON);
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
            if (condition == null) continue;
            String script = condition.getScript();
            Set fieldSet = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{entityType});
            for (String field : fieldSet) {
                Set fieldEntrySet;
                if (!field.startsWith(entityType) || (fieldEntrySet = ScriptUtils.getEntries((MainEntityType)mainType, (String)(field.startsWith("targetisself_") ? field.substring("targetisself_".length()) : field), (String[])new String[]{entityType})).isEmpty()) continue;
                entrySet.addAll(fieldEntrySet);
            }
        }
        return entrySet;
    }

    private void changeTenant(Object newValue) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue(KEY_TARGETBILL, null);
        dataModel.setValue(KEY_TARGETBILLNUM, null);
        String relation = (String)this.getModel().getValue(Key_RELATION);
        this.visibleTarget(relation, newValue);
    }

    private void visibleTarget(String relation, Object tenantValue) {
        if (Relation.SELF.getType().equalsIgnoreCase(relation)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{Key_TARGET, KEY_TARGETBILL, KEY_TENANT});
            return;
        }
        boolean visibleTenant = !ParamFactory.getBotpInterface();
        this.getView().setVisible(Boolean.valueOf(visibleTenant), new String[]{KEY_TENANT});
        if (tenantValue == null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{Key_TARGET});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_TARGETBILL});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_TARGETBILL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{Key_TARGET});
        }
    }

    private void showBillType() {
        DynamicObject tenantObj = (DynamicObject)this.getModel().getValue(KEY_TENANT);
        if (tenantObj == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u79df\u6237\u201d\u3002", (String)"IDIDecisionFormPlugin_22", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        IDIEntityObjectList.openF7Form(this, String.valueOf(tenantObj.getPkValue()), ActionId_SET_BILLTYPE);
    }

    private void reciveMulTenantBillType(Object result) {
        if (result != null) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)result;
            for (ListSelectedRow row : data) {
                String formId = (String)row.getPrimaryKeyValue();
                String displayName = row.getName();
                this.getModel().setValue(KEY_TARGETBILLNUM, (Object)formId);
                this.getModel().setValue(KEY_TARGETBILL, (Object)displayName);
            }
        }
    }

    private MulTenantBillInfo getMulTenantBillInfo(boolean needEntityNumber) {
        MulTenantBillInfo billInfo = new MulTenantBillInfo();
        DynamicObject tenantObj = (DynamicObject)this.getModel().getValue(KEY_TENANT);
        if (tenantObj == null) {
            return null;
        }
        billInfo.setTenantNumber(tenantObj.getString("number"));
        billInfo.setTenantId(tenantObj.getString("tenantid"));
        billInfo.setAccountId(tenantObj.getString("accountid"));
        String targetBill = (String)this.getModel().getValue(KEY_TARGETBILL);
        String targetBillNumber = (String)this.getModel().getValue(KEY_TARGETBILLNUM);
        if (StringUtils.isEmpty((String)targetBillNumber) && needEntityNumber) {
            return null;
        }
        billInfo.setEntityNumber(targetBillNumber);
        billInfo.setBillDisplayName(targetBill);
        return billInfo;
    }

    private MainEntityType getTargetEntity() {
        MulTenantBillInfo mulTenantBillInfo = this.getMulTenantBillInfo(true);
        String targetEntity = this.getEntityNumber();
        if (mulTenantBillInfo != null) {
            return mulTenantBillInfo.achieveBIllEntityType();
        }
        if (StringUtils.isNotEmpty((String)targetEntity)) {
            return EntityMetadataCache.getDataEntityType((String)targetEntity);
        }
        return null;
    }

    private void changeMulTarget(String mulEntityName) {
        if (StringUtils.isNotEmpty((String)mulEntityName)) {
            String targetNumber = (String)this.getModel().getValue(KEY_TARGETBILLNUM);
            DynamicObject entityobject = BusinessDataServiceHelper.newDynamicObject((String)"bos_entityobject");
            entityobject.set("id", (Object)targetNumber);
            this.changeTarget(entityobject);
        } else {
            this.getModel().setValue(KEY_TARGETBILLNUM, null);
            this.changeTarget(null);
        }
    }

    private Map<String, String> achieveFieldCaption(MainEntityType entityType) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(10);
        if (entityType == null) {
            return fieldMap;
        }
        Map entityTypeMap = entityType.getAllEntities();
        List cols = FilterGridHelper.getAllFilterColumns((MainEntityType)entityType);
        String billEntityType = entityType.getName();
        for (Map map : cols) {
            boolean isEntry;
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            String value = fieldName;
            boolean entryEntityNotEmpty = StringUtils.isNotEmpty((String)entryEntity);
            boolean bl = isEntry = !billEntityType.equals(entryEntity);
            if (entryEntityNotEmpty && isEntry) {
                EntityType entryType = (EntityType)entityTypeMap.get(entryEntity);
                value = entryType instanceof SubEntryType ? entryType.getParent().getName() + "." + entryEntity + "." + fieldName : entryEntity + "." + fieldName;
            }
            fieldMap.put(value, fieldCaption);
        }
        return fieldMap;
    }
}

