/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.data.idi.decision.model.EntityDataQueryParamApi;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.util.DynamicObjectCopyMergeUtil;

public class IDIEntityObjectList
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(IDIEntityObjectList.class);
    private static final String CUSTOMPARAM_TENANTID = "tenantId";
    private static final String CUSTOMPARAM_ISF7 = "isF7";

    public void initialize() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        boolean isF7 = (Boolean)fsp.getCustomParam(CUSTOMPARAM_ISF7);
        if (isF7) {
            BillList list = (BillList)this.getControl("billlistap");
            String tenantId = (String)fsp.getCustomParam(CUSTOMPARAM_TENANTID);
            try {
                final DynamicObject tenant = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(tenantId), (String)"ctsy_tenant");
                RequestContext rc = RequestContext.get();
                String curTenantId = rc.getTenantId();
                String accountId = rc.getAccountId();
                if (!curTenantId.equals(tenant.getString("tenantid")) || !accountId.equals(tenant.getString("accountid"))) {
                    list.addCreateListDataProviderListener(new CreateListDataProviderListener(){

                        public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
                            beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new F7DataProvider(tenant));
                        }
                    });
                }
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
    }

    protected static void openF7Form(AbstractFormPlugin parentPlugin, String tenantId, String actionId) {
        ListShowParameter listShowParameter = CoreShowFormHelper.createShowListForm((String)"idi_entityobjectlist", (boolean)false);
        listShowParameter.setFormId("bos_treelistf7");
        listShowParameter.setCustomParam(CUSTOMPARAM_TENANTID, (Object)tenantId);
        listShowParameter.setCustomParam(CUSTOMPARAM_ISF7, (Object)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)parentPlugin, actionId));
        parentPlugin.getView().showForm((FormShowParameter)listShowParameter);
    }

    private static class F7DataProvider
    extends ListDataProvider {
        private DynamicObject tenantObj;

        public F7DataProvider(DynamicObject tenantObj) {
            this.tenantObj = tenantObj;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            EntityDataQueryParamApi param;
            DynamicObjectCollection realDatas;
            QueryBuilder qb = this.getQueryBuilder();
            QFilter[] filters = qb.getFilters();
            ArrayList<String> filterList = new ArrayList<String>(10);
            if (filters != null && filters.length > 0) {
                for (QFilter filter : filters) {
                    if (filter == null) continue;
                    filterList.add(filter.toSerializedString());
                }
            }
            if ((realDatas = ExecutorHelper.loadCrossTenantEntityData((DynamicObject)this.tenantObj, (EntityDataQueryParamApi)(param = new EntityDataQueryParamApi(qb.getSelectFields(), qb.getEntityName(), filterList, qb.getOrderBys(), start, limit)), (boolean)false)) != null && !realDatas.isEmpty() && qb.getReturnEntityType() != null) {
                DynamicObjectCollection returnDatCols = new DynamicObjectCollection(qb.getReturnEntityType(), null);
                for (DynamicObject realData : realDatas) {
                    DynamicObject target = returnDatCols.addNew();
                    DynamicObjectCopyMergeUtil.mergeDynamicObject((DynamicObject)realData, (DynamicObject)target);
                }
                return returnDatCols;
            }
            return realDatas;
        }

        public int getRealCount() {
            return 1;
        }

        public int getMaxCount() {
            return 1;
        }

        public boolean isExceedMaxCount() {
            return false;
        }

        public int getBillDataCount() {
            return 1;
        }

        protected boolean isRegisterProperty() {
            return true;
        }
    }
}

