/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.InvoiceImageResult;
import kd.data.idi.data.InvoiceImageRuleResult;
import kd.data.idi.util.IDIJSONUtils;

public class IDIInvoiceViewFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener {
    private static final String KEY_CONTROL_ENTRYENTITY = "entryentity";
    private static final String KEY_CONTROL_ERRORENTRY = "errorentry";
    private static final String KEY_CONTROL_TREEVIEWAP = "treeviewap";
    private static final String KEY_CONTROL_INVOICEIMAGE = "invoiceimage";
    private static final String KEY_FIELD_ERRORINVOICENO = "errorinvoiceno";
    private static final String KEY_FIELD_INVOICECONFIG = "invoiceconfig";
    private static final String KEY_FIELD_ERRORITEM = "erroritem";
    private static final String KEY_PARAMETER_INVOICERESULT = "invoiceresult";
    private Map<String, String> invoiceTypeMap = new HashMap<String, String>(){
        {
            this.put("1", ResManager.loadKDString((String)"\u666e\u901a\u7535\u5b50\u53d1\u7968", (String)"IDIInvoiceViewFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("2", ResManager.loadKDString((String)"\u7535\u5b50\u53d1\u7968\u4e13\u7968", (String)"IDIInvoiceViewFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("3", ResManager.loadKDString((String)"\u666e\u901a\u7eb8\u8d28\u53d1\u7968", (String)"IDIInvoiceViewFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("4", ResManager.loadKDString((String)"\u4e13\u7528\u7eb8\u8d28\u53d1\u7968", (String)"IDIInvoiceViewFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("5", ResManager.loadKDString((String)"\u666e\u901a\u7eb8\u8d28\u5377\u7968", (String)"IDIInvoiceViewFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("6", ResManager.loadKDString((String)"6", (String)"IDIInvoiceViewFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("7", ResManager.loadKDString((String)"\u901a\u7528\u673a\u6253", (String)"IDIInvoiceViewFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("8", ResManager.loadKDString((String)"\u7684\u58eb\u7968", (String)"IDIInvoiceViewFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("9", ResManager.loadKDString((String)"\u706b\u8f66\u7968", (String)"IDIInvoiceViewFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("10", ResManager.loadKDString((String)"\u98de\u673a\u7968", (String)"IDIInvoiceViewFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("11", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"IDIInvoiceViewFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("12", ResManager.loadKDString((String)"\u673a\u52a8\u8f66", (String)"IDIInvoiceViewFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("13", ResManager.loadKDString((String)"\u4e8c\u624b\u8f66", (String)"IDIInvoiceViewFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("14", ResManager.loadKDString((String)"\u5b9a\u989d\u53d1\u7968", (String)"IDIInvoiceViewFormPlugin_13", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("15", ResManager.loadKDString((String)"\u901a\u884c\u8d39", (String)"IDIInvoiceViewFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("16", ResManager.loadKDString((String)"\u5ba2\u8fd0\u53d1\u7968", (String)"IDIInvoiceViewFormPlugin_15", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("17", ResManager.loadKDString((String)"\u8fc7\u8def\u8fc7\u6865\u8d39", (String)"IDIInvoiceViewFormPlugin_16", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("18", ResManager.loadKDString((String)"\u8f66\u8239\u7a0e\u53d1\u7968\uff08\u4e13\u7968\uff09", (String)"IDIInvoiceViewFormPlugin_17", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("19", ResManager.loadKDString((String)"\u5b8c\u7a0e\u8bc1\u660e", (String)"IDIInvoiceViewFormPlugin_18", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("20", ResManager.loadKDString((String)"\u8f6e\u8239\u7968", (String)"IDIInvoiceViewFormPlugin_19", (String)"data-idi-formplugin", (Object[])new Object[0]));
            this.put("21", ResManager.loadKDString((String)"\u9152\u5e97\u8d26\u5355", (String)"IDIInvoiceViewFormPlugin_20", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
    };
    private static final String KEY_CONSTANT_ISTYPE = "isType";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid entryEntity = (AbstractGrid)this.getControl(KEY_CONTROL_ENTRYENTITY);
        entryEntity.addRowClickListener((RowClickEventListener)this);
        TreeView tv = (TreeView)this.getControl(KEY_CONTROL_TREEVIEWAP);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        LinkedHashMap<String, List<InvoiceImageResult>> normalMap;
        ArrayList<InvoiceImageResult> errorList;
        String invoiceResult = this.getInvoiceResult();
        if (!StringUtils.isEmpty((String)invoiceResult)) {
            List list = IDIJSONUtils.jsonCastToList((String)invoiceResult, InvoiceImageResult.class);
            errorList = new ArrayList<InvoiceImageResult>();
            normalMap = new LinkedHashMap<String, List<InvoiceImageResult>>();
            for (InvoiceImageResult result : list) {
                boolean isPass = true;
                if (result.getRuleResults() != null && !result.getRuleResults().isEmpty()) {
                    for (InvoiceImageRuleResult rule : result.getRuleResults()) {
                        if (rule.isPass()) continue;
                        isPass = false;
                        break;
                    }
                }
                if (isPass) {
                    String invoiceType = result.getInvoiceType();
                    ArrayList<InvoiceImageResult> typeList = (ArrayList<InvoiceImageResult>)normalMap.get(invoiceType);
                    if (typeList == null) {
                        typeList = new ArrayList<InvoiceImageResult>();
                        normalMap.put(invoiceType, typeList);
                    }
                    typeList.add(result);
                    continue;
                }
                errorList.add(result);
            }
        } else {
            throw new KDException(new ErrorCode("", ""), new Object[]{"invoceresult is empty"});
        }
        this.initErrorCarEntry(errorList);
        this.initNormalTree(normalMap);
    }

    private void initNormalTree(Map<String, List<InvoiceImageResult>> normalMap) {
        if (normalMap == null) {
            normalMap = new HashMap<String, List<InvoiceImageResult>>();
        }
        String rootId = Uuid8.generateShortUuid();
        TreeNode root = new TreeNode("", rootId, ResManager.loadKDString((String)"\u6b63\u5e38\u7968\u636e", (String)"IDIInvoiceViewFormPlugin_21", (String)"data-idi-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        TreeNode firstNode = null;
        for (Map.Entry<String, List<InvoiceImageResult>> entry : normalMap.entrySet()) {
            String invoiceType = entry.getKey();
            List<InvoiceImageResult> childList = entry.getValue();
            TreeNode typeNode = new TreeNode(rootId, invoiceType + "_" + KEY_CONSTANT_ISTYPE, this.invoiceTypeMap.get(invoiceType));
            root.addChild(typeNode);
            for (InvoiceImageResult result : childList) {
                TreeNode tn = new TreeNode(invoiceType, result.getInvoiceNo(), result.getInvoiceNo());
                if (firstNode == null) {
                    firstNode = tn;
                    typeNode.setIsOpened(true);
                }
                typeNode.addChild(tn);
            }
        }
        TreeView tv = (TreeView)this.getControl(KEY_CONTROL_TREEVIEWAP);
        tv.addNode(root);
        if (firstNode != null) {
            tv.focusNode(firstNode);
            TreeNodeEvent evt = new TreeNodeEvent((Object)tv, (Object)firstNode.getParentid(), (Object)firstNode.getId());
            this.treeNodeClick(evt);
        }
        this.getView().updateView(KEY_CONTROL_TREEVIEWAP);
    }

    private void initErrorCarEntry(List<InvoiceImageResult> errorList) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(KEY_CONTROL_ENTRYENTITY);
        if (errorList == null || errorList.isEmpty()) {
            return;
        }
        dataModel.beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(KEY_FIELD_ERRORINVOICENO, new Object[0]);
        tvs.addField(KEY_FIELD_INVOICECONFIG, new Object[0]);
        for (InvoiceImageResult result : errorList) {
            tvs.addRow(new Object[]{result.getInvoiceNo(), IDIJSONUtils.toJsonString((Object)result)});
        }
        model.batchCreateNewEntryRow(KEY_CONTROL_ENTRYENTITY, tvs);
        this.getView().updateView(KEY_CONTROL_ENTRYENTITY);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String invoiceResult;
        String nodeId = (String)evt.getNodeId();
        String parentId = (String)evt.getParentNodeId();
        if (!(StringUtils.isEmpty((String)parentId) || nodeId.endsWith(KEY_CONSTANT_ISTYPE) || StringUtils.isEmpty((String)(invoiceResult = this.getInvoiceResult())))) {
            InvoiceImageResult selectData = null;
            List list = IDIJSONUtils.jsonCastToList((String)invoiceResult, InvoiceImageResult.class);
            if (list != null && !list.isEmpty()) {
                for (InvoiceImageResult result : list) {
                    if (!result.getInvoiceNo().equalsIgnoreCase(nodeId)) continue;
                    selectData = result;
                    break;
                }
                if (selectData == null) {
                    throw new KDException(new ErrorCode("", ""), new Object[]{"click node is null"});
                }
                this.getModel().deleteEntryData(KEY_CONTROL_ERRORENTRY);
                this.processImage(selectData.getImageNo());
            }
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        this.treeNodeClick(evt);
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        if (rowIndex > -1) {
            IDataModel model = this.getModel();
            String invoiceConfigStr = (String)this.getModel().getValue(KEY_FIELD_INVOICECONFIG);
            if (StringUtils.isNotEmpty((String)invoiceConfigStr)) {
                InvoiceImageResult result = (InvoiceImageResult)IDIJSONUtils.cast((String)invoiceConfigStr, InvoiceImageResult.class);
                model.deleteEntryData(KEY_CONTROL_ERRORENTRY);
                model.beginInit();
                AbstractFormDataModel abModel = (AbstractFormDataModel)model;
                TableValueSetter tv = new TableValueSetter(new String[0]);
                tv.addField(KEY_FIELD_ERRORITEM, new Object[0]);
                List ruleList = result.getRuleResults();
                for (InvoiceImageRuleResult rule : ruleList) {
                    if (rule.isPass()) continue;
                    tv.addRow(new Object[]{rule.getText()});
                }
                abModel.batchCreateNewEntryRow(KEY_CONTROL_ERRORENTRY, tv);
                this.getView().updateView(KEY_CONTROL_ERRORENTRY);
                this.processImage(result.getImageNo());
            }
        }
    }

    private void processImage(String imageNo) {
        RequestContext ctx = RequestContext.get();
        String url = ImageServiceHelper.viewPhoto((String)imageNo, (String)ctx.getUserId(), (String)ctx.getUserName());
        if (url == null) {
            throw new KDException(new ErrorCode("", ""), new Object[]{"image url of  error invoice  is null"});
        }
        CustomControl cc = (CustomControl)this.getControl(KEY_CONTROL_INVOICEIMAGE);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("billSrc", url);
        cc.setData(resultMap);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.entryRowClick(evt);
    }

    private String getInvoiceResult() {
        String invoiceResult = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PARAMETER_INVOICERESULT);
        return invoiceResult;
    }
}

