/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.KeywordConfig;
import kd.data.idi.data.KeywordConfigItem;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.formplugin.IDIConditionEdit;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;
import kd.data.idi.util.TranFormulaHelper;

public class IDIKeyWordFormPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    private static final String CustomParam_ENTITY_NUMBER = "entitynumber";
    private static final String CustomParam_ONLYHEADFIELD = "onlyheadfield";
    private static final String FIELD = "field";
    private static final String HASKEYWORDTEXT = "haskeywordtext";
    private static final String NOTHASKEYWORDTEXT = "nothaskeywordtext";
    private static final String KEYWORDENTRY = "keywordentry";
    private static final String KEYWORDF7 = "keyword";
    private static final String KEYWORD_ID = "keyword_id";
    private static final String BTN_COPY = "btn_copy";
    private static final String TOOLBAR = "advcontoolbarap";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_ID = "id";
    private static final String KEY_STARTCONDITION = "startcondition";
    private static final String KEY_STARTCONDITION_JSON = "startcondition_json";
    private static final String ActionId_SET_START_CONDITION = "setStartCondition";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, KEY_STARTCONDITION});
        this.addItemClickListeners(new String[]{TOOLBAR});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTN_COPY.equalsIgnoreCase(evt.getItemKey())) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            int[] rowIndexs = proxy.getEntryState(KEYWORDENTRY).getSelectedRows();
            if (rowIndexs.length > 0) {
                IDataModel model = this.getModel();
                int rowIndex = model.createNewEntryRow(KEYWORDENTRY);
                model.setValue(FIELD, model.getValue(FIELD, rowIndexs[0]), rowIndex);
                model.setValue(KEYWORDF7, model.getValue(KEYWORDF7, rowIndexs[0]), rowIndex);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"IDIKeyWordFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        EntityTypeUtil helper;
        List cols;
        MainEntityType entityType;
        Object comboItems;
        super.afterCreateNewData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        String onlyHeadField = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ONLYHEADFIELD);
        String detailConfig = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_DETAIL_CONFIG);
        if (StringUtils.isNotEmpty((String)entityNumber) && (comboItems = this.createComboItem(entityType = EntityMetadataCache.getDataEntityType((String)entityNumber), cols = (helper = new EntityTypeUtil()).getFilterColumns((IDataEntityType)entityType, !StringUtils.isBlank((String)onlyHeadField) && Boolean.parseBoolean(onlyHeadField)))) != null) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD);
            comboEdit.setComboItems((List)comboItems);
        }
        if (StringUtils.isNotEmpty((String)detailConfig)) {
            IDataModel dataModel = this.getModel();
            KeywordConfig keyWordConfig = (KeywordConfig)IDIJSONUtils.cast((String)detailConfig, KeywordConfig.class);
            dataModel.setValue(HASKEYWORDTEXT, (Object)keyWordConfig.getLocalDetectedText());
            dataModel.setValue(NOTHASKEYWORDTEXT, (Object)keyWordConfig.getLocalNotDetectedText());
            List list = keyWordConfig.getItems();
            for (KeywordConfigItem item : list) {
                int rowIndex = this.getModel().createNewEntryRow(KEYWORDENTRY);
                this.getModel().setValue(FIELD, (Object)item.getPropertyName(), rowIndex);
                List keywordLibraryIds = item.getKeywordLibraryIds();
                Object[] ids = keywordLibraryIds != null && !keywordLibraryIds.isEmpty() ? keywordLibraryIds.toArray() : new Object[]{};
                this.getModel().setValue(KEYWORDF7, (Object)ids, rowIndex);
                this.getModel().setValue(KEYWORD_ID, (Object)item.getItemId(), rowIndex);
            }
            IDICondition condition = keyWordConfig.getStartCondition();
            if (condition != null) {
                String exprTran = this.getExprDesc(condition);
                this.getModel().setValue(KEY_STARTCONDITION, (Object)exprTran);
                this.getModel().setValue(KEY_STARTCONDITION_JSON, (Object)IDIJSONUtils.toJsonString((Object)condition));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try {
            KeywordConfig keyWordConfig;
            IDICondition condition;
            String detailConfig = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_DETAIL_CONFIG);
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
            if (StringUtils.isNotEmpty((String)detailConfig) && (condition = (keyWordConfig = (KeywordConfig)IDIJSONUtils.cast((String)detailConfig, KeywordConfig.class)).getStartCondition()) != null) {
                TranFormulaHelper.tranFormula((IDICondition)condition, (String)entityNumber, (FormShowParameter)new FormShowParameter());
                this.getModel().setValue(KEY_STARTCONDITION, (Object)this.getExprDesc(condition));
                this.getView().updateView("contentpanel");
            }
        }
        catch (Exception ignore) {
            SchemaExecutorLogger.info((String)("IDI multi-language exception" + Arrays.toString(ignore.getStackTrace())), (Object[])new Object[0]);
        }
    }

    private List<ComboItem> createComboItem(MainEntityType entityType, List<Map<String, Object>> listNodes) {
        if (listNodes == null) {
            return null;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(listNodes.size());
        String entityNumber = entityType.getName();
        Map entityTypeMap = entityType.getAllEntities();
        for (Map<String, Object> map : listNodes) {
            if (!"text".equalsIgnoreCase((String)map.get("type"))) continue;
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(fieldCaption);
            String value = fieldName;
            if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
                EntityType entryType = (EntityType)entityTypeMap.get(entryEntity);
                value = entryType instanceof SubEntryType ? entryType.getParent().getName() + "." + entryEntity + "." + fieldName : entryEntity + "." + fieldName;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(localeString);
            comboItem.setValue(value);
            list.add(comboItem);
        }
        return list;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (BTN_OK.equals(control.getKey())) {
            if (this.validate()) {
                String returnData = this.getReturnData();
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
            }
        } else if (KEY_STARTCONDITION.equals(control.getKey())) {
            String conditionJson = (String)this.getModel().getValue(KEY_STARTCONDITION_JSON);
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
            IDIConditionEdit.openCondition(conditionJson, entityNumber, ActionId_SET_START_CONDITION, this);
        }
    }

    private String getReturnData() {
        KeywordConfig keywordConfig = new KeywordConfig();
        IDataModel dataModel = this.getModel();
        LocaleString localDetectedText = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)dataModel.getValue(HASKEYWORDTEXT)));
        String hasKeyWordText = localDetectedText.toString();
        LocaleString localNotDetectedText = IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)dataModel.getValue(NOTHASKEYWORDTEXT)));
        String notHasKeyWordText = localNotDetectedText.toString();
        localDetectedText = StringUtils.isEmpty((String)hasKeyWordText) ? new LocaleString(ResManager.loadKDString((String)"\u5b58\u5728\u5f02\u5e38\u654f\u611f\u8bcd", (String)"IDIKeyWordFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0])) : localDetectedText;
        localNotDetectedText = StringUtils.isEmpty((String)notHasKeyWordText) ? new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5f02\u5e38\u654f\u611f\u8bcd", (String)"IDIKeyWordFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0])) : localNotDetectedText;
        keywordConfig.setLocalDetectedText(localDetectedText);
        keywordConfig.setLocalNotDetectedText(localNotDetectedText);
        int rowCount = dataModel.getEntryRowCount(KEYWORDENTRY);
        ArrayList<KeywordConfigItem> list = new ArrayList<KeywordConfigItem>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObjectCollection keywordsCol = (DynamicObjectCollection)dataModel.getValue(KEYWORDF7, i);
            String rowID = (String)dataModel.getValue(KEYWORD_ID, i);
            String property = (String)dataModel.getValue(FIELD, i);
            KeywordConfigItem item = new KeywordConfigItem();
            item.setItemId(rowID);
            item.setPropertyName(property);
            if (keywordsCol != null && !keywordsCol.isEmpty()) {
                ArrayList<Long> keywordLibraryIds = new ArrayList<Long>(keywordsCol.size());
                for (DynamicObject keywordObj : keywordsCol) {
                    keywordLibraryIds.add(((DynamicObject)keywordObj.get(1)).getLong(KEY_ID));
                }
                item.setKeywordLibraryIds(keywordLibraryIds);
            }
            list.add(item);
        }
        keywordConfig.setItems(list);
        String condition = (String)this.getModel().getValue(KEY_STARTCONDITION_JSON);
        if (StringUtils.isNotEmpty((String)condition)) {
            keywordConfig.setStartCondition((IDICondition)IDIJSONUtils.cast((String)condition, IDICondition.class));
        }
        return IDIJSONUtils.toJsonString((Object)keywordConfig);
    }

    private boolean validate() {
        IDataModel dataModel = this.getModel();
        int rowCount = dataModel.getEntryRowCount(KEYWORDENTRY);
        if (rowCount <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u654f\u611f\u8bcd\u5e93\u3002", (String)"IDIKeyWordFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashSet<String> propertySet = new HashSet<String>();
        ArrayList<Integer> emptyList = new ArrayList<Integer>();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObjectCollection keywordsCol = (DynamicObjectCollection)dataModel.getValue(KEYWORDF7, i);
            String rowID = (String)dataModel.getValue(KEYWORD_ID, i);
            String property = (String)dataModel.getValue(FIELD, i);
            Objects.requireNonNull(rowID);
            boolean keyWordIsNull = keywordsCol == null || keywordsCol.isEmpty();
            boolean propertyIsNull = StringUtils.isEmpty((String)property);
            if (!keyWordIsNull && propertyIsNull) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u68c0\u6d4b\u5b57\u6bb5\u3002", (String)"IDIKeyWordFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (keyWordIsNull && !propertyIsNull) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u654f\u611f\u8bcd\u5e93\u201d\u3002", (String)"IDIKeyWordFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (keyWordIsNull) {
                emptyList.add(i);
            }
            if (propertyIsNull || propertySet.add(property)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u68c0\u6d4b\u5b57\u6bb5\u201d\u91cd\u590d\u3002", (String)"IDIKeyWordFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        int[] emptyRowIndexs = new int[emptyList.size()];
        for (int i = 0; i < emptyList.size(); ++i) {
            emptyRowIndexs[i] = (Integer)emptyList.get(i);
        }
        dataModel.deleteEntryRows(KEYWORDENTRY, emptyRowIndexs);
        if (emptyRowIndexs.length == rowCount) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u654f\u611f\u8bcd\u5e93\u3002", (String)"IDIKeyWordFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (KEYWORDENTRY.equals(e.getEntryProp().getName())) {
            IDataModel dataModel = this.getModel();
            for (RowDataEntity row : e.getRowDataEntities()) {
                dataModel.setValue(KEYWORD_ID, (Object)Uuid16.create().toString(), row.getRowIndex());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (FIELD.equals(propertyName)) {
            ChangeData[] changeData = e.getChangeSet();
            this.getModel().setValue(KEYWORDF7, null, changeData[0].getRowIndex());
        } else if (KEY_STARTCONDITION.equals(propertyName) && StringUtils.isEmpty((String)((String)(newValue = e.getChangeSet()[0].getNewValue())))) {
            this.getModel().setValue(KEY_STARTCONDITION_JSON, (Object)"");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDICondition condition;
        String actionId = closedCallBackEvent.getActionId();
        String result = (String)closedCallBackEvent.getReturnData();
        if (ActionId_SET_START_CONDITION.equals(actionId) && !StringUtils.isEmpty((String)result) && (condition = (IDICondition)IDIJSONUtils.cast((String)result, IDICondition.class)) != null) {
            String exprTran = this.getExprDesc(condition);
            this.getModel().setValue(KEY_STARTCONDITION, (Object)exprTran);
            this.getModel().setValue(KEY_STARTCONDITION_JSON, (Object)result);
        }
    }

    private String getExprDesc(IDICondition condition) {
        if (condition == null) {
            return "";
        }
        String handDesc = condition.getDescription().toString();
        if (StringUtils.isNotEmpty((String)handDesc)) {
            return handDesc;
        }
        return StringUtils.isNotEmpty((String)condition.getExprTran()) ? condition.getExprTran() : condition.getExpression();
    }
}

