/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.idi.data.MatchType;
import kd.data.idi.engine.SchemaExecutorLogger;

public class IDIKeywordLibraryListPlugin
extends AbstractListPlugin {
    private static final String OPERATE_DISABLE = "disable";
    private static final String OPERATE_DELETE = "delete";
    private static final String KEY_MATCH_TYPE = "matchType";
    private static final String KEY_KEY_WORD_CONFIG = "keywordConfig";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "disable": 
            case "delete": {
                this.checkDisableOrDeleteData(operateKey, args);
                break;
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        try {
            DynamicObjectCollection pageData = e.getPageData();
            Object[] ids = pageData.stream().map(DataEntityBase::getPkValue).toArray();
            Map keywordLibraryMap = BusinessDataServiceHelper.loadFromCache((String)"idi_keyword_library", (String)"id,desc", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            for (DynamicObject row : pageData) {
                DynamicObject keywordLibrary = (DynamicObject)keywordLibraryMap.get(row.get("id"));
                if (!StringUtils.isBlank((CharSequence)row.getString("localedesc")) || keywordLibrary == null || !StringUtils.isNotBlank((CharSequence)keywordLibrary.getString("desc"))) continue;
                row.set("localedesc", (Object)new LocaleString(Lang.zh_CN.toString(), keywordLibrary.getString("desc")));
            }
        }
        catch (Exception ignore) {
            SchemaExecutorLogger.info((String)("IDI multi-language exception" + Arrays.toString(ignore.getStackTrace())), (Object[])new Object[0]);
        }
    }

    private void checkDisableOrDeleteData(String operateKey, BeforeDoOperationEventArgs args) {
        ArrayList keywordLibIds = new ArrayList();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        listSelectedData.forEach(e -> keywordLibIds.add(e.getPrimaryKeyValue().toString()));
        DynamicObjectCollection schemaObjArr = QueryServiceHelper.query((String)"idi_schema", (String)"id,number,name,rule_tag", null);
        boolean checkFlag = false;
        if (schemaObjArr != null && schemaObjArr.size() > 0) {
            block0: for (DynamicObject schemaDo : schemaObjArr) {
                JSONArray areaArray;
                JSONObject schemaConfig;
                String schemaConfigStr = schemaDo.getString("rule_tag");
                if (StringUtils.isBlank((CharSequence)schemaConfigStr) || (schemaConfig = JSONObject.parseObject((String)schemaConfigStr)) == null || (areaArray = schemaConfig.getJSONArray("area")) == null || areaArray.isEmpty()) continue;
                for (int i = 0; i < areaArray.size(); ++i) {
                    JSONObject area = areaArray.getJSONObject(i);
                    JSONArray decisionArray = area.getJSONArray("decision");
                    if (decisionArray == null || decisionArray.isEmpty()) continue;
                    for (int k = 0; k < decisionArray.size(); ++k) {
                        JSONArray keywordItems;
                        JSONObject keywordConfig;
                        JSONObject decision = decisionArray.getJSONObject(k);
                        if (!MatchType.KEYWORD.getType().equalsIgnoreCase(decision.getString(KEY_MATCH_TYPE)) || (keywordConfig = decision.getJSONObject(KEY_KEY_WORD_CONFIG)) == null || (keywordItems = keywordConfig.getJSONArray("items")) == null || keywordItems.isEmpty()) continue;
                        for (int j = 0; j < keywordItems.size(); ++j) {
                            List keywordLibraryIdList;
                            JSONObject item = keywordItems.getJSONObject(j);
                            JSONArray keywordLibraryIds = item.getJSONArray("keywordLibraryIds");
                            if (keywordLibraryIds == null || Collections.disjoint(keywordLibraryIdList = keywordLibraryIds.toJavaList(String.class), keywordLibIds)) continue;
                            checkFlag = true;
                            break block0;
                        }
                    }
                }
            }
        }
        if (checkFlag) {
            if (operateKey.equals(OPERATE_DISABLE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"IDIKeywordLibraryListPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
            if (operateKey.equals(OPERATE_DELETE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"IDIKeywordLibraryListPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
            args.setCancel(true);
        }
    }
}

