/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class IDITemplateListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    private static final int clientIdLength = 29;
    private static final int secretLength = 32;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        ListSelectedRowCollection selectedRows;
        super.beforeClick(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if ("btnok".equals(key) && (selectedRows = this.getSelectedRows()) != null && !selectedRows.isEmpty()) {
            this.getPageCache().put("returnData", "1");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String returnData = this.getPageCache().get("returnData");
        IFormView parentView = this.getView().getParentView();
        if ("1".equals(returnData) && parentView != null && parentView.getEntityId().equals("idi_checkattachment")) {
            this.getPageCache().remove("returnData");
            QFilter lcFilter = new QFilter("number", "=", (Object)"lincai_sign").and("enable", "=", (Object)"1");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"IDILcSecretVerifyPlugin.getApiConfig", (String)"idi_api_config", (String)"clientid,clientsecret,paramentryentity.paramname,paramentryentity.paramtype", (QFilter[])lcFilter.toArray(), null);){
                String clientId = null;
                String clientSecret = null;
                String projectCode = null;
                String fileSecret = null;
                if (dataSet != null) {
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        clientId = row.getString("clientid");
                        clientSecret = row.getString("clientsecret");
                        if ("projectCode".equals(row.getString("paramentryentity.paramname"))) {
                            projectCode = row.getString("paramentryentity.paramtype");
                        }
                        if (!"fileSecret".equals(row.getString("paramentryentity.paramname"))) continue;
                        fileSecret = row.getString("paramentryentity.paramtype");
                    }
                }
                if (clientId == null || clientId.length() != 29 || clientSecret == null || clientSecret.length() != 32 || projectCode == null || projectCode.length() != 29 || fileSecret == null || fileSecret.length() != 32) {
                    e.setCancel(true);
                    String message = ResManager.loadKDString((String)"\u5982\u9700\u4f7f\u7528\u4ee4\u624d\u79d1\u6280\u6a21\u677f\uff0c\u8bf7\u70b9\u201c\u786e\u5b9a\u201d\u8fdb\u5165\u5e94\u7528\u5e02\u573a\u8ba2\u8d2d", (String)"IDILcSecretVerifyPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u5982\u5df2\u8ba2\u8d2d\uff0c\u8bf7\u81f3\u201c\u914d\u7f6e-API\u53c2\u6570\u201d\u4e2d\u914d\u7f6e\u7b7e\u540d\u4fe1\u606f", (String)"IDILcSecretVerifyPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("visitAppMarket", (IFormPlugin)this));
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes == result && "visitAppMarket".equals(actionId)) {
            QFilter numberFilter = new QFilter("param_key", "=", (Object)"lcAppMarketUrl");
            DynamicObject paramConfig = QueryServiceHelper.queryOne((String)"idi_param_config", (String)"param_val", (QFilter[])numberFilter.toArray());
            if (paramConfig == null || StringUtils.isEmpty((String)paramConfig.getString("param_val"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u914d\u7f6e\u201d>\u201c\u53c2\u6570\u914d\u7f6e\u201d\u4e2d\u914d\u7f6e\u201c\u91d1\u8776\u4e91\u82cd\u7a79\u5e94\u7528\u5e02\u573a\u8ba2\u8d2d\u4ee4\u624d\u5730\u5740\u201d\u3002", (String)"IDILcSecretVerifyPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().openUrl(paramConfig.getString("param_val"));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows != null && !selectedRows.isEmpty()) {
            this.getPageCache().put("returnData", "1");
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        if (pageData == null || pageData.isEmpty()) {
            return;
        }
        String domainUrl = UrlService.getDomainContextUrl();
        for (DynamicObject data : pageData) {
            String lcTemplatePicUrl = data.getString("lctemplatepic");
            if (!StringUtils.isNotEmpty((String)lcTemplatePicUrl)) continue;
            data.set("lctemplatepic", (Object)(domainUrl + lcTemplatePicUrl));
        }
    }
}

