/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.api.external.impl;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.api.external.IExternalApiAbutment;
import kd.data.idi.api.external.impl.AbutmentParam;
import kd.data.idi.api.external.impl.CompanyParam;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class CompanyApiAbutmentImpl
implements IExternalApiAbutment<CompanyParam, String> {
    @Override
    public UrlParam getUrlParam(String number, AbutmentParam additionalConfig) {
        UrlParam urlParam = new UrlParam();
        String url = null;
        String merchanCode = null;
        String merchanSecret = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CompanyApiAbutmentImpl.getUrlParam", (String)"idi_api_config", (String)"number,url,clientid,clientsecret", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("enable", "=", (Object)"1")}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    url = row.getString("url");
                    merchanCode = row.getString("clientid");
                    merchanSecret = row.getString("clientsecret");
                }
            }
        }
        urlParam.setUrl(url);
        urlParam.setCustomerKey(merchanCode);
        urlParam.setSecret(merchanSecret);
        return urlParam;
    }

    @Override
    public boolean validate(UrlParam urlParam, CompanyParam companyParam) {
        String errorMesg = ResManager.loadKDString((String)"\u7f3a\u5c11API\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"APIConfig_0", (String)"data-idi-core", (Object[])new Object[0]);
        if (urlParam == null) {
            SchemaExecutorLogger.error("CompanyApiAbutmentImpl-UrlParam is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getUrl())) {
            SchemaExecutorLogger.error("CompanyApiAbutmentImpl-UrlParam.url is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getCustomerKey())) {
            SchemaExecutorLogger.error("CompanyApiAbutmentImpl-UrlParam.client_id is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getSecret())) {
            SchemaExecutorLogger.error("CompanyApiAbutmentImpl-UrlParam.client_secret is null");
            throw new KDBizException(errorMesg);
        }
        if (companyParam == null) {
            SchemaExecutorLogger.error("CompanyApiAbutmentImpl-CompanyParam is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)companyParam.getKeyWord())) {
            SchemaExecutorLogger.error("CompanyApiAbutmentImpl-CompanyParam.KeyWord is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)companyParam.getClientCompanyId())) {
            SchemaExecutorLogger.error("CompanyApiAbutmentImpl-CompanyParam.ClientCompanyId is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)companyParam.getClientCompanyName())) {
            SchemaExecutorLogger.error("CompanyApiAbutmentImpl-CompanyParam.ClientCompanyName is null");
            throw new KDBizException(errorMesg);
        }
        return false;
    }

    @Override
    public String tokenService() {
        return null;
    }

    @Override
    public String getToken(UrlParam urlParam) {
        return null;
    }

    @Override
    public String getTokenFromCache(String cacheKey) {
        return null;
    }

    @Override
    public String buildCacheKey(String fixKey) {
        return null;
    }

    @Override
    public String apiService() {
        return null;
    }

    @Override
    public String apiAction(UrlParam urlParam, CompanyParam companyParam) {
        this.validate(urlParam, companyParam);
        Map<String, Object> paramMap = companyParam.toMap();
        String paramJson = IDIJSONUtils.toJsonString(paramMap);
        SchemaExecutorLogger.info("[DATA-IDI] ApiAction daas param :" + paramJson, new Object[0]);
        Map<String, Object> headerMap = this.createHeader(urlParam, companyParam);
        SchemaExecutorLogger.info("[DATA-IDI] ApiAction daas header :" + IDIJSONUtils.toJsonString(headerMap), new Object[0]);
        String number = "data-idi-daas";
        this.importAPI(number);
        int timeOut = ParamFactory.getTimeOut();
        String content = this.iscInvoke(number, paramJson, urlParam.getUrl(), timeOut, this.createHeader(urlParam, companyParam));
        SchemaExecutorLogger.info("[DATA-IDI] ApiAction daas result :" + content, new Object[0]);
        return content;
    }

    @Override
    public String parseResult(String content, CompanyParam companyParam) {
        return content;
    }

    @Override
    public Map<String, Object> createHeader(UrlParam urlParam, CompanyParam companyParam) {
        HashMap<String, Object> header = new HashMap<String, Object>(5);
        String nonce = UUID.randomUUID().toString().replaceAll("-", "");
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = this.sign(urlParam.getSecret(), timestamp, nonce);
        header.put("x-acgw-timestamp", timestamp);
        header.put("x-acgw-nonce", nonce);
        header.put("x-acgw-sign", sign);
        header.put("x-acgw-appid", urlParam.getCustomerKey());
        header.put("Content-Type", "application/json;charset=UTF-8");
        return header;
    }

    private String sign(String appSecret, String timestamp, String nonce) {
        StringBuilder sber = new StringBuilder();
        sber.append(timestamp).append(nonce);
        return Base64.encodeBase64String((byte[])new HmacUtils(HmacAlgorithms.HMAC_SHA_256, appSecret.getBytes(StandardCharsets.UTF_8)).hmac(sber.toString().getBytes(StandardCharsets.UTF_8)));
    }
}

