/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.TranFormulaHelper;

public class BillFlowConfigDetail {
    private String billTypeNumber;
    private String billTypeNumberEntityName;
    private String dateFieldName;
    private String dateFieldEntityName;
    private List<String> displayFieldList;
    private List<String> displayFieldNameList;
    private List<LocaleString> localDisplayFieldNameList;
    private boolean isCalculateDistanceDays = true;

    public String getBillTypeNumber() {
        return this.billTypeNumber;
    }

    public void setBillTypeNumber(String billTypeNumber) {
        this.billTypeNumber = billTypeNumber;
    }

    public String getDateFieldName() {
        return this.dateFieldName;
    }

    public void setDateFieldName(String dateFieldName) {
        this.dateFieldName = dateFieldName;
    }

    public List<String> getDisplayFieldList() {
        return this.displayFieldList;
    }

    public void setDisplayFieldList(List<String> displayFieldList) {
        this.displayFieldList = displayFieldList;
    }

    public boolean isCalculateDistanceDays() {
        return this.isCalculateDistanceDays;
    }

    public void setCalculateDistanceDays(boolean calculateDistanceDays) {
        this.isCalculateDistanceDays = calculateDistanceDays;
    }

    public String getBillTypeNumberEntityName() {
        return this.billTypeNumberEntityName;
    }

    public void setBillTypeNumberEntityName(String billTypeNumberEntityName) {
        this.billTypeNumberEntityName = billTypeNumberEntityName;
    }

    public String getDateFieldEntityName() {
        String localFieldCaption = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("isbillflow", true);
            params.put("onlyheadfield", "true");
            localFieldCaption = TranFormulaHelper.getLocalFieldCaption(this.billTypeNumber, this.dateFieldName, params);
        }
        catch (Exception ignore) {
            SchemaExecutorLogger.info("IDI multi-language exception" + Arrays.toString(ignore.getStackTrace()), new Object[0]);
        }
        return StringUtils.isEmpty(localFieldCaption) ? this.dateFieldEntityName : localFieldCaption;
    }

    public void setDateFieldEntityName(String dateFieldEntityName) {
        this.dateFieldEntityName = dateFieldEntityName;
    }

    public List<String> getDisplayFieldNameList() {
        if (this.localDisplayFieldNameList == null) {
            return this.displayFieldNameList;
        }
        try {
            ArrayList<String> resultList = new ArrayList<String>(10);
            this.displayFieldNameList = this.displayFieldNameList == null ? Collections.emptyList() : this.displayFieldNameList;
            for (int i = 0; i < this.displayFieldNameList.size(); ++i) {
                if (this.localDisplayFieldNameList.size() > i && StringUtils.isNotEmpty((String)this.localDisplayFieldNameList.get(i).toString())) {
                    resultList.add(this.localDisplayFieldNameList.get(i).toString());
                    continue;
                }
                resultList.add(this.displayFieldNameList.get(i));
            }
            return resultList;
        }
        catch (Exception e) {
            SchemaExecutorLogger.info("IDI multi-language exception" + Arrays.toString(e.getStackTrace()), new Object[0]);
            return this.displayFieldNameList;
        }
    }

    public void setDisplayFieldNameList(List<String> displayFieldNameList) {
        this.displayFieldNameList = displayFieldNameList;
    }

    public List<LocaleString> getLocalDisplayFieldNameList() {
        if (this.localDisplayFieldNameList == null) {
            return this.displayFieldNameList == null ? new ArrayList<LocaleString>(0) : this.displayFieldNameList.stream().map(x -> new LocaleString(Lang.zh_CN.toString(), x)).collect(Collectors.toList());
        }
        return this.localDisplayFieldNameList;
    }

    public void setLocalDisplayFieldNameList(List<LocaleString> localDisplayFieldNameList) {
        if (this.localDisplayFieldNameList == null) {
            this.localDisplayFieldNameList = localDisplayFieldNameList;
        } else {
            for (int i = 0; i < this.localDisplayFieldNameList.size(); ++i) {
                if (localDisplayFieldNameList.get(i) == null) continue;
                this.localDisplayFieldNameList.get(i).put(Lang.get().toString(), (Object)localDisplayFieldNameList.get(i).getLocaleValue());
            }
        }
    }
}

