/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.data.idi.data.BillControlTypeEnum;

public class GradeItem {
    private String condition;
    private float grade;
    private String showScript;
    private LocaleString localeShowScript;
    private String showColor;
    private BillControlTypeEnum billControl;

    public GradeItem(String condition, float grade, String showScript, String showColor) {
        this.condition = condition;
        this.grade = grade;
        this.showColor = showColor;
        this.showScript = showScript;
    }

    public GradeItem(String condition, float grade, String showScript, LocaleString localeShowScript, String showColor, BillControlTypeEnum billControl) {
        this.condition = condition;
        this.grade = grade;
        this.showScript = showScript;
        this.localeShowScript = localeShowScript;
        this.showColor = showColor;
        this.billControl = billControl;
    }

    public GradeItem() {
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setGrade(float grade) {
        this.grade = grade;
    }

    public float getGrade() {
        return this.grade;
    }

    public void setShowColor(String showColor) {
        this.showColor = showColor;
    }

    public String getShowColor() {
        return this.showColor;
    }

    public String getShowScript() {
        if (this.localeShowScript == null) {
            return this.showScript;
        }
        return this.localeShowScript.toString();
    }

    public void setShowScript(String showScript) {
        this.showScript = showScript;
    }

    public BillControlTypeEnum getBillControl() {
        return this.billControl;
    }

    public void setBillControl(BillControlTypeEnum billControl) {
        this.billControl = billControl;
    }

    public boolean hasControl() {
        return BillControlTypeEnum.FORCE == this.billControl || BillControlTypeEnum.CONFIREM == this.billControl;
    }

    public LocaleString getLocaleShowScript() {
        if (this.localeShowScript == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.showScript == null ? "" : this.showScript);
        }
        return this.localeShowScript;
    }

    public void setLocaleShowScript(LocaleString localeShowScript) {
        this.localeShowScript = localeShowScript;
    }

    public String toString() {
        return "GradeItem{condition='" + this.condition + '\'' + ", grade=" + this.grade + ", showScript='" + this.showScript + '\'' + ", showColor='" + this.showColor + '\'' + ", billControl=" + (Object)((Object)this.billControl) + ", localeShowScript='" + this.localeShowScript == null ? "null" : this.localeShowScript.toString() + '\'' + '}';
    }
}

