/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import kd.data.idi.data.IDIEnumLoadKDStringBridge;

public enum IDICompareType {
    EQUALS("=", new IDIEnumLoadKDStringBridge("\u7b49\u4e8e", "IDICompareType_0", "data-idi-core")),
    NOT_EQUALS("!=", new IDIEnumLoadKDStringBridge("\u4e0d\u7b49\u4e8e", "IDICompareType_1", "data-idi-core")),
    LARGE_EQUALS(">=", new IDIEnumLoadKDStringBridge("\u5927\u4e8e\u7b49\u4e8e", "IDICompareType_2", "data-idi-core")),
    LESS_EQUALS("<=", new IDIEnumLoadKDStringBridge("\u5c0f\u4e8e\u7b49\u4e8e", "IDICompareType_3", "data-idi-core")),
    LARGE(">", new IDIEnumLoadKDStringBridge("\u5927\u4e8e", "IDICompareType_4", "data-idi-core")),
    LESS("<", new IDIEnumLoadKDStringBridge("\u5c0f\u4e8e", "IDICompareType_5", "data-idi-core")),
    BOOLEAN_EQUALS("==", new IDIEnumLoadKDStringBridge("\u7b49\u4e8e", "IDICompareType_0", "data-idi-core"));

    private String type;
    private IDIEnumLoadKDStringBridge caption;

    private IDICompareType(String type, IDIEnumLoadKDStringBridge caption) {
        this.type = type;
        this.caption = caption;
    }

    public String getType() {
        return this.type;
    }

    public String getCaption() {
        return this.caption.loadKDString();
    }

    public static IDICompareType typeToCompareType(String type) {
        if (type != null) {
            for (IDICompareType e : IDICompareType.values()) {
                if (!type.equals(e.type)) continue;
                return e;
            }
        }
        return null;
    }

    public static String getCaption(String type) {
        if (type == null) {
            return null;
        }
        for (IDICompareType e : IDICompareType.values()) {
            if (!type.equals(e.getType())) continue;
            return e.getCaption();
        }
        return null;
    }
}

