/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import kd.bos.util.StringUtils;
import kd.data.idi.data.IDIEnumLoadKDStringBridge;

public enum InvoiceCloudCodeType {
    CHECK_FAIL("0001,0002,1101,1119,1200,1214,1132,1301,9999,0005,0006,1002,1006,1007,1008,1009,1020,3109,3110,0301,0304,0314,0317,1110,1307,1221,1222,1213,1212,1133,3106,3107,1224,1225,0411", new IDIEnumLoadKDStringBridge("\u53d1\u7968\u67e5\u9a8c\u5931\u8d25", "InvoiceCloudCodeType_0", "data-idi-core")),
    INVOICE_NOT_EXIST("0009", new IDIEnumLoadKDStringBridge("\u67e5\u9a8c\u53d1\u7968\u4e0d\u5b58\u5728", "InvoiceCloudCodeType_1", "data-idi-core")),
    EXCEED_FIVE_CHECK_TIMES("1001", new IDIEnumLoadKDStringBridge("\u8be5\u5f20\u53d1\u7968\u67e5\u9a8c\u6b21\u6570\u8d85\u8fc75\u6b21\uff0c\u8bf7\u4e8e\u6b21\u65e5\u518d\u6b21\u67e5\u9a8c", "InvoiceCloudCodeType_2", "data-idi-core")),
    CANNOT_FIND_INVOICE("1003", new IDIEnumLoadKDStringBridge("\u67e5\u65e0\u6b64\u7968", "InvoiceCloudCodeType_3", "data-idi-core")),
    EXCEED_MAX_CHECK_TIMES("1004,3108", new IDIEnumLoadKDStringBridge("\u5df2\u8d85\u8fc7\u53d1\u7968\u6700\u5927\u67e5\u9a8c\u91cf", "InvoiceCloudCodeType_4", "data-idi-core")),
    INFORMATION_NOT_STANDARDIZED("1005", new IDIEnumLoadKDStringBridge("\u53d1\u7968\u4fe1\u606f\u4e0d\u89c4\u8303\uff08\u4f8b\u5982\u53f7\u7801\u3001\u4ee3\u7801\u3001\u6821\u9a8c\u7801\u4f4d\u6570\u4e0d\u89c4\u8303\uff09", "InvoiceCloudCodeType_5", "data-idi-core")),
    CANNOT_CHECK_SAME_DAY("1014", new IDIEnumLoadKDStringBridge("\u53d1\u7968\u65e5\u671f\u5f53\u5929\u4e0d\u80fd\u67e5\u9a8c\uff0c\u8bf7\u6b21\u65e5\u518d\u67e5", "InvoiceCloudCodeType_6", "data-idi-core")),
    CANNOT_CHECK_EXCEED_ONE_YEAR("1015", new IDIEnumLoadKDStringBridge("\u7a0e\u5c40\u89c4\u5b9a\u8d85\u8fc7\u4e00\u5e74\u7684\u53d1\u7968\u4e0d\u80fd\u67e5\u9a8c", "InvoiceCloudCodeType_7", "data-idi-core")),
    INVOICE_DATE_FORMAT_ERROR("0313", new IDIEnumLoadKDStringBridge("\u53d1\u7968\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e", "InvoiceCloudCodeType_8", "data-idi-core")),
    INVOICE_CODE_EMPTY("0315", new IDIEnumLoadKDStringBridge("\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a", "InvoiceCloudCodeType_9", "data-idi-core")),
    INVOICE_NUMBER_EMPTY("0316", new IDIEnumLoadKDStringBridge("\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", "InvoiceCloudCodeType_10", "data-idi-core")),
    UPLOAD_IMAGE_FILE_EMPTY("3100", new IDIEnumLoadKDStringBridge("\u4e0a\u4f20\u7684\u56fe\u50cf\u4e3a\u7a7a\u6587\u4ef6", "InvoiceCloudCodeType_11", "data-idi-core")),
    UPLOAD_FILE_NOT_IMAGE("3101", new IDIEnumLoadKDStringBridge("\u4e0a\u4f20\u7684\u4e0d\u662f\u56fe\u50cf\u6587\u4ef6", "InvoiceCloudCodeType_12", "data-idi-core")),
    UPLOAD_FILE_TOO_SMALL("3102", new IDIEnumLoadKDStringBridge("\u4e0a\u4f20\u6587\u4ef6\u8fc7\u5c0f\uff0c\u8bf7\u4e0a\u4f20\u5927\u56fe", "InvoiceCloudCodeType_13", "data-idi-core")),
    NEED_UPLOAD_CLEAR_IMAGE("3103,3105", new IDIEnumLoadKDStringBridge("\u8bf7\u4e0a\u4f20\u6709\u6548\u4e14\u6e05\u6670\u5f69\u8272\u7684\u53d1\u7968\u56fe\u50cf", "InvoiceCloudCodeType_14", "data-idi-core")),
    CANNOT_FIND_INVOICE_AREA("3104", new IDIEnumLoadKDStringBridge("\u672a\u627e\u5230\u76ee\u6807\u53d1\u7968\u533a\u57df", "InvoiceCloudCodeType_15", "data-idi-core")),
    DEFAULT_MESSAGE("", new IDIEnumLoadKDStringBridge("\u53d1\u7968\u68c0\u67e5\u5931\u8d25", "InvoiceCloudCodeType_16", "data-idi-core"));

    private String errorCode;
    private IDIEnumLoadKDStringBridge errorMessage;

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage.loadKDString();
    }

    private InvoiceCloudCodeType(String errorCode, IDIEnumLoadKDStringBridge errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public static InvoiceCloudCodeType typeToCloudCodeType(String errorCode) {
        if (StringUtils.isNotEmpty((String)errorCode)) {
            for (InvoiceCloudCodeType codeType : InvoiceCloudCodeType.values()) {
                if (!codeType.errorCode.contains(errorCode)) continue;
                return codeType;
            }
        }
        return DEFAULT_MESSAGE;
    }

    public static String getErrorMessage(String errorCode) {
        if (errorCode == null) {
            return null;
        }
        for (InvoiceCloudCodeType e : InvoiceCloudCodeType.values()) {
            if (!errorCode.equals(e.getErrorCode())) continue;
            return e.getErrorMessage();
        }
        return null;
    }
}

