/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.CustomInvoiceParam;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.InvoiceConfigCustom;
import kd.data.idi.data.InvoiceDecisionRule;

public class InvoiceConfig {
    private boolean crossOneYear;
    private String requestDateField;
    private Date fromDate;
    private boolean isCertifiedOfInvoice;
    private boolean isDuplicate;
    private String companyFieldName;
    private boolean isCheckInvoiceHeader;
    private boolean isBuyerTaxCode;
    private boolean isCompletedOfSalerInfo;
    private boolean isCompletedOfBuyerInfo;
    private boolean isCompletedOfStamp;
    private boolean isFullAmountOfAllInvoices;
    private boolean isContinuousNumber;
    private Integer numberRange;
    private String serialNoField;
    private String amountFieldName;
    private IDICondition idiCondition;
    private List<InvoiceConfigCustom> customList;
    private List<DeductionGradeConfig> deductionGradeConfigList;
    private int crossOneYearDeductionGradePercent = 0;
    private int certifiedOfInvoiceDeductionGradePercent = 0;
    private int duplicateDeductionGradePercent = 0;
    private int checkInvoiceHeaderDeductionGradePercent = 0;
    private int buyerTaxCodeDeductionGradePercent = 0;
    private int completedOfSalerInfoDeductionGradePercent = 0;
    private int completedOfBuyerInfoDeductionGradePercent = 0;
    private int completedOfStampDeductionGradePercent = 0;
    private int fullAmountOfAllInvoicesDeductionGradePercent = 0;
    private int continuousNumberGradePercent = 0;
    private String noInvoiceTip;
    private LocaleString localNoInvoiceTip;
    private boolean useCustomInvoiceParam;
    private CustomInvoiceParam customInvoiceParam;
    private IDICondition startCondition;

    public boolean isCrossOneYear() {
        return this.crossOneYear;
    }

    public void setCrossOneYear(boolean crossOneYear) {
        this.crossOneYear = crossOneYear;
    }

    public String getRequestDateField() {
        return this.requestDateField;
    }

    public void setRequestDateField(String requestDateField) {
        this.requestDateField = requestDateField;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public boolean isCertifiedOfInvoice() {
        return this.isCertifiedOfInvoice;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.isDuplicate = duplicate;
    }

    public boolean isCheckInvoiceHeader() {
        return this.isCheckInvoiceHeader;
    }

    public void setCheckInvoiceHeader(boolean checkInvoiceHeader) {
        this.isCheckInvoiceHeader = checkInvoiceHeader;
    }

    public boolean isBuyerTaxCode() {
        return this.isBuyerTaxCode;
    }

    public void setBuyerTaxCode(boolean buyerTaxCode) {
        this.isBuyerTaxCode = buyerTaxCode;
    }

    public void setCertifiedOfInvoice(boolean certifiedOfInvoice) {
        this.isCertifiedOfInvoice = certifiedOfInvoice;
    }

    public boolean isCompletedOfSalerInfo() {
        return this.isCompletedOfSalerInfo;
    }

    public void setCompletedOfSalerInfo(boolean completedOfSalerInfo) {
        this.isCompletedOfSalerInfo = completedOfSalerInfo;
    }

    public boolean isCompletedOfBuyerInfo() {
        return this.isCompletedOfBuyerInfo;
    }

    public void setCompletedOfBuyerInfo(boolean completedOfBuyerInfo) {
        this.isCompletedOfBuyerInfo = completedOfBuyerInfo;
    }

    public boolean isCompletedOfStamp() {
        return this.isCompletedOfStamp;
    }

    public void setCompletedOfStamp(boolean completedOfStamp) {
        this.isCompletedOfStamp = completedOfStamp;
    }

    public List<InvoiceConfigCustom> getCustomList() {
        return this.customList;
    }

    public void setCustomList(List<InvoiceConfigCustom> customList) {
        this.customList = customList;
    }

    public String getCompanyFieldName() {
        return this.companyFieldName;
    }

    public void setCompanyFieldName(String companyFieldName) {
        this.companyFieldName = companyFieldName;
    }

    public boolean isFullAmountOfAllInvoices() {
        return this.isFullAmountOfAllInvoices;
    }

    public void setFullAmountOfAllInvoices(boolean fullAmountOfAllInvoices) {
        this.isFullAmountOfAllInvoices = fullAmountOfAllInvoices;
    }

    public boolean isContinuousNumber() {
        return this.isContinuousNumber;
    }

    public void setContinuousNumber(boolean continuousNumber) {
        this.isContinuousNumber = continuousNumber;
    }

    public Integer getNumberRange() {
        return this.numberRange;
    }

    public void setNumberRange(Integer numberRange) {
        this.numberRange = numberRange;
    }

    public String getAmountFieldName() {
        return this.amountFieldName;
    }

    public void setAmountFieldName(String amountFieldName) {
        this.amountFieldName = amountFieldName;
    }

    public IDICondition getIdiCondition() {
        return this.idiCondition;
    }

    public void setIdiCondition(IDICondition idiCondition) {
        this.idiCondition = idiCondition;
    }

    public List<DeductionGradeConfig> getDeductionGradeConfigList() {
        return this.deductionGradeConfigList;
    }

    public void setDeductionGradeConfigList(List<DeductionGradeConfig> deductionGradeConfigList) {
        this.deductionGradeConfigList = deductionGradeConfigList;
    }

    public int getCrossOneYearDeductionGradePercent() {
        return this.crossOneYearDeductionGradePercent;
    }

    public void setCrossOneYearDeductionGradePercent(int crossOneYearDeductionGradePercent) {
        this.crossOneYearDeductionGradePercent = crossOneYearDeductionGradePercent;
    }

    public int getCertifiedOfInvoiceDeductionGradePercent() {
        return this.certifiedOfInvoiceDeductionGradePercent;
    }

    public void setCertifiedOfInvoiceDeductionGradePercent(int certifiedOfInvoiceDeductionGradePercent) {
        this.certifiedOfInvoiceDeductionGradePercent = certifiedOfInvoiceDeductionGradePercent;
    }

    public int getDuplicateDeductionGradePercent() {
        return this.duplicateDeductionGradePercent;
    }

    public void setDuplicateDeductionGradePercent(int duplicateDeductionGradePercent) {
        this.duplicateDeductionGradePercent = duplicateDeductionGradePercent;
    }

    public int getCheckInvoiceHeaderDeductionGradePercent() {
        return this.checkInvoiceHeaderDeductionGradePercent;
    }

    public void setCheckInvoiceHeaderDeductionGradePercent(int checkInvoiceHeaderDeductionGradePercent) {
        this.checkInvoiceHeaderDeductionGradePercent = checkInvoiceHeaderDeductionGradePercent;
    }

    public int getBuyerTaxCodeDeductionGradePercent() {
        return this.buyerTaxCodeDeductionGradePercent;
    }

    public void setBuyerTaxCodeDeductionGradePercent(int buyerTaxCodeDeductionGradePercent) {
        this.buyerTaxCodeDeductionGradePercent = buyerTaxCodeDeductionGradePercent;
    }

    public int getCompletedOfSalerInfoDeductionGradePercent() {
        return this.completedOfSalerInfoDeductionGradePercent;
    }

    public void setCompletedOfSalerInfoDeductionGradePercent(int completedOfSalerInfoDeductionGradePercent) {
        this.completedOfSalerInfoDeductionGradePercent = completedOfSalerInfoDeductionGradePercent;
    }

    public int getCompletedOfBuyerInfoDeductionGradePercent() {
        return this.completedOfBuyerInfoDeductionGradePercent;
    }

    public void setCompletedOfBuyerInfoDeductionGradePercent(int completedOfBuyerInfoDeductionGradePercent) {
        this.completedOfBuyerInfoDeductionGradePercent = completedOfBuyerInfoDeductionGradePercent;
    }

    public int getCompletedOfStampDeductionGradePercent() {
        return this.completedOfStampDeductionGradePercent;
    }

    public void setCompletedOfStampDeductionGradePercent(int completedOfStampDeductionGradePercent) {
        this.completedOfStampDeductionGradePercent = completedOfStampDeductionGradePercent;
    }

    public int getFullAmountOfAllInvoicesDeductionGradePercent() {
        return this.fullAmountOfAllInvoicesDeductionGradePercent;
    }

    public void setFullAmountOfAllInvoicesDeductionGradePercent(int fullAmountOfAllInvoicesDeductionGradePercent) {
        this.fullAmountOfAllInvoicesDeductionGradePercent = fullAmountOfAllInvoicesDeductionGradePercent;
    }

    public int getContinuousNumberGradePercent() {
        return this.continuousNumberGradePercent;
    }

    public void setContinuousNumberGradePercent(int continuousNumberGradePercent) {
        this.continuousNumberGradePercent = continuousNumberGradePercent;
    }

    public String getNoInvoiceTip() {
        if (this.localNoInvoiceTip == null) {
            return this.noInvoiceTip;
        }
        return this.localNoInvoiceTip.toString();
    }

    public void setNoInvoiceTip(String noInvoiceTip) {
        this.noInvoiceTip = noInvoiceTip;
    }

    public LocaleString getLocalNoInvoiceTip() {
        if (this.localNoInvoiceTip == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.noInvoiceTip == null ? "" : this.noInvoiceTip);
        }
        return this.localNoInvoiceTip;
    }

    public void setLocalNoInvoiceTip(LocaleString localNoInvoiceTip) {
        this.localNoInvoiceTip = localNoInvoiceTip;
    }

    public void extractProperties(Set<String> varSet, String billType) {
        List<InvoiceConfigCustom> customList;
        if (this.getAmountFieldName() != null) {
            varSet.add(this.getAmountFieldName());
        }
        if (this.getCompanyFieldName() != null) {
            varSet.add(this.getCompanyFieldName());
        }
        if (this.getRequestDateField() != null) {
            varSet.add(this.getRequestDateField());
        }
        if ((customList = this.getCustomList()) != null) {
            for (InvoiceConfigCustom item : customList) {
                if (item.getRuleList() == null) continue;
                for (InvoiceDecisionRule rule : item.getRuleList()) {
                    if (rule.getCondition() == null) continue;
                    rule.getCondition().extractProperties(varSet, billType, new String[]{billType});
                }
            }
        }
        if (this.customInvoiceParam != null) {
            this.customInvoiceParam.extractProperties(varSet);
        }
        if (StringUtils.isNotEmpty((String)this.getSerialNoField())) {
            varSet.add(this.getSerialNoField());
        }
        if (this.getStartCondition() != null) {
            this.getStartCondition().extractProperties(varSet, billType, new String[]{billType});
        }
    }

    public boolean isUseCustomInvoiceParam() {
        return this.useCustomInvoiceParam;
    }

    public void setUseCustomInvoiceParam(boolean useCustomInvoiceParam) {
        this.useCustomInvoiceParam = useCustomInvoiceParam;
    }

    public CustomInvoiceParam getCustomInvoiceParam() {
        return this.customInvoiceParam;
    }

    public void setCustomInvoiceParam(CustomInvoiceParam customInvoiceParam) {
        this.customInvoiceParam = customInvoiceParam;
    }

    public IDICondition getStartCondition() {
        return this.startCondition;
    }

    public void setStartCondition(IDICondition startCondition) {
        this.startCondition = startCondition;
    }

    public String getSerialNoField() {
        return this.serialNoField;
    }

    public void setSerialNoField(String serialNoField) {
        this.serialNoField = serialNoField;
    }

    public boolean validate() {
        boolean ispass = true;
        boolean noPrepare = !this.crossOneYear && !this.isCertifiedOfInvoice && !this.isDuplicate && !this.isCheckInvoiceHeader && !this.isBuyerTaxCode && !this.isCompletedOfSalerInfo && !this.isCompletedOfBuyerInfo && !this.isFullAmountOfAllInvoices && !this.isContinuousNumber;
        boolean noCustom = CollectionUtils.isEmpty(this.customList);
        if (noPrepare && noCustom) {
            ispass = false;
        } else if (CollectionUtils.isNotEmpty(this.customList)) {
            block0: for (InvoiceConfigCustom invoiceConfigCustom : this.customList) {
                List<InvoiceDecisionRule> ruleList = invoiceConfigCustom.getRuleList();
                if (!CollectionUtils.isNotEmpty(ruleList)) continue;
                for (InvoiceDecisionRule rule : ruleList) {
                    if (rule.validate()) continue;
                    ispass = false;
                    continue block0;
                }
            }
        }
        return ispass;
    }
}

