/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;

public enum NumericalUnitEnum {
    NULL("0", ""){

        @Override
        public BigDecimal calUnitScale(BigDecimal value, int precision) {
            BigDecimal newValue = precision <= 0 ? value : value.setScale(precision, 4);
            return newValue;
        }
    }
    ,
    THOUSAND("1", ResManager.loadKDString((String)"\u5343", (String)"NumericalUnitEnum_0", (String)"data-idi-core", (Object[])new Object[0])){

        @Override
        public BigDecimal calUnitScale(BigDecimal value, int precision) {
            BigDecimal newValue = value.divide(new BigDecimal(1000));
            int newPrecision = precision + 3;
            return newValue.setScale(newPrecision, 4);
        }
    }
    ,
    TENTHOUSAND("2", ResManager.loadKDString((String)"\u4e07", (String)"NumericalUnitEnum_1", (String)"data-idi-core", (Object[])new Object[0])){

        @Override
        public BigDecimal calUnitScale(BigDecimal value, int precision) {
            BigDecimal newValue = value.divide(new BigDecimal(10000));
            int newPrecision = precision + 4;
            return newValue.setScale(newPrecision, 4);
        }
    }
    ,
    HUNDREDMILLION("3", ResManager.loadKDString((String)"\u4ebf", (String)"NumericalUnitEnum_2", (String)"data-idi-core", (Object[])new Object[0])){

        @Override
        public BigDecimal calUnitScale(BigDecimal value, int precision) {
            BigDecimal newValue = value.divide(new BigDecimal(100000000));
            int newPrecision = precision + 8;
            return newValue.setScale(newPrecision, 4);
        }
    }
    ,
    PERCENTAGE("4", "%"){

        @Override
        public BigDecimal calUnitScale(BigDecimal value, int precision) {
            BigDecimal newValue = value.multiply(new BigDecimal(100));
            int newPrecision = precision - 2;
            return newValue.setScale(Math.max(newPrecision, 0), 4);
        }
    }
    ,
    PERMILLAGE("5", "\u2030"){

        @Override
        public BigDecimal calUnitScale(BigDecimal value, int precision) {
            BigDecimal newValue = value.multiply(new BigDecimal(1000));
            int newPrecision = precision - 3;
            return newValue.setScale(Math.max(newPrecision, 0), 4);
        }
    };

    private String code;
    private String name;

    private NumericalUnitEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static NumericalUnitEnum convertFromMatchType(String code) {
        if (code != null) {
            for (NumericalUnitEnum e : NumericalUnitEnum.values()) {
                if (!code.equals(e.code)) continue;
                return e;
            }
        }
        return NULL;
    }

    public abstract BigDecimal calUnitScale(BigDecimal var1, int var2);
}

