/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.GradeItem;
import kd.data.idi.data.IDICondition;

public class Schema {
    private String number;
    private String name;
    private IDICondition startCondition;
    private List<Area> area;
    private List<GradeItem> grade;
    private String analysisMode;
    private long id;
    private boolean highLight;

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IDICondition getStartCondition() {
        return this.startCondition;
    }

    public void setStartCondition(IDICondition startCondition) {
        this.startCondition = startCondition;
    }

    public List<GradeItem> getGrade() {
        return this.grade;
    }

    public void setGrade(List<GradeItem> grade) {
        this.grade = grade;
    }

    public List<Area> getArea() {
        return this.area;
    }

    public void setArea(List<Area> area) {
        this.area = area;
    }

    public boolean isHighLight() {
        return this.highLight;
    }

    public void setHighLight(boolean highLight) {
        this.highLight = highLight;
    }

    public Set<String> extractProperties(String billType) {
        HashSet<String> varSet = new HashSet<String>();
        varSet.add("id");
        for (Area area : this.getArea()) {
            area.extractProperties(varSet, billType);
        }
        return varSet;
    }

    public String getAnalysisMode() {
        return this.analysisMode;
    }

    public void setAnalysisMode(String analysisMode) {
        this.analysisMode = analysisMode;
    }

    public boolean hasControl() {
        if (this.decisionHasControl()) {
            return true;
        }
        return this.gradeHasControl();
    }

    public boolean decisionHasControl() {
        if (this.area != null && !this.area.isEmpty()) {
            for (Area a : this.area) {
                if (!a.hasControl()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean gradeHasControl() {
        if (this.grade != null && !this.grade.isEmpty()) {
            for (GradeItem gradeItem : this.grade) {
                if (!gradeItem.hasControl()) continue;
                return true;
            }
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean hasLC() {
        if (this.area != null && !this.area.isEmpty()) {
            for (Area a : this.area) {
                if (!a.hasLC()) continue;
                return true;
            }
        }
        return false;
    }

    public Map<Long, Set<String>> achieveLcTemplateField(String billType) {
        HashMap<Long, Set<String>> lcTemplateFieldMap = new HashMap<Long, Set<String>>(10);
        if (this.area != null && !this.area.isEmpty()) {
            for (Area a : this.area) {
                if (!a.hasLC()) continue;
                Map<Long, Set<String>> areaLcTemplateFieldMap = a.achieveLcTemplateField(billType);
                areaLcTemplateFieldMap.forEach((templateId, fieldSet) -> {
                    Set lcTemplateFieldSet = (Set)lcTemplateFieldMap.get(templateId);
                    if (CollectionUtils.isNotEmpty((Collection)lcTemplateFieldSet)) {
                        lcTemplateFieldSet.addAll(fieldSet);
                    } else {
                        lcTemplateFieldSet = fieldSet;
                        lcTemplateFieldMap.put((Long)templateId, lcTemplateFieldSet);
                    }
                });
            }
        }
        return lcTemplateFieldMap;
    }
}

