/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.FormatObject;
import kd.data.idi.data.Schema;
import kd.data.idi.engine.courier.service.CourierParam;

public class SchemaContext {
    protected static final ThreadLocal<SchemaContext> current = new ThreadLocal();
    private Schema schema;
    private String entityType;
    private Object billId;
    private boolean debug = true;
    private FormatObject userFormatObject;
    private Map<Long, Long> currentGLPeriodId = new HashMap<Long, Long>();
    private Map<String, DynamicObject> currentGLAccountTable = new HashMap<String, DynamicObject>();
    private Map<String, CourierParam> courierParam;
    private DynamicObject billObj;
    private boolean billControl;
    private Map<Long, Set<String>> lcTemplateFieldMap;
    private String traceId;
    private MainEntityType srcEntityType;
    private String pageId;
    private boolean needHighLight;
    private boolean needAiAttachment;
    private boolean needRefreshAiResult;
    private boolean isBackstage;

    public static SchemaContext create() {
        SchemaContext context = new SchemaContext();
        current.set(context);
        return context;
    }

    public static SchemaContext create(SchemaContext context) {
        current.set(context);
        return context;
    }

    public static void remove() {
        current.remove();
    }

    public static SchemaContext get() {
        return current.get();
    }

    public Long getCurrentGLPeriodId(Long periodType) {
        return this.currentGLPeriodId.get(periodType);
    }

    public void setCurrentGLPeriodId(Long periodType, Long currentGLPeriodId) {
        this.currentGLPeriodId.put(periodType, currentGLPeriodId);
    }

    public DynamicObject getCurrentGLAccountTable(Number orgId, Number bookTypeId) {
        return this.currentGLAccountTable.get(orgId + "_" + bookTypeId);
    }

    public void setCurrentGLAccountTable(Number orgId, Number bookTypeId, DynamicObject accountTable) {
        this.currentGLAccountTable.put(orgId + "_" + bookTypeId, accountTable);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public Object getBillId() {
        return this.billId;
    }

    public void setBillId(Object billId) {
        this.billId = billId;
    }

    public DynamicObject getSelfBill() {
        return this.billObj;
    }

    public void setSelfBill(DynamicObject bill) {
        this.billObj = bill;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public FormatObject getUserFormatObject() {
        return this.userFormatObject;
    }

    public void setUserFormatObject(FormatObject userFormatObject) {
        this.userFormatObject = userFormatObject;
    }

    public Map<String, CourierParam> getCourierParam() {
        return this.courierParam;
    }

    public void setCourierParam(Map<String, CourierParam> courierParam) {
        this.courierParam = courierParam;
    }

    public boolean isBillControl() {
        return this.billControl;
    }

    public void setBillControl(boolean billControl) {
        this.billControl = billControl;
    }

    public Map<Long, Set<String>> getLcTemplateFieldMap() {
        return this.lcTemplateFieldMap;
    }

    public void setLcTemplateFieldMap(Map<Long, Set<String>> lcTemplateFieldMap) {
        this.lcTemplateFieldMap = lcTemplateFieldMap;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public MainEntityType getSrcEntityType() {
        return this.srcEntityType;
    }

    public void setSrcEntityType(MainEntityType srcEntityType) {
        this.srcEntityType = srcEntityType;
    }

    public boolean isNeedHighLight() {
        return this.needHighLight;
    }

    public void setNeedHighLight(boolean needHighLight) {
        this.needHighLight = needHighLight;
    }

    public boolean isNeedAiAttachment() {
        return this.needAiAttachment;
    }

    public void setNeedAiAttachment(boolean needAiAttachment) {
        this.needAiAttachment = needAiAttachment;
    }

    public boolean isNeedRefreshAiResult() {
        return this.needRefreshAiResult;
    }

    public void setNeedRefreshAiResult(boolean needRefreshAiResult) {
        this.needRefreshAiResult = needRefreshAiResult;
    }

    public boolean isBackstage() {
        return this.isBackstage;
    }

    public void setBackstage(boolean backstage) {
        this.isBackstage = backstage;
    }
}

