/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.IDIEnumLoadKDStringBridge;

public class StatisticsConfig {
    public static final String LASTTIME = "lastTime";
    public static final String LASTTHREETIMES = "lastThreeTimes";
    public static final String LASTCUSTOMTIMES = "lastCustomTimes";
    private String targetBillType;
    private IDICondition condition;
    private DimFieldType dimFieldType;
    private String dimPropName;
    private List<String> dimPropNames;
    private List<String> renameDimPropNames;
    private List<LocaleString> localRenameDimPropNames;
    private String showField;
    private String renameShowField;
    private LocaleString localRenameShowField;
    private List<DataProcessConfig> processConfigList;
    private int customTimes;

    public String getTargetBillType() {
        return this.targetBillType;
    }

    public void setTargetBillType(String targetBillType) {
        this.targetBillType = targetBillType;
    }

    public IDICondition getCondition() {
        return this.condition;
    }

    public void setCondition(IDICondition condition) {
        this.condition = condition;
    }

    public DimFieldType getDimFieldType() {
        return this.dimFieldType;
    }

    public void setDimFieldType(DimFieldType dimFieldType) {
        this.dimFieldType = dimFieldType;
    }

    public String getDimPropName() {
        return this.dimPropName;
    }

    public void setDimPropName(String dimPropName) {
        this.dimPropName = dimPropName;
    }

    public String getShowField() {
        return this.showField;
    }

    public void setShowField(String showField) {
        this.showField = showField;
    }

    public String getRenameShowField() {
        if (this.localRenameShowField == null) {
            return this.renameShowField;
        }
        return this.localRenameShowField.toString();
    }

    public void setRenameShowField(String renameShowField) {
        this.renameShowField = renameShowField;
    }

    public LocaleString getLocalRenameShowField() {
        if (this.localRenameShowField == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.renameShowField);
        }
        return this.localRenameShowField;
    }

    public void setLocalRenameShowField(LocaleString localRenameShowField) {
        this.localRenameShowField = localRenameShowField;
    }

    public List<String> getDimPropNames() {
        return this.dimPropNames == null ? new ArrayList(1) : this.dimPropNames;
    }

    public List<String> getDimPropNameList() {
        if ((this.dimPropNames == null || this.dimPropNames.isEmpty()) && StringUtils.isNotEmpty((String)this.dimPropName)) {
            ArrayList<String> result = new ArrayList<String>(1);
            result.add(this.dimPropName);
            return result;
        }
        if (this.dimPropNames == null) {
            return new ArrayList<String>(1);
        }
        return this.dimPropNames;
    }

    public String getDimPropNameSting(String dimPropName) {
        if (this.dimPropNames == null) {
            return StringUtils.isEmpty((String)dimPropName) ? null : "," + dimPropName + ",";
        }
        if (this.dimPropNames.isEmpty() && StringUtils.isNotEmpty((String)dimPropName)) {
            this.dimPropNames.add(dimPropName);
        }
        return this.dimPropNames.isEmpty() ? null : "," + String.join((CharSequence)",", this.dimPropNames) + ",";
    }

    public List<String> getRenameDimPropNames() {
        if (this.localRenameDimPropNames == null) {
            return this.renameDimPropNames;
        }
        return this.localRenameDimPropNames.stream().map(LocaleString::toString).collect(Collectors.toList());
    }

    public void setRenameDimPropNames(List<String> renameDimPropNames) {
        this.renameDimPropNames = renameDimPropNames;
    }

    public List<LocaleString> getLocalRenameDimPropNames() {
        if (this.localRenameDimPropNames == null) {
            return this.renameDimPropNames == null ? new ArrayList<LocaleString>(0) : this.renameDimPropNames.stream().map(x -> new LocaleString(Lang.zh_CN.toString(), x)).collect(Collectors.toList());
        }
        return this.localRenameDimPropNames;
    }

    public void setLocalRenameDimPropNames(List<LocaleString> localRenameDimPropNames) {
        this.localRenameDimPropNames = localRenameDimPropNames;
    }

    public void setDimPropNames(List<String> dimPropNames) {
        this.dimPropNames = dimPropNames;
    }

    public List<DataProcessConfig> getProcessConfigList() {
        return this.processConfigList;
    }

    public void setProcessConfigList(List<DataProcessConfig> processConfigList) {
        this.processConfigList = processConfigList;
    }

    public void extractProperties(Set<String> varSet, String billType) {
        if (this.getCondition() != null) {
            IDICondition.extractFieldEqualProperties(varSet, this.getCondition().getFilterCondition());
        }
        if (this.processConfigList != null && !this.processConfigList.isEmpty()) {
            for (DataProcessConfig dataProcessConfig : this.processConfigList) {
                if (MethodType.RANK != dataProcessConfig.getMethod()) continue;
                varSet.add(dataProcessConfig.getPropName());
            }
        }
        if (DimFieldType.ENTRY == this.getDimFieldType()) {
            varSet.addAll(this.getDimPropNameList());
        }
    }

    public int getCustomTimes() {
        return this.customTimes;
    }

    public void setCustomTimes(int customTimes) {
        this.customTimes = customTimes;
    }

    public static class DataProcessConfig {
        private MethodType method;
        private String propName;
        private String displayName;
        private LocaleString localDisplayName;
        private String lastTimePropName;

        public MethodType getMethod() {
            return this.method;
        }

        public void setMethod(MethodType method) {
            this.method = method;
        }

        public String getPropName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }

        public String getDisplayName() {
            if (this.localDisplayName == null) {
                return this.displayName;
            }
            return this.localDisplayName.toString();
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public LocaleString getLocalDisplayName() {
            if (this.localDisplayName == null) {
                return this.displayName == null ? new LocaleString(Lang.zh_CN.toString(), "") : new LocaleString(Lang.zh_CN.toString(), this.displayName);
            }
            return this.localDisplayName;
        }

        public void setLocalDisplayName(LocaleString localDisplayName) {
            this.localDisplayName = localDisplayName;
        }

        public String getLastTimePropName() {
            return this.lastTimePropName;
        }

        public void setLastTimePropName(String lastTimePropName) {
            this.lastTimePropName = lastTimePropName;
        }
    }

    public static enum MethodType {
        MIN("MIN", new IDIEnumLoadKDStringBridge("\u6700\u5c0f\u503c", "StatisticsConfig_0", "data-idi-core")),
        MAX("MAX", new IDIEnumLoadKDStringBridge("\u6700\u5927\u503c", "StatisticsConfig_1", "data-idi-core")),
        AVG("AVG", new IDIEnumLoadKDStringBridge("\u5e73\u5747\u503c", "StatisticsConfig_2", "data-idi-core")),
        SUM("SUM", new IDIEnumLoadKDStringBridge("\u6c47\u603b", "StatisticsConfig_3", "data-idi-core")),
        COUNT("COUNT", new IDIEnumLoadKDStringBridge("\u8ba1\u6570", "StatisticsConfig_4", "data-idi-core")),
        RANK("RANK", new IDIEnumLoadKDStringBridge("\u6392\u540d", "StatisticsConfig_5", "data-idi-core")),
        LAST("LAST", new IDIEnumLoadKDStringBridge("\u6700\u8fd1\u4e00\u6b21", "StatisticsConfig_6", "data-idi-core")),
        DISPLAY("DISPLAY", new IDIEnumLoadKDStringBridge("\u4ec5\u5c55\u793a", "StatisticsConfig_7", "data-idi-core"));

        private String type;
        private IDIEnumLoadKDStringBridge desc;

        private MethodType(String type, IDIEnumLoadKDStringBridge desc) {
            this.type = type;
            this.desc = desc;
        }

        public String getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }

        public static MethodType convert(String type) {
            if (type != null) {
                for (MethodType e : MethodType.values()) {
                    if (!type.equals(e.type)) continue;
                    return e;
                }
            }
            return null;
        }

        public static String getDesc(String type) {
            if (type == null) {
                return null;
            }
            for (MethodType e : MethodType.values()) {
                if (!type.equals(e.getType())) continue;
                return e.getDesc();
            }
            return null;
        }
    }

    public static enum DimFieldType {
        HEADER("HEADER"),
        ENTRY("ENTRY");

        private String type;

        private DimFieldType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static DimFieldType convert(String type) {
            if (type != null) {
                for (DimFieldType e : DimFieldType.values()) {
                    if (!type.equals(e.type)) continue;
                    return e;
                }
            }
            return null;
        }
    }
}

