/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data.statistics;

import java.util.Arrays;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.TranFormulaHelper;

public class AlarmHoverSettingRow {
    private String propName;
    private String propDisplayName;
    private String displayName;
    private LocaleString localDisplayName;
    private String entityNumber;

    public AlarmHoverSettingRow(String propName, String propDisplayName, String displayName, LocaleString localDisplayName) {
        this.propName = propName;
        this.propDisplayName = propDisplayName;
        this.displayName = displayName;
        this.localDisplayName = localDisplayName;
    }

    public String getPropName() {
        return this.propName;
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public String getPropDisplayName() {
        if (StringUtils.isNotEmpty((String)this.entityNumber)) {
            try {
                String localFieldCaption = TranFormulaHelper.getLocalFieldCaption(this.entityNumber, this.propName, null);
                return StringUtils.isEmpty((String)localFieldCaption) ? this.propDisplayName : localFieldCaption;
            }
            catch (Exception ignore) {
                SchemaExecutorLogger.info("IDI multi-language exception" + Arrays.toString(ignore.getStackTrace()), new Object[0]);
            }
        }
        return this.propDisplayName;
    }

    public void setPropDisplayName(String propDisplayName) {
        this.propDisplayName = propDisplayName;
    }

    public String getDisplayName() {
        if (this.localDisplayName == null) {
            return this.displayName;
        }
        return this.localDisplayName.toString();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public LocaleString getLocalDisplayName() {
        if (this.localDisplayName == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.displayName == null ? "" : this.displayName);
        }
        return this.localDisplayName;
    }

    public void setLocalDisplayName(LocaleString localDisplayName) {
        this.localDisplayName = localDisplayName;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }
}

