/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.dataconverter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.data.show.HrefItemModel;
import kd.data.idi.data.show.PopoverModel;
import kd.data.idi.data.show.PopoverRowModel;
import kd.data.idi.data.show.TextItemModel;
import kd.data.idi.dataconverter.IIDIDataConverter;
import kd.data.idi.util.IDIJSONUtils;

public abstract class IDISchemaResultDataConvert
implements IIDIDataConverter<SchemaResult, Map<String, Object>, Schema> {
    protected static final String COLOR_GREEN = "green";
    protected static final String COLOR_YELLOW = "yellow";
    protected static final String COLOR_RES = "red";

    String getColor(String color) {
        if (COLOR_GREEN.equals(color)) {
            return "#32AA70";
        }
        if (COLOR_YELLOW.equals(color)) {
            return "#FFAA56";
        }
        if (COLOR_RES.equals(color)) {
            return "#FF0000";
        }
        return color;
    }

    String getIcon(String type) {
        switch (type) {
            case "normal": {
                return "agree_13_13.png";
            }
            case "warnning": {
                return "remind_28_28.png";
            }
            case "nocontrolbillcontrolalarming": 
            case "alarming": {
                return "fail.png";
            }
            case "none": {
                return "exception.png";
            }
            case "loading": {
                return "none.png";
            }
        }
        return "agree_13_13.png";
    }

    PopoverModel createCardPopover(HoverContent s) {
        PopoverModel popoverModel = new PopoverModel();
        TextItemModel itemModel = HoverContent.ContentType.HREF == s.getType() || HoverContent.ContentType.CHAT == s.getType() ? new HrefItemModel(s.getContent(), s.getData()) : new TextItemModel(s.getContent());
        itemModel.addItemStyle("color", "#768893");
        itemModel.addItemStyle("width", "100%");
        PopoverRowModel rowModel = new PopoverRowModel();
        rowModel.addItem(itemModel);
        popoverModel.addRowItem(rowModel);
        return popoverModel;
    }

    PopoverModel createCardPopover(DecisionFrontEndResult frontEndResult, String ... args) {
        List<List<HoverContent>> hoverContent = frontEndResult.getHoverContent();
        if (hoverContent == null || hoverContent.isEmpty()) {
            return null;
        }
        PopoverModel popoverModel = new PopoverModel();
        String matchType = null;
        if (args != null && args.length > 0) {
            matchType = args[0];
        }
        if (MatchType.ALARM.getType().equalsIgnoreCase(matchType)) {
            return this.alarmCountMsgHrefContents(popoverModel, frontEndResult);
        }
        PopoverRowModel lastPopoverRowModel = null;
        int rowIndex = 0;
        for (List<HoverContent> row : hoverContent) {
            PopoverRowModel rowModel = new PopoverRowModel();
            rowModel.addPopoverRowStyle("background-color", frontEndResult.isTableStyle() && rowIndex == 0 ? "#F3F3F3" : "#ffffff");
            rowModel.addPopoverRowStyle("display", "flex");
            int i = 0;
            for (HoverContent s : row) {
                TextItemModel itemModel;
                TextItemModel textItemModel = itemModel = HoverContent.ContentType.HREF == s.getType() || HoverContent.ContentType.CHAT == s.getType() ? new HrefItemModel(s.getContent(), s.getData()) : new TextItemModel(s.getContent());
                if (frontEndResult.isTableStyle() && HoverContent.ContentType.TITLE == s.getType()) {
                    itemModel.addItemStyle("color", "#333333");
                    itemModel.addItemStyle("word-break", "break-word");
                    if (i > 0) {
                        itemModel.addItemStyle("border-left-color", "#cccccc");
                        itemModel.addItemStyle("border-left-style", "solid");
                        itemModel.addItemStyle("border-left-width", "1px");
                    }
                } else {
                    itemModel.addItemStyle("color", "#1D1D1D");
                }
                itemModel.addItemStyle("flex-grow", "1");
                itemModel.addItemStyle("width", "138px");
                String align = "";
                align = i == 0 ? "left" : (i == row.size() - 1 ? "right" : "center");
                itemModel.addItemStyle("text-align", align);
                rowModel.addItem(itemModel);
                ++i;
            }
            popoverModel.addRowItem(rowModel);
            lastPopoverRowModel = rowModel;
            ++rowIndex;
        }
        if (lastPopoverRowModel == null) {
            return null;
        }
        return popoverModel;
    }

    private PopoverModel alarmCountMsgHrefContents(PopoverModel popoverModel, DecisionFrontEndResult frontEndResult) {
        List<String> headTitleList = frontEndResult.getHeadTitleList();
        List<List<HoverContent>> hoverContentList = frontEndResult.getHoverContent();
        Map<String, Object> customParamMap = frontEndResult.getCustomParamMap();
        List billIds = (List)customParamMap.get("sameBillIds");
        String entityNumber = (String)customParamMap.get("entityNumber");
        popoverModel.addRowItem(this.createHeadRowModel(headTitleList));
        for (List<HoverContent> hoverContents : hoverContentList) {
            popoverModel.addRowItem(this.createDataRowModel(hoverContents));
        }
        popoverModel.addRowItem(this.createBottomRowModel(entityNumber, billIds));
        return popoverModel;
    }

    private PopoverRowModel createHeadRowModel(List<String> headTitleList) {
        PopoverRowModel headRowModel = new PopoverRowModel();
        headRowModel.addPopoverRowStyle("background-color", "#e5e5e5");
        headRowModel.addPopoverRowStyle("display", "flex");
        int index = 0;
        for (String h : headTitleList) {
            TextItemModel itemModel = new TextItemModel(h);
            itemModel.addItemStyle("text-align", "left");
            itemModel.addItemStyle("flex-grow", "0");
            itemModel.addItemStyle("width", "138px");
            itemModel.addItemStyle("word-break", "break-word");
            if (index > 0) {
                itemModel.addItemStyle("margin-left", "30px");
            }
            headRowModel.addItem(itemModel);
            ++index;
        }
        return headRowModel;
    }

    private PopoverRowModel createDataRowModel(List<HoverContent> hoverContents) {
        PopoverRowModel currentRowModel = new PopoverRowModel();
        currentRowModel.addPopoverRowStyle("background-color", "#ffffff");
        currentRowModel.addPopoverRowStyle("display", "flex");
        int index = 0;
        for (HoverContent hoverContent : hoverContents) {
            String content = hoverContent.getContent();
            Map<String, Object> data = hoverContent.getData();
            TextItemModel currentItemModel = HoverContent.ContentType.HREF == hoverContent.getType() || HoverContent.ContentType.CHAT == hoverContent.getType() ? new HrefItemModel(content, data) : new TextItemModel(content);
            currentItemModel.addItemStyle("color", "#1D1D1D");
            currentItemModel.addItemStyle("text-align", "left");
            currentItemModel.addItemStyle("flex-grow", "0");
            currentItemModel.addItemStyle("width", "138px");
            if (index > 0) {
                currentItemModel.addItemStyle("margin-left", "30px");
            }
            currentRowModel.addItem(currentItemModel);
            ++index;
        }
        return currentRowModel;
    }

    private PopoverRowModel createBottomRowModel(String entityNumber, List billIds) {
        HashMap<String, Object> bottomData = new HashMap<String, Object>(3);
        bottomData.put("entityNumber", entityNumber);
        bottomData.put("action", "showBillList");
        bottomData.put("billId", IDIJSONUtils.toJsonString((Object)billIds));
        String bottomContent = billIds.size() > 3 ? String.format(ResManager.loadKDString((String)"...\u5171%d\u5f20\u91cd\u590d\u5355\u636e", (String)"IDISchemaResultPCDataConvert_20", (String)"data-idi-core", (Object[])new Object[0]), billIds.size()) : String.format(ResManager.loadKDString((String)"\u5171%d\u5f20\u91cd\u590d\u5355\u636e", (String)"IDISchemaResultPCDataConvert_19", (String)"data-idi-core", (Object[])new Object[0]), billIds.size());
        HrefItemModel bottomItemModel = new HrefItemModel(bottomContent, (Map<String, Object>)bottomData);
        bottomItemModel.addItemStyle("color", "#1D1D1D");
        bottomItemModel.addItemStyle("text-align", "left");
        bottomItemModel.addItemStyle("min-width", "80px");
        PopoverRowModel bottomPopoverRowModel = new PopoverRowModel();
        bottomPopoverRowModel.addItem(bottomItemModel);
        bottomPopoverRowModel.addPopoverRowStyle("background-color", "#ffffff");
        bottomPopoverRowModel.addPopoverRowStyle("display", "flex");
        return bottomPopoverRowModel;
    }

    String getErrorSchemaText(String defaultText, String status) {
        String text = defaultText;
        switch (status) {
            case "empty": {
                text = ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u65b9\u6848\u6216\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848", (String)"IDISchemaResultPCDataConvert_1", (String)"data-idi-core", (Object[])new Object[0]);
                break;
            }
            case "disable": {
                text = ResManager.loadKDString((String)"\u65b9\u6848\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848", (String)"IDISchemaResultPCDataConvert_2", (String)"data-idi-core", (Object[])new Object[0]);
                break;
            }
            case "nostart": {
                text = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848", (String)"IDISchemaResultPCDataConvert_3", (String)"data-idi-core", (Object[])new Object[0]);
                break;
            }
            case "nolicense": {
                text = ResManager.loadKDString((String)"\u6ca1\u6709\u201cPRO_IDI\u201d\u5206\u7ec4\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IDISchemaResultPCDataConvert_21", (String)"data-idi-core", (Object[])new Object[0]);
            }
        }
        return text;
    }
}

