/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.dataconverter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.MobileRelationItem;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.data.show.CardModel;
import kd.data.idi.data.show.CardRowModel;
import kd.data.idi.data.show.IconItemModel;
import kd.data.idi.data.show.ItemModel;
import kd.data.idi.data.show.TextItemModel;
import kd.data.idi.dataconverter.IDISchemaResultPCDataConvert;

public class IDISchemaResultMobileDataConvert
extends IDISchemaResultPCDataConvert {
    @Override
    public Map<String, Object> convertObject(SchemaResult result, Schema schema) {
        Map<String, Object> map = super.convertObject(result, schema);
        map.put("isPC", Boolean.FALSE);
        return map;
    }

    @Override
    protected List<CardRowModel> createHeader(Schema schema, SchemaResult result) {
        List<CardRowModel> list = super.createHeader(schema, result);
        CardRowModel cardRowModel = list.get(0);
        cardRowModel.addMainStyle("max-width", "190px");
        return list;
    }

    @Override
    protected String defaultHeadertxt() {
        return ResManager.loadKDString((String)"\u67e5\u770b\u5c0fk\u6d1e\u5bdf\u8be6\u60c5", (String)"IDISchemaResultMobileDataConvert_2", (String)"data-idi-core", (Object[])new Object[0]);
    }

    @Override
    protected CardModel createCard(int i, AreaResult areaResult) {
        CardModel cardModel = super.createCard(i, areaResult);
        if (cardModel == null) {
            return null;
        }
        cardModel.addCardStyle("border-left-color", i % 2 == 0 ? "#EA5E56" : "#4598F0");
        cardModel.addCardStyle("border-top", "0px");
        cardModel.addCardStyle("border-right", "0px");
        cardModel.addCardStyle("border-bottom", "0px");
        cardModel.addCardStyle("background-color", "#ffffff");
        return cardModel;
    }

    @Override
    protected void createTotalRow(List<CardRowModel> cardRowModelList, List<CardRowModel> statisticCardRowModelList) {
        int successCount = 0;
        int errorCount = 0;
        ArrayList<MobileRelationItem> dataList = new ArrayList<MobileRelationItem>();
        ArrayList<MobileRelationItem> errorDataList = new ArrayList<MobileRelationItem>();
        ArrayList<CardRowModel> removeList = new ArrayList<CardRowModel>();
        for (CardRowModel cardRowModel : statisticCardRowModelList) {
            List<ItemModel> itemList = cardRowModel.getMainDesc();
            ItemModel item = itemList.get(0);
            String iconName = ((IconItemModel)item).getIconName();
            if (iconName.indexOf("agree") > -1) {
                ++successCount;
                dataList.add(new MobileRelationItem(((TextItemModel)itemList.get(1)).getContent(), "agree"));
                removeList.add(cardRowModel);
                continue;
            }
            if (iconName.indexOf("exception") <= -1) continue;
            ++errorCount;
            errorDataList.add(new MobileRelationItem(((TextItemModel)itemList.get(1)).getContent(), "none"));
            removeList.add(cardRowModel);
        }
        StringBuilder sb = new StringBuilder();
        if (successCount + errorCount > 1) {
            if (successCount > 0) {
                sb.append(String.format(ResManager.loadKDString((String)"%d\u9879\u68c0\u67e5\u9879\u5408\u89c4", (String)"IDISchemaResultMobileDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]), successCount));
            }
            if (errorCount > 0) {
                sb.append(String.format(ResManager.loadKDString((String)"%d\u9879\u68c0\u67e5\u9879\u672a\u6b63\u5e38\u68c0\u6d4b\u51fa", (String)"IDISchemaResultMobileDataConvert_1", (String)"data-idi-core", (Object[])new Object[0]), errorCount));
            }
        }
        if (sb.length() > 0) {
            DecisionResult totalResult = new DecisionResult();
            totalResult.setShowText(sb.toString());
            totalResult.setFrontEndResult(new DecisionFrontEndResult());
            Decision d = new Decision();
            totalResult.setDecision(d);
            CardRowModel totalRowModel = this.createCardRow(totalResult, null, null, null);
            List<ItemModel> iconList = totalRowModel.getSecondDesc();
            IconItemModel iconModel = (IconItemModel)iconList.get(0);
            iconModel.setIconName("arrow.png");
            iconModel.addItemStyle("transform", "rotate(270deg)");
            iconModel.getItemStyle().remove("display");
            iconModel.addImageStyle("width", "24px");
            iconModel.addImageStyle("height", "24px");
            cardRowModelList.add(totalRowModel);
            dataList.addAll(errorDataList);
            if (!dataList.isEmpty()) {
                totalRowModel.setDataList(dataList);
            }
            cardRowModelList.removeAll(removeList);
        }
    }

    @Override
    protected void tableDataIconStyleChange(IconItemModel iconModel) {
        iconModel.addItemStyle("display", "none");
    }

    @Override
    protected void invoiceRowStyle(IconItemModel iconModel, CardRowModel cardRowModel) {
        cardRowModel.addSecondStyle("display", "none");
        cardRowModel.addMainStyle("width", "100%");
    }

    @Override
    protected IconItemModel createCardRowIcon(DecisionResult decisionResult) {
        String status = decisionResult.getStatus();
        if (!StringUtils.isEmpty((String)status)) {
            IconItemModel iconItemModel = new IconItemModel("block.png");
            iconItemModel.setIconName(this.getIcon(status));
            return iconItemModel;
        }
        return null;
    }

    @Override
    protected void cardRowStyle(CardRowModel cardRowModel, IconItemModel iconModel, List<ItemModel> secondList) {
        if (iconModel != null) {
            iconModel.addItemStyle("display", "none");
        }
        if (secondList.isEmpty()) {
            cardRowModel.addMainStyle("width", "91%");
        } else {
            cardRowModel.addMainStyle("width", "50%");
            cardRowModel.setSecondDesc(secondList);
            cardRowModel.addSecondStyle("width", "46%");
            cardRowModel.addSecondStyle("justify-content", "flex-end");
        }
    }

    @Override
    protected IconItemModel createCardRowIcon(LinkUpBillResult linkUpBillResult) {
        String status = linkUpBillResult.getStatus();
        if (!StringUtils.isEmpty((String)status)) {
            IconItemModel iconItemModel = new IconItemModel("block.png");
            iconItemModel.setIconName(this.getIcon(status));
            return iconItemModel;
        }
        return null;
    }
}

