/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.dataconverter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.AlarmResult;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.BillControlTypeEnum;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.GradeItem;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.InvoiceImageRuleResult;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.dataconverter.IIDIDataConverter;
import kd.data.idi.decision.openapi.ApiDecisionResultItem;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;

public class IDISchemaResultOpDataConvert
implements IIDIDataConverter<SchemaResult, Map<String, Object>, Schema> {
    private static final String STATUS = "status";
    private static final String GRADE_MORETHAN = "morethan";
    private static final String GRADE_OTHER = "other";
    private static final String CONTROLSTATUS = "controlStatus";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";

    @Override
    public Map<String, Object> convertObject(SchemaResult result, Schema schema) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(STATUS, result.getStatus());
        if ("success".equalsIgnoreCase(result.getStatus())) {
            String fixMessage;
            List<ControlResult> list;
            try {
                list = this.processDecisionResult(result);
            }
            catch (Throwable e) {
                SchemaExecutorLogger.error(IDIJSONUtils.toJsonString((Object)result), e);
                throw e;
            }
            SchemaExecutorLogger.info("ControlResult :" + IDIJSONUtils.toJsonString(list), new Object[0]);
            boolean isItemControl = false;
            boolean isItemFore = false;
            HashSet<String> showTxtSet = new HashSet<String>(1);
            for (ControlResult controlResult : list) {
                if (controlResult.isPass || !controlResult.isShow) continue;
                if (controlResult.controlType == BillControlTypeEnum.FORCE || controlResult.controlType == BillControlTypeEnum.CONFIREM) {
                    String showTxt = controlResult.showTxt;
                    if (StringUtils.isNotEmpty((CharSequence)showTxt)) {
                        showTxtSet.add(showTxt.trim());
                    }
                    isItemControl = true;
                }
                if (controlResult.controlType != BillControlTypeEnum.FORCE) continue;
                isItemFore = true;
            }
            boolean onlyAttachRecognizeFailed = false;
            SchemaExecutorLogger.info("idi showTxtSet :" + IDIJSONUtils.toJsonString(showTxtSet), new Object[0]);
            if (showTxtSet.size() == 1 && (fixMessage = ResManager.loadKDString((String)"\u5b58\u5728\u8bc6\u522b\u5931\u8d25\u7684\u9644\u4ef6", (String)"AttachmentExecutor_4", (String)"data-idi-core", (Object[])new Object[0])).equals(showTxtSet.iterator().next())) {
                isItemFore = false;
                isItemControl = true;
                onlyAttachRecognizeFailed = true;
            }
            int score = result.getScore();
            GradeItem matchItem = this.matchGrade(schema, score);
            boolean hasGrade = false;
            boolean gradleControl = false;
            boolean isGradeForce = false;
            if (matchItem != null) {
                hasGrade = true;
                gradleControl = matchItem.hasControl();
                isGradeForce = BillControlTypeEnum.FORCE == matchItem.getBillControl();
            }
            SchemaExecutorLogger.info("idi isItemFore : %s, isItemControl: %s, gradleControl : %s, isGradeForce : %s", isItemFore, isItemControl, gradleControl, isGradeForce);
            boolean needGrade = false;
            if (isItemFore) {
                this.createItemShowContent(true, resultMap, list, false);
            } else if (isGradeForce) {
                needGrade = true;
                this.createGradeItemShowContent(true, resultMap, list, score, matchItem);
            } else if (isItemControl) {
                this.createItemShowContent(false, resultMap, list, onlyAttachRecognizeFailed);
            } else if (gradleControl) {
                needGrade = true;
                this.createGradeItemShowContent(false, resultMap, list, score, matchItem);
            } else {
                String message;
                if (!list.isEmpty()) {
                    message = ResManager.loadKDString((String)"\u5168\u90e8\u901a\u8fc7\u6216\u4e0d\u901a\u8fc7\u9879\u4e3a\u4e0d\u63a7\u5236\u3002\u7ed3\u679c\u4e3a\uff1a", (String)"IDISchemaResultOpDataConvert_2", (String)"data-idi-core", (Object[])new Object[0]);
                    message = message + list;
                    SchemaExecutorLogger.info(message, new Object[0]);
                }
                if (!hasGrade) {
                    message = ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u603b\u5206\u914d\u7f6e\u3002\u7ed3\u679c\u4e3a\uff1a", (String)"IDISchemaResultOpDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]);
                    message = message + list;
                } else {
                    message = ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u603b\u5206\u914d\u7f6e\u3002\u8be5\u6761\u76ee\u672a\u914d\u7f6e\u63a7\u5236\u6216\u4e0d\u63a7\u5236\u3002\u603b\u6570\u914d\u7f6e\u4e3a\uff1a", (String)"IDISchemaResultOpDataConvert_1", (String)"data-idi-core", (Object[])new Object[0]);
                    message = message + matchItem;
                }
                SchemaExecutorLogger.info(message, new Object[0]);
                resultMap.put(CONTROLSTATUS, BillControlTypeEnum.NOCONTROL.getType());
            }
            List messageList = (List)resultMap.get(CONTENT);
            if (BillControlTypeEnum.CONFIREM.getType().equals(resultMap.get(CONTROLSTATUS)) && CollectionUtils.isNotEmpty((Collection)messageList)) {
                String scoreTitle = ResManager.loadKDString((String)"\u3010\u667a\u80fd\u6570\u636e\u6d1e\u5bdf\u8bc4\u5206%d\u5206\u3011", (String)"IDISchemaResultOpDataConvert_11", (String)"data-idi-core", (Object[])new Object[0]);
                if (needGrade) {
                    messageList.add(0, String.format(scoreTitle, result.getScore()));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)messageList)) {
                String endMsg = (String)messageList.get(messageList.size() - 1);
                if (StringUtils.isNotEmpty((CharSequence)endMsg) && endMsg.endsWith("\uff1b")) {
                    endMsg = endMsg.substring(0, endMsg.length() - 1);
                }
                messageList.set(messageList.size() - 1, endMsg);
            }
        }
        SchemaExecutorLogger.info("schema result :" + IDIJSONUtils.toJsonString((Object)result), new Object[0]);
        SchemaExecutorLogger.info("bill control result convert:" + resultMap, new Object[0]);
        return resultMap;
    }

    private void createGradeItemShowContent(Boolean isGradeItemForce, Map<String, Object> resultMap, List<ControlResult> list, int score, GradeItem matchItem) {
        String title = this.convertGradeTitle(isGradeItemForce, score, matchItem.getShowScript());
        List<String> messageList = this.convertGradeShowTxt(isGradeItemForce, list);
        resultMap.put(TITLE, title);
        resultMap.put(CONTENT, messageList);
        resultMap.put(CONTROLSTATUS, matchItem.getBillControl().getType());
    }

    private void createItemShowContent(Boolean isItemForce, Map<String, Object> resultMap, List<ControlResult> list, boolean onlyAttachRecognizeFailed) {
        String title = this.convertItemTitle(isItemForce);
        List<String> messageList = this.convertShowTxt(list, isItemForce, onlyAttachRecognizeFailed);
        resultMap.put(CONTROLSTATUS, isItemForce != false ? BillControlTypeEnum.FORCE.getType() : BillControlTypeEnum.CONFIREM.getType());
        resultMap.put(TITLE, title);
        resultMap.put(CONTENT, messageList);
    }

    private GradeItem matchGrade(Schema schema, int score) {
        List<GradeItem> gradeList = schema.getGrade();
        GradeItem matchItem = null;
        GradeItem defaultMatchItem = null;
        if (gradeList != null) {
            for (GradeItem item : gradeList) {
                if (GRADE_MORETHAN.equalsIgnoreCase(item.getCondition())) {
                    if (!((float)score >= item.getGrade())) continue;
                    matchItem = item;
                    break;
                }
                if (!GRADE_OTHER.equalsIgnoreCase(item.getCondition()) || defaultMatchItem != null) continue;
                defaultMatchItem = item;
            }
        }
        if (matchItem == null) {
            matchItem = defaultMatchItem;
        }
        return matchItem;
    }

    private String convertGradeTitle(boolean isForce, int score, String gradeTxt) {
        String message = isForce ? ResManager.loadKDString((String)"\u5355\u636e\u68c0\u67e5\u8bc4\u5206\uff1a%1$s\u5206\uff0c%2$s\uff0c\u5b58\u5728\u4ee5\u4e0b\u6263\u5206\u9879", (String)"IDISchemaResultOpDataConvert_3", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u636e\u68c0\u67e5\u8bc4\u5206\uff1a%1$s\u5206\uff0c%2$s", (String)"IDISchemaResultOpDataConvert_4", (String)"data-idi-core", (Object[])new Object[0]);
        return String.format(message, score, gradeTxt);
    }

    private List<String> convertGradeShowTxt(Boolean isGradeItemForce, List<ControlResult> controlResultList) {
        ArrayList<String> messageList = new ArrayList<String>(controlResultList.size());
        for (ControlResult controlResult : controlResultList) {
            if (!controlResult.isShow || controlResult.deductPoints == null || controlResult.deductPoints.compareTo(BigDecimal.ZERO) == 0) continue;
            StringBuilder sb = new StringBuilder();
            if (isGradeItemForce.booleanValue()) {
                sb.append(controlResult.decisionName).append('\uff1a');
            }
            double point = controlResult.deductPoints.doubleValue();
            String confirmDeduct = ResManager.loadKDString((String)"\u6263%s\u5206", (String)"IDISchemaResultOpDataConvert_12", (String)"data-idi-core", (Object[])new Object[0]);
            if (!isGradeItemForce.booleanValue()) {
                confirmDeduct = String.format(confirmDeduct, point);
                sb.append(confirmDeduct).append('\uff1a');
            } else {
                String errorDeduct = ResManager.loadKDString((String)"\u6263\u5206\uff1a", (String)"IDISchemaResultOpDataConvert_5", (String)"data-idi-core", (Object[])new Object[0]);
                sb.append(errorDeduct).append(point).append('\uff0c');
            }
            sb.append(controlResult.showTxt);
            messageList.add(sb.toString());
        }
        return messageList;
    }

    private String convertItemTitle(boolean isForce) {
        return isForce ? ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u68c0\u67e5\u9879\u4e0d\u901a\u8fc7", (String)"IDISchemaResultOpDataConvert_6", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u68c0\u67e5\u9879\u68c0\u67e5\u4e0d\u901a\u8fc7", (String)"IDISchemaResultOpDataConvert_7", (String)"data-idi-core", (Object[])new Object[0]);
    }

    private List<String> convertShowTxt(List<ControlResult> controlResultList, boolean isForce, boolean onlyAttachRecognizeFailed) {
        ArrayList<String> messageList = new ArrayList<String>(controlResultList.size());
        String attachRecognizeFailedMsg = ResManager.loadKDString((String)"\u5b58\u5728\u8bc6\u522b\u5931\u8d25\u7684\u9644\u4ef6", (String)"AttachmentExecutor_4", (String)"data-idi-core", (Object[])new Object[0]);
        for (ControlResult controlResult : controlResultList) {
            String msg;
            if (controlResult.isPass || !controlResult.isShow || !(isForce && controlResult.controlType == BillControlTypeEnum.FORCE || !isForce && controlResult.controlType == BillControlTypeEnum.CONFIREM) && (!onlyAttachRecognizeFailed || controlResult.controlType != BillControlTypeEnum.FORCE || !attachRecognizeFailedMsg.equals(controlResult.showTxt))) continue;
            if (isForce) {
                msg = StringUtils.isNotBlank((CharSequence)controlResult.decisionName) ? controlResult.decisionName + '\uff1a' + controlResult.showTxt : controlResult.showTxt;
            } else {
                String noScoreTitle = ResManager.loadKDString((String)"\u3010\u667a\u80fd\u6570\u636e\u6d1e\u5bdf\u3011", (String)"IDISchemaResultOpDataConvert_10", (String)"data-idi-core", (Object[])new Object[0]);
                msg = noScoreTitle + controlResult.showTxt;
            }
            messageList.add(msg);
        }
        return messageList;
    }

    private List<ControlResult> processDecisionResult(SchemaResult result) {
        ArrayList<ControlResult> list = new ArrayList<ControlResult>(10);
        List<AreaResult> areaResultList = result.getAreaResults();
        if (areaResultList != null) {
            for (AreaResult areaResult : areaResultList) {
                List<DecisionResult> decisionResultList = areaResult.getDecisionResults();
                if (decisionResultList == null) continue;
                for (DecisionResult decisionResult : decisionResultList) {
                    if (decisionResult == null) continue;
                    String matchType = decisionResult.getDecision().getMatchType();
                    MatchType matchTypeEnum = MatchType.convertFromMatchType(matchType);
                    if (matchTypeEnum == null) {
                        list.add(this.processCustomDecisionResult(decisionResult));
                        continue;
                    }
                    switch (matchTypeEnum) {
                        case LINKUP_BILL: {
                            List<ControlResult> linkupBillList = this.processLinkupBill(decisionResult, decisionResult.getLinkUpBillResults());
                            list.addAll(linkupBillList);
                            break;
                        }
                        case INVOICE: {
                            List<ControlResult> invoiceList = this.processInvoice(decisionResult);
                            list.addAll(invoiceList);
                            break;
                        }
                        case KEYWORD: {
                            ControlResult keyWordResult = this.processKeyWordResult(decisionResult);
                            list.add(keyWordResult);
                            break;
                        }
                        case ALARM: {
                            ControlResult alarmResult = this.processAlarmResult(decisionResult);
                            list.add(alarmResult);
                            break;
                        }
                        case ATTACHMENT: {
                            List<ControlResult> attachmentList = this.processAttachmentResult(decisionResult);
                            list.addAll(attachmentList);
                            break;
                        }
                    }
                }
            }
        }
        return list;
    }

    private ControlResult processCustomDecisionResult(DecisionResult decisionResult) {
        ControlResult cr = new ControlResult();
        cr.isPass = true;
        if (CollectionUtils.isNotEmpty(decisionResult.getApiDecisionResultItems())) {
            for (ApiDecisionResultItem resultItem : decisionResult.getApiDecisionResultItems()) {
                if (!cr.isPass || "green".equals(resultItem.getStatus())) continue;
                cr.isPass = false;
                cr.showTxt = resultItem.getShowText();
            }
        } else {
            cr.isPass = false;
        }
        cr.decisionName = decisionResult.getDecision().getName();
        if (cr.showTxt == null) {
            cr.showTxt = decisionResult.getShowText();
        }
        cr.deductPoints = this.calculate(decisionResult.getDecision().getMark(), decisionResult.getDeductPercent());
        cr.controlType = decisionResult.getDecision().getBillControl();
        return cr;
    }

    private ControlResult processAlarmResult(DecisionResult decisionResult) {
        if (decisionResult.getAlarmResult() != null && decisionResult.getAlarmResult().isOverLimit()) {
            AlarmResult alarmResult = decisionResult.getAlarmResult();
            ControlResult cr = new ControlResult();
            cr.isPass = false;
            cr.decisionName = "";
            String msg = ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u3010%1$s\u3011\u4ec5\u68c0\u67e5\u524d%2$d\u884c\uff0c%3$s", (String)"IDISchemaResultOpDataConvert_13", (String)"data-idi-core", (Object[])new Object[0]);
            cr.showTxt = String.format(msg, decisionResult.getDecision().getName(), alarmResult.getMinLimitCount(), alarmResult.getOriginalShowText());
            cr.deductPoints = this.calculate(decisionResult.getDecision().getMark(), decisionResult.getDeductPercent());
            cr.controlType = "green".equals(decisionResult.getStatus()) ? BillControlTypeEnum.CONFIREM : decisionResult.getDecision().getBillControl();
            return cr;
        }
        return this.processNormalResult(decisionResult);
    }

    private ControlResult processKeyWordResult(DecisionResult decisionResult) {
        ControlResult cr = new ControlResult();
        cr.isPass = "green".equals(decisionResult.getStatus()) || "nocontrolbillcontrolalarming".equals(decisionResult.getStatus());
        cr.decisionName = decisionResult.getDecision().getName();
        if (StringUtils.isEmpty((CharSequence)decisionResult.getShowText()) && StringUtils.isEmpty((CharSequence)decisionResult.getStatus()) && MatchType.LINKUP_BILL.getType().equals(decisionResult.getDecision().getMatchType())) {
            cr.showTxt = ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3\u6216\u672a\u627e\u5230\u4efb\u4f55\u4e00\u5f20\u76ee\u6807\u5355\u6216\u672a\u547d\u4e2d\u4efb\u4f55\u4e00\u4e2a\u68c0\u67e5\u9879", (String)"IDISchemaResultOpDataConvert_9", (String)"data-idi-core", (Object[])new Object[0]);
        } else {
            List<List<HoverContent>> tableList;
            cr.showTxt = decisionResult.getShowText() == null ? "" : decisionResult.getShowText();
            DecisionFrontEndResult frontEndResult = decisionResult.getFrontEndResult();
            StringBuilder keyWordBuild = new StringBuilder();
            if (frontEndResult != null && CollectionUtils.isNotEmpty(tableList = frontEndResult.getHoverContent())) {
                for (List<HoverContent> rowContents : tableList) {
                    String keyword;
                    if (!CollectionUtils.isNotEmpty(rowContents) || rowContents.size() != 2 || !StringUtils.isNotEmpty((CharSequence)(keyword = rowContents.get(1) == null ? "" : rowContents.get(1).getContent()))) continue;
                    String showKey = keyword.replaceAll(";", "\u3001");
                    showKey = showKey.length() - 1 == showKey.lastIndexOf("\u3001") ? showKey.substring(0, showKey.length() - 1) : showKey;
                    keyWordBuild.append("\u3001").append(showKey);
                }
            }
            if (keyWordBuild.length() > 0) {
                cr.showTxt = cr.showTxt + "\uff0c" + keyWordBuild.substring(1);
            }
        }
        cr.deductPoints = this.calculate(decisionResult.getDecision().getMark(), decisionResult.getDeductPercent());
        cr.controlType = decisionResult.getDecision().getBillControl();
        return cr;
    }

    private List<ControlResult> processLinkupBill(DecisionResult decisionResult, List<LinkUpBillResult> linkUpBillResultList) {
        ArrayList<ControlResult> list = new ArrayList<ControlResult>(10);
        Decision decision = decisionResult.getDecision();
        String decisionName = decision.getName();
        BillControlTypeEnum billControlTypeEnum = decision.getBillControl();
        int mark = decision.getMark();
        if (linkUpBillResultList != null && !linkUpBillResultList.isEmpty()) {
            for (LinkUpBillResult linkUpBillResult : linkUpBillResultList) {
                ControlResult cr = new ControlResult();
                cr.isPass = linkUpBillResult.isPass();
                cr.decisionName = decisionName;
                cr.showTxt = linkUpBillResult.getShowText();
                cr.controlType = billControlTypeEnum;
                cr.deductPoints = this.calculate(mark, linkUpBillResult.getDeductPercent());
                list.add(cr);
            }
        } else {
            ControlResult cr = this.processNormalResult(decisionResult);
            list.add(cr);
        }
        return list;
    }

    private List<ControlResult> processAttachmentResult(DecisionResult decisionResult) {
        ArrayList<ControlResult> list = new ArrayList<ControlResult>(10);
        Decision decision = decisionResult.getDecision();
        String decisionName = decision.getName();
        BillControlTypeEnum billControlTypeEnum = decision.getBillControl();
        int mark = decision.getMark();
        List<LinkUpBillResult> attachmentResultList = decisionResult.getAttachmentResults();
        if (attachmentResultList != null && !attachmentResultList.isEmpty()) {
            for (LinkUpBillResult attachmentResult : attachmentResultList) {
                ControlResult cr = new ControlResult();
                cr.isPass = attachmentResult.isPass();
                cr.decisionName = decisionName;
                cr.showTxt = attachmentResult.getShowText();
                cr.controlType = billControlTypeEnum;
                cr.deductPoints = this.calculate(mark, attachmentResult.getDeductPercent());
                list.add(cr);
            }
        } else {
            ControlResult cr = this.processNormalResult(decisionResult);
            list.add(cr);
        }
        return list;
    }

    private List<ControlResult> processInvoice(DecisionResult decisionResult) {
        ArrayList<ControlResult> list = new ArrayList<ControlResult>(10);
        List<InvoiceImageRuleResult> resultList = decisionResult.getInvoiceImageRuleResults();
        Decision decision = decisionResult.getDecision();
        String decisionName = decision.getName();
        BillControlTypeEnum billControlTypeEnum = decision.getBillControl();
        int mark = decision.getMark();
        if (resultList != null && !resultList.isEmpty()) {
            for (InvoiceImageRuleResult invoiceImageRuleResult : resultList) {
                if (invoiceImageRuleResult == null) continue;
                ControlResult cr = new ControlResult();
                cr.isPass = invoiceImageRuleResult.isPass();
                cr.decisionName = decisionName;
                cr.showTxt = invoiceImageRuleResult.getText();
                cr.controlType = billControlTypeEnum;
                cr.deductPoints = this.calculate(mark, invoiceImageRuleResult.getDeductPercent());
                list.add(cr);
            }
        } else {
            ControlResult cr = this.processNormalResult(decisionResult);
            list.add(cr);
        }
        return list;
    }

    private ControlResult processNormalResult(DecisionResult decisionResult) {
        ControlResult cr = new ControlResult();
        cr.isPass = "green".equals(decisionResult.getStatus());
        cr.decisionName = decisionResult.getDecision().getName();
        cr.showTxt = StringUtils.isEmpty((CharSequence)decisionResult.getShowText()) && StringUtils.isEmpty((CharSequence)decisionResult.getStatus()) && MatchType.LINKUP_BILL.getType().equals(decisionResult.getDecision().getMatchType()) ? ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3\u6216\u672a\u627e\u5230\u4efb\u4f55\u4e00\u5f20\u76ee\u6807\u5355\u6216\u672a\u547d\u4e2d\u4efb\u4f55\u4e00\u4e2a\u68c0\u67e5\u9879", (String)"IDISchemaResultOpDataConvert_9", (String)"data-idi-core", (Object[])new Object[0]) : (decisionResult.getShowText() == null ? "" : decisionResult.getShowText());
        cr.deductPoints = this.calculate(decisionResult.getDecision().getMark(), decisionResult.getDeductPercent());
        cr.controlType = decisionResult.getDecision().getBillControl();
        return cr;
    }

    private BigDecimal calculate(int decisionScore, BigDecimal deductPercent) {
        BigDecimal decisionScoreBig = new BigDecimal(decisionScore, DecisionResult.DECIMAL4);
        if (deductPercent == null || deductPercent.compareTo(BigDecimal.ZERO) == 0 || decisionScore == 0) {
            return BigDecimal.ZERO;
        }
        if (deductPercent.compareTo(DecisionResult.HUNDRED) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6263\u5206\u6bd4\u4f8b\u5927\u4e8e100\u3002", (String)"IDISchemaResultOpDataConvert_8", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return decisionScoreBig.multiply(deductPercent, DecisionResult.DECIMAL4).divide(DecisionResult.HUNDRED, DecisionResult.DECIMAL4);
    }

    private static class ControlResult {
        public boolean isPass;
        public String decisionName;
        public String showTxt;
        public BigDecimal deductPoints;
        public BillControlTypeEnum controlType;
        public boolean isShow = true;

        private ControlResult() {
        }

        public String toString() {
            return "ControlResult{isPass=" + this.isPass + ", decisionName='" + this.decisionName + '\'' + ", showTxt='" + this.showTxt + '\'' + ", deductPoints=" + this.deductPoints + ", controlType=" + (Object)((Object)this.controlType) + ", isShow=" + this.isShow + '}';
        }
    }
}

